/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.tracing;

import de.grogra.ray.RTFakeObject;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.debug3d.Debug3d;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.light.DefaultLightProcessor;
import de.grogra.ray.light.LightProcessor;
import de.grogra.ray.memory.MemoryPool;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DefaultRayTracer
implements RayProcessor {
    private static final boolean USE_MEMORY_POOL = true;
    private int m_depthLimit = 8;
    private static final float LIGHT_VARIANCE_MAX = 1.7608814f;
    private static final float LIGHT_WEIGHT_MIN = 0.03f;
    private IntersectionProcessor m_intersectionProcessor = null;
    private LightProcessor m_lightProcessor = null;
    private final RayContext m_rayContext = new RayContext();
    private MemoryPool m_memoryPool;
    private IntersectionDescription m_desc = new IntersectionDescription();
    private final Color3f m_rayColor = new Color3f();
    private final Vector3f m_weight = new Vector3f();
    private float m_weightAverage;
    private float m_varianceSum;
    private float m_weightSum;
    private ShadingEnvironment cur_env = new ShadingEnvironment();

    public DefaultRayTracer() {
        this.setLightProcessor(new DefaultLightProcessor());
    }

    public boolean hasFixedLightProcessor() {
        return false;
    }

    public void setLightProcessor(LightProcessor lightProcessor) {
        this.m_lightProcessor = lightProcessor;
    }

    public LightProcessor getLightProcessor() {
        return this.m_lightProcessor;
    }

    public void setRecursionDepth(int n) {
        if (n >= 0) {
            this.m_depthLimit = n;
        }
    }

    public int getRecursionDepth() {
        return this.m_depthLimit;
    }

    public void prepareRayProcessor(RTScene rTScene, IntersectionProcessor intersectionProcessor) {
        this.m_memoryPool = MemoryPool.getPool();
        this.m_intersectionProcessor = intersectionProcessor;
        this.m_lightProcessor.prepareLightProcessor(rTScene, this.m_intersectionProcessor);
    }

    public void getColorFromRay(Ray ray, Color4f color4f) {
        if (this.m_intersectionProcessor == null) {
            System.err.println("ERROR in Raytracer: no intersection processor defined for DefaultRayTracer");
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        this.m_rayContext.initializeContext();
        this.m_weight.set(1.0f, 1.0f, 1.0f);
        if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray, this.m_rayContext, this.m_desc)) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        Debug3d.logFiniteRay(ray, this.m_desc.getT(), 1.0f);
        Debug3d.logNormal((Tuple3f)this.m_desc.getPoint(), (Tuple3f)this.m_desc.getNormal());
        this.recursivelyTraceRay(1, ray, this.m_rayContext, this.m_desc, this.m_weight, this.m_rayColor);
        color4f.x = this.m_rayColor.x;
        color4f.y = this.m_rayColor.y;
        color4f.z = this.m_rayColor.z;
        color4f.w = 1.0f;
    }

    private void recursivelyTraceRay(int n, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription, Vector3f vector3f, Color3f color3f) {
        if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
            ((RTFakeObject)intersectionDescription.getRTObject()).getColor(ray, intersectionDescription, color3f);
            return;
        }
        this.cur_env.rays.clear();
        if (!intersectionDescription.getRTObject().getUserData().isInside) {
            this.m_lightProcessor.getLightRays(ray, intersectionDescription, this.cur_env.rays);
        }
        this.refreshEnvironment(this.cur_env, ray, rayContext, intersectionDescription);
        for (int i = 0; i < this.cur_env.rays.size(); ++i) {
            Debug3d.logDirectLightRay(this.cur_env.rays.rays[i]);
        }
        intersectionDescription.getRTObject().getShader().getShadingColor(this.cur_env, color3f);
        if (n <= this.m_depthLimit) {
            Ray ray2 = this.m_memoryPool.newRay();
            Color3f color3f2 = this.m_memoryPool.newColor3f();
            Vector3f vector3f2 = this.m_memoryPool.newVector3f();
            Ray ray3 = this.m_memoryPool.newRay();
            Color3f color3f3 = this.m_memoryPool.newColor3f();
            Vector3f vector3f3 = this.m_memoryPool.newVector3f();
            Vector3f vector3f4 = this.m_memoryPool.newVector3f();
            intersectionDescription.getRTObject().getShader().computeMaxRays(this.cur_env, ray2, vector3f2, ray3, vector3f3);
            color3f2.set((Tuple3f)ray2.color);
            color3f3.set((Tuple3f)ray3.color);
            vector3f4.set((Tuple3f)vector3f);
            RTObject rTObject = intersectionDescription.getRTObject();
            this.m_varianceSum = vector3f2.x + vector3f2.y + vector3f2.z;
            this.m_weightSum = color3f2.x * vector3f.x + color3f2.y * vector3f.y + color3f2.z * vector3f.z;
            if (this.m_varianceSum < 1.7608814f && this.m_weightSum > 0.03f) {
                vector3f.x *= color3f2.x;
                vector3f.y *= color3f2.y;
                vector3f.z *= color3f2.z;
                rayContext.excludeObject = !rTObject.getUserData().isInside ? rTObject : null;
                if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray2, rayContext, intersectionDescription)) {
                    this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                    Debug3d.logInfiniteRay(ray2, this.m_weightAverage);
                    ray2.getColor().set(0.0f, 0.0f, 0.0f);
                } else {
                    this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                    Debug3d.logFiniteRay(ray2, intersectionDescription.getT(), this.m_weightAverage);
                    Debug3d.logNormal((Tuple3f)intersectionDescription.getPoint(), (Tuple3f)intersectionDescription.getNormal());
                    this.recursivelyTraceRay(n + 1, ray2, rayContext, intersectionDescription, vector3f, ray2.getColor());
                }
                vector3f.set((Tuple3f)vector3f4);
                ray2.getColor().x *= color3f2.x;
                ray2.getColor().y *= color3f2.y;
                ray2.getColor().z *= color3f2.z;
                color3f.add((Tuple3f)ray2.getColor());
            }
            this.m_varianceSum = vector3f3.x + vector3f3.y + vector3f3.z;
            this.m_weightSum = color3f3.x * vector3f.x + color3f3.y * vector3f.y + color3f3.z * vector3f.z;
            if (this.m_varianceSum < 1.7608814f && this.m_weightSum > 0.03f) {
                int n2 = -1;
                vector3f.x *= color3f3.x;
                vector3f.y *= color3f3.y;
                vector3f.z *= color3f3.z;
                if (rTObject.isSolid()) {
                    boolean bl = rTObject.getUserData().isInside = !rTObject.getUserData().isInside;
                    if (!rTObject.getUserData().isInside) {
                        rayContext.excludeObject = rTObject;
                        if (rayContext.isLastMaterial(rTObject)) {
                            rayContext.popMaterial();
                        } else {
                            n2 = rayContext.deleteMaterial(rTObject);
                        }
                    } else {
                        rayContext.excludeObject = null;
                        rayContext.pushMaterial(rTObject);
                    }
                } else {
                    rayContext.excludeObject = rTObject;
                }
                if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray3, rayContext, intersectionDescription)) {
                    this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                    Debug3d.logInfiniteRay(ray3, this.m_weightAverage);
                    ray3.getColor().set(0.0f, 0.0f, 0.0f);
                } else {
                    this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                    Debug3d.logFiniteRay(ray3, intersectionDescription.getT(), this.m_weightAverage);
                    Debug3d.logNormal((Tuple3f)intersectionDescription.getPoint(), (Tuple3f)intersectionDescription.getNormal());
                    this.recursivelyTraceRay(n + 1, ray3, rayContext, intersectionDescription, vector3f, ray3.getColor());
                }
                if (rTObject.isSolid()) {
                    if (!rTObject.getUserData().isInside) {
                        if (n2 == -1) {
                            rayContext.pushMaterial(rTObject);
                        } else {
                            rayContext.insertMaterial(rTObject, n2);
                        }
                    } else {
                        rayContext.popMaterial();
                    }
                    rTObject.getUserData().isInside = !rTObject.getUserData().isInside;
                }
                vector3f.set((Tuple3f)vector3f4);
                ray3.getColor().x *= color3f3.x;
                ray3.getColor().y *= color3f3.y;
                ray3.getColor().z *= color3f3.z;
                color3f.add((Tuple3f)ray3.getColor());
            }
            this.m_memoryPool.freeVector3f(vector3f4);
            this.m_memoryPool.freeVector3f(vector3f3);
            this.m_memoryPool.freeColor3f(color3f3);
            this.m_memoryPool.freeRay(ray3);
            this.m_memoryPool.freeVector3f(vector3f2);
            this.m_memoryPool.freeColor3f(color3f2);
            this.m_memoryPool.freeRay(ray2);
        }
    }

    private void refreshEnvironment(ShadingEnvironment shadingEnvironment, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        if (intersectionDescription == null) {
            return;
        }
        shadingEnvironment.localPoint.set((Tuple3f)intersectionDescription.getLocalPoint());
        shadingEnvironment.point.set((Tuple3f)intersectionDescription.getPoint());
        shadingEnvironment.normal.set((Tuple3f)intersectionDescription.getNormal());
        shadingEnvironment.view.set((Tuple3f)ray.getDirection());
        shadingEnvironment.view.negate();
        shadingEnvironment.photonDirection = false;
        shadingEnvironment.solid = intersectionDescription.getRTObject().isSolid();
        if (intersectionDescription.getRTObject().getUserData().isInside) {
            if (rayContext.isLastMaterial(intersectionDescription.getRTObject())) {
                shadingEnvironment.iorRatio = rayContext.getExitingIORRation();
            }
        } else {
            shadingEnvironment.iorRatio = intersectionDescription.getRTObject().getMedium() == null ? 1.0f : rayContext.getCurrentIOR() / intersectionDescription.getRTObject().getMedium().getIndexOfRefraction();
        }
        shadingEnvironment.uv.set((Tuple2f)intersectionDescription.getUVCoordinate());
        shadingEnvironment.dpdu.set((Tuple3f)intersectionDescription.getTangenteU());
        shadingEnvironment.dpdv.set((Tuple3f)intersectionDescription.getTangenteV());
    }
}

