/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.antialiasing;

import de.grogra.ray.RTCamera;
import de.grogra.ray.antialiasing.Antialiasing;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import java.util.Random;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;

public class StochasticSupersampling
implements Antialiasing {
    private static final int PIXEL_DIVISION = 4;
    private static final float PIXEL_DIVISION_1_SQ = 0.0625f;
    private Ray m_ray = new Ray();
    private RTCamera m_camera;
    private RayProcessor m_processor;
    private double x_offset;
    private double y_offset;
    private double x_delta;
    private double y_delta;
    private Random m_random = new Random(System.currentTimeMillis());
    private Color4f m_curColor = new Color4f();

    public void initialize(RTCamera rTCamera, RayProcessor rayProcessor) {
        this.m_camera = rTCamera;
        this.m_processor = rayProcessor;
    }

    public void getColorFromFrustum(double d, double d2, double d3, double d4, Color4f color4f) {
        this.x_delta = d3 / 4.0;
        this.y_delta = d4 / 4.0;
        this.y_offset = d2;
        for (int i = 0; i < 4; ++i) {
            this.x_offset = d;
            for (int j = 0; j < 4; ++j) {
                this.m_camera.getRayFromCoordinates(this.x_offset + (double)this.m_random.nextFloat() * this.x_delta, this.y_offset + (double)this.m_random.nextFloat() * this.y_delta, this.m_ray);
                this.m_processor.getColorFromRay(this.m_ray, this.m_curColor);
                if (j == 0 && i == 0) {
                    color4f.set((Tuple4f)this.m_curColor);
                } else {
                    color4f.add((Tuple4f)this.m_curColor);
                }
                this.x_offset += this.x_delta;
            }
            this.y_offset += this.y_delta;
        }
        color4f.scale(0.0625f);
    }
}

