/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.antialiasing;

import de.grogra.ray.RTCamera;
import de.grogra.ray.antialiasing.Antialiasing;
import de.grogra.ray.memory.MemoryPool;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;

public class AdaptiveSupersampling
implements Antialiasing {
    private static final boolean USE_MEMORY_POOL = true;
    private final boolean m_showDivisions = false;
    private final boolean m_cachingIsEnabled = true;
    private double m_limit = 1.0;
    private int m_depthLimit = 3;
    private Ray m_ray = new Ray();
    private RTCamera m_camera;
    private RayProcessor m_processor;
    private MemoryPool m_memoryPool;
    private int m_calculations = 0;
    private int m_maxCalculations = 0;
    private float[][] m_memoX;
    private float[][] m_memoY;
    private float[][] m_memoZ;
    private float[][] m_memoW;
    private boolean[][] m_memoIsSet;
    private int m_memoWidth = 0;
    private int m_memoHeight = 0;
    private boolean m_allocated = false;
    private double m_currentY = -1.0;
    private double m_scaleX;
    private double m_scaleY;

    public void initialize(RTCamera rTCamera, RayProcessor rayProcessor) {
        this.m_camera = rTCamera;
        this.m_processor = rayProcessor;
        this.m_memoryPool = MemoryPool.getPool();
        this.m_maxCalculations = this.m_depthLimit * this.m_depthLimit + (this.m_depthLimit + 1) * (this.m_depthLimit + 1);
    }

    public void getColorFromFrustum(double d, double d2, double d3, double d4, Color4f color4f) {
        if (this.m_processor == null || this.m_camera == null) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (!this.m_allocated) {
            this.allocateMemory(d3, d4);
        }
        if (this.m_currentY != d2) {
            this.refreshMemory(d2);
        }
        this.m_calculations = 0;
        this.getSubpixelColor(1, d, d2, d3, d4, color4f);
    }

    private void getSubpixelColor(int n, double d, double d2, double d3, double d4, Color4f color4f) {
        Color4f color4f2 = this.m_memoryPool.newColor4f();
        Color4f color4f3 = this.m_memoryPool.newColor4f();
        Color4f color4f4 = this.m_memoryPool.newColor4f();
        Color4f color4f5 = this.m_memoryPool.newColor4f();
        Color4f color4f6 = this.m_memoryPool.newColor4f();
        this.getCachedColor(n, d, d2, color4f2);
        this.getCachedColor(n, d + d3, d2, color4f3);
        this.getCachedColor(n, d + d3, d2 + d4, color4f4);
        this.getCachedColor(n, d, d2 + d4, color4f5);
        this.getCachedColor(n + 1, d + d3 * 0.5, d2 + d4 * 0.5, color4f6);
        if (color4f2.w == 0.0f && color4f3.w == 0.0f && color4f4.w == 0.0f && color4f5.w == 0.0f && color4f6.w == 0.0f) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.m_memoryPool.freeColor4f(color4f6);
            this.m_memoryPool.freeColor4f(color4f5);
            this.m_memoryPool.freeColor4f(color4f4);
            this.m_memoryPool.freeColor4f(color4f3);
            this.m_memoryPool.freeColor4f(color4f2);
            return;
        }
        Color4f color4f7 = this.m_memoryPool.newColor4f();
        Color4f color4f8 = this.m_memoryPool.newColor4f();
        Color4f color4f9 = this.m_memoryPool.newColor4f();
        Color4f color4f10 = this.m_memoryPool.newColor4f();
        if (this.getColorDifference(color4f6, color4f2) > this.m_limit && n < this.m_depthLimit) {
            this.getSubpixelColor(n + 1, d, d2, d3 * 0.5, d4 * 0.5, color4f7);
        } else if (color4f2.w == 0.0f && color4f6.w == 0.0f) {
            color4f7.set(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            color4f7.set((Tuple4f)color4f6);
            color4f7.add((Tuple4f)color4f2);
            color4f7.scale(0.5f);
        }
        if (this.getColorDifference(color4f6, color4f3) > this.m_limit && n < this.m_depthLimit) {
            this.getSubpixelColor(n + 1, d + d3 * 0.5, d2, d3 * 0.5, d4 * 0.5, color4f8);
        } else if (color4f3.w == 0.0f && color4f6.w == 0.0f) {
            color4f8.set(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            color4f8.set((Tuple4f)color4f6);
            color4f8.add((Tuple4f)color4f3);
            color4f8.scale(0.5f);
        }
        if (this.getColorDifference(color4f6, color4f4) > this.m_limit && n < this.m_depthLimit) {
            this.getSubpixelColor(n + 1, d + d3 * 0.5, d2 + d4 * 0.5, d3 * 0.5, d4 * 0.5, color4f9);
        } else if (color4f4.w == 0.0f && color4f6.w == 0.0f) {
            color4f9.set(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            color4f9.set((Tuple4f)color4f6);
            color4f9.add((Tuple4f)color4f4);
            color4f9.scale(0.5f);
        }
        if (this.getColorDifference(color4f6, color4f5) > this.m_limit && n < this.m_depthLimit) {
            this.getSubpixelColor(n + 1, d, d2 + d4 * 0.5, d3 * 0.5, d4 * 0.5, color4f10);
        } else if (color4f5.w == 0.0f && color4f6.w == 0.0f) {
            color4f10.set(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            color4f10.set((Tuple4f)color4f6);
            color4f10.add((Tuple4f)color4f5);
            color4f10.scale(0.5f);
        }
        color4f.set((Tuple4f)color4f7);
        color4f.add((Tuple4f)color4f8);
        color4f.add((Tuple4f)color4f9);
        color4f.add((Tuple4f)color4f10);
        color4f.scale(0.25f);
        this.m_memoryPool.freeColor4f(color4f10);
        this.m_memoryPool.freeColor4f(color4f9);
        this.m_memoryPool.freeColor4f(color4f8);
        this.m_memoryPool.freeColor4f(color4f7);
        this.m_memoryPool.freeColor4f(color4f6);
        this.m_memoryPool.freeColor4f(color4f5);
        this.m_memoryPool.freeColor4f(color4f4);
        this.m_memoryPool.freeColor4f(color4f3);
        this.m_memoryPool.freeColor4f(color4f2);
    }

    private double getColorDifference(Color4f color4f, Color4f color4f2) {
        double d = 0.0;
        d += (double)Math.abs(color4f.x - color4f2.x);
        d += (double)Math.abs(color4f.y - color4f2.y);
        d += (double)Math.abs(color4f.z - color4f2.z);
        return d += 3.0 * (double)Math.abs(color4f.w - color4f2.w);
    }

    private void allocateMemory(double d, double d2) {
        int n = 1 << this.m_depthLimit - 1;
        int n2 = (int)Math.round(2.0 / d);
        int n3 = (int)Math.round(2.0 / d2);
        this.m_memoWidth = n2 * n + 1;
        this.m_memoHeight = n + 1;
        this.m_memoX = new float[this.m_memoWidth][this.m_memoHeight];
        this.m_memoY = new float[this.m_memoWidth][this.m_memoHeight];
        this.m_memoZ = new float[this.m_memoWidth][this.m_memoHeight];
        this.m_memoW = new float[this.m_memoWidth][this.m_memoHeight];
        this.m_memoIsSet = new boolean[this.m_memoWidth][this.m_memoHeight];
        for (int i = 0; i < this.m_memoHeight; ++i) {
            for (int j = 0; j < this.m_memoWidth; ++j) {
                this.m_memoIsSet[j][i] = false;
            }
        }
        this.m_scaleX = (double)n / 2.0 * (double)n2;
        this.m_scaleY = (double)n / 2.0 * (double)n3;
        this.m_allocated = true;
    }

    private void refreshMemory(double d) {
        int n;
        for (n = 1; n < this.m_memoHeight - 1; ++n) {
            for (int i = 0; i < this.m_memoWidth; ++i) {
                this.m_memoIsSet[i][n] = false;
            }
        }
        for (n = 0; n < this.m_memoWidth; ++n) {
            if (this.m_memoIsSet[n][this.m_memoHeight - 1]) {
                this.m_memoIsSet[n][0] = true;
                this.m_memoX[n][0] = this.m_memoX[n][this.m_memoHeight - 1];
                this.m_memoY[n][0] = this.m_memoY[n][this.m_memoHeight - 1];
                this.m_memoZ[n][0] = this.m_memoZ[n][this.m_memoHeight - 1];
                this.m_memoW[n][0] = this.m_memoW[n][this.m_memoHeight - 1];
                this.m_memoIsSet[n][this.m_memoHeight - 1] = false;
                continue;
            }
            this.m_memoIsSet[n][0] = false;
        }
        this.m_currentY = d;
    }

    private void getCachedColor(int n, double d, double d2, Color4f color4f) {
        if (n > this.m_depthLimit) {
            this.m_camera.getRayFromCoordinates(d, d2, this.m_ray);
            this.m_processor.getColorFromRay(this.m_ray, color4f);
            return;
        }
        int n2 = (int)((d + 1.0) * this.m_scaleX + 1.0E-7);
        int n3 = (int)((d2 - this.m_currentY) * this.m_scaleY + 1.0E-7);
        if (this.m_memoIsSet[n2][n3]) {
            color4f.x = this.m_memoX[n2][n3];
            color4f.y = this.m_memoY[n2][n3];
            color4f.z = this.m_memoZ[n2][n3];
            color4f.w = this.m_memoW[n2][n3];
        } else {
            this.m_camera.getRayFromCoordinates(d, d2, this.m_ray);
            this.m_processor.getColorFromRay(this.m_ray, color4f);
            ++this.m_calculations;
            this.m_memoX[n2][n3] = color4f.x;
            this.m_memoY[n2][n3] = color4f.y;
            this.m_memoZ[n2][n3] = color4f.z;
            this.m_memoW[n2][n3] = color4f.w;
            this.m_memoIsSet[n2][n3] = true;
        }
    }
}

