/*
 * Decompiled with CFR 0.152.
 */
package pi6.geom;

import pi6.geom.DListElement;
import pi6.geom.Line2;

public final class Point2
extends DListElement {
    protected final double x;
    protected final double y;
    protected boolean visitflag;
    public static final int ONSEGMENT = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int INFRONTOFA = 3;
    public static final int BEHINDB = 4;

    public Point2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double distance2(Point2 p) {
        return (p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y);
    }

    public final boolean isLess(Point2 p) {
        return this.x < p.x || this.x == p.x && this.y < p.y;
    }

    public final boolean isGreater(Point2 p) {
        return this.x > p.x || this.x == p.x && this.y > p.y;
    }

    public final String toString() {
        return new String(new StringBuilder(" Pt[").append(this.x).append("|").append(this.y).append("]").toString());
    }

    public final int pointLineTest(Point2 a, Point2 b) {
        double dy = b.y - a.y;
        double dx = b.x - a.x;
        double res = dy * (this.x - a.x) - dx * (this.y - a.y);
        if (res < 0.0) {
            return 1;
        }
        if (res > 0.0) {
            return 2;
        }
        if (dx > 0.0) {
            if (this.x < a.x) {
                return 3;
            }
            return b.x >= this.x ? 0 : 4;
        }
        if (dx < 0.0) {
            if (this.x > a.x) {
                return 3;
            }
            return b.x <= this.x ? 0 : 4;
        }
        if (dy > 0.0) {
            if (this.y < a.y) {
                return 3;
            }
            return b.y >= this.y ? 0 : 4;
        }
        if (dy < 0.0) {
            if (this.y > a.y) {
                return 3;
            }
            return b.y <= this.y ? 0 : 4;
        }
        System.out.println("Error, pointLineTest with a=b");
        throw new RuntimeException("Error, pointLineTest with a=b");
    }

    public final Point2 MidPoint(Point2 b) {
        return new Point2((this.x + b.x) / 2.0, (this.y + b.y) / 2.0);
    }

    public final Line2 Bisector(Point2 b) {
        Point2 m = this.MidPoint(b);
        double dx = b.x - this.x;
        double dy = b.y - this.y;
        return new Line2(new Point2(m.x - dy, m.y + dx), new Point2(m.x + dy, m.y - dx));
    }
}

