/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.openalea;

import de.grogra.ext.openalea.HttpData;
import de.grogra.ext.openalea.OpenAleaHttpHandler;
import de.grogra.graph.impl.GraphManager;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import java.io.IOException;
import java.net.Socket;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class OpenAleaCommand
extends LockProtectedCommand {
    final GraphManager graph;

    public OpenAleaCommand(GraphManager graphManager) {
        super((Lockable)graphManager, true, 10000);
        this.graph = graphManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(Object object, Context context, Lock lock) {
        HttpData httpData = (HttpData)object;
        Socket socket = httpData.getSocket();
        HttpParams httpParams = httpData.getParams();
        DefaultHttpServerConnection defaultHttpServerConnection = new DefaultHttpServerConnection();
        try {
            defaultHttpServerConnection.bind(socket, httpParams);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BasicHttpProcessor basicHttpProcessor = new BasicHttpProcessor();
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        HttpRequestHandlerRegistry httpRequestHandlerRegistry = new HttpRequestHandlerRegistry();
        httpRequestHandlerRegistry.register("*", (HttpRequestHandler)new OpenAleaHttpHandler(context));
        HttpService httpService = new HttpService((HttpProcessor)basicHttpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
        httpService.setParams(httpParams);
        httpService.setHandlerResolver((HttpRequestHandlerResolver)httpRequestHandlerRegistry);
        BasicHttpContext basicHttpContext = new BasicHttpContext(null);
        try {
            httpService.handleRequest((HttpServerConnection)defaultHttpServerConnection, (HttpContext)basicHttpContext);
        }
        catch (ConnectionClosedException connectionClosedException) {
            System.err.println("Client closed connection");
        }
        catch (IOException iOException) {
            System.err.println("I/O error: " + iOException.getMessage());
        }
        catch (HttpException httpException) {
            System.err.println("Unrecoverable HTTP protocol violation: " + httpException.getMessage());
        }
        finally {
            try {
                defaultHttpServerConnection.shutdown();
            }
            catch (IOException iOException) {
                System.err.println("Connection shutdown problem: " + iOException.getMessage());
            }
        }
    }
}

