/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.io.SerialUtilities;
import org.jfree.util.AbstractObjectList;

public class StrokeList
extends AbstractObjectList {
    public Stroke getStroke(int n) {
        return (Stroke)this.get(n);
    }

    public void setStroke(int n, Stroke stroke) {
        this.set(n, stroke);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StrokeList) {
            return super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Stroke stroke = this.getStroke(i);
            if (stroke != null) {
                objectOutputStream.writeInt(i);
                SerialUtilities.writeStroke(stroke, objectOutputStream);
                continue;
            }
            objectOutputStream.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = objectInputStream.readInt();
            if (n2 == -1) continue;
            this.setStroke(n2, SerialUtilities.readStroke(objectInputStream));
        }
    }
}

