/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Iterator;

public class LineBreakIterator
implements Iterator {
    public static final int DONE = -1;
    private char[] text;
    private int position;

    public LineBreakIterator() {
        this.setText("");
    }

    public LineBreakIterator(String string) {
        this.setText(string);
    }

    public synchronized int nextPosition() {
        char c;
        boolean bl;
        if (this.text == null) {
            return -1;
        }
        if (this.position == -1) {
            return -1;
        }
        int n = this.text.length;
        int n2 = this.position;
        do {
            int n3;
            if (n2 >= n) {
                this.position = -1;
                return -1;
            }
            bl = false;
            c = '\u0000';
            for (n3 = n2; n3 < n; ++n3) {
                c = this.text[n3];
                if (c != '\n' && c != '\r') continue;
                bl = true;
                break;
            }
            n2 = n3;
        } while (!bl);
        if (c == '\r' && ++n2 < n && this.text[n2] == '\n') {
            ++n2;
        }
        this.position = n2;
        return this.position;
    }

    public int nextWithEnd() {
        int n = this.position;
        if (n == -1) {
            return -1;
        }
        if (n == this.text.length) {
            this.position = -1;
            return -1;
        }
        int n2 = this.nextPosition();
        if (n2 == -1) {
            return this.text.length;
        }
        return n2;
    }

    public String getText() {
        return new String(this.text);
    }

    public void setText(String string) {
        this.position = 0;
        this.text = string.toCharArray();
    }

    public boolean hasNext() {
        return this.position != -1;
    }

    public Object next() {
        if (this.position == -1) {
            return null;
        }
        int n = this.position;
        int n2 = this.nextWithEnd();
        if (n2 == -1) {
            return new String(this.text, n, this.text.length - n);
        }
        if (n2 > 0) {
            int n3 = n;
            while (n2 > n3 && (this.text[n2 - 1] == '\n' || this.text[n2 - 1] == '\r')) {
                --n2;
            }
        }
        return new String(this.text, n, n2 - n);
    }

    public void remove() {
        throw new UnsupportedOperationException("This iterator is read-only.");
    }
}

