/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jfree.util.ObjectUtilities;

public class HashNMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -670924844536074826L;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private HashMap table = new HashMap();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    protected List createList() {
        return new ArrayList();
    }

    public boolean put(Object object, Object object2) {
        List list = (List)this.table.get(object);
        if (list == null) {
            List list2 = this.createList();
            list2.add(object2);
            this.table.put(object, list2);
            return true;
        }
        list.clear();
        return list.add(object2);
    }

    public boolean add(Object object, Object object2) {
        List list = (List)this.table.get(object);
        if (list == null) {
            this.put(object, object2);
            return true;
        }
        return list.add(object2);
    }

    public Object getFirst(Object object) {
        return this.get(object, 0);
    }

    public Object get(Object object, int n) {
        List list = (List)this.table.get(object);
        if (list == null) {
            return null;
        }
        return list.get(n);
    }

    public Iterator getAll(Object object) {
        List list = (List)this.table.get(object);
        if (list == null) {
            return EMPTY_ITERATOR;
        }
        return list.iterator();
    }

    public Iterator keys() {
        return this.table.keySet().iterator();
    }

    public Set keySet() {
        return this.table.keySet();
    }

    public boolean remove(Object object, Object object2) {
        List list = (List)this.table.get(object);
        if (list == null) {
            return false;
        }
        if (!list.remove(object2)) {
            return false;
        }
        if (list.size() == 0) {
            this.table.remove(object);
        }
        return true;
    }

    public void removeAll(Object object) {
        this.table.remove(object);
    }

    public void clear() {
        this.table.clear();
    }

    public boolean containsKey(Object object) {
        return this.table.containsKey(object);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.table.values().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            List list = (List)iterator.next();
            bl = list.contains(object);
        }
        return bl;
    }

    public boolean containsValue(Object object, Object object2) {
        List list = (List)this.table.get(object);
        if (list == null) {
            return false;
        }
        return list.contains(object2);
    }

    public boolean contains(Object object) {
        if (this.containsKey(object)) {
            return true;
        }
        return this.containsValue(object);
    }

    public Object clone() throws CloneNotSupportedException {
        HashNMap hashNMap = (HashNMap)super.clone();
        hashNMap.table = new HashMap();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            List list = (List)hashNMap.table.get(e);
            if (list == null) continue;
            hashNMap.table.put(e, ObjectUtilities.clone(list));
        }
        return hashNMap;
    }

    public Object[] toArray(Object object, Object[] objectArray) {
        if (object == null) {
            throw new NullPointerException("Key must not be null.");
        }
        List list = (List)this.table.get(object);
        if (list != null) {
            return list.toArray(objectArray);
        }
        if (objectArray.length > 0) {
            objectArray[0] = null;
        }
        return objectArray;
    }

    public Object[] toArray(Object object) {
        if (object == null) {
            throw new NullPointerException("Key must not be null.");
        }
        List list = (List)this.table.get(object);
        if (list != null) {
            return list.toArray();
        }
        return EMPTY_ARRAY;
    }

    public int getValueCount(Object object) {
        if (object == null) {
            throw new NullPointerException("Key must not be null.");
        }
        List list = (List)this.table.get(object);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    private static final class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("This iterator is empty.");
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator is empty, no remove supported.");
        }
    }
}

