/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public class TextFragment
implements Serializable {
    private static final long serialVersionUID = 4465945952903143262L;
    public static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    public static final Paint DEFAULT_PAINT = Color.black;
    private String text;
    private Font font;
    private Paint paint;
    private float baselineOffset;
    protected static final LogContext logger = Log.createContext(TextFragment.class);

    public TextFragment(String string) {
        this(string, DEFAULT_FONT, DEFAULT_PAINT);
    }

    public TextFragment(String string, Font font) {
        this(string, font, DEFAULT_PAINT);
    }

    public TextFragment(String string, Font font, Paint paint) {
        this(string, font, paint, 0.0f);
    }

    public TextFragment(String string, Font font, Paint paint, float f) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.text = string;
        this.font = font;
        this.paint = paint;
        this.baselineOffset = f;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public float getBaselineOffset() {
        return this.baselineOffset;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        TextUtilities.drawRotatedString(this.text, graphics2D, f, f2 + this.baselineOffset, textAnchor, d, f3, f4);
    }

    public Size2D calculateDimensions(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(this.text, graphics2D, fontMetrics);
        Size2D size2D = new Size2D(rectangle2D.getWidth(), rectangle2D.getHeight());
        return size2D;
    }

    public float calculateBaselineOffset(Graphics2D graphics2D, TextAnchor textAnchor) {
        float f = 0.0f;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        LineMetrics lineMetrics = fontMetrics.getLineMetrics("ABCxyz", graphics2D);
        if (textAnchor == TextAnchor.TOP_LEFT || textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.TOP_RIGHT) {
            f = lineMetrics.getAscent();
        } else if (textAnchor == TextAnchor.BOTTOM_LEFT || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BOTTOM_RIGHT) {
            f = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        return f;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextFragment) {
            TextFragment textFragment = (TextFragment)object;
            if (!this.text.equals(textFragment.text)) {
                return false;
            }
            if (!this.font.equals(textFragment.font)) {
                return false;
            }
            return this.paint.equals(textFragment.paint);
        }
        return false;
    }

    public int hashCode() {
        int n = this.text != null ? this.text.hashCode() : 0;
        n = 29 * n + (this.font != null ? this.font.hashCode() : 0);
        n = 29 * n + (this.paint != null ? this.paint.hashCode() : 0);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

