/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MovingAverage {
    public static TimeSeriesCollection createMovingAverage(TimeSeriesCollection timeSeriesCollection, String string, int n, int n2) {
        if (timeSeriesCollection == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage() : null source.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        for (int i = 0; i < timeSeriesCollection.getSeriesCount(); ++i) {
            TimeSeries timeSeries = timeSeriesCollection.getSeries(i);
            TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, timeSeries.getKey() + string, n, n2);
            timeSeriesCollection2.addSeries(timeSeries2);
        }
        return timeSeriesCollection2;
    }

    public static TimeSeries createMovingAverage(TimeSeries timeSeries, String string, int n, int n2) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("Null source.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeries timeSeries2 = new TimeSeries(string, timeSeries.getTimePeriodClass());
        if (timeSeries.getItemCount() > 0) {
            long l = timeSeries.getDataItem(0).getPeriod().getSerialIndex() + (long)n2;
            for (int i = timeSeries.getItemCount() - 1; i >= 0; --i) {
                TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(i);
                RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
                long l2 = regularTimePeriod.getSerialIndex();
                if (l2 < l) continue;
                int n3 = 0;
                double d = 0.0;
                long l3 = regularTimePeriod.getSerialIndex() - (long)n;
                boolean bl = false;
                for (int j = 0; j < n && !bl; ++j) {
                    if (i - j < 0) continue;
                    TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getDataItem(i - j);
                    RegularTimePeriod regularTimePeriod2 = timeSeriesDataItem2.getPeriod();
                    Number number = timeSeriesDataItem2.getValue();
                    long l4 = regularTimePeriod2.getSerialIndex();
                    if (l4 > l3) {
                        if (number == null) continue;
                        d += number.doubleValue();
                        ++n3;
                        continue;
                    }
                    bl = true;
                }
                if (n3 > 0) {
                    timeSeries2.add(regularTimePeriod, d / (double)n3);
                    continue;
                }
                timeSeries2.add(regularTimePeriod, null);
            }
        }
        return timeSeries2;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries timeSeries, String string, int n) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("Null 'source'.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 2.");
        }
        TimeSeries timeSeries2 = new TimeSeries(string, timeSeries.getTimePeriodClass());
        double d = 0.0;
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(i);
            RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
            d += timeSeriesDataItem.getValue().doubleValue();
            if (i > n - 1) {
                TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getDataItem(i - n);
                timeSeries2.add(regularTimePeriod, (d -= timeSeriesDataItem2.getValue().doubleValue()) / (double)n);
                continue;
            }
            if (i != n - 1) continue;
            timeSeries2.add(regularTimePeriod, d / (double)n);
        }
        return timeSeries2;
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, long l, long l2) {
        return MovingAverage.createMovingAverage(xYDataset, string, (double)l, (double)l2);
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, double d, double d2) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null source (XYDataset).");
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i = 0; i < xYDataset.getSeriesCount(); ++i) {
            XYSeries xYSeries = MovingAverage.createMovingAverage(xYDataset, i, xYDataset.getSeriesKey(i) + string, d, d2);
            xYSeriesCollection.addSeries(xYSeries);
        }
        return xYSeriesCollection;
    }

    public static XYSeries createMovingAverage(XYDataset xYDataset, int n, String string, double d, double d2) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null source (XYDataset).");
        }
        if (d < Double.MIN_VALUE) {
            throw new IllegalArgumentException("period must be positive.");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("skip must be >= 0.0.");
        }
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
        if (xYDataset.getItemCount(n) > 0) {
            double d3 = xYDataset.getXValue(n, 0) + d2;
            for (int i = xYDataset.getItemCount(n) - 1; i >= 0; --i) {
                double d4 = xYDataset.getXValue(n, i);
                if (!(d4 >= d3)) continue;
                int n2 = 0;
                double d5 = 0.0;
                double d6 = d4 - d;
                int n3 = 0;
                boolean bl = false;
                while (!bl) {
                    if (i - n3 >= 0) {
                        double d7 = xYDataset.getXValue(n, i - n3);
                        Number number = xYDataset.getY(n, i - n3);
                        if (d7 > d6) {
                            if (number != null) {
                                d5 += number.doubleValue();
                                ++n2;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    ++n3;
                }
                if (n2 > 0) {
                    xYSeries.add(d4, d5 / (double)n2);
                    continue;
                }
                xYSeries.add(d4, (Number)null);
            }
        }
        return xYSeries;
    }
}

