/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;

public class DefaultPieDataset
extends AbstractDataset
implements PieDataset,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 2904745139106540618L;
    private DefaultKeyedValues data;

    public DefaultPieDataset() {
        this.data = new DefaultKeyedValues();
    }

    public DefaultPieDataset(KeyedValues keyedValues) {
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        this.data = new DefaultKeyedValues();
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            this.data.addValue(keyedValues.getKey(i), keyedValues.getValue(i));
        }
    }

    public int getItemCount() {
        return this.data.getItemCount();
    }

    public List getKeys() {
        return Collections.unmodifiableList(this.data.getKeys());
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        if (this.getItemCount() > n) {
            comparable = this.data.getKey(n);
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        return this.data.getIndex(comparable);
    }

    public Number getValue(int n) {
        Number number = null;
        if (this.getItemCount() > n) {
            number = this.data.getValue(n);
        }
        return number;
    }

    public Number getValue(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.data.getValue(comparable);
    }

    public void setValue(Comparable comparable, Number number) {
        this.data.setValue(comparable, number);
        this.fireDatasetChanged();
    }

    public void setValue(Comparable comparable, double d) {
        this.setValue(comparable, new Double(d));
    }

    public void remove(Comparable comparable) {
        this.data.removeValue(comparable);
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieDataset)) {
            return false;
        }
        PieDataset pieDataset = (PieDataset)object;
        int n = this.getItemCount();
        if (pieDataset.getItemCount() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = pieDataset.getKey(i))) {
                return false;
            }
            Number number = this.getValue(i);
            Number number2 = pieDataset.getValue(i);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPieDataset defaultPieDataset = (DefaultPieDataset)super.clone();
        defaultPieDataset.data = (DefaultKeyedValues)this.data.clone();
        return defaultPieDataset;
    }
}

