/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.util;

import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.util.EventListener;
import de.grogra.util.Map;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.concurrent.Executor;

public class UIPropertyUpdater
implements EventListener {
    private final UIProperty property;
    private final String method;
    private final boolean component;
    private final Executor queue;

    public UIPropertyUpdater(UIProperty uIProperty, Context context, boolean bl, String string, Executor executor, boolean bl2) {
        this.property = uIProperty;
        this.component = bl;
        this.method = string;
        this.queue = executor;
        if (bl2) {
            this.update(context);
        }
        uIProperty.addPropertyListener(context, this);
    }

    public static UIPropertyUpdater install(UIProperty uIProperty, Context context, boolean bl, String string, Executor executor, Map map) {
        boolean bl2;
        Object object;
        if (map != null && (object = map.get((Object)uIProperty.getName(), Map.DEFAULT_VALUE)) != Map.DEFAULT_VALUE) {
            uIProperty.setValue(context, object);
            bl2 = true;
        } else {
            object = uIProperty.getValue(context);
            bl2 = object != null;
        }
        UIPropertyUpdater uIPropertyUpdater = new UIPropertyUpdater(uIProperty, context, bl, string, executor, false);
        if (bl2) {
            uIPropertyUpdater.update(context, object);
        }
        return uIPropertyUpdater;
    }

    public void dispose(Context context) {
        this.property.removePropertyListener(context, this);
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof UIPropertyEditEvent) {
            this.update((UIPropertyEditEvent)eventObject, ((UIPropertyEditEvent)eventObject).getNewValue());
        }
    }

    public void update(Context context) {
        this.update(context, this.property.getValue(context));
    }

    void update(final Context context, final Object object) {
        if (this.queue == null) {
            this.updateCallback(context, object);
        } else {
            this.queue.execute(new Runnable(){

                public void run() {
                    UIPropertyUpdater.this.updateCallback(context, object);
                }
            });
        }
    }

    void updateCallback(Context context, Object object) {
        int n;
        Context context2 = this.property.getSource(context);
        Object object2 = this.component ? context2.getComponent() : context2;
        Method[] methodArray = object2.getClass().getMethods();
        for (n = methodArray.length - 1; !(n < 0 || methodArray[n].getName().equals(this.method) && (methodArray[n].getModifiers() & 8) == 0 && methodArray[n].getParameterTypes().length == 1); --n) {
        }
        if (n < 0) {
            System.err.println("Method " + this.method + " not found for " + object2);
            Thread.dumpStack();
            return;
        }
        try {
            methodArray[n].invoke(object2, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

