/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.edit;

import de.grogra.persistence.ManageableType;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.edit.PropertyEditor;
import de.grogra.reflect.Field;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;

public abstract class Property {
    private final Context context;
    private final Type type;
    private Quantity quantity;

    public Property(Context context, Type type) {
        this.context = context;
        this.type = type;
    }

    public Context getContext() {
        return this.context;
    }

    public Workbench getWorkbench() {
        return this.context.getWorkbench();
    }

    public UIToolkit getToolkit() {
        return UIToolkit.get(this.context);
    }

    public PropertyEditor getEditor() {
        return null;
    }

    public Type getType() {
        return this.type;
    }

    protected void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public Property createSubProperty(Type type, String string, int n) {
        ManageableType.Field field;
        if (string.length() == 0) {
            return this;
        }
        ManageableType manageableType = ManageableType.forType((Type)type);
        ManageableType.Field field2 = field = manageableType != null ? manageableType.getManagedField(string) : null;
        if (field == null) {
            return null;
        }
        return this.createSubProperty(type, (Field)field, n);
    }

    public abstract Property createSubProperty(Type var1, Field var2, int var3);

    public abstract boolean isWritable();

    public abstract void setValue(Object var1) throws InterruptedException;

    public abstract Object getValue();
}

