/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.ProtoInstanceImport;
import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.SpotLightDocument;
import de.grogra.ext.x3d.xmlbeans.X3DNode;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.imp3d.shading.Light;
import de.grogra.math.RGBColor;
import java.util.HashMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpotLightImport {
    private static float intensityFactor = 100.0f;
    private static Vector3d upVec = new Vector3d(0.0, 0.0, 1.0);

    public static LightNode createInstance(SpotLightDocument.SpotLight spotLight) {
        LightNode lightNode = null;
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        if (spotLight.isSetUSE()) {
            try {
                lightNode = (LightNode)((Node)hashMap.get(spotLight.getUSE())).cloneGraph((EdgePattern)EdgePatternImpl.TREE, true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            lightNode = new LightNode();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (spotLight.isSetIS()) {
                ProtoInstanceImport.calcFinalValueMap(hashMap2, (X3DNode)spotLight);
            }
            SpotLightImport.setValues(lightNode, spotLight, hashMap2);
            if (spotLight.isSetDEF()) {
                hashMap.put(spotLight.getDEF(), lightNode);
            }
        }
        lightNode.setName("X3DSpotLight");
        return lightNode;
    }

    private static void setValues(LightNode lightNode, SpotLightDocument.SpotLight spotLight, HashMap<String, String> hashMap) {
        SpotLight spotLight2 = new SpotLight();
        RGBColor rGBColor = new RGBColor();
        String string = hashMap.get("color") != null ? hashMap.get("color") : spotLight.getColor();
        Util.splitStringToTuple3f((Tuple3f)rGBColor, string);
        spotLight2.getColor().set((Tuple3f)rGBColor);
        Vector3d vector3d = new Vector3d();
        String string2 = hashMap.get("direction") != null ? hashMap.get("direction") : spotLight.getDirection();
        Util.convertStringToTuple3d((Tuple3d)vector3d, string2);
        Matrix4d matrix4d = Util.vectorsToTransMatrix(upVec, vector3d);
        Vector3d vector3d2 = new Vector3d();
        String string3 = hashMap.get("location") != null ? hashMap.get("location") : spotLight.getLocation();
        Util.convertStringToTuple3d((Tuple3d)vector3d2, string3);
        matrix4d.setTranslation(vector3d2);
        lightNode.setTransform(matrix4d);
        float f = hashMap.get("intensity") != null ? Float.valueOf(hashMap.get("intensity")).floatValue() : spotLight.getIntensity();
        spotLight2.setPower(f * intensityFactor);
        float f2 = hashMap.get("beamWidth") != null ? Float.valueOf(hashMap.get("beamWidth")).floatValue() : spotLight.getBeamWidth();
        spotLight2.setInnerAngle(f2);
        float f3 = hashMap.get("cutOffAngle") != null ? Float.valueOf(hashMap.get("cutOffAngle")).floatValue() : spotLight.getCutOffAngle();
        spotLight2.setInnerAngle(f3);
        lightNode.setLight((Light)spotLight2);
    }
}

