/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.ProtoInstanceImport;
import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.PointLightDocument;
import de.grogra.ext.x3d.xmlbeans.X3DNode;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.shading.Light;
import de.grogra.math.RGBColor;
import java.util.HashMap;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointLightImport {
    private static float intensityFactor = 100.0f;

    public static LightNode createInstance(PointLightDocument.PointLight pointLight) {
        LightNode lightNode = null;
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        if (pointLight.isSetUSE()) {
            try {
                lightNode = (LightNode)((Node)hashMap.get(pointLight.getUSE())).cloneGraph((EdgePattern)EdgePatternImpl.TREE, true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            lightNode = new LightNode();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (pointLight.isSetIS()) {
                ProtoInstanceImport.calcFinalValueMap(hashMap2, (X3DNode)pointLight);
            }
            PointLightImport.setValues(lightNode, pointLight, hashMap2);
            if (pointLight.isSetDEF()) {
                hashMap.put(pointLight.getDEF(), lightNode);
            }
        }
        lightNode.setName("X3DPointLight");
        return lightNode;
    }

    private static void setValues(LightNode lightNode, PointLightDocument.PointLight pointLight, HashMap<String, String> hashMap) {
        PointLight pointLight2 = new PointLight();
        RGBColor rGBColor = new RGBColor();
        String string = hashMap.get("color") != null ? hashMap.get("color") : pointLight.getColor();
        Util.splitStringToTuple3f((Tuple3f)rGBColor, string);
        pointLight2.getColor().set((Tuple3f)rGBColor);
        Vector3f vector3f = new Vector3f();
        String string2 = hashMap.get("location") != null ? hashMap.get("location") : pointLight.getLocation();
        Util.convertStringToTuple3f((Tuple3f)vector3f, string2);
        lightNode.setTransform((Tuple3f)vector3f);
        float f = hashMap.get("intensity") != null ? Float.valueOf(hashMap.get("intensity")).floatValue() : pointLight.getIntensity();
        pointLight2.setPower(f * intensityFactor);
        lightNode.setLight((Light)pointLight2);
    }
}

