/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.ProtoInstanceImport;
import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.MaterialDocument;
import de.grogra.ext.x3d.xmlbeans.X3DNode;
import de.grogra.imp3d.shading.Phong;
import de.grogra.math.ChannelMap;
import de.grogra.math.Graytone;
import de.grogra.math.RGBColor;
import java.util.HashMap;
import javax.vecmath.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialImport {
    public static Phong createInstance(MaterialDocument.Material material) {
        Phong phong = null;
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        if (material.isSetUSE()) {
            phong = ((Phong)hashMap.get(material.getUSE())).clone();
        } else {
            phong = new Phong();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (material.isSetIS()) {
                ProtoInstanceImport.calcFinalValueMap(hashMap2, (X3DNode)material);
            }
            MaterialImport.setValues(phong, material, hashMap2);
            if (material.isSetDEF()) {
                hashMap.put(material.getDEF(), phong);
            }
        }
        return phong;
    }

    private static void setValues(Phong phong, MaterialDocument.Material material, HashMap<String, String> hashMap) {
        float f = hashMap.get("ambientIntensity") != null ? Float.valueOf(hashMap.get("ambientIntensity")).floatValue() : material.getAmbientIntensity();
        phong.setAmbient((ChannelMap)new Graytone(f));
        RGBColor rGBColor = new RGBColor();
        String string = hashMap.get("diffuseColor") != null ? hashMap.get("diffuseColor") : material.getDiffuseColor();
        Util.splitStringToTuple3f((Tuple3f)rGBColor, string);
        phong.setDiffuse((ChannelMap)rGBColor);
        RGBColor rGBColor2 = new RGBColor();
        String string2 = hashMap.get("emissiveColor") != null ? hashMap.get("emissiveColor") : material.getEmissiveColor();
        Util.splitStringToTuple3f((Tuple3f)rGBColor2, string2);
        phong.setEmissive((ChannelMap)rGBColor2);
        float f2 = hashMap.get("shininess") != null ? Float.valueOf(hashMap.get("shininess")).floatValue() : material.getShininess();
        phong.setShininess((ChannelMap)new Graytone(f2));
        RGBColor rGBColor3 = new RGBColor();
        String string3 = hashMap.get("specularColor") != null ? hashMap.get("specularColor") : material.getSpecularColor();
        Util.splitStringToTuple3f((Tuple3f)rGBColor3, string3);
        phong.setSpecular((ChannelMap)rGBColor3);
        float f3 = hashMap.get("transparency") != null ? Float.valueOf(hashMap.get("transparency")).floatValue() : material.getTransparency();
        phong.setTransparency((ChannelMap)new Graytone(f3));
    }
}

