/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.exportation;

import de.grogra.ext.x3d.X3DExport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.AppearanceDocument;
import de.grogra.ext.x3d.xmlbeans.ImageTextureDocument;
import de.grogra.ext.x3d.xmlbeans.MaterialDocument;
import de.grogra.ext.x3d.xmlbeans.ShapeDocument;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SurfaceMap;
import de.grogra.math.ChannelMap;
import de.grogra.math.ColorMap;
import de.grogra.math.Graytone;
import de.grogra.math.RGBColor;
import de.grogra.pf.registry.Item;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;

public class AppearanceExport {
    public static HashMap<ChannelMap, String> imageFileMap = new HashMap();

    public static void handleAppearance(ShapeDocument.Shape shape, Object object, Shader shader, X3DExport x3DExport, GraphState graphState) {
        AppearanceDocument.Appearance appearance = shape.addNewAppearance();
        MaterialDocument.Material material = appearance.addNewMaterial();
        if (shader instanceof RGBAShader) {
            RGBAShader rGBAShader = (RGBAShader)shader;
            material.setDiffuseColor(rGBAShader.x + " " + rGBAShader.y + " " + rGBAShader.z);
            if (1.0f - rGBAShader.w != 0.0f) {
                material.setTransparency(1.0f - rGBAShader.w);
            }
        } else if (shader instanceof Phong) {
            int n;
            float f;
            int n2;
            RGBColor rGBColor;
            int n3;
            float f2;
            int n4;
            RGBColor rGBColor2;
            int n5;
            float f3;
            Phong phong = (Phong)shader;
            ChannelMap channelMap = phong.getAmbient();
            if (channelMap == null) {
                channelMap = Phong.DEFAULT_AMBIENT;
            }
            if (channelMap instanceof ColorMap && (f3 = Util.intToGray(n5 = ((ColorMap)channelMap).getAverageColor())) != 0.2f) {
                material.setAmbientIntensity(f3);
            }
            if ((channelMap = phong.getDiffuse()) instanceof SurfaceMap) {
                try {
                    String string = AppearanceExport.exportChannelMap(channelMap, x3DExport, appearance);
                    ImageTextureDocument.ImageTexture imageTexture = appearance.addNewImageTexture();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    imageTexture.setUrl(arrayList);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't write image file for x3d export.");
                }
            } else {
                RGBColor rGBColor3;
                if (channelMap == null) {
                    channelMap = Phong.DEFAULT_DIFFUSE;
                }
                if (channelMap instanceof ColorMap && !(rGBColor3 = Util.intToRGB(n5 = ((ColorMap)channelMap).getAverageColor())).equals((Tuple3f)new RGBColor(0.8f, 0.8f, 0.8f))) {
                    material.setDiffuseColor(rGBColor3.x + " " + rGBColor3.y + " " + rGBColor3.z);
                }
            }
            if ((channelMap = phong.getEmissive()) == null) {
                channelMap = Phong.DEFAULT_EMISSIVE;
            }
            if (channelMap instanceof ColorMap && !(rGBColor2 = Util.intToRGB(n4 = ((ColorMap)channelMap).getAverageColor())).equals((Tuple3f)new RGBColor(0.0f, 0.0f, 0.0f))) {
                material.setEmissiveColor(rGBColor2.x + " " + rGBColor2.y + " " + rGBColor2.z);
            }
            if ((channelMap = phong.getShininess()) == null) {
                channelMap = new Graytone(0.5f);
            }
            if (channelMap instanceof ColorMap && (f2 = Util.intToGray(n3 = ((ColorMap)channelMap).getAverageColor())) != 0.2f) {
                material.setShininess(f2);
            }
            if ((channelMap = phong.getSpecular()) == null) {
                channelMap = Phong.DEFAULT_SPECULAR;
            }
            if (channelMap instanceof ColorMap && !(rGBColor = Util.intToRGB(n2 = ((ColorMap)channelMap).getAverageColor())).equals((Tuple3f)new RGBColor(0.0f, 0.0f, 0.0f))) {
                material.setSpecularColor(rGBColor.x + " " + rGBColor.y + " " + rGBColor.z);
            }
            if ((channelMap = phong.getTransparency()) == null) {
                channelMap = Phong.DEFAULT_TRANSPARENCY;
            }
            if (channelMap instanceof ColorMap && (f = Util.intToGray(n = ((ColorMap)channelMap).getAverageColor())) != 0.0f) {
                material.setTransparency(f);
            }
        }
    }

    private static String exportChannelMap(ChannelMap channelMap, X3DExport x3DExport, AppearanceDocument.Appearance appearance) throws IOException {
        Object object;
        Object object2;
        BufferedImage bufferedImage;
        boolean bl;
        AffineUVTransformation affineUVTransformation;
        String string = null;
        String string2 = "png";
        String string3 = "surfacemap." + string2;
        SurfaceMap surfaceMap = (SurfaceMap)channelMap;
        ChannelMap channelMap2 = surfaceMap.getInput();
        if (channelMap2 instanceof AffineUVTransformation) {
            affineUVTransformation = (AffineUVTransformation)channelMap2;
            if (affineUVTransformation.getInput() != null) {
                affineUVTransformation = null;
                bl = true;
            } else {
                bl = false;
            }
        } else if (channelMap2 != null) {
            bl = true;
            affineUVTransformation = null;
        } else {
            bl = false;
            affineUVTransformation = null;
        }
        if (bl) {
            bufferedImage = new BufferedImage(256, 256, 2);
            surfaceMap.drawImage(bufferedImage, 1, true);
        } else if (surfaceMap instanceof ImageMap) {
            object2 = ((ImageMap)surfaceMap).getImageAdapter();
            bufferedImage = object2.getBufferedImage();
            object = object2.getProvider();
            String string4 = ((Item)object).getAbsoluteName();
            string4 = string4.substring(string4.lastIndexOf("/") + 1, string4.length());
            string3 = string4 + "." + string2;
        } else {
            bufferedImage = new BufferedImage(256, 256, 2);
            surfaceMap.drawImage(bufferedImage, 1, false);
        }
        if (imageFileMap.get(channelMap) == null) {
            if (bufferedImage != null) {
                object2 = (File)x3DExport.getFile(string3);
                ImageIO.write((RenderedImage)bufferedImage, string2, (File)object2);
                object = ((File)object2).getCanonicalPath();
                int n = ((String)object).lastIndexOf(File.separator) + 1;
                string = ((String)object).substring(n, ((String)object).length());
                imageFileMap.put(channelMap, string);
            }
        } else {
            string = imageFileMap.get(channelMap);
        }
        if (affineUVTransformation != null) {
            Vector2f vector2f;
            Vector2f vector2f2;
            object2 = appearance.addNewTextureTransform();
            float f = affineUVTransformation.getAngle();
            if (f != 0.0f) {
                object2.setRotation(-f);
            }
            if (!(vector2f2 = new Vector2f(affineUVTransformation.getOffsetU(), affineUVTransformation.getOffsetV())).equals((Tuple2f)new Vector2f(0.0f, 0.0f))) {
                object2.setTranslation(-vector2f2.x + " " + -vector2f2.y);
            }
            if (!(vector2f = new Vector2f(affineUVTransformation.getScaleU(), affineUVTransformation.getScaleV())).equals((Tuple2f)new Vector2f(1.0f, 1.0f))) {
                object2.setScale(vector2f.x + " " + vector2f.y);
            }
        }
        return string;
    }
}

