/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.graph.impl.Node;
import de.grogra.persistence.ModificationQueue;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAQueue;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.Runtime;
import de.grogra.rgg.model.TransferableQueue;
import de.grogra.util.HierarchicalQueue;
import de.grogra.util.Utils;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.RuntimeModel;
import de.grogra.xl.query.RuntimeModelException;
import de.grogra.xl.util.ObjectList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyQueue
extends ModificationQueue
implements TransferableQueue {
    public static final PropertyQueueDescriptor PROPERTY_QUEUE = new PropertyQueueDescriptor();
    public static final MakePersistentDescriptor MAKE_PERSISTENT = new MakePersistentDescriptor();
    private final Runtime model;
    private final QueueDescriptor<?> descriptor;
    private final ObjectList<Node> newNodes = new ObjectList();
    private final PropertyQueue makePersistentQueue;
    private ObjectList<HierarchicalQueue.Cursor> segments = new ObjectList();
    private int segmentsSize = 0;

    PropertyQueue(RGGGraph rGGGraph, QueueDescriptor<?> queueDescriptor, PropertyQueue propertyQueue) {
        super((PersistenceManager)rGGGraph.manager);
        this.model = (Runtime)rGGGraph.getModel();
        this.descriptor = queueDescriptor;
        this.makePersistentQueue = propertyQueue;
    }

    public QueueDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    void makePersistent(Node node) {
        this.manager.prepareId((PersistenceCapable)node);
        this.newNodes.add((Object)node);
    }

    static PropertyQueue current(Node node) {
        if (node.getGraph() == null) {
            throw new IllegalStateException(node + " is not yet part of a graph.");
        }
        RGGGraph rGGGraph = RGGGraph.get(node.getGraph());
        if (rGGGraph == null) {
            throw new IllegalStateException(node.getGraph() + " is not yet represented as an RGGGraph");
        }
        QueueCollection queueCollection = rGGGraph.getQueues();
        if (queueCollection == null) {
            throw new IllegalStateException("No active derivation, so no deferred assignments");
        }
        return (PropertyQueue)queueCollection.getQueue((QueueDescriptor)PROPERTY_QUEUE);
    }

    public boolean process(int[] nArray) throws RuntimeModelException {
        boolean bl = this.newNodes.size > 0;
        Transaction transaction = this.manager.getActiveTransaction();
        try {
            for (int i = 0; i < this.newNodes.size; ++i) {
                Node node = (Node)this.newNodes.get(i);
                this.manager.makePersistent((PersistenceCapable)node, node.getId(), transaction);
            }
            this.newNodes.clear();
            return this.apply(transaction) || bl;
        }
        catch (IOException iOException) {
            throw new RuntimeModelException(Utils.unwrap((Throwable)iOException), (RuntimeModel)this.model);
        }
    }

    @Override
    public boolean write(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.newNodes.size; ++i) {
            Node node = (Node)this.newNodes.get(i);
            this.makePersistent((PersistenceCapable)node, node.getId());
        }
        this.newNodes.clear();
        this.getData().write(dataOutput);
        return this.hasItems();
    }

    @Override
    public void read(DataInput dataInput) throws IOException {
        XAQueue.Data data = this.createData();
        data.read(dataInput);
        this.restore((HierarchicalQueue.Data)data);
    }

    public void markSegment(int n) {
        while (this.segmentsSize <= n) {
            this.segments.set(this.segmentsSize, (Object)this.getCursor((HierarchicalQueue.Cursor)this.segments.get(this.segmentsSize)));
            ++this.segmentsSize;
        }
    }

    public void resetToSegment(int n) {
        this.moveTo((HierarchicalQueue.Cursor)this.segments.get(n));
        this.segmentsSize = n + 1;
    }

    public void clear() {
        super.clear();
        this.segmentsSize = 0;
    }

    public void clearSegmentsToExclude(int[] nArray) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MakePersistentDescriptor
    extends QueueDescriptor<PropertyQueue> {
        protected QueueDescriptor[] queuesToProcessBefore() {
            return QueueDescriptor.DESCRIPTOR_0;
        }

        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{GraphQueue.FIRST_QUEUE, PROPERTY_QUEUE};
        }

        public PropertyQueue createQueue(QueueCollection queueCollection) {
            return new PropertyQueue((RGGGraph)queueCollection.getGraph(), this, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyQueueDescriptor
    extends QueueDescriptor<PropertyQueue> {
        protected QueueDescriptor[] queuesToProcessBefore() {
            return DESCRIPTOR_0;
        }

        protected QueueDescriptor[] queuesToProcessAfter() {
            return DESCRIPTOR_0;
        }

        public PropertyQueue createQueue(QueueCollection queueCollection) {
            return new PropertyQueue((RGGGraph)queueCollection.getGraph(), this, (PropertyQueue)queueCollection.getQueue((QueueDescriptor)MAKE_PERSISTENT));
        }
    }
}

