/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ResourceLoader;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.TypeItem;
import de.grogra.pf.ui.Workbench;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.rgg.model.XLFilter;
import de.grogra.util.IOWrapException;
import de.grogra.util.MimeType;
import de.grogra.vfs.MemoryFileSystem;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.CompilationUnit;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.CompilerOptions;
import de.grogra.xl.compiler.Main;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.CompilationUnitScope;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.util.ObjectList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationFilter
extends FilterBase
implements ObjectSource,
ResourceLoader {
    public static final MimeType COMPILATION_UNIT_TYPE = MimeType.valueOf(CompilationUnit.class);
    public static final IOFlavor CUNIT_FLAVOR = new IOFlavor(COMPILATION_UNIT_TYPE);
    public static final String DEACTIVATION_CATEGORY = "java.lang.Class";
    public static boolean WRITE_CLASSES = true;
    public static boolean DUMP_TYPES = false;
    private CompilationUnitScope compilationUnit;
    private ObjectList sources = new ObjectList();

    public CompilationFilter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.RESOURCE_LOADER);
    }

    public Object getObject() {
        return this;
    }

    public CompilationUnitScope getCompilationUnit() {
        return this.compilationUnit;
    }

    private static void add(ObjectList<Type> objectList, Type type) {
        objectList.add((Object)type);
        for (int i = type.getDeclaredTypeCount() - 1; i >= 0; --i) {
            CompilationFilter.add(objectList, type.getDeclaredType(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type[] compile(CClass cClass, ClassLoader classLoader) throws IOException {
        BytecodeWriter bytecodeWriter;
        StringBuffer stringBuffer;
        ObjectList objectList = new ObjectList();
        XLFilter.CLASSPATH.set(XLFilter.createDefaultClassPath((RegistryContext)this));
        try {
            objectList.add(((ObjectSource)this.source).getObject());
            stringBuffer = new StringBuffer(this.source.getSystemId());
            for (int i = 0; i < this.sources.size(); ++i) {
                objectList.add(((ObjectSource)this.sources.get(i)).getObject());
                stringBuffer.append(", ").append(((ObjectSource)this.sources.get(i)).getSystemId());
            }
        }
        finally {
            XLFilter.CLASSPATH.set(null);
        }
        CompilationUnit[] compilationUnitArray = (CompilationUnit[])objectList.toArray((Object[])new CompilationUnit[objectList.size()]);
        Compiler compiler = new Compiler();
        CompilationUnitScope[] compilationUnitScopeArray = compiler.compile(compilationUnitArray, cClass, null, null, null, true);
        this.compilationUnit = compilationUnitScopeArray[0];
        int n = 49;
        CompilerOptions compilerOptions = compilationUnitArray[0].options;
        for (int i = 0; i < compilationUnitArray.length; ++i) {
            if (!compilationUnitArray[i].options.supportsVersion(n)) {
                compilerOptions = compilationUnitArray[i].options;
                n = compilerOptions.javaVersion;
            }
            compiler.problems.addAll(compilationUnitArray[i].problems);
        }
        if (compiler.problems.containsErrors()) {
            throw new IOWrapException((Throwable)compiler.problems);
        }
        if (compiler.problems.containsWarnings()) {
            Registry.current().getLogger().log(Workbench.GUI_INFO, Library.I18N.msg("xl.compilation-warnings", (Object)stringBuffer), (Throwable)compiler.problems);
        } else if (cClass == null) {
            Registry.current().getLogger().log(Workbench.SOFT_GUI_INFO, Library.I18N.msg("xl.compilation-successful", (Object)stringBuffer));
        }
        ObjectList objectList2 = new ObjectList();
        for (int i = 0; i < compilationUnitScopeArray.length; ++i) {
            bytecodeWriter = compilationUnitScopeArray[i].getDeclaredTypes();
            for (int j = 0; j < ((Type[])bytecodeWriter).length; ++j) {
                CompilationFilter.add((ObjectList<Type>)objectList2, (Type)bytecodeWriter[j]);
            }
        }
        Type[] typeArray = (Type[])objectList2.toArray((Object[])new Type[objectList2.size()]);
        bytecodeWriter = new BytecodeWriter(compilerOptions);
        MemoryFileSystem memoryFileSystem = bytecodeWriter.createFileSystemFor(compilationUnitScopeArray);
        if (classLoader == null) {
            classLoader = ClassPath.get((Scope)this.compilationUnit).getClassLoader();
        }
        ClassAdapter.URLClassLoaderWithPool uRLClassLoaderWithPool = new ClassAdapter.URLClassLoaderWithPool(new URL[]{memoryFileSystem.toURL(memoryFileSystem.getRoot())}, classLoader);
        if (WRITE_CLASSES) {
            File file = new File(System.getProperty("user.home"), "classes.zip");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            memoryFileSystem.writeJar((OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (DUMP_TYPES) {
                Main.dumpType((Type)typeArray[i], (boolean)true);
            }
            try {
                typeArray[i] = ClassAdapter.wrap(Class.forName(typeArray[i].getBinaryName(), false, (ClassLoader)uRLClassLoaderWithPool));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOWrapException((Throwable)classNotFoundException);
            }
        }
        return typeArray;
    }

    public void loadResource(Registry registry) throws IOException {
        Type[] typeArray = this.compile(null, null);
        for (int i = 0; i < typeArray.length; ++i) {
            registry.getDirectory("/classes", null).add((Item)new TypeItem(typeArray[i]));
        }
    }

    public boolean addResource(FilterSource filterSource) {
        FilterSource filterSource2 = IO.createPipeline((FilterSource)filterSource, (IOFlavor)CUNIT_FLAVOR);
        if (filterSource2 == null) {
            return false;
        }
        this.sources.add((Object)filterSource2);
        return true;
    }

    public String getJoinedDeactivationCategory() {
        return DEACTIVATION_CATEGORY;
    }
}

