/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.State;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.objects.Transformation;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.TVector3d;
import de.grogra.math.Transform3D;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.Transaction;
import de.grogra.pf.ui.event.ClickEvent;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.Type;
import de.grogra.rgg.Attributes;
import de.grogra.util.EventListener;
import de.grogra.xl.impl.base.FieldListPattern;
import de.grogra.xl.query.UserDefinedPattern;
import java.util.EventObject;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class Cell
extends Node
implements EventListener,
Transformation {
    public static final int TRANSFORMING_MASK = 2048;
    public static final int USED_BITS = 12;
    protected int state = 0;
    protected Shader shader = null;
    final TVector3d position = new TVector3d();
    protected float radius = 0.0f;
    protected float length = 0.0f;
    public static final Node.NType $TYPE = new Node.NType((Node)new Cell());
    public static final Node.NType.Field state$FIELD = new _Field("state", 0x200004, Type.INT, null, 0);
    public static final Node.NType.Field shader$FIELD;
    public static final Node.NType.Field transforming$FIELD;
    public static final Node.NType.Field x$FIELD;
    public static final Node.NType.Field y$FIELD;
    public static final Node.NType.Field z$FIELD;
    public static final Node.NType.Field radius$FIELD;
    public static final Node.NType.Field length$FIELD;

    public Cell() {
        this(0.0f, 0.0f, 0.0f, 0);
    }

    public Cell(float f, float f2, float f3, int n) {
        this(f, f2, f3, 0.3f, -1.0f, true, n);
    }

    public Cell(double d, double d2, double d3, float f, float f2, boolean bl, int n) {
        this.position.set(d, d2, d3);
        this.length = f;
        this.radius = f2;
        this.state = n;
        if (bl) {
            this.bits |= 0x800;
        }
    }

    public Shader getShader() {
        return this.shader != null ? this.shader : (this.state > 0 ? RGBAShader.YELLOW : (this.state < 0 ? RGBAShader.RED : RGBAShader.GRAY));
    }

    float getRadius0() {
        return this.radius >= 0.0f ? this.radius : (this.state != 0 ? 0.4f : 0.2f);
    }

    protected boolean getBoolean(BooleanAttribute booleanAttribute, GraphState graphState) {
        return booleanAttribute != Attributes.BASE_OPEN && booleanAttribute != Attributes.TOP_OPEN && booleanAttribute != Attributes.SCALE_V && super.getBoolean(booleanAttribute, graphState);
    }

    protected Object getObject(ObjectAttribute objectAttribute, Object object, GraphState graphState) {
        if (objectAttribute == Attributes.TRANSFORM) {
            return this.position;
        }
        if (objectAttribute == Attributes.SHAPE) {
            return Cylinder.$TYPE.getRepresentative();
        }
        return super.getObject(objectAttribute, object, graphState);
    }

    public double getX() {
        return this.position.x;
    }

    public void setX(double d) {
        this.position.x = d;
    }

    public double getY() {
        return this.position.y;
    }

    public void setY(double d) {
        this.position.y = d;
    }

    public double getZ() {
        return this.position.z;
    }

    public void setZ(double d) {
        this.position.z = d;
    }

    public TVector3d getPosition() {
        return this.position;
    }

    public double distance(Cell cell) {
        TVector3d tVector3d = this.position;
        TVector3d tVector3d2 = cell.position;
        double d = tVector3d.x - tVector3d2.x;
        double d2 = d * d;
        d = tVector3d.y - tVector3d2.y;
        double d3 = d2 + d * d;
        d = tVector3d.z - tVector3d2.z;
        return Math.sqrt(d3 + d * d);
    }

    public double distanceLinf(Cell cell) {
        TVector3d tVector3d = this.position;
        TVector3d tVector3d2 = cell.position;
        double d = tVector3d.y - tVector3d2.y;
        d = tVector3d.x - tVector3d2.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d > d2) {
            d2 = d;
        } else if (-d > d2) {
            d2 = -d;
        }
        d = tVector3d.z - tVector3d2.z;
        return d > d2 ? d : (-d > d2 ? -d : d2);
    }

    public void preTransform(Object object, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2, GraphState graphState) {
        Object object2 = object == this ? (graphState.getInstancingPathIndex() <= 0 ? this.position : (Transform3D)graphState.checkObject((Object)this, true, Attributes.TRANSFORM, (Object)this.position)) : (Transform3D)graphState.getObject(object, bl, null, Attributes.TRANSFORM);
        if (object2 != null) {
            object2.transform(matrix4d, matrix4d2);
        } else {
            matrix4d2.set(matrix4d);
        }
    }

    public void postTransform(Object object, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2, Matrix4d matrix4d3, GraphState graphState) {
        boolean bl2 = object == this ? (graphState.getInstancingPathIndex() <= 0 ? (this.bits & 0x800) != 0 : graphState.checkBoolean((Object)this, true, Attributes.TRANSFORMING, (this.bits & 0x800) != 0)) : graphState.getBoolean(object, bl, Attributes.TRANSFORMING);
        if (bl2) {
            matrix4d2.set(matrix4d);
        } else if (matrix4d2 != matrix4d3) {
            matrix4d2.set(matrix4d3);
        }
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof ClickEvent) {
            // empty if block
        }
    }

    public String toString() {
        return "Cell[" + this.position + ",state=" + this.state + ']';
    }

    public int getSymbolColor() {
        return 0xFFFFA0;
    }

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.TRANSFORMATION);
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.BASE_OPEN));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.TOP_OPEN));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.SCALE_V));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.SHAPE));
        $TYPE.addAccessor((AttributeAccessor)new Node.FieldAttributeAccessor((Attribute)Attributes.SHADER, shader$FIELD){

            public Object getObject(Object object, Object object2, GraphState graphState) {
                return ((Cell)((Object)object)).getShader();
            }
        });
        $TYPE.setAttribute(shader$FIELD, (Attribute)Attributes.SHADER);
        $TYPE.addAccessor((AttributeAccessor)new Node.FieldAttributeAccessor((Attribute)Attributes.RADIUS, radius$FIELD){

            public float getFloat(Object object, GraphState graphState) {
                return ((Cell)((Object)object)).getRadius0();
            }
        });
        $TYPE.setAttribute(radius$FIELD, (Attribute)Attributes.RADIUS);
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.TRANSFORM){

            public boolean isWritable(Object object, GraphState graphState) {
                return true;
            }

            protected Object clone(Object object) {
                return new Vector3d((Tuple3d)object);
            }

            public Object setObject(Object object, Object object2, GraphState graphState) {
                Transaction transaction = ((State)graphState).getActiveTransaction();
                Cell cell = (Cell)((Object)object);
                if (object2 instanceof Tuple3d) {
                    Tuple3d tuple3d = (Tuple3d)object2;
                    x$FIELD.setDouble((Object)cell, null, tuple3d.x, transaction);
                    y$FIELD.setDouble((Object)cell, null, tuple3d.y, transaction);
                    z$FIELD.setDouble((Object)cell, null, tuple3d.z, transaction);
                } else if (object2 instanceof Tuple3f) {
                    Tuple3f tuple3f = (Tuple3f)object2;
                    x$FIELD.setDouble((Object)cell, null, (double)tuple3f.x, transaction);
                    y$FIELD.setDouble((Object)cell, null, (double)tuple3f.y, transaction);
                    z$FIELD.setDouble((Object)cell, null, (double)tuple3f.z, transaction);
                } else if (object2 instanceof Matrix4f) {
                    Matrix4f matrix4f = (Matrix4f)object2;
                    x$FIELD.setDouble((Object)cell, null, (double)matrix4f.m03, transaction);
                    y$FIELD.setDouble((Object)cell, null, (double)matrix4f.m13, transaction);
                    z$FIELD.setDouble((Object)cell, null, (double)matrix4f.m23, transaction);
                } else {
                    Matrix4d matrix4d;
                    if (object2 instanceof Matrix4d) {
                        matrix4d = (Matrix4d)object2;
                    } else {
                        matrix4d = new Matrix4d();
                        matrix4d.setIdentity();
                        if (object2 instanceof Transform3D) {
                            ((Transform3D)object2).transform(matrix4d, matrix4d);
                        }
                    }
                    x$FIELD.setDouble((Object)cell, null, matrix4d.m03, transaction);
                    y$FIELD.setDouble((Object)cell, null, matrix4d.m13, transaction);
                    z$FIELD.setDouble((Object)cell, null, matrix4d.m23, transaction);
                }
                return cell.position;
            }
        });
        $TYPE.setDependentAttribute(x$FIELD, (Attribute)Attributes.TRANSFORM);
        $TYPE.setDependentAttribute(y$FIELD, (Attribute)Attributes.TRANSFORM);
        $TYPE.setDependentAttribute(z$FIELD, (Attribute)Attributes.TRANSFORM);
        $TYPE.addDependency((Attribute)Attributes.TRANSFORM, (Attribute)Attributes.TRANSFORMATION);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Cell();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public void setShader(Shader shader) {
        shader$FIELD.setObject((Object)this, (Object)shader);
    }

    public boolean isTransforming() {
        return (this.bits & 0x800) != 0;
    }

    public void setTransforming(boolean bl) {
        this.bits = bl ? (this.bits |= 0x800) : (this.bits &= 0xFFFFF7FF);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)state$FIELD);
        shader$FIELD = new _Field("shader", 0x200004, (Type)ClassAdapter.wrap(Shader.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)shader$FIELD);
        transforming$FIELD = new Node.NType.BitField($TYPE, "transforming", 0x200000, Type.BOOLEAN, 2048);
        $TYPE.addManagedField((ManageableType.Field)transforming$FIELD);
        x$FIELD = new _Field("x", 0x200000, Type.DOUBLE, null, 2);
        $TYPE.addManagedField((ManageableType.Field)x$FIELD);
        y$FIELD = new _Field("y", 0x200000, Type.DOUBLE, null, 3);
        $TYPE.addManagedField((ManageableType.Field)y$FIELD);
        z$FIELD = new _Field("z", 0x200000, Type.DOUBLE, null, 4);
        $TYPE.addManagedField((ManageableType.Field)z$FIELD);
        radius$FIELD = new _Field("radius", 0x200004, Type.FLOAT, null, 5);
        $TYPE.addManagedField((ManageableType.Field)radius$FIELD);
        length$FIELD = new _Field("length", 0x200004, Type.FLOAT, null, 6);
        $TYPE.addManagedField((ManageableType.Field)length$FIELD);
        $TYPE.declareFieldAttribute(state$FIELD, (Attribute)Attributes.STATE);
        $TYPE.declareFieldAttribute(transforming$FIELD, (Attribute)Attributes.TRANSFORMING);
        $TYPE.declareFieldAttribute(length$FIELD, (Attribute)Attributes.LENGTH);
        Cell.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 0: {
                    ((Cell)((Object)object)).state = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Cell)((Object)object)).getState();
                }
            }
            return super.getInt(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 5: {
                    ((Cell)((Object)object)).radius = f;
                    return;
                }
                case 6: {
                    ((Cell)((Object)object)).length = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 5: {
                    return ((Cell)((Object)object)).getRadius();
                }
                case 6: {
                    return ((Cell)((Object)object)).getLength();
                }
            }
            return super.getFloat(object);
        }

        public void setDouble(Object object, double d) {
            switch (this.id) {
                case 2: {
                    ((Cell)((Object)object)).setX(d);
                    return;
                }
                case 3: {
                    ((Cell)((Object)object)).setY(d);
                    return;
                }
                case 4: {
                    ((Cell)((Object)object)).setZ(d);
                    return;
                }
            }
            super.setDouble(object, d);
        }

        public double getDouble(Object object) {
            switch (this.id) {
                case 2: {
                    return ((Cell)((Object)object)).getX();
                }
                case 3: {
                    return ((Cell)((Object)object)).getY();
                }
                case 4: {
                    return ((Cell)((Object)object)).getZ();
                }
            }
            return super.getDouble(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 1: {
                    ((Cell)((Object)object)).shader = (Shader)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 1: {
                    return ((Cell)((Object)object)).shader;
                }
            }
            return super.getObject(object);
        }
    }

    public static class Pattern
    extends FieldListPattern {
        public Pattern() {
            super((Type)$TYPE, (Field)state$FIELD);
        }

        private static void signature(@UserDefinedPattern.In @UserDefinedPattern.Out Cell cell, int n) {
        }
    }
}

