/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.numeric;

import de.grogra.graph.impl.Extent;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.numeric.ClsEntry;
import de.grogra.numeric.FirstOrderIntegratorAdapter;
import de.grogra.numeric.Monitor;
import de.grogra.numeric.MonitorEntry;
import de.grogra.numeric.NumericException;
import de.grogra.numeric.ODE;
import de.grogra.numeric.RateEntry;
import de.grogra.numeric.Solver;
import de.grogra.numeric.Tolerance;
import de.grogra.persistence.PersistenceField;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.TypeItem;
import de.grogra.reflect.Annotation;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.rgg.model.PropertyRuntime;
import de.grogra.xl.lang.VoidToDouble;
import de.grogra.xl.ode.RateAssignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.nonstiff.DormandPrince54Integrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphODE
implements ODE {
    HashMap<Class, RateEntry> rateTable;
    Solver solver = new FirstOrderIntegratorAdapter((FirstOrderIntegrator)new DormandPrince54Integrator(0.0, 1.0, 1.0E-4, 1.0E-4));
    double[] state;
    double[] absTol;
    double[] relTol;
    final ArrayList<MonitorEntry> monitors = new ArrayList();

    public abstract void getRate();

    public final void getRate(double[] dArray, double d, double[] dArray2) {
        GraphManager graphManager = Library.graph();
        Arrays.fill(dArray, 0.0);
        graphManager.rate = dArray;
        this.copyStateToGraph(dArray2, false);
        this.getRate();
    }

    /*
     * WARNING - void declaration
     */
    public void integrate(double d) throws NumericException {
        GraphManager graphManager = Library.graph();
        graphManager.baseMap.clear();
        if (this.rateTable == null) {
            List<RateAssignment> list = GraphODE.getRateAssignments(Library.workbench().getRegistry());
            this.rateTable = this.calculateOffsets(list);
        }
        int n = 0;
        for (RateEntry rateEntry : this.rateTable.values()) {
            Extent extent = graphManager.getExtent(rateEntry.cls);
            int n2 = extent.totalSize();
            n += n2 * rateEntry.props.length;
        }
        if (this.state == null || this.state.length != n) {
            this.state = new double[n > 0 ? n : 1];
            this.absTol = new double[n > 0 ? n : 1];
            this.relTol = new double[n > 0 ? n : 1];
        }
        Arrays.fill(this.absTol, 0.0);
        Arrays.fill(this.relTol, 0.0);
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        LinkedList linkedList = new LinkedList();
        for (RateEntry rateEntry : this.rateTable.values()) {
            Extent extent = graphManager.getExtent(rateEntry.cls);
            while (extent != null) {
                for (int i = 0; i <= 7; ++i) {
                    Node node = extent.getFirstNode(i);
                    while (node != null) {
                        long l = node.getId();
                        if (!graphManager.baseMap.containsKey(l)) {
                            void var17_23;
                            Class<?> clazz = node.getClass();
                            RateEntry rateEntry2 = this.rateTable.get(clazz);
                            while (var17_23 == null) {
                                clazz = clazz.getSuperclass();
                                RateEntry rateEntry3 = this.rateTable.get(clazz);
                            }
                            graphManager.baseMap.put(l, n3);
                            n3 += var17_23.m;
                        }
                        int n4 = graphManager.baseMap.get(l);
                        for (PropertyRuntime.GraphProperty graphProperty : rateEntry.props) {
                            Annotation annotation;
                            double d2;
                            this.state[n4 + graphProperty.offset] = d2 = graphProperty.getDouble(node, null);
                            PersistenceField persistenceField = graphProperty.getField();
                            Field field = Reflection.getDeclaredField((Type)persistenceField.getDeclaringType(), (String)persistenceField.getDescriptor());
                            if (field == null || (annotation = Reflection.getDeclaredAnnotation((Member)field, Tolerance.class)) == null) continue;
                            double d3 = (Double)annotation.value("absolute");
                            double d4 = (Double)annotation.value("relative");
                            this.absTol[n4 + graphProperty.offset] = d3;
                            this.relTol[n4 + graphProperty.offset] = d4;
                            bl |= d3 != 0.0;
                            bl2 |= d4 != 0.0;
                        }
                        node = extent.getNextNode(node);
                    }
                }
                if (extent.totalSize() > extent.size()) {
                    extent.getSubExtents(linkedList);
                }
                extent = (Extent)linkedList.poll();
            }
        }
        assert (n3 == n);
        this.solver.setTolerances(bl ? this.absTol : null, bl2 ? this.relTol : null);
        Monitor monitor = new Monitor(){

            public void g(double[] dArray, double d, double[] dArray2) {
                GraphODE.this.copyStateToGraph(dArray2, false);
                for (int i = 0; i < GraphODE.this.monitors.size(); ++i) {
                    dArray[i] = GraphODE.this.monitors.get(i).g(d, dArray2);
                }
            }

            public boolean handleEvent(int n, double d, double[] dArray) {
                GraphODE.this.copyStateToGraph(dArray, false);
                return GraphODE.this.monitors.get(n).handleEvent(d, dArray);
            }
        };
        this.solver.setMonitor(this.monitors.size(), monitor);
        this.solver.integrate((ODE)this, 0.0, this.state, d, this.state);
        this.copyStateToGraph(this.state, true);
    }

    public Solver getSolver() {
        return this.solver;
    }

    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    public void monitor(VoidToDouble voidToDouble) {
        this.monitor(voidToDouble, null);
    }

    public void monitor(final VoidToDouble voidToDouble, final Runnable runnable) {
        assert (voidToDouble != null);
        this.monitors.add(new MonitorEntry(){

            public boolean handleEvent(double d, double[] dArray) {
                if (runnable != null) {
                    runnable.run();
                }
                return true;
            }

            public double g(double d, double[] dArray) {
                return voidToDouble.evaluateDouble();
            }
        });
    }

    public void monitorPeriodic(final double d, final Runnable runnable) {
        assert (runnable != null);
        this.monitors.add(new MonitorEntry(){

            public boolean handleEvent(double d2, double[] dArray) {
                runnable.run();
                return false;
            }

            public double g(double d2, double[] dArray) {
                return Math.sin(Math.PI * d2 / d);
            }
        });
    }

    public void unmonitor() {
        this.monitors.clear();
    }

    /*
     * WARNING - void declaration
     */
    HashMap<Class, RateEntry> calculateOffsets(List<RateAssignment> list) {
        Object object;
        Iterator<PropertyRuntime.GraphProperty> iterator;
        Object object322;
        HashMap<Class, ClsEntry> hashMap = new HashMap<Class, ClsEntry>();
        ClsEntry clsEntry = new ClsEntry();
        clsEntry.cls = Object.class;
        hashMap.put(Object.class, clsEntry);
        for (Object object322 : list) {
            void object22;
            iterator = (PropertyRuntime.GraphProperty)object322.property;
            ((PropertyRuntime.GraphProperty)((Object)iterator)).offset = -1;
            ClsEntry clsEntry2 = (ClsEntry)hashMap.get(object322.cls);
            if (clsEntry2 == null) {
                ClsEntry clsEntry3 = new ClsEntry();
                clsEntry3.cls = object322.cls;
                hashMap.put(object322.cls, clsEntry3);
            }
            if (object22.props.contains(iterator)) continue;
            object22.props.add((PropertyRuntime.GraphProperty)((Object)iterator));
        }
        for (Object object322 : hashMap.values()) {
            void var7_12;
            if (object322 == clsEntry) continue;
            iterator = object322.cls.getSuperclass();
            ClsEntry clsEntry4 = (ClsEntry)hashMap.get(iterator);
            while (var7_12 == null) {
                iterator = ((Class)((Object)iterator)).getSuperclass();
                ClsEntry clsEntry5 = (ClsEntry)hashMap.get(iterator);
            }
            object322.parent = var7_12;
            object322.next = var7_12.child;
            var7_12.child = object322;
        }
        HashMap hashMap2 = new HashMap();
        object322 = clsEntry.child;
        while (object322 != null) {
            ClsEntry clsEntry6;
            object322.size = object322.parent.size;
            for (PropertyRuntime.GraphProperty graphProperty : object322.props) {
                clsEntry6 = graphProperty.getField();
                object = (PropertyRuntime.GraphProperty)hashMap2.get(clsEntry6);
                if (object != null) {
                    graphProperty.offset = ((PropertyRuntime.GraphProperty)object).offset;
                    continue;
                }
                hashMap2.put(clsEntry6, graphProperty);
                ++object322.size;
                graphProperty.offset = graphProperty.offset;
            }
            if (object322.child != null) {
                object322 = object322.child;
                continue;
            }
            iterator = object322.props.iterator();
            while (iterator.hasNext()) {
                PropertyRuntime.GraphProperty graphProperty = (PropertyRuntime.GraphProperty)iterator.next();
                clsEntry6 = graphProperty.getField();
                object = (PropertyRuntime.GraphProperty)hashMap2.get(clsEntry6);
                if (object == graphProperty) {
                    hashMap2.remove(clsEntry6);
                    continue;
                }
                iterator.remove();
            }
            while (object322 != clsEntry && object322.next == null) {
                object322 = object322.parent;
                iterator = object322.props.iterator();
                while (iterator.hasNext()) {
                    PropertyRuntime.GraphProperty graphProperty = iterator.next();
                    clsEntry6 = graphProperty.getField();
                    object = (PropertyRuntime.GraphProperty)hashMap2.get(clsEntry6);
                    if (object == graphProperty) {
                        hashMap2.remove(clsEntry6);
                        continue;
                    }
                    iterator.remove();
                }
            }
            object322 = object322.next;
        }
        iterator = new HashMap();
        for (ClsEntry clsEntry6 : hashMap.values()) {
            if (clsEntry6.props.size() <= 0) continue;
            object = new RateEntry();
            ((RateEntry)object).cls = clsEntry6.cls;
            ((RateEntry)object).m = clsEntry6.size;
            ((RateEntry)object).props = clsEntry6.props.toArray(new PropertyRuntime.GraphProperty[clsEntry6.props.size()]);
            ((HashMap)((Object)iterator)).put(((RateEntry)object).cls, object);
        }
        return iterator;
    }

    void copyStateToGraph(double[] dArray, boolean bl) {
        GraphManager graphManager = Library.graph();
        LinkedList linkedList = new LinkedList();
        for (RateEntry rateEntry : this.rateTable.values()) {
            Extent extent = graphManager.getExtent(rateEntry.cls);
            while (extent != null) {
                for (int i = 0; i <= 7; ++i) {
                    Node node = extent.getFirstNode(i);
                    while (node != null) {
                        long l = node.getId();
                        int n = graphManager.baseMap.get(l);
                        for (PropertyRuntime.GraphProperty graphProperty : rateEntry.props) {
                            double d = dArray[n + graphProperty.offset];
                            if (bl) {
                                graphProperty.setDouble(node, null, d);
                                continue;
                            }
                            graphProperty.getField().setDouble((Object)node, null, d, null);
                        }
                        node = extent.getNextNode(node);
                    }
                }
                if (extent.totalSize() > extent.size()) {
                    extent.getSubExtents(linkedList);
                }
                extent = (Extent)linkedList.poll();
            }
        }
    }

    public static List<RateAssignment> getRateAssignments(Registry registry) {
        ArrayList<RateAssignment> arrayList = new ArrayList<RateAssignment>();
        Item item = registry.getItem("/classes");
        for (Item item2 = (Item)item.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
            if (!item2.getName().endsWith("$ODEHelper")) continue;
            try {
                RateAssignment[] rateAssignmentArray = (RateAssignment[])Reflection.get(null, (Field)Reflection.getDeclaredField((Type)((Type)((TypeItem)item2).getObject()), (String)"TABLE"));
                arrayList.addAll(Arrays.asList(rateAssignmentArray));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return arrayList;
    }
}

