/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.Attribute;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.PolygonMesh;
import de.grogra.math.TMatrix4d;
import de.grogra.mtg.Attributes;
import de.grogra.mtg.MTGBranch;
import de.grogra.mtg.MTGBranchElement;
import de.grogra.mtg.MTGDressingData;
import de.grogra.mtg.MTGDressingDefaultValues;
import de.grogra.mtg.MTGDressingFile;
import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGNodeData;
import de.grogra.mtg.MTGNodeDataClasses;
import de.grogra.mtg.MTGNodeDataFeature;
import de.grogra.mtg.MTGSquares;
import de.grogra.mtg.MTGVoxel;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTGRoot
extends MTGNode
implements Renderable {
    protected PolygonMesh polygons = null;
    private double dist;
    protected int visibleSides = 2;
    private MTGNodeData nodeData = new MTGNodeData();
    public static final Node.NType $TYPE = new Node.NType(MTGRoot.class);
    public static final Node.NType.Field dist$FIELD = new _Field("dist", 0x200001, Type.DOUBLE, null, 0);
    public static final Node.NType.Field visibleSides$FIELD;

    @Override
    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    @Override
    protected Node newInstance() {
        return new MTGRoot();
    }

    public void setPolygons(PolygonMesh polygonMesh) {
        this.polygons = polygonMesh;
    }

    public PolygonMesh getPolygons() {
        return this.polygons;
    }

    public Object getObject(String string) {
        return this.nodeData.getObject(string);
    }

    public void setObject(String string, Object object) {
        if (this.nodeData == null) {
            this.nodeData = new MTGNodeData();
        }
        this.nodeData.setObject(string, object);
    }

    public MTGNodeData getData() {
        return this.nodeData;
    }

    public void setData(MTGNodeData mTGNodeData) {
        this.nodeData = mTGNodeData;
    }

    private void addNodeToNodeList(MTGNode mTGNode) throws MTGError.MTGPlantFrameException {
        Object object = this.getObject("Node List");
        if (object == null) {
            throw new MTGError.MTGPlantFrameException("Node list not instantiated before adding node to list.");
        }
        ArrayList arrayList = (ArrayList)object;
        arrayList.add(mTGNode);
        mTGNode.mtgID = arrayList.size() - 1;
    }

    public void deleteNodeList() {
        this.setObject("Node List", null);
    }

    public void refreshNodeIndices() throws MTGError.MTGPlantFrameException {
        Object object = this.getObject("Node List");
        if (object == null) {
            ArrayList arrayList = new ArrayList();
            this.setObject("Node List", arrayList);
        } else {
            ArrayList arrayList = (ArrayList)object;
            arrayList.clear();
        }
        this.mtgID = -1;
        this.refreshNodeIndicesInternal(this);
    }

    private void refreshNodeIndicesInternal(MTGNode mTGNode) throws MTGError.MTGPlantFrameException {
        Edge edge;
        for (edge = mTGNode.getFirstEdge(); edge != null; edge = edge.getNext((Node)mTGNode)) {
            if (edge.getSource() != mTGNode || !edge.testEdgeBits(4096)) continue;
            this.addNodeToNodeList((MTGNode)edge.getTarget());
            this.refreshNodeIndicesInternal((MTGNode)edge.getTarget());
        }
        if (mTGNode != this) {
            for (edge = mTGNode.getFirstEdge(); edge != null; edge = edge.getNext((Node)mTGNode)) {
                if (edge.getSource() != mTGNode || !edge.testEdgeBits(256) && !edge.testEdgeBits(512)) continue;
                this.addNodeToNodeList((MTGNode)edge.getTarget());
                this.refreshNodeIndicesInternal((MTGNode)edge.getTarget());
            }
        }
    }

    public void removeInterScaleTopoRelations() throws MTGError.MTGPlantFrameException {
        int[] nArray = this.getRootIds(-1);
        for (int i = 0; i < nArray.length; ++i) {
            this.removeInterScaleTopoRelationsInternal(nArray[i]);
        }
    }

    private void removeInterScaleTopoRelationsInternal(int n) throws MTGError.MTGPlantFrameException {
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        while (!bl) {
            int[] nArray = this.topoSons(n, -1);
            if (nArray.length == 0) {
                bl = true;
            }
            int n3 = n;
            for (int i = 0; i < nArray.length; ++i) {
                int n4;
                n2 = nArray[i];
                int n5 = this.getScale(n);
                if (n5 != (n4 = this.getScale(n2))) {
                    MTGNode mTGNode = this.getNode(n);
                    MTGNode mTGNode2 = this.getNode(n2);
                    mTGNode.removeEdgeBitsTo((Node)mTGNode2, this.edgeType(n, n2), null);
                    continue;
                }
                if (this.edgeType(n, n2) == 256) {
                    n3 = n2;
                    continue;
                }
                arrayList.add(new Integer(n2));
            }
            if (n == n3) {
                bl = true;
                continue;
            }
            n = n3;
        }
        while (!arrayList.isEmpty()) {
            n2 = (Integer)arrayList.remove(0);
            this.removeInterScaleTopoRelationsInternal(n2);
        }
    }

    private void refreshNodeList() throws MTGError.MTGPlantFrameException {
        this.refreshNodeIndices();
    }

    private Vector3d getSupportDirVector(int n) throws MTGError.MTGPlantFrameException {
        Vector3d vector3d = null;
        if (n == -1) {
            vector3d = new Vector3d(0.0, 0.0, 1.0);
        } else {
            MTGBranchElement mTGBranchElement = this.searchForElement(n);
            if (mTGBranchElement == null) {
                throw new MTGError.MTGPlantFrameException("Node index with no corresponding branch element.");
            }
            vector3d = new Vector3d(mTGBranchElement.getDirp());
        }
        return vector3d;
    }

    private Vector3d getSupportDirsVector(int n) throws MTGError.MTGPlantFrameException {
        Vector3d vector3d = null;
        if (n == -1) {
            vector3d = new Vector3d(1.0, 0.0, 0.0);
        } else {
            MTGBranchElement mTGBranchElement = this.searchForElement(n);
            if (mTGBranchElement == null) {
                throw new MTGError.MTGPlantFrameException("Node index with no corresponding branch element.");
            }
            vector3d = new Vector3d(mTGBranchElement.getDirs());
        }
        return vector3d;
    }

    private double angleAlongXAxis(Point3d point3d) {
        double d = 0.0;
        if (point3d.y <= 0.0 && point3d.z >= 0.0) {
            if (point3d.y != 0.0) {
                d = point3d.z != 0.0 ? Math.atan(Math.abs(point3d.y) / point3d.z) : 1.5707963267948966;
            }
        } else if (point3d.y <= 0.0 && point3d.z < 0.0) {
            d = point3d.y == 0.0 ? Math.PI : 1.5707963267948966 + Math.atan(Math.abs(point3d.z) / Math.abs(point3d.y));
        } else if (point3d.y > 0.0 && point3d.z < 0.0) {
            d = Math.PI + Math.atan(point3d.y / Math.abs(point3d.z));
        } else if (point3d.y > 0.0 && point3d.z >= 0.0) {
            d = point3d.z == 0.0 ? 4.71238898038469 : 4.71238898038469 + Math.atan(point3d.z / point3d.y);
        }
        return d *= -1.0;
    }

    private double angleAlongYAxis(Point3d point3d) {
        double d = 0.0;
        if (point3d.x >= 0.0 && point3d.z >= 0.0) {
            if (point3d.x != 0.0) {
                d = point3d.z != 0.0 ? Math.atan(point3d.x / point3d.z) : 1.5707963267948966;
            }
        } else if (point3d.x >= 0.0 && point3d.z < 0.0) {
            d = point3d.x == 0.0 ? Math.PI : 1.5707963267948966 + Math.atan(Math.abs(point3d.z) / point3d.x);
        } else if (point3d.x < 0.0 && point3d.z < 0.0) {
            d = Math.PI + Math.atan(Math.abs(point3d.x) / Math.abs(point3d.z));
        } else if (point3d.x < 0.0 && point3d.z >= 0.0) {
            d = point3d.z == 0.0 ? 4.71238898038469 : 4.71238898038469 + Math.atan(point3d.z / Math.abs(point3d.x));
        }
        return d *= -1.0;
    }

    private Vector3d computeInterNodeRotation(Vector3d vector3d, Vector3d vector3d2) throws MTGError.MTGPlantFrameException {
        Point3d point3d = new Point3d(vector3d.x, vector3d.y, vector3d.z);
        Point3d point3d2 = new Point3d(vector3d2.x, vector3d2.y, vector3d2.z);
        try {
            double d = this.angleAlongXAxis(point3d);
            Point3d point3d3 = new Point3d();
            Point3d point3d4 = new Point3d();
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            matrix4d.rotX(d);
            matrix4d.transform(point3d, point3d3);
            matrix4d.transform(point3d2, point3d4);
            double d2 = this.angleAlongYAxis(point3d3);
            Point3d point3d5 = new Point3d();
            Point3d point3d6 = new Point3d();
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d2.setIdentity();
            matrix4d2.rotY(d2);
            matrix4d2.transform(point3d3, point3d5);
            matrix4d2.transform(point3d4, point3d6);
            Vector3d vector3d3 = new Vector3d();
            double d3 = this.angleAlongYAxis(point3d6);
            Point3d point3d7 = new Point3d();
            Matrix4d matrix4d3 = new Matrix4d();
            matrix4d3.setIdentity();
            matrix4d3.rotY(d3);
            matrix4d3.transform(point3d6, point3d7);
            double d4 = this.angleAlongXAxis(point3d7);
            return new Vector3d(-d4, -d3, 0.0);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void computeInterNodeTransformation() throws MTGError.MTGPlantFrameException {
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            MTGBranch mTGBranch = arrayList.get(i);
            int n = mTGBranch.getSupportNodeIndex();
            Vector3d vector3d = this.getSupportDirVector(n);
            if (vector3d == null) {
                throw new MTGError.MTGPlantFrameException("No preceeding direction vector found.");
            }
            Vector3d vector3d2 = this.getSupportDirsVector(n);
            if (vector3d2 == null) {
                throw new MTGError.MTGPlantFrameException("No preceeding secondary direction vector found.");
            }
            for (int j = 0; j < mTGBranch.getElementCount(); ++j) {
                MTGBranchElement mTGBranchElement;
                MTGBranchElement mTGBranchElement2 = mTGBranch.getElement(j);
                int n2 = mTGBranchElement2.getNodeIndex();
                if (n2 == -1) {
                    throw new MTGError.MTGPlantFrameException("Branch element referencing no node instance.");
                }
                MTGNode mTGNode = this.getNode(n2);
                if (mTGNode == null) {
                    throw new MTGError.MTGPlantFrameException("Branch element referencing no node instance.");
                }
                Vector3d vector3d3 = mTGBranchElement2.getDirp();
                Vector3d vector3d4 = mTGBranchElement2.getDirs();
                if (vector3d3 == null) {
                    throw new MTGError.MTGPlantFrameException("No direction vector found for branch element.");
                }
                if (vector3d4 == null) {
                    throw new MTGError.MTGPlantFrameException("No secondary direction vector found for branch element.");
                }
                Vector3d vector3d5 = null;
                Vector3d vector3d6 = null;
                if (j == 0) {
                    vector3d5 = this.computeInterNodeRotation(vector3d, vector3d3);
                    vector3d6 = this.computeInterNodeRotation(vector3d2, vector3d4);
                } else {
                    mTGBranchElement = mTGBranch.getElement(j - 1);
                    Vector3d vector3d7 = mTGBranchElement.getDirp();
                    Vector3d vector3d8 = mTGBranchElement.getDirs();
                    vector3d5 = this.computeInterNodeRotation(vector3d7, vector3d3);
                    vector3d6 = this.computeInterNodeRotation(vector3d8, vector3d4);
                }
                if (vector3d5 == null) {
                    throw new MTGError.MTGPlantFrameException("Fail to compute inter-node rotation transformation.");
                }
                if (vector3d6 == null) {
                    throw new MTGError.MTGPlantFrameException("Fail to compute inter-node secondary rotation transformation.");
                }
                mTGBranchElement = this.combinePriSecRotation(vector3d5.x, vector3d5.y, vector3d5.z, 0.0, 0.0, 0.0);
                mTGNode.setTransform((Matrix4d)mTGBranchElement);
                mTGNode.length = (float)mTGBranchElement2.getLength();
                mTGNode.diameter = (float)mTGBranchElement2.getBotDia();
                if (!(mTGNode.diameter < 0.001f)) continue;
                mTGNode.diameter = 0.001f;
            }
        }
    }

    public Matrix4d combinePriSecRotation(double d, double d2, double d3, double d4, double d5, double d6) {
        TMatrix4d tMatrix4d = new TMatrix4d();
        tMatrix4d.rotZ(d3);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.rotY(d2);
        tMatrix4d.mul(matrix4d);
        matrix4d.rotX(d);
        tMatrix4d.mul(matrix4d);
        TMatrix4d tMatrix4d2 = new TMatrix4d();
        tMatrix4d2.rotZ(d6);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.rotY(d5);
        tMatrix4d2.mul(matrix4d2);
        matrix4d2.rotX(d4);
        tMatrix4d2.mul(matrix4d2);
        tMatrix4d.mul((Matrix4d)tMatrix4d2);
        return tMatrix4d;
    }

    public void plantFrameDelete(int n) {
        ArrayList<MTGNode> arrayList = new ArrayList<MTGNode>();
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
            if (edge.getSource() != this || !edge.testEdgeBits(768)) continue;
            MTGNode mTGNode = (MTGNode)edge.getTarget();
            if (mTGNode.mtgScale != n) continue;
            arrayList.add(mTGNode);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.removeEdgeBitsTo((Node)arrayList.get(i), 768, null);
        }
    }

    public void plantFrame(int n, double d) throws MTGError.MTGPlantFrameException {
        try {
            int n2;
            Serializable serializable;
            Object object;
            this.dist = d;
            MTGDressingFile mTGDressingFile = new MTGDressingFile();
            this.setObject("Dressing", mTGDressingFile);
            this.setObject("Plant Origin", new Vector3d(0.0, 0.0, 0.0));
            Object object2 = this.getObject("Plant Min");
            if (object2 == null) {
                this.setObject("Plant Min", new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE));
            }
            if ((object = this.getObject("Plant Max")) == null) {
                this.setObject("Plant Max", new Vector3d(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE));
            }
            this.refreshNodeList();
            this.removeAllSuccOrBranchEdges(n);
            int[] nArray = this.getRootIds(n);
            Object object3 = this.getObject("Branches");
            if (object3 == null) {
                serializable = new ArrayList();
                this.setObject("Branches", serializable);
            } else {
                serializable = (ArrayList)object3;
                serializable.clear();
            }
            serializable = new Integer(0);
            this.setObject("Plant Count", serializable);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.lookForBranches(nArray[n2], n, 0);
            }
            n2 = this.mtgType();
            switch (n2) {
                case 2: 
                case 3: {
                    this.computeGeometry(n2, n);
                    break;
                }
                default: {
                    this.computeGeometryStandard(n2, n);
                }
            }
            this.downSizeBranches();
            this.polygons = null;
            this.computeInterNodeTransformation();
            this.connectToVisibleScale(nArray);
            this.clearNonPersistantData();
        }
        catch (Throwable throwable) {
            System.out.println("Unable to compute Plant Frame.");
        }
    }

    private void clearNonPersistantData() {
        Object object = this.getObject("CLASSES");
        Object object2 = this.getObject("FEATURES");
        MTGNodeData mTGNodeData = new MTGNodeData();
        mTGNodeData.setObject("CLASSES", object);
        mTGNodeData.setObject("FEATURES", object2);
        this.setData(mTGNodeData);
    }

    private void computeGeometryStandard(int n, int n2) throws MTGError.MTGPlantFrameException {
        if (n != 1) {
            throw new MTGError.MTGPlantFrameException("Unable to compute standard MTG geometry.");
        }
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("No branch information available for geometry computation.");
        }
        int n3 = arrayList.size();
        this.computeAzimuth(n2);
        this.setupCoordinateVariables();
        for (int i = 0; i < n3; ++i) {
            MTGBranch mTGBranch = arrayList.get(i);
            if (mTGBranch.getSupportNodeIndex() == -1) {
                this.newTrunk(i);
            }
            this.computeBranchLengthsStandard(i);
            this.computeDiameters(i, n2);
            this.computeCategory(i);
            this.computeAlpha(i);
            this.computeBranchCoordinatesStandard(i, n2);
        }
    }

    double lookForRatio(int n, int n2) throws MTGError.MTGPlantFrameException {
        double d = -1.0;
        double d2 = 0.1;
        int[] nArray = this.topoSons(n, 512);
        int n3 = nArray == null ? 0 : nArray.length;
        d = n3 != 0 ? 1.0 + (double)(n3 + 1) * d2 : 1.0;
        for (int i = 0; i < n3; ++i) {
            if (n2 == nArray[i]) continue;
            d -= d2;
        }
        if (d == -1.0) {
            throw new MTGError.MTGPlantFrameException("Error looking for ratio while computing coordinates");
        }
        return d;
    }

    public int findLocalTopoRoot(int n, int n2) throws MTGError.MTGPlantFrameException {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Node does not exists for finding local topological root.");
        }
        int n3 = n;
        int n4 = -1;
        int n5 = -1;
        do {
            n = n3;
            n5 = this.compoFather(n);
            n3 = this.topoFather(n, n2);
            n4 = n3 != -1 ? this.compoFather(n3) : -1;
        } while (n3 != -1 && n4 == n5);
        return n;
    }

    private int pathLengthInternal(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        if (n == n2) {
            return 0;
        }
        while (n4 != -1) {
            n4 = this.topoFather(n4, n3);
            ++n5;
            if (n4 != n) continue;
            return n5;
        }
        return -1;
    }

    public int pathLength(int n, int n2, int n3) {
        int n4 = 0;
        n4 = this.pathLengthInternal(n, n2, n3);
        return n4;
    }

    private double computeRatio(int n, int n2) throws MTGError.MTGPlantFrameException {
        double d = -1.0;
        int n3 = this.location(n2);
        if (this.getScale(n2) > this.getScale(n3)) {
            d = this.lookForRatio(n, n2);
        } else {
            int[] nArray = this.compoSonsIds(n, this.getScale(n3));
            if (nArray == null) {
                throw new MTGError.MTGPlantFrameException("Invalid null for compositional sons of given node");
            }
            if (nArray.length > 0) {
                int n4 = this.findLocalTopoRoot(n3, -1);
                double d2 = this.pathLength(n4, n3, -1);
                if (d2 == 0.0) {
                    d2 = 1.0;
                }
                double d3 = nArray.length;
                d = d3 / d2;
            } else {
                d = 1.0;
            }
        }
        if (d == -1.0) {
            throw new MTGError.MTGPlantFrameException("Invalid ramification ratio while computing standard plant frame geometry.");
        }
        return d;
    }

    private Vector3d computeElementCoordinatesStandard(MTGBranchElement mTGBranchElement, double d, int n) throws MTGError.MTGPlantFrameException {
        int n2 = mTGBranchElement.getNodeIndex();
        MTGNode mTGNode = this.getNode(n2);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Invalid node for branch element during coordinate computation.");
        }
        int n3 = this.topoFather(n2, -1);
        if (n3 == -1) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            this.updatePlantMinMax(new Vector3d(d2, d3, d4));
            Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
            Vector3d vector3d2 = new Vector3d(1.0, 0.0, 0.0);
            Vector3d vector3d3 = new Vector3d(d2, d3, d4);
            double d5 = 1.5707963267948966;
            double d6 = 0.0;
            double d7 = mTGBranchElement.getLength();
            if (d7 != 0.0) {
                d5 = this.computeElevationAlpha(vector3d);
                d6 = this.computeAzimuthBeta(vector3d);
            }
            Vector3d vector3d4 = (Vector3d)this.getObject("Coord Origin");
            this.setObject("Coord Origin", new Vector3d(vector3d3.x + vector3d4.x, vector3d3.y + vector3d4.y, vector3d3.z + vector3d4.z));
            mTGBranchElement.setDirp(vector3d);
            mTGBranchElement.setDirs(vector3d2);
            mTGBranchElement.setOrigin(vector3d3);
            mTGBranchElement.setAlpha(d5);
            mTGBranchElement.setBeta(d6);
            return new Vector3d(vector3d.x * d7, vector3d.y * d7, vector3d.z * d7);
        }
        double d8 = mTGBranchElement.getBeta();
        double d9 = 0.0;
        double d10 = 1.0;
        MTGBranchElement mTGBranchElement2 = this.searchForElement(n3);
        Vector3d vector3d = null;
        if (this.edgeType(n3, n2) == 512) {
            d9 = d;
            d10 = this.computeRatio(n3, n2);
            d8 = mTGBranchElement.getBeta();
            MTGDressingFile mTGDressingFile = this.getDressingFile();
            if (mTGDressingFile == null) {
                throw new MTGError.MTGPlantFrameException("Dressing not available for computing branch coordinates.");
            }
            if (mTGDressingFile.isAlphaRelative()) {
                vector3d = this.putOn(mTGBranchElement2, mTGBranchElement, d9, d8, d10, n);
            }
        } else {
            vector3d = this.putOn(mTGBranchElement2, mTGBranchElement, d9, d8, d10, n);
        }
        return vector3d;
    }

    private Vector3d findSecondaryDirection(double d, double d2, double d3) {
        return new Vector3d(-Math.sin(d2) * Math.cos(d3) + Math.cos(d2) * Math.sin(d) * Math.sin(d3), Math.cos(d2) * Math.cos(d3) + Math.sin(d2) * Math.sin(d) * Math.sin(d3), Math.cos(d) * Math.sin(d3));
    }

    private double getDefaultPsi(int n) {
        MTGDressingFile mTGDressingFile = this.getDressingFile();
        return (double)mTGDressingFile.getDefaultPsi() / (double)n;
    }

    Vector3d putOn(MTGBranchElement mTGBranchElement, MTGBranchElement mTGBranchElement2, double d, double d2, double d3, int n) throws MTGError.MTGPlantFrameException {
        if (mTGBranchElement.getLength() < 0.0) {
            throw new MTGError.MTGPlantFrameException("Invalid length for base element.");
        }
        if (this.getNode(mTGBranchElement.getNodeIndex()) == null) {
            throw new MTGError.MTGPlantFrameException("Invalid base element.");
        }
        double d4 = mTGBranchElement.getAlpha();
        double d5 = mTGBranchElement.getBeta();
        double d6 = mTGBranchElement.getLength();
        Vector3d vector3d = mTGBranchElement.getOrigin();
        double d7 = 1.5707963267948966 - d;
        Vector3d vector3d2 = mTGBranchElement.getDirp();
        Vector3d vector3d3 = mTGBranchElement.getDirs();
        if (vector3d2 == null || vector3d3 == null) {
            return null;
        }
        Vector3d vector3d4 = mTGBranchElement.getDirt();
        vector3d2.normalize();
        vector3d4.normalize();
        vector3d3.normalize();
        Vector3d vector3d5 = new Vector3d();
        this.setElevationAzimuth(vector3d5, d7, d2);
        this.changeBenchmark(vector3d5, vector3d4, vector3d3, vector3d2);
        vector3d5.normalize();
        double d8 = 0.0;
        d8 = this.getDefaultPsi(n);
        Vector3d vector3d6 = this.findSecondaryDirection(d7, d2, d8);
        this.changeBenchmark(vector3d6, vector3d4, vector3d3, vector3d2);
        vector3d6.normalize();
        double d9 = mTGBranchElement2.getLength();
        Vector3d vector3d7 = mTGBranchElement.getDirp();
        Vector3d vector3d8 = new Vector3d();
        vector3d8.add((Tuple3d)vector3d7, (Tuple3d)vector3d);
        mTGBranchElement2.setDirp(vector3d5);
        mTGBranchElement2.setDirs(vector3d6);
        mTGBranchElement2.setOrigin(vector3d8);
        double d10 = 0.0;
        double d11 = 0.0;
        if (vector3d5.length() != 0.0) {
            d10 = this.computeElevationAlpha(vector3d5);
            d11 = this.computeAzimuthBeta(vector3d5);
        }
        mTGBranchElement2.setAlpha(d10);
        mTGBranchElement2.setBeta(d11);
        Vector3d vector3d9 = new Vector3d();
        vector3d9.scale(d9, (Tuple3d)vector3d5);
        vector3d9.add((Tuple3d)vector3d9, (Tuple3d)mTGBranchElement2.getOrigin());
        return vector3d9;
    }

    private void computeAlpha(int n) throws MTGError.MTGPlantFrameException {
        MTGBranch mTGBranch = this.getBranch(n);
        int n2 = mTGBranch.baseOfBranch();
        mTGBranch.setAlpha(this.computeElementAngle(n2));
    }

    private double computeElementAngle(int n) {
        double d = -1.0;
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode.hasAlpha()) {
            d = mTGNode.Alpha;
        } else {
            d = this.lookUpForAlpha(n);
            if (d != -1.0) {
                return d;
            }
            d = this.lookDownForAlpha(n);
        }
        return d;
    }

    private double lookDownForAlpha(int n) {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode.hasAlpha()) {
            return mTGNode.Alpha;
        }
        int[] nArray = this.compoSonsIds(n);
        if (nArray != null && nArray.length >= 1) {
            return this.lookDownForAlpha(nArray[0]);
        }
        return -1.0;
    }

    private double lookUpForAlpha(int n) {
        int[] nArray;
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode.hasAlpha()) {
            return mTGNode.TopDia;
        }
        int n2 = this.compoFather(n);
        if (n2 != -2 && (nArray = this.compoSonsIds(n2)).length >= 1 && nArray[0] == n) {
            return this.lookUpForAlpha(n2);
        }
        return -1.0;
    }

    private void computeBranchCoordinatesStandard(int n, int n2) throws MTGError.MTGPlantFrameException {
        MTGBranch mTGBranch = this.getBranch(n);
        MTGDressingFile mTGDressingFile = this.getDressingFile();
        boolean bl = false;
        if (mTGDressingFile != null) {
            mTGDressingFile.getBranchForm(mTGBranch.category);
        }
        if (!bl) {
            double d = mTGBranch.getAlpha();
            int n3 = mTGBranch.getElementCount();
            if (d == -1.0) {
                d = mTGDressingFile.getDefaultAlpha() / mTGDressingFile.getAlphaUnit();
            }
            for (int i = 0; i < n3; ++i) {
                Vector3d vector3d = this.computeElementCoordinatesStandard(mTGBranch.getElement(i), d, n2);
                if (vector3d == null) continue;
                this.updatePlantMinMax(vector3d);
            }
        }
    }

    private void downSizeBranches() throws MTGError.MTGPlantFrameException {
        Vector3d vector3d = (Vector3d)this.getObject("Plant Max");
        Vector3d vector3d2 = (Vector3d)this.getObject("Plant Min");
        double d = vector3d.x - vector3d2.x;
        double d2 = vector3d.y - vector3d2.y;
        double d3 = vector3d.z - vector3d2.z;
        double d4 = 1.0;
        if (d >= d2) {
            d4 = d >= d3 ? 1.0 / d : 1.0 / d3;
        }
        if (d2 > d) {
            d4 = d2 >= d3 ? 1.0 / d2 : 1.0 / d3;
        }
        d4 *= 10.0;
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("Branches do not exist for normalization.");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            MTGBranch mTGBranch = arrayList.get(i);
            for (int j = 0; j < mTGBranch.getElementCount(); ++j) {
                double d5;
                double d6;
                double d7;
                MTGBranchElement mTGBranchElement = mTGBranch.getElement(j);
                Vector3d vector3d3 = mTGBranchElement.getOrigin();
                if (vector3d3 != null) {
                    vector3d3.scale(d4);
                    mTGBranchElement.setOrigin(vector3d3);
                }
                if ((d7 = mTGBranchElement.getLength()) != 0.0) {
                    mTGBranchElement.setLength(d7 * d4);
                }
                if ((d6 = mTGBranchElement.getTopDia()) != 0.0) {
                    mTGBranchElement.setTopDia(d6 * d4);
                }
                if ((d5 = mTGBranchElement.getBotDia()) == 0.0) continue;
                mTGBranchElement.setBotDia(d5 * d4);
            }
        }
    }

    private void computeGeometry(int n, int n2) throws MTGError.MTGPlantFrameException {
        if (n != 2 && n != 3) {
            throw new MTGError.MTGPlantFrameException("Unable to compute coordinate MTG geometry.");
        }
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("No branch information available for geometry computation.");
        }
        int n3 = arrayList.size();
        this.computeAzimuth(n2);
        this.setupCoordinateVariables();
        for (int i = 0; i < n3; ++i) {
            MTGBranch mTGBranch = arrayList.get(i);
            if (mTGBranch.getSupportNodeIndex() == -1) {
                this.newTrunk(i);
            }
            this.computeBranchLengths(i, n);
            this.computeDiameters(i, n2);
            this.computeBranchCoordinates(i, n2, n);
        }
    }

    private void computeBranchCoordinates(int n, int n2, int n3) throws MTGError.MTGPlantFrameException {
        Vector3d vector3d;
        Vector3d vector3d2;
        MTGDressingFile mTGDressingFile;
        double d;
        Object object;
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("Branch information not available for plant frame computation.");
        }
        if (arrayList.size() - 1 < n) {
            throw new MTGError.MTGPlantFrameException("Invalid branch index for branch retrieval.");
        }
        MTGBranch mTGBranch = arrayList.get(n);
        Vector3d vector3d3 = this.lookForOrigin(mTGBranch.getElement(0), n2, n3);
        if (vector3d3 == null) {
            return;
        }
        this.updatePlantMinMax(vector3d3);
        boolean bl = true;
        LinkedList<MTGBranchElement> linkedList = new LinkedList<MTGBranchElement>();
        for (int i = 0; i < mTGBranch.getElementCount(); ++i) {
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            object = this.lookForCoords(mTGBranchElement.getNodeIndex(), n2, n3);
            if (object != null) {
                Vector3d vector3d4;
                bl = false;
                this.updatePlantMinMax((Vector3d)object);
                Vector3d vector3d5 = this.getEulerAttributes(this.getNode(mTGBranchElement.getNodeIndex()));
                Vector3d vector3d6 = new Vector3d();
                vector3d6.sub((Tuple3d)object, (Tuple3d)vector3d3);
                d = vector3d6.length();
                if (vector3d5 != null) {
                    vector3d4 = this.computeEulerPriDirection(vector3d5);
                    mTGDressingFile = this.computeEulerSecDirection(vector3d5);
                } else {
                    vector3d4 = new Vector3d(vector3d6);
                    if (d <= 1.0E-7) {
                        int n4 = this.topoFather(mTGBranchElement.getNodeIndex(), -1);
                        if (n4 != -1) {
                            MTGBranchElement mTGBranchElement2 = this.searchForElement(n4);
                            vector3d4 = mTGBranchElement2.getDirp();
                            mTGDressingFile = mTGBranchElement2.getDirs();
                            while (vector3d4 == null) {
                                if ((n4 = this.topoFather(n4, -1)) != -1) {
                                    mTGBranchElement2 = this.searchForElement(n4);
                                    vector3d4 = mTGBranchElement2.getDirp();
                                    mTGDressingFile = mTGBranchElement2.getDirs();
                                    continue;
                                }
                                throw new MTGError.MTGPlantFrameException("Unable to find preceeding node direction vector.");
                            }
                        } else {
                            if (vector3d4.length() != 0.0) {
                                vector3d4.normalize();
                            }
                            mTGDressingFile = new Vector3d(vector3d4);
                        }
                    } else {
                        vector3d4.normalize();
                        mTGDressingFile = this.computeAPerpendicularDirection(vector3d4);
                        mTGDressingFile.normalize();
                    }
                }
                if (vector3d4.length() != 0.0) {
                    vector3d4.normalize();
                }
                if (mTGDressingFile.length() != 0.0) {
                    mTGDressingFile.normalize();
                }
                vector3d2 = new Vector3d((Vector3d)mTGDressingFile);
                vector3d = new Vector3d(vector3d4);
                double d2 = 0.0;
                double d3 = 0.0;
                if (d != 0.0) {
                    d2 = this.computeElevationAlpha(vector3d4);
                    d3 = this.computeAzimuthBeta(vector3d4);
                }
                boolean bl2 = false;
                while (!linkedList.isEmpty()) {
                    bl2 = true;
                    MTGBranchElement mTGBranchElement3 = (MTGBranchElement)linkedList.remove();
                    int n5 = mTGBranch.getElementIndex(mTGBranchElement3);
                    if (n5 == -1) {
                        throw new MTGError.MTGPlantFrameException("Unknown branch element.");
                    }
                    double d4 = d / mTGBranchElement3.getLength();
                    Vector3d vector3d7 = this.getEulerAttributes(this.getNode(mTGBranchElement3.getNodeIndex()));
                    if (vector3d7 != null) {
                        vector3d = this.computeEulerPriDirection(vector3d5);
                        mTGDressingFile = this.computeEulerSecDirection(vector3d5);
                    } else {
                        vector3d = vector3d4;
                    }
                    vector3d.normalize();
                    vector3d2.normalize();
                    vector3d4.normalize();
                    mTGDressingFile.normalize();
                    mTGBranchElement3.setDirp(vector3d);
                    mTGBranchElement3.setDirs((Vector3d)mTGDressingFile);
                    mTGBranchElement3.setOrigin(vector3d3);
                    mTGBranchElement3.setLength(d4);
                    mTGBranchElement3.setAlpha(d2);
                    mTGBranchElement3.setBeta(d3);
                    this.setElementLengthDirectionOrder(mTGBranchElement3, d4, vector3d);
                    Vector3d vector3d8 = new Vector3d(vector3d);
                    vector3d8.scale(d4);
                    vector3d3.add((Tuple3d)vector3d8);
                }
                double d5 = bl2 ? d / mTGBranchElement.getLength() : d;
                mTGBranchElement.setDirp(vector3d4);
                mTGBranchElement.setDirs((Vector3d)mTGDressingFile);
                mTGBranchElement.setAlpha(d2);
                mTGBranchElement.setBeta(d3);
                mTGBranchElement.setLength(d5);
                mTGBranchElement.setOrigin(vector3d3);
                this.setElementLengthDirectionOrder(mTGBranchElement, d5, vector3d4);
                Vector3d vector3d9 = new Vector3d(vector3d4);
                vector3d9.scale(d5);
                vector3d3.add((Tuple3d)vector3d9);
                this.updatePlantMinMax((Vector3d)object);
                continue;
            }
            linkedList.add(mTGBranchElement);
        }
        if (!linkedList.isEmpty()) {
            if (bl) {
                while (!linkedList.isEmpty()) {
                    MTGBranchElement mTGBranchElement = (MTGBranchElement)linkedList.remove();
                    int n6 = this.topoFather(mTGBranchElement.getNodeIndex(), -1);
                    if (n6 == -1 || (object = this.searchForElement(n6)) == null) continue;
                    mTGBranchElement.setOrigin(vector3d3);
                    mTGBranchElement.setDirp(((MTGBranchElement)object).getDirp());
                    mTGBranchElement.setDirs(((MTGBranchElement)object).getDirs());
                    this.setElementLengthDirectionOrder(mTGBranchElement, -1.0, ((MTGBranchElement)object).getDirp());
                }
            } else {
                while (!linkedList.isEmpty()) {
                    MTGBranchElement mTGBranchElement = (MTGBranchElement)linkedList.remove();
                    int n7 = mTGBranch.getElementIndex(mTGBranchElement);
                    if (n7 == -1) {
                        throw new MTGError.MTGPlantFrameException("Unknown branch element");
                    }
                    double d6 = this.getNode(mTGBranchElement.getNodeIndex()).hasLength() ? (double)this.getNode((int)mTGBranchElement.getNodeIndex()).length : ((mTGDressingFile = this.getDressingFile()) == null ? (double)MTGDressingDefaultValues.DEFAULT_MIN_LENGTH : (double)mTGDressingFile.getMinLength(this.getNode((int)mTGBranchElement.getNodeIndex()).mtgClass));
                    mTGBranchElement.setLength(d6);
                    mTGDressingFile = this.getEulerAttributes(this.getNode(mTGBranchElement.getNodeIndex()));
                    if (mTGDressingFile != null) {
                        vector3d = this.computeEulerPriDirection((Vector3d)mTGDressingFile);
                        vector3d2 = this.computeEulerSecDirection((Vector3d)mTGDressingFile);
                    } else {
                        int n8 = this.topoFather(mTGBranchElement.getNodeIndex(), -1);
                        if (n8 != -1) {
                            MTGBranchElement mTGBranchElement4 = this.searchForElement(n8);
                            vector3d = mTGBranchElement4.getDirp();
                            vector3d2 = mTGBranchElement4.getDirs();
                        } else {
                            vector3d = new Vector3d(0.0, 0.0, 0.0);
                            vector3d2 = new Vector3d(0.0, 0.0, 0.0);
                        }
                    }
                    vector3d.normalize();
                    vector3d2.normalize();
                    d = 0.0;
                    double d7 = 0.0;
                    if (d6 != 0.0) {
                        d = this.computeElevationAlpha(vector3d);
                        d7 = this.computeAzimuthBeta(vector3d);
                    }
                    mTGBranchElement.setDirp(vector3d);
                    mTGBranchElement.setDirs(vector3d2);
                    mTGBranchElement.setAlpha(d);
                    mTGBranchElement.setBeta(d7);
                    mTGBranchElement.setLength(d6);
                    mTGBranchElement.setOrigin(vector3d3);
                    this.setElementLengthDirectionOrder(mTGBranchElement, d6, vector3d);
                    Vector3d vector3d10 = new Vector3d(vector3d);
                    vector3d10.scale(d6);
                    vector3d3.add((Tuple3d)vector3d10);
                    this.updatePlantMinMax(vector3d3);
                }
            }
        }
        if (!linkedList.isEmpty()) {
            throw new MTGError.MTGPlantFrameException("Unable to compute all branch coordinate values.");
        }
    }

    private void setElementLengthDirectionOrder(MTGBranchElement mTGBranchElement, double d, Vector3d vector3d) {
        int n = mTGBranchElement.getNodeIndex();
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode != null) {
            if (d != -1.0) {
                mTGNode.Length = d;
            }
            if (vector3d != null) {
                mTGNode.setDirectoryPrimary(vector3d);
            }
            mTGNode.Order = mTGBranchElement.getOrder();
        }
    }

    private Vector3d computeAPerpendicularDirection(Vector3d vector3d) {
        double d = this.computeAzimuthBeta(vector3d);
        double d2 = -this.computeElevationAlpha(vector3d);
        double d3 = 4.71238898038469;
        double d4 = Math.sin(d);
        double d5 = Math.sin(d2);
        double d6 = Math.sin(d3);
        double d7 = Math.cos(d);
        double d8 = Math.cos(d2);
        double d9 = Math.cos(d3);
        double d10 = -d4 * d9 + d7 * d5 * d6;
        double d11 = d7 * d9 + d4 * d5 * d6;
        double d12 = d8 * d6;
        return new Vector3d(d10, d11, d12);
    }

    private double computeAzimuthBeta(Vector3d vector3d) {
        double d;
        double d2 = vector3d.length();
        double d3 = d2 > 0.0 ? vector3d.x : 0.0;
        double d4 = this.computeElevationAlpha(vector3d);
        double d5 = Math.cos(d4);
        if (d5 != 0.0) {
            double d6 = d3 / d5;
            if (d6 > 1.0) {
                d6 = 1.0;
            }
            if (d6 < -1.0) {
                d6 = -1.0;
            }
            d = Math.acos(d6);
            if (vector3d.y < 0.0) {
                d = Math.PI * 2 - d;
            }
            if (vector3d.y == 0.0) {
                d = vector3d.x >= 0.0 ? 0.0 : Math.PI;
            }
        } else {
            d = 0.0;
        }
        if (Math.abs(d) < Math.pow(10.0, -4.0)) {
            d = 0.0;
        }
        return d;
    }

    private double computeElevationAlpha(Vector3d vector3d) {
        double d;
        double d2;
        double d3 = vector3d.length();
        double d4 = d2 = d3 > 0.0 ? vector3d.z / d3 : 0.0;
        if (d2 != 0.0) {
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            if (d2 < -1.0) {
                d2 = -1.0;
            }
            d = Math.asin(d2);
        } else {
            d = 0.0;
        }
        if (Math.abs(d) < Math.pow(10.0, -4.0)) {
            d = 0.0;
        }
        return d;
    }

    private Vector3d computeEulerPriDirection(Vector3d vector3d) {
        if (vector3d == null) {
            return null;
        }
        return new Vector3d(Math.cos(vector3d.z) * Math.cos(vector3d.x), Math.sin(vector3d.z) * Math.cos(vector3d.x), -Math.sin(vector3d.z));
    }

    private Vector3d computeEulerSecDirection(Vector3d vector3d) {
        if (vector3d == null) {
            return null;
        }
        return new Vector3d(-Math.sin(vector3d.z) * Math.cos(vector3d.y) + Math.cos(vector3d.z) * Math.sin(vector3d.x) * Math.sin(vector3d.y), Math.cos(vector3d.z) * Math.cos(vector3d.y) + Math.sin(vector3d.z) * Math.sin(vector3d.x) * Math.sin(vector3d.y), Math.sin(vector3d.y) * Math.cos(vector3d.x));
    }

    private Vector3d getEulerAttributes(MTGNode mTGNode) {
        if (mTGNode.hasAA() && mTGNode.hasBB() && mTGNode.hasCC()) {
            return new Vector3d(mTGNode.AA, mTGNode.BB, mTGNode.CC);
        }
        return null;
    }

    private void updatePlantMinMax(Vector3d vector3d) {
        Vector3d vector3d2 = (Vector3d)this.getObject("Plant Min");
        Vector3d vector3d3 = (Vector3d)this.getObject("Plant Max");
        Vector3d vector3d4 = this.minVector3f(vector3d, vector3d2);
        Vector3d vector3d5 = this.maxVector3f(vector3d, vector3d3);
        this.setObject("Plant Min", vector3d4);
        this.setObject("Plant Max", vector3d5);
    }

    private Vector3d lookForCoords(int n, int n2, int n3) throws MTGError.MTGPlantFrameException {
        Vector3d vector3d;
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            return null;
        }
        if (this.getScale(n) >= n2 && (vector3d = this.getCoordAttributes(mTGNode, n3)) != null) {
            return vector3d;
        }
        return null;
    }

    private Vector3d lookForOrigin(MTGBranchElement mTGBranchElement, int n, int n2) throws MTGError.MTGPlantFrameException {
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        int n3 = mTGBranchElement.getNodeIndex();
        int n4 = this.location(n3);
        if (n4 == -1) {
            Object object = this.getObject("Plant Origin");
            if (object != null) {
                return (Vector3d)object;
            }
        } else {
            MTGBranchElement mTGBranchElement2 = this.searchForElement(n4);
            if (mTGBranchElement2.getNodeIndex() != -1) {
                Vector3d vector3d2 = new Vector3d(mTGBranchElement2.getDirp());
                if (vector3d2 != null) {
                    double d = mTGBranchElement2.getLength();
                    vector3d2.scale(d);
                    vector3d.add((Tuple3d)vector3d2, (Tuple3d)mTGBranchElement2.getOrigin());
                    return vector3d;
                }
                return null;
            }
        }
        return vector3d;
    }

    private int location(int n) throws MTGError.MTGPlantFrameException {
        int n2 = this.getScale(n);
        int n3 = this.getPrefix(n);
        if (n3 == -1) {
            return -1;
        }
        if (n3 == -2) {
            return -1;
        }
        int n4 = this.getScale(n3);
        if (n2 <= n4) {
            return n3;
        }
        return this.location(n3);
    }

    private int nextDefinedDia(MTGBranch mTGBranch, int n, boolean bl) {
        int n2 = mTGBranch.getElementCount();
        if (n2 - 1 < n || n2 <= 0) {
            return -1;
        }
        for (int i = n; i < n2; ++i) {
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            if (!(bl ? mTGBranchElement.getTopDia() != -1.0 : mTGBranchElement.getBotDia() != -1.0)) continue;
            return i;
        }
        return -1;
    }

    private MTGBranch getBranch(int n) throws MTGError.MTGPlantFrameException {
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("Branch information not available for plant frame computation.");
        }
        if (arrayList.size() - 1 < n) {
            throw new MTGError.MTGPlantFrameException("Invalid branch index for branch retrieval.");
        }
        return arrayList.get(n);
    }

    private int lookUpCategory(int n) throws MTGError.MTGPlantFrameException {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Invalid node index for computing branch category.");
        }
        if (mTGNode.hasCategory()) {
            return mTGNode.Category;
        }
        int n2 = this.compoFather(n);
        if (n2 != -2) {
            return this.lookUpCategory(n2);
        }
        return -1;
    }

    private int lookDownCategory(int n) throws MTGError.MTGPlantFrameException {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Invalid node index for computing branch category.");
        }
        if (mTGNode.hasCategory()) {
            return mTGNode.Category;
        }
        int[] nArray = this.compoSonsIds(n);
        if (nArray != null && nArray.length >= 1) {
            return this.lookDownCategory(nArray[0]);
        }
        return -1;
    }

    private int lookForCategory(int n) throws MTGError.MTGPlantFrameException {
        int n2 = -1;
        n2 = this.lookUpCategory(n);
        if (n2 == -1) {
            n2 = this.lookDownCategory(n);
        }
        if (n2 == -1) {
            MTGDressingFile mTGDressingFile = this.getDressingFile();
            if (mTGDressingFile == null) {
                throw new MTGError.MTGPlantFrameException("Dressing information not available for plant frame computation.");
            }
            n2 = mTGDressingFile.getDefaultCategory();
        }
        return n2;
    }

    private int ramOrder(int n) throws MTGError.MTGPlantFrameException {
        int n2 = 0;
        MTGBranch mTGBranch = this.getBranch(n);
        int n3 = mTGBranch.getSupportNodeIndex();
        if (n3 == -1) {
            n2 = 0;
        } else {
            ArrayList<MTGBranch> arrayList = this.getBranches();
            int n4 = -1;
            if (arrayList == null) {
                throw new MTGError.MTGPlantFrameException("Branches data not available for branch category computation.");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                MTGBranch mTGBranch2 = arrayList.get(i);
                int n5 = mTGBranch2.getElementCount();
                if (n5 > 0) {
                    for (int j = 0; j < n5; ++j) {
                        if (mTGBranch2.getElement(j).getNodeIndex() != n3) continue;
                        n4 = i;
                        break;
                    }
                }
                if (n4 != -1) break;
            }
            if (n4 == -1) {
                throw new MTGError.MTGPlantFrameException("Unable to find branch for supporting branch element while computing branch category.");
            }
            n2 = 1 + this.ramOrder(n4);
        }
        return n2;
    }

    private void computeCategory(int n) throws MTGError.MTGPlantFrameException {
        MTGBranch mTGBranch = this.getBranch(n);
        int n2 = mTGBranch.getSupportNodeIndex();
        if (n2 == -1) {
            MTGDressingFile mTGDressingFile = this.getDressingFile();
            if (mTGDressingFile == null) {
                throw new MTGError.MTGPlantFrameException("Dressing information not available for plant frame computation.");
            }
            mTGBranch.setCategory(mTGDressingFile.getAxeDefaultCategory());
        } else {
            int n3 = this.lookForCategory(mTGBranch.baseOfBranch());
            if (n3 == -1) {
                n3 = this.ramOrder(n);
            }
            mTGBranch.setCategory(n3);
        }
    }

    private void computeDiameters(int n, int n2) throws MTGError.MTGPlantFrameException {
        MTGBranch mTGBranch = this.getBranch(n);
        this.assignGivenDiameters(mTGBranch);
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        boolean bl = true;
        int n3 = -1;
        for (int i = 0; i < mTGBranch.getElementCount(); ++i) {
            int n4;
            int n5;
            int n6;
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            if (i == 0) {
                Object object;
                n6 = mTGBranchElement.getNodeIndex();
                n5 = this.topoFather(n6, -1);
                if (n5 == -1) {
                    object = this.getDressingFile();
                    if (object == null) {
                        throw new MTGError.MTGPlantFrameException("Dressing information not available for plant frame computation.");
                    }
                    n4 = this.nextDefinedDia(mTGBranch, i, true);
                    int n7 = this.nextDefinedDia(mTGBranch, i, false);
                    if (n7 != -1 && n7 <= n4) {
                        d3 = mTGBranch.getElement(n7).getBotDia();
                        d4 = mTGBranch.getElement(n7).getBotDia();
                    } else if (n4 != -1) {
                        d3 = mTGBranch.getElement(n4).getTopDia();
                        d4 = mTGBranch.getElement(n4).getTopDia();
                    } else {
                        d3 = (double)((MTGDressingData)object).getMinTopDia(this.getNode((int)mTGBranchElement.getNodeIndex()).mtgClass) / (double)n2;
                        d4 = (double)((MTGDressingData)object).getMinBotDia(this.getNode((int)mTGBranchElement.getNodeIndex()).mtgClass) / (double)n2;
                    }
                } else {
                    object = this.searchForElement(n5);
                    d3 = ((MTGBranchElement)object).getTopDia();
                    d4 = ((MTGBranchElement)object).getBotDia();
                }
            } else {
                d3 = mTGBranch.getElement(i - 1).getTopDia();
                d4 = mTGBranch.getElement(i - 1).getBotDia();
            }
            d2 = mTGBranchElement.getBotDia() == -1.0 ? d3 : mTGBranchElement.getBotDia();
            if (mTGBranchElement.getTopDia() == -1.0) {
                if (bl) {
                    n6 = i + 1;
                    if (i == mTGBranch.getElementCount() - 1) {
                        n6 = i;
                    }
                    n5 = this.nextDefinedDia(mTGBranch, n6, true);
                    int n8 = this.nextDefinedDia(mTGBranch, n6, false);
                    if (n8 != -1 && n8 <= n5) {
                        bl = false;
                        n3 = n8;
                        n4 = n8 - i;
                        double d5 = this.computeDiaRatio(n4, d2, mTGBranch.getElement(n8).getBotDia());
                        d = d2 / d5;
                    } else if (n5 != -1) {
                        bl = false;
                        n3 = n5;
                        n4 = n5 - i;
                        if (mTGBranch.getElement(n5).getTopDia() > 0.0) {
                            double d6 = this.computeDiaRatio(n4, d2, mTGBranch.getElement(n5).getTopDia());
                            d = d2 / d6;
                        }
                    }
                }
                if (d == -1.0) {
                    d = d2 * (d3 / d4);
                }
            } else {
                d = mTGBranchElement.getTopDia();
            }
            mTGBranchElement.setBotDia(d2);
            mTGBranchElement.setTopDia(d);
            if (i != n3) continue;
            bl = true;
        }
    }

    private double computeDiaRatio(int n, double d, double d2) {
        double d3 = Math.pow(d / d2, 1.0 / (double)n);
        return d3;
    }

    private void assignGivenDiameters(MTGBranch mTGBranch) {
        if (mTGBranch == null) {
            return;
        }
        for (int i = 0; i < mTGBranch.getElementCount(); ++i) {
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            double d = this.lookForTopDia(mTGBranch.getElement(i).getNodeIndex());
            double d2 = this.lookForBottomDia(mTGBranch.getElement(i).getNodeIndex());
            mTGBranchElement.setTopDia(d);
            mTGBranchElement.setBotDia(d2);
        }
    }

    private double lookForTopDia(int n) {
        double d = -1.0;
        d = this.lookUpDia(n, true);
        if (d != -1.0) {
            return d;
        }
        d = this.lookDownDia(n, true);
        return d;
    }

    private double lookForBottomDia(int n) {
        double d = -1.0;
        d = this.lookUpDia(n, false);
        if (d != -1.0) {
            return d;
        }
        d = this.lookDownDia(n, false);
        return d;
    }

    private double lookUpDia(int n, boolean bl) {
        int[] nArray;
        MTGNode mTGNode = this.getNode(n);
        if (bl && mTGNode.hasTopDia()) {
            return mTGNode.TopDia;
        }
        if (!bl && mTGNode.hasBotDia()) {
            return mTGNode.BotDia;
        }
        int n2 = this.compoFather(n);
        if (n2 != -2 && (nArray = this.compoSonsIds(n2)).length >= 1 && nArray[nArray.length - 1] == n) {
            return this.lookUpDia(n2, bl);
        }
        return -1.0;
    }

    private double lookDownDia(int n, boolean bl) {
        MTGNode mTGNode = this.getNode(n);
        if (bl && mTGNode.hasTopDia()) {
            return mTGNode.TopDia;
        }
        if (!bl && mTGNode.hasBotDia()) {
            return mTGNode.BotDia;
        }
        int[] nArray = this.compoSonsIds(n);
        if (nArray != null && nArray.length >= 1) {
            return this.lookDownDia(nArray[0], bl);
        }
        return -1.0;
    }

    private double lookUpLength(int n) {
        MTGNode mTGNode = this.getNode(n);
        double d = -1.0;
        if (mTGNode.hasLength()) {
            d = mTGNode.getLength();
        } else {
            int n2 = this.compoFather(n);
            if (n2 != -2 && (d = this.lookUpLength(n2)) != -1.0) {
                int[] nArray = this.compoSonsIds(n2);
                d /= (double)nArray.length;
            }
        }
        return d;
    }

    private double lookDownLength(int n) throws MTGError.MTGPlantFrameException {
        MTGDressingFile mTGDressingFile;
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode.hasLength()) {
            return mTGNode.getLength();
        }
        int[] nArray = this.compoSonsIds(n);
        if (nArray != null && nArray.length > 0) {
            double d = 0.0;
            for (int i = 0; i < nArray.length; ++i) {
                d += this.lookDownLength(nArray[i]);
            }
            if (d > 0.0) {
                return d;
            }
        }
        if ((mTGDressingFile = this.getDressingFile()) == null) {
            throw new MTGError.MTGPlantFrameException("Dressing information not found.");
        }
        return mTGDressingFile.getMinLength(mTGNode.mtgClass);
    }

    private void computeElementLengthStandard(MTGBranchElement mTGBranchElement) throws MTGError.MTGPlantFrameException {
        int n = mTGBranchElement.getNodeIndex();
        double d = this.lookUpLength(n);
        if (d == -1.0) {
            d = this.lookDownLength(n);
        }
        if (d < 0.0) {
            throw new MTGError.MTGPlantFrameException("Unable to compute branch element length.");
        }
        mTGBranchElement.setLength(d);
    }

    private void computeBranchLengthsStandard(int n) throws MTGError.MTGPlantFrameException {
        MTGBranch mTGBranch = this.getBranch(n);
        int n2 = mTGBranch.getElementCount();
        for (int i = 0; i < n2; ++i) {
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            this.computeElementLengthStandard(mTGBranchElement);
        }
    }

    private void computeBranchLengths(int n, int n2) throws MTGError.MTGPlantFrameException {
        boolean bl = this.coordinatesExistInBranch(n, n2);
        if (!bl) {
            this.computeBranchLengthsStandard(n);
        } else {
            int n3 = 0;
            MTGBranch mTGBranch = this.getBranch(n);
            int n4 = -1;
            int n5 = -1;
            int n6 = mTGBranch.getElement(0).getNodeIndex();
            int n7 = this.topoFather(n6, -1);
            if (n6 != -1) {
                n5 = n6;
            }
            if (n7 != -1) {
                n4 = n7;
            }
            n3 = n5 - 1;
            n4 = mTGBranch.getElementCount();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            n6 = this.nextElementIndexWithCoordinates(mTGBranch, 0, n2);
            if (n6 == -1) {
                return;
            }
            arrayList.add(new Integer(n6));
            while (n6 + 1 <= n4 - 1 && (n6 = this.nextElementIndexWithCoordinates(mTGBranch, n6 + 1, n2)) != -1) {
                arrayList.add(new Integer(n6));
            }
            block1: for (n7 = 0; n7 < n4; ++n7) {
                int n8 = 0;
                int n9 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if ((mTGBranch.getElement((Integer)arrayList.get(i)).getNodeIndex() <= mTGBranch.getElement(n7).getNodeIndex() || n7 != 0) && (mTGBranch.getElement((Integer)arrayList.get(i)).getNodeIndex() < mTGBranch.getElement(n7).getNodeIndex() || n7 == 0)) continue;
                    n8 = mTGBranch.getElement((Integer)arrayList.get(i)).getNodeIndex();
                    n9 = i;
                    int n10 = 0;
                    n10 = n9 != 0 ? n8 - mTGBranch.getElement((Integer)arrayList.get(n9 - 1)).getNodeIndex() : n8 - n3;
                    int n11 = 0;
                    n11 = n7 != 0 ? mTGBranch.getElement(n7).getNodeIndex() - mTGBranch.getElement(n7 - 1).getNodeIndex() : mTGBranch.getElement(n7).getNodeIndex() - n3;
                    double d = 0.0;
                    d = n11 == 0 || n10 == 0 ? Double.MAX_VALUE : (double)n10 / (double)n11;
                    if (d < 1.0) {
                        MTGDressingFile mTGDressingFile = this.getDressingFile();
                        if (mTGDressingFile == null) {
                            throw new MTGError.MTGPlantFrameException("Dressing information not found.");
                        }
                        d = mTGDressingFile.getMinLength(this.getNode((int)mTGBranch.getElement((int)n7).getNodeIndex()).mtgClass);
                    }
                    mTGBranch.getElement(n7).setLength(d);
                    continue block1;
                }
            }
        }
    }

    private int nextElementIndexWithCoordinates(MTGBranch mTGBranch, int n, int n2) throws MTGError.MTGPlantFrameException {
        int n3 = mTGBranch.getElementCount();
        for (int i = n; i < n3; ++i) {
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            int n4 = mTGBranchElement.getNodeIndex();
            MTGNode mTGNode = this.getNode(n4);
            if (!this.hasCoordAttributes(mTGNode, n2)) continue;
            return i;
        }
        return -1;
    }

    private boolean coordinatesExistInBranch(int n, int n2) throws MTGError.MTGPlantFrameException {
        MTGBranch mTGBranch = this.getBranch(n);
        int n3 = mTGBranch.getElementCount();
        for (int i = 0; i < n3; ++i) {
            MTGBranchElement mTGBranchElement = mTGBranch.getElement(i);
            int n4 = mTGBranchElement.getNodeIndex();
            MTGNode mTGNode = this.getNode(n4);
            if (mTGNode == null) {
                throw new MTGError.MTGPlantFrameException("Invalid node index.");
            }
            if (!this.hasCoordAttributes(mTGNode, n2)) continue;
            return true;
        }
        return false;
    }

    private MTGDressingFile getDressingFile() {
        Object object = this.getObject("Dressing");
        if (object != null) {
            return (MTGDressingFile)object;
        }
        return null;
    }

    private void newTrunk(int n) throws MTGError.MTGPlantFrameException {
        MTGSquares mTGSquares = this.getSquares();
        if (mTGSquares == null) {
            throw new MTGError.MTGPlantFrameException("Squares information not available for plant frame constructions.");
        }
        mTGSquares.addVoxel(new MTGVoxel(n));
    }

    private void setupCoordinateVariables() throws MTGError.MTGPlantFrameException {
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        this.setObject("Coord Origin", vector3d);
        MTGDressingFile mTGDressingFile = this.getDressingFile();
        double d = 0.0;
        d = this.dist == 0.0 ? (double)mTGDressingFile.getDefaultDistance() : this.dist;
        MTGSquares mTGSquares = new MTGSquares(d / (double)mTGDressingFile.getLengthUnit());
        this.setObject("Coord Squares", mTGSquares);
    }

    private MTGSquares getSquares() {
        Object object = this.getObject("Coord Squares");
        if (object != null) {
            return (MTGSquares)object;
        }
        return null;
    }

    public int mtgType() throws MTGError.MTGPlantFrameException {
        int n = 1;
        if (this.hasDAB()) {
            n = 2;
        }
        if (this.hasL1()) {
            n = 2;
        }
        if (this.hasXX()) {
            n = 3;
        }
        return n;
    }

    private boolean verifyTriangleReference() throws MTGError.MTGPlantFrameException {
        return this.hasDAB() && this.hasDAC() && this.hasDBC() && this.hasL1() && this.hasL2() && this.hasL3();
    }

    private boolean verifyCartesianReference() throws MTGError.MTGPlantFrameException {
        return this.hasXX() && this.hasYY() && this.hasZZ();
    }

    private void computeAzimuth(int n) throws MTGError.MTGPlantFrameException {
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("No branch information available for geometry computation.");
        }
        MTGDressingFile mTGDressingFile = this.getDressingFile();
        if (mTGDressingFile == null) {
            throw new MTGError.MTGPlantFrameException("No dressing information available for geometry computation.");
        }
        double d = 0.0;
        double d2 = mTGDressingFile.getPhillotaxy() / mTGDressingFile.getAzimutUnit();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            MTGBranch mTGBranch = arrayList.get(i);
            int n3 = mTGBranch.getPlant();
            int n4 = mTGBranch.getElementCount();
            for (int j = 0; j < n4; ++j) {
                MTGBranchElement mTGBranchElement = mTGBranch.getElement(j);
                MTGBranch mTGBranch2 = new MTGBranch(mTGBranchElement.getNodeIndex(), n3, n);
                int n5 = this.numberOfBranchOccurrences(mTGBranch2);
                int n6 = this.indexOfFirstBranchOccurrence(mTGBranch2);
                if (n6 == -1) continue;
                for (int k = n6; k < n6 + n5; ++k) {
                    int n7 = arrayList.get(k).baseOfBranch();
                    Double d3 = this.lookForAzimuth(n7);
                    if (d3 != null) {
                        arrayList.get(k).getElement(0).setBeta(d3);
                        continue;
                    }
                    arrayList.get(k).getElement(0).setBeta(d);
                    d += d2;
                }
            }
        }
    }

    private Double lookForAzimuth(int n) throws MTGError.MTGPlantFrameException {
        return this.lookForAzimuthUp(n);
    }

    private Double lookForAzimuthUp(int n) throws MTGError.MTGPlantFrameException {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Node for specified index not found.");
        }
        if (mTGNode.hasAzimut()) {
            return new Double(mTGNode.Azimut);
        }
        int n2 = this.compoFather(n);
        if (n2 != -2) {
            return this.lookForAzimuthUp(n2);
        }
        return null;
    }

    private int indexOfFirstBranchOccurrence(MTGBranch mTGBranch) throws MTGError.MTGPlantFrameException {
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("No branch information available for geometry computation.");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!MTGBranch.equal(arrayList.get(i), mTGBranch)) continue;
            return i;
        }
        return -1;
    }

    private int numberOfBranchOccurrences(MTGBranch mTGBranch) throws MTGError.MTGPlantFrameException {
        int n;
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            throw new MTGError.MTGPlantFrameException("No branch information available for geometry computation.");
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (n = 0; n < arrayList.size(); ++n) {
            if (MTGBranch.lessThan(arrayList.get(n), mTGBranch)) continue;
            n2 = n;
            bl = true;
            break;
        }
        if (!bl) {
            n2 = arrayList.size();
        }
        n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!MTGBranch.greaterThan(arrayList.get(i), mTGBranch)) continue;
            n3 = i;
            n = 1;
            break;
        }
        if (n == 0) {
            n3 = arrayList.size();
        }
        return n3 - n2;
    }

    public int getBranchesCount() {
        try {
            ArrayList<MTGBranch> arrayList = this.getBranches();
            if (arrayList != null) {
                return arrayList.size();
            }
            return -1;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get Branch count.");
            return 0;
        }
    }

    public MTGBranchElement searchForElement(int n) {
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (arrayList == null) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            MTGBranch mTGBranch = arrayList.get(i);
            for (int j = 0; j < mTGBranch.getElementCount(); ++j) {
                MTGBranchElement mTGBranchElement = mTGBranch.getElement(j);
                if (mTGBranchElement.getNodeIndex() != n) continue;
                return mTGBranchElement;
            }
        }
        return null;
    }

    public ArrayList<MTGBranch> getBranches() {
        try {
            Object object = this.getObject("Branches");
            if (object != null) {
                return (ArrayList)object;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void lookForBranches(int n, int n2, int n3) throws MTGError.MTGPlantFrameException {
        Object object;
        int n4;
        Object object2;
        if (this.getNode(n) == null) {
            throw new MTGError.MTGPlantFrameException("Branch origin does not exist in node list.");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = this.topoFather(n, -1);
        if (n5 == -1) {
            this.incrementPlantCount();
        }
        MTGBranch mTGBranch = new MTGBranch(n5, this.getPlantCount(), n2);
        MTGBranchElement mTGBranchElement = new MTGBranchElement(n);
        mTGBranchElement.setOrder(n3);
        mTGBranch.addElement(mTGBranchElement);
        boolean bl = false;
        while (!bl) {
            object2 = this.topoSons(n, -1);
            if (((Object)object2).length == 0) {
                bl = true;
            }
            Object object3 = n;
            for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                object = object2[n4];
                if (this.edgeType(n, (int)object) == 256) {
                    MTGBranchElement mTGBranchElement2 = new MTGBranchElement((int)object);
                    mTGBranchElement2.setOrder(n3);
                    mTGBranch.addElement(mTGBranchElement2);
                    object3 = object;
                    continue;
                }
                arrayList.add(new Integer((int)object));
            }
            if (n == object3) {
                bl = true;
                continue;
            }
            n = object3;
        }
        object2 = this.getObject("Branches");
        if (object2 == null) {
            throw new MTGError.MTGPlantFrameException("No container for branches in root node.");
        }
        ArrayList arrayList2 = (ArrayList)object2;
        n4 = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (MTGBranch.lessThan((MTGBranch)arrayList2.get(i), mTGBranch)) continue;
            arrayList2.add(i, mTGBranch);
            n4 = 1;
            break;
        }
        if (n4 == 0) {
            arrayList2.add(mTGBranch);
        }
        int n6 = n3 + 1;
        while (!arrayList.isEmpty()) {
            object = (Integer)arrayList.remove(0);
            this.lookForBranches((int)object, n2, n6);
        }
    }

    public void incrementPlantCount() throws MTGError.MTGPlantFrameException {
        try {
            Object object = this.getObject("Plant Count");
            if (object == null) {
                throw new MTGError.MTGPlantFrameException("Unable to retrieve plant count from MTG root node.");
            }
            Integer n = (Integer)object;
            this.setObject("Plant Count", new Integer(n + 1));
        }
        catch (Throwable throwable) {
            System.out.println("Unable to increment plant count.");
        }
    }

    public int getPlantCount() throws MTGError.MTGPlantFrameException {
        try {
            Object object = this.getObject("Plant Count");
            if (object == null) {
                throw new MTGError.MTGPlantFrameException("Unable to retrieve plant count from MTG root node.");
            }
            return (Integer)object;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get plant count.");
            return 0;
        }
    }

    public int height(MTGNode mTGNode, MTGNode mTGNode2) throws MTGError.MTGPlantFrameException {
        if (mTGNode == null || mTGNode2 == null) {
            return -1;
        }
        int n = this.heightInternal(mTGNode, mTGNode2, 0);
        return n;
    }

    private int heightInternal(MTGNode mTGNode, MTGNode mTGNode2, int n) {
        if (mTGNode.equals(mTGNode2)) {
            return n;
        }
        MTGNode[] mTGNodeArray = mTGNode.topoSonNodes(-1);
        if (mTGNodeArray != null && mTGNodeArray.length > 0) {
            int n2 = -1;
            for (int i = 0; i < mTGNodeArray.length; ++i) {
                int n3 = this.heightInternal(mTGNodeArray[i], mTGNode2, n + 1);
                if (n3 == -1) continue;
                n2 = n3;
            }
            return n2;
        }
        return -1;
    }

    public MTGNode[] getRoots(int n) throws MTGError.MTGPlantFrameException {
        this.refreshNodeList();
        int[] nArray = this.getRootIds(n);
        MTGNode[] mTGNodeArray = new MTGNode[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            mTGNodeArray[i] = this.getNode(nArray[i]);
        }
        this.deleteNodeList();
        return mTGNodeArray;
    }

    public int[] getRootIds(int n) throws MTGError.MTGPlantFrameException {
        try {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Object object = this.getObject("Node List");
            if (object != null && object instanceof ArrayList) {
                ArrayList arrayList2 = (ArrayList)object;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    n2 = this.topoFather(i, -1);
                    if (n2 != -1) continue;
                    if (n != -1) {
                        if (this.getScale(i) != n) continue;
                        arrayList.add(new Integer(i));
                        continue;
                    }
                    arrayList.add(new Integer(i));
                }
            }
            int[] nArray = new int[arrayList.size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
            return nArray;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get root nodes.");
            return null;
        }
    }

    public ArrayList<MTGNodeDataClasses> getClassesInfo() throws MTGError.MTGPlantFrameException {
        try {
            Object object = this.getObject("CLASSES");
            if (object == null) {
                throw new MTGError.MTGPlantFrameException("Expected class information in MTG root node not found.");
            }
            return (ArrayList)object;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get class information.");
            return null;
        }
    }

    public ArrayList<MTGNodeDataFeature> getFeaturesInfo() throws MTGError.MTGPlantFrameException {
        try {
            Object object = this.getObject("FEATURES");
            if (object == null) {
                throw new MTGError.MTGPlantFrameException("Expected feature information in MTG root node not found.");
            }
            return (ArrayList)object;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get feature information.");
            return null;
        }
    }

    public MTGNode getNode(int n) {
        try {
            Object object = this.getObject("Node List");
            if (object != null && object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                if (arrayList.size() - 1 < n) {
                    return null;
                }
                MTGNode mTGNode = (MTGNode)arrayList.get(n);
                return mTGNode;
            }
            return null;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get node.");
            return null;
        }
    }

    public int getIndex(MTGNode mTGNode) {
        try {
            return mTGNode.mtgID;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get node index.");
            return -1;
        }
    }

    public int edgeType(int n, int n2) {
        try {
            MTGNode mTGNode = this.getNode(n);
            MTGNode mTGNode2 = this.getNode(n2);
            if (mTGNode == null || mTGNode2 == null) {
                return -1;
            }
            int n3 = mTGNode.getEdgeBitsTo((Node)mTGNode2);
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get edge between nodes.");
            return -1;
        }
    }

    public int topoFather(int n, int n2) {
        try {
            MTGNode mTGNode = this.getNode(n);
            if (mTGNode != null) {
                MTGNode mTGNode2 = null;
                if (n2 == -1) {
                    mTGNode2 = (MTGNode)mTGNode.findAdjacent(true, false, 512);
                    if (mTGNode2 == null) {
                        mTGNode2 = (MTGNode)mTGNode.findAdjacent(true, false, 256);
                    }
                } else {
                    mTGNode2 = (MTGNode)mTGNode.findAdjacent(true, false, n2);
                }
                if (mTGNode2 != null) {
                    return this.getIndex(mTGNode2);
                }
            }
            return -1;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get topological father of node.");
            return -1;
        }
    }

    public int[] topoSons(int n, int n2) {
        try {
            MTGNode mTGNode = this.getNode(n);
            if (mTGNode != null) {
                return mTGNode.topoSons(n2);
            }
            return null;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get topological sons of node.");
            return null;
        }
    }

    public int compoFather(int n) {
        try {
            MTGNode mTGNode = this.getNode(n);
            if (mTGNode != null) {
                MTGNode mTGNode2 = (MTGNode)mTGNode.findAdjacent(true, false, 4096);
                if (mTGNode2 == this) {
                    return -2;
                }
                if (mTGNode2 != null) {
                    return this.getIndex(mTGNode2);
                }
            }
            return -1;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get compositional father of node.");
            return -1;
        }
    }

    public MTGNode compoFather(MTGNode mTGNode) {
        try {
            if (mTGNode != null) {
                MTGNode mTGNode2 = (MTGNode)mTGNode.findAdjacent(true, false, 4096);
                return mTGNode2;
            }
            return null;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get compositional father of node.");
            return null;
        }
    }

    public int[] compoSonsIds(int n, int n2) throws MTGError.MTGPlantFrameException {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Invalid node index used for retrieving compositional sons.");
        }
        int n3 = this.getScale(n);
        if (n2 <= n3) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = this.compoSonsIds(n);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 == n3 + 1) {
                    arrayList.add(new Integer(nArray[i]));
                    continue;
                }
                int[] nArray2 = this.compoSonsIds(nArray[i], n2);
                if (nArray2 == null) {
                    throw new MTGError.MTGPlantFrameException("Null exception compositional sons.");
                }
                for (int j = 0; j < nArray2.length; ++j) {
                    arrayList.add(new Integer(nArray2[j]));
                }
            }
        }
        int[] nArray3 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray3[i] = (Integer)arrayList.get(i);
        }
        return nArray3;
    }

    public int[] compoSonsIds(int n) {
        try {
            MTGNode mTGNode = this.getNode(n);
            if (mTGNode != null) {
                return mTGNode.compoSonsIds();
            }
            return null;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get compositional sons of node.");
            return null;
        }
    }

    private int getPrefix(int n) throws MTGError.MTGPlantFrameException {
        MTGNode mTGNode = this.getNode(n);
        if (mTGNode == null) {
            throw new MTGError.MTGPlantFrameException("Node of specified index cannot be found.");
        }
        int n2 = this.topoFather(n, -1);
        if (n2 != -1) {
            return n2;
        }
        return this.compoFather(n);
    }

    public int getScale(int n) throws MTGError.MTGPlantFrameException {
        try {
            MTGNode mTGNode = this.getNode(n);
            if (mTGNode == null) {
                throw new MTGError.MTGPlantFrameException("Node of specified index cannot be found.");
            }
            return mTGNode.mtgScale;
        }
        catch (Throwable throwable) {
            System.out.println("Unable to get scale of node.");
            return -1;
        }
    }

    private boolean hasCoordAttributes(MTGNode mTGNode, int n) {
        if (mTGNode == null) {
            return false;
        }
        if (n == 2) {
            return mTGNode.hasL1() && mTGNode.hasL2() && mTGNode.hasL3();
        }
        if (n == 3) {
            return mTGNode.hasXX() && mTGNode.hasYY() && mTGNode.hasZZ();
        }
        return false;
    }

    private Vector3d getCoordAttributes(MTGNode mTGNode, int n) {
        if (mTGNode == null) {
            return null;
        }
        Object var5_3 = null;
        Object var4_4 = null;
        Object var3_5 = null;
        if (n == 2) {
            if (mTGNode.hasL1() && mTGNode.hasL2() && mTGNode.hasL3()) {
                return new Vector3d(mTGNode.L1, mTGNode.L2, mTGNode.L3);
            }
        } else if (n == 3 && mTGNode.hasXX() && mTGNode.hasYY() && mTGNode.hasZZ()) {
            return new Vector3d(mTGNode.XX, mTGNode.YY, mTGNode.ZZ);
        }
        return null;
    }

    private Vector3d minVector3f(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.x <= vector3d2.x ? vector3d.x : vector3d2.x;
        double d2 = vector3d.y <= vector3d2.y ? vector3d.y : vector3d2.y;
        double d3 = vector3d.z <= vector3d2.z ? vector3d.z : vector3d2.z;
        return new Vector3d(d, d2, d3);
    }

    private Vector3d maxVector3f(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.x >= vector3d2.x ? vector3d.x : vector3d2.x;
        double d2 = vector3d.y >= vector3d2.y ? vector3d.y : vector3d2.y;
        double d3 = vector3d.z >= vector3d2.z ? vector3d.z : vector3d2.z;
        return new Vector3d(d, d2, d3);
    }

    private void computeMesh(boolean[] blArray) {
        ArrayList<MTGBranch> arrayList = this.getBranches();
        if (blArray == null) {
            blArray = new boolean[]{false, false, false, true, false};
        }
        if (arrayList != null) {
            this.polygons = new PolygonMesh();
            FloatList floatList = new FloatList();
            IntList intList = new IntList();
            for (int i = 0; i < arrayList.size(); ++i) {
                MTGBranch mTGBranch = arrayList.get(i);
                if (blArray != null && !blArray[mTGBranch.getScale()]) continue;
                for (int j = 0; j < mTGBranch.getElementCount(); ++j) {
                    int n;
                    int n2;
                    MTGBranchElement mTGBranchElement = mTGBranch.getElement(j);
                    MTGBranchElement mTGBranchElement2 = j < mTGBranch.getElementCount() - 1 ? mTGBranch.getElement(j + 1) : null;
                    Point3d[] point3dArray = mTGBranchElement.getTopSurface(mTGBranchElement2);
                    Point3d[] point3dArray2 = mTGBranchElement.getBotSurface(mTGBranchElement2);
                    for (n2 = 0; n2 < point3dArray.length; ++n2) {
                        floatList.push((float)point3dArray[n2].x, (float)point3dArray[n2].y, (float)point3dArray[n2].z);
                        floatList.push((float)point3dArray2[n2].x, (float)point3dArray2[n2].y, (float)point3dArray2[n2].z);
                    }
                    n2 = floatList.size() / 3 - point3dArray.length * 2;
                    boolean bl = true;
                    for (n = n2; n < floatList.size() / 3 - 2; ++n) {
                        if (bl) {
                            intList.push(n, n + 1, n + 2);
                            bl = false;
                            continue;
                        }
                        intList.push(n + 2, n + 1, n);
                        bl = true;
                    }
                    n = floatList.size() / 3 - 2;
                    int n3 = floatList.size() / 3 - 1;
                    intList.push(n, n3, n2);
                    intList.push(n2 + 1, n2, n3);
                }
            }
            this.polygons.setIndexData(intList);
            this.polygons.setVertexData(floatList);
        }
    }

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
    }

    public int classSymbolToClassIndex(String string) {
        Object object = this.nodeData.getObject("CLASSES");
        if (object == null) {
            return -1;
        }
        ArrayList arrayList = (ArrayList)this.getObject("CLASSES");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((MTGNodeDataClasses)arrayList.get(i)).getSymbol().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int classScale(String string) {
        Object object = this.nodeData.getObject("CLASSES");
        if (object == null) {
            return -1;
        }
        ArrayList arrayList = (ArrayList)this.getObject("CLASSES");
        for (int i = 0; i < arrayList.size(); ++i) {
            MTGNodeDataClasses mTGNodeDataClasses = (MTGNodeDataClasses)arrayList.get(i);
            if (!mTGNodeDataClasses.getSymbol().equals(string)) continue;
            return mTGNodeDataClasses.getScale();
        }
        return -1;
    }

    public int[] classSymbolsToClassIndices(String[] stringArray) {
        Object object = this.nodeData.getObject("CLASSES");
        if (object == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.getObject("CLASSES");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.classSymbolToClassIndex(stringArray[i]);
            if (n == -1) {
                return null;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private ArrayList<MTGNode> findRefine(ArrayList<MTGNode> arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<MTGNode> arrayList2 = new ArrayList<MTGNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            MTGNode mTGNode = arrayList.get(i);
            for (Edge edge = mTGNode.getFirstEdge(); edge != null; edge = edge.getNext((Node)mTGNode)) {
                if (edge.getSource() != mTGNode || !edge.testEdgeBits(4096)) continue;
                arrayList2.add((MTGNode)edge.getTarget());
            }
        }
        return arrayList2;
    }

    private void removeAllSuccOrBranchEdges() {
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
            if (edge.getSource() != this || !edge.testEdgeBits(768)) continue;
            this.removeEdgeBitsTo(edge.getTarget(), 768, null);
        }
    }

    private void removeAllSuccOrBranchEdges(int n) throws MTGError.MTGPlantFrameException {
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
            int n2;
            int n3;
            Node node;
            if (edge.getSource() != this || !edge.testEdgeBits(768) || !((node = edge.getTarget()) instanceof MTGNode) || (n3 = this.getScale(n2 = this.getIndex((MTGNode)node))) != n) continue;
            this.removeEdgeBitsTo(edge.getTarget(), 768, null);
        }
    }

    private void connectToVisibleScale(int[] nArray) throws MTGError.MTGPlantFrameException {
        boolean[] blArray = null;
        Object object = Library.workbench().getProperty(MTGKeys.MTG_SCALES_VISIBLE);
        if (object != null && nArray != null && object != null) {
            blArray = (boolean[])object;
            for (int i = 0; i < nArray.length; ++i) {
                MTGNode mTGNode = this.getNode(nArray[i]);
                if (!blArray[this.getScale(nArray[i])] || mTGNode == null) continue;
                this.addEdgeBitsTo((Node)mTGNode, 512, null);
            }
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        try {
            Object object2;
            boolean[] blArray = null;
            boolean bl2 = false;
            Object object3 = Library.workbench().getProperty(MTGKeys.MTG_SCALES_VISIBLE);
            if (object3 != null) {
                blArray = (boolean[])object3;
            }
            if ((object2 = Library.workbench().getProperty(MTGKeys.MTG_SCALES_CHANGED)) != null) {
                bl2 = (Boolean)object2;
            }
            if (bl2) {
                for (int i = 0; i < blArray.length; ++i) {
                    if (blArray[i]) {
                        this.plantFrame(i, 400.0);
                        continue;
                    }
                    this.plantFrameDelete(i);
                }
                Library.workbench().setProperty(MTGKeys.MTG_SCALES_CHANGED, (Object)new Boolean(false));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setElevationAzimuth(Vector3d vector3d, double d, double d2) {
        vector3d.x = Math.cos(d2) * Math.cos(d);
        vector3d.y = Math.sin(d2) * Math.cos(d);
        vector3d.z = Math.sin(d);
    }

    public void changeBenchmark(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        vector3d.x = d * vector3d2.x + d2 * vector3d3.x + d3 * vector3d4.x;
        vector3d.y = d * vector3d2.y + d2 * vector3d3.y + d3 * vector3d4.y;
        vector3d.z = d * vector3d2.z + d2 * vector3d3.z + d3 * vector3d4.z;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)dist$FIELD);
        visibleSides$FIELD = new _Field("visibleSides", 0x200001, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)visibleSides$FIELD);
        $TYPE.declareFieldAttribute(dist$FIELD, (Attribute)Attributes.MTG_DIST);
        $TYPE.declareFieldAttribute(visibleSides$FIELD, (Attribute)Attributes.MTG_VISIBLE_SIDES);
        MTGRoot.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setDouble(Object object, double d) {
            switch (this.id) {
                case 0: {
                    ((MTGRoot)object).dist = d;
                    return;
                }
            }
            super.setDouble(object, d);
        }

        public double getDouble(Object object) {
            switch (this.id) {
                case 0: {
                    return ((MTGRoot)object).dist;
                }
            }
            return super.getDouble(object);
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((MTGRoot)object).visibleSides = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((MTGRoot)object).visibleSides;
                }
            }
            return super.getInt(object);
        }
    }
}

