/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.Attribute;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.mtg.Attributes;
import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import de.grogra.turtle.F;
import java.util.ArrayList;
import javax.vecmath.Vector3d;

public class MTGNode
extends F {
    private static final long serialVersionUID = -6891957776951480685L;
    public String mtgClass;
    public int mtgClassID;
    public int mtgID;
    public int mtgScale;
    public double L1;
    public double L2;
    public double L3;
    public double DAB;
    public double DAC;
    public double DBC;
    public double XX;
    public double YY;
    public double ZZ;
    public double Length;
    public double Azimut;
    public double Alpha;
    public double AA;
    public double BB;
    public double CC;
    public double TopDia;
    public double BotDia;
    public double Position;
    public int Category;
    public Vector3d DirectionPrimary;
    public int Order;
    public int stdAttFlag;
    public int dataFlag;
    public static final Node.NType $TYPE = new Node.NType(MTGNode.class);
    public static final Node.NType.Field mtgClass$FIELD = new _Field("mtgClass", 0x200001, Type.STRING, null, 0);
    public static final Node.NType.Field mtgClassID$FIELD;
    public static final Node.NType.Field mtgID$FIELD;
    public static final Node.NType.Field mtgScale$FIELD;
    public static final Node.NType.Field L1$FIELD;
    public static final Node.NType.Field L2$FIELD;
    public static final Node.NType.Field L3$FIELD;
    public static final Node.NType.Field DAB$FIELD;
    public static final Node.NType.Field DAC$FIELD;
    public static final Node.NType.Field DBC$FIELD;
    public static final Node.NType.Field XX$FIELD;
    public static final Node.NType.Field YY$FIELD;
    public static final Node.NType.Field ZZ$FIELD;
    public static final Node.NType.Field Azimut$FIELD;
    public static final Node.NType.Field Alpha$FIELD;
    public static final Node.NType.Field AA$FIELD;
    public static final Node.NType.Field BB$FIELD;
    public static final Node.NType.Field CC$FIELD;
    public static final Node.NType.Field TopDia$FIELD;
    public static final Node.NType.Field BotDia$FIELD;
    public static final Node.NType.Field Position$FIELD;
    public static final Node.NType.Field Category$FIELD;
    public static final Node.NType.Field DirectionPrimary$FIELD;
    public static final Node.NType.Field Order$FIELD;
    public static final Node.NType.Field Length$FIELD;
    public static final Node.NType.Field stdAttFlag$FIELD;
    public static final Node.NType.Field dataFlag$FIELD;

    public MTGNode() {
        this.initMTGAttributes();
        this.length = 0.0f;
        this.dataFlag = 0;
    }

    private void initMTGAttributes() {
        this.stdAttFlag = 0;
        this.L1 = 0.0;
        this.L2 = 0.0;
        this.L3 = 0.0;
        this.DAB = 0.0;
        this.DAC = 0.0;
        this.DBC = 0.0;
        this.XX = 0.0;
        this.YY = 0.0;
        this.ZZ = 0.0;
        this.Length = 0.0;
        this.Azimut = 0.0;
        this.Alpha = 0.0;
        this.AA = 0.0;
        this.BB = 0.0;
        this.CC = 0.0;
        this.TopDia = 0.0;
        this.BotDia = 0.0;
        this.Position = 0.0;
        this.Category = 0;
        this.DirectionPrimary = new Vector3d();
        this.Order = -1;
    }

    public void setDirectoryPrimary(Vector3d vector3d) {
        if (vector3d != null) {
            this.DirectionPrimary = new Vector3d(vector3d);
        }
    }

    public boolean hasStdAtt(int n) {
        return (this.stdAttFlag & n) == n;
    }

    public void setStdAttFlagOn(int n) {
        this.stdAttFlag |= n;
    }

    public void setStdAttFlagOff(int n) {
        this.stdAttFlag &= ~n;
    }

    public boolean hasL1() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("L1"));
    }

    public boolean hasL2() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("L2"));
    }

    public boolean hasL3() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("L3"));
    }

    public boolean hasDAB() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("DAB"));
    }

    public boolean hasDAC() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("DAC"));
    }

    public boolean hasDBC() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("DBC"));
    }

    public boolean hasXX() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("XX"));
    }

    public boolean hasYY() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("YY"));
    }

    public boolean hasZZ() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("ZZ"));
    }

    public boolean hasLength() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("Length"));
    }

    public boolean hasAzimut() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("Azimut"));
    }

    public boolean hasAlpha() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("Alpha"));
    }

    public boolean hasAA() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("AA"));
    }

    public boolean hasBB() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("BB"));
    }

    public boolean hasCC() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("CC"));
    }

    public boolean hasTopDia() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("TopDia"));
    }

    public boolean hasBotDia() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("BotDia"));
    }

    public boolean hasPosition() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("Position"));
    }

    public boolean hasCategory() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("Category"));
    }

    public boolean hasDirectionPrimary() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("DirectionPrimary"));
    }

    public boolean hasOrder() {
        return this.hasStdAtt(MTGKeys.getStdAttFlagMask("Order"));
    }

    public int[] topoSons(int n) {
        try {
            int n2;
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (object = this.getFirstEdge(); object != null; object = object.getNext((Node)this)) {
                n2 = 0;
                n2 = n == -1 ? (object.testEdgeBits(256) || object.testEdgeBits(512) ? 1 : 0) : object.testEdgeBits(n);
                if (n2 == 0 || object.getSource() != this || !(object.getTarget() instanceof MTGNode)) continue;
                MTGNode mTGNode = (MTGNode)object.getTarget();
                arrayList.add(new Integer(mTGNode.mtgID));
            }
            object = new int[arrayList.size()];
            for (n2 = 0; n2 < ((Edge)object).length; ++n2) {
                object[n2] = (Edge)((Integer)arrayList.get(n2));
            }
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public MTGNode[] topoSonNodes(int n) {
        try {
            int n2;
            Edge edge;
            ArrayList<MTGNode> arrayList = new ArrayList<MTGNode>();
            for (edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
                n2 = 0;
                n2 = n == -1 ? (edge.testEdgeBits(256) || edge.testEdgeBits(512) ? 1 : 0) : edge.testEdgeBits(n);
                if (n2 == 0 || edge.getSource() != this || !(edge.getTarget() instanceof MTGNode)) continue;
                MTGNode mTGNode = (MTGNode)edge.getTarget();
                arrayList.add(mTGNode);
            }
            edge = new MTGNode[arrayList.size()];
            for (n2 = 0; n2 < ((MTGNode[])edge).length; ++n2) {
                edge[n2] = (MTGNode)arrayList.get(n2);
            }
            return edge;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int order(MTGNode mTGNode) throws MTGError.MTGPlantFrameException {
        if (mTGNode == null) {
            return -1;
        }
        int n = this.orderInternal(this, mTGNode, 0);
        return n;
    }

    private int orderInternal(MTGNode mTGNode, MTGNode mTGNode2, int n) {
        if (mTGNode.equals(mTGNode2)) {
            return n;
        }
        MTGNode[] mTGNodeArray = mTGNode.topoSonNodes(-1);
        if (mTGNodeArray != null && mTGNodeArray.length > 0) {
            int n2 = -1;
            for (int i = 0; i < mTGNodeArray.length; ++i) {
                int n3;
                int n4 = n;
                if (mTGNode.getEdgeBitsTo((Node)mTGNodeArray[i]) == 512) {
                    ++n4;
                }
                if ((n3 = this.orderInternal(mTGNodeArray[i], mTGNode2, n4)) == -1) continue;
                n2 = n3;
            }
            return n2;
        }
        return -1;
    }

    public int height(MTGNode mTGNode) throws MTGError.MTGPlantFrameException {
        if (mTGNode == null) {
            return -1;
        }
        int n = this.heightInternal(this, mTGNode, 0);
        return n;
    }

    private int heightInternal(MTGNode mTGNode, MTGNode mTGNode2, int n) {
        if (mTGNode.equals(mTGNode2)) {
            return n;
        }
        MTGNode[] mTGNodeArray = mTGNode.topoSonNodes(-1);
        if (mTGNodeArray != null && mTGNodeArray.length > 0) {
            int n2 = -1;
            for (int i = 0; i < mTGNodeArray.length; ++i) {
                int n3 = this.heightInternal(mTGNodeArray[i], mTGNode2, n + 1);
                if (n3 == -1) continue;
                n2 = n3;
            }
            return n2;
        }
        return -1;
    }

    public MTGNode compoFather() {
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
            if (!edge.testEdgeBits(4096) || edge.getTarget() != this) continue;
            return (MTGNode)edge.getSource();
        }
        return null;
    }

    public MTGNode[] compoSons() {
        Edge edge;
        ArrayList<MTGNode> arrayList = new ArrayList<MTGNode>();
        for (edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
            if (!edge.testEdgeBits(4096) || edge.getSource() != this || !(edge.getTarget() instanceof MTGNode)) continue;
            arrayList.add((MTGNode)edge.getTarget());
        }
        edge = new MTGNode[arrayList.size()];
        for (int i = 0; i < ((Edge)edge).length; ++i) {
            edge[i] = (MTGNode)arrayList.get(i);
        }
        return edge;
    }

    public int[] compoSonsIds() {
        try {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (object = this.getFirstEdge(); object != null; object = object.getNext((Node)this)) {
                if (!object.testEdgeBits(4096) || object.getSource() != this || !(object.getTarget() instanceof MTGNode)) continue;
                MTGNode mTGNode = (MTGNode)object.getTarget();
                arrayList.add(new Integer(mTGNode.mtgID));
            }
            object = new int[arrayList.size()];
            for (int i = 0; i < ((Edge)object).length; ++i) {
                object[i] = (Edge)((Integer)arrayList.get(i));
            }
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Integer compoSonsCount() {
        try {
            int n = 0;
            for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
                if (!edge.testEdgeBits(4096) || edge.getSource() != this || !(edge.getTarget() instanceof MTGNode)) continue;
                MTGNode mTGNode = (MTGNode)edge.getTarget();
                ++n;
            }
            return new Integer(n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int getOrder() {
        try {
            if (this.hasOrder()) {
                return this.Order;
            }
            return -1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public double getLength() {
        try {
            if (this.hasLength()) {
                return this.Length;
            }
            return -1.0;
        }
        catch (Throwable throwable) {
            return -1.0;
        }
    }

    public MTGNode findAdjacentMTG(boolean bl, int n, String string, int n2) {
        try {
            for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
                if (!edge.testEdgeBits(n) || !bl || edge.getSource() != this || !(edge.getTarget() instanceof MTGNode)) continue;
                MTGNode mTGNode = (MTGNode)edge.getTarget();
                String string2 = mTGNode.mtgClass;
                int n3 = mTGNode.mtgClassID;
                if (!string2.equals(string) || n3 != n2) continue;
                return mTGNode;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Node.NType getType() {
        return $TYPE;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new MTGNode();
    }

    public static void copyStdAttributes(MTGNode mTGNode, MTGNode mTGNode2) {
        if (mTGNode == null || mTGNode2 == null) {
            return;
        }
        mTGNode2.mtgClass = mTGNode.mtgClass;
        mTGNode2.mtgID = mTGNode.mtgID;
        mTGNode2.mtgClassID = mTGNode.mtgClassID;
        mTGNode2.mtgScale = mTGNode.mtgScale;
        mTGNode2.L1 = mTGNode.L1;
        mTGNode2.L2 = mTGNode.L2;
        mTGNode2.L3 = mTGNode.L3;
        mTGNode2.DAB = mTGNode.DAB;
        mTGNode2.DAC = mTGNode.DAC;
        mTGNode2.DBC = mTGNode.DBC;
        mTGNode2.XX = mTGNode.XX;
        mTGNode2.YY = mTGNode.YY;
        mTGNode2.ZZ = mTGNode.ZZ;
        mTGNode2.Length = mTGNode.Length;
        mTGNode2.Azimut = mTGNode.Azimut;
        mTGNode2.Alpha = mTGNode.Alpha;
        mTGNode2.AA = mTGNode.AA;
        mTGNode2.BB = mTGNode.BB;
        mTGNode2.CC = mTGNode.CC;
        mTGNode2.TopDia = mTGNode.TopDia;
        mTGNode2.BotDia = mTGNode.BotDia;
        mTGNode2.Position = mTGNode.Position;
        mTGNode2.Category = mTGNode.Category;
        mTGNode2.setDirectoryPrimary(mTGNode.DirectionPrimary);
        mTGNode2.Order = mTGNode.Order;
        mTGNode2.stdAttFlag = mTGNode.stdAttFlag;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mtgClass$FIELD);
        mtgClassID$FIELD = new _Field("mtgClassID", 0x200001, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)mtgClassID$FIELD);
        mtgID$FIELD = new _Field("mtgID", 0x200001, Type.INT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)mtgID$FIELD);
        L1$FIELD = new _Field("L1", 0x200001, Type.DOUBLE, null, 3);
        $TYPE.addManagedField((ManageableType.Field)L1$FIELD);
        L2$FIELD = new _Field("L2", 0x200001, Type.DOUBLE, null, 4);
        $TYPE.addManagedField((ManageableType.Field)L2$FIELD);
        L3$FIELD = new _Field("L3", 0x200001, Type.DOUBLE, null, 5);
        $TYPE.addManagedField((ManageableType.Field)L3$FIELD);
        DAB$FIELD = new _Field("DAB", 0x200001, Type.DOUBLE, null, 6);
        $TYPE.addManagedField((ManageableType.Field)DAB$FIELD);
        DAC$FIELD = new _Field("DAC", 0x200001, Type.DOUBLE, null, 7);
        $TYPE.addManagedField((ManageableType.Field)DAC$FIELD);
        DBC$FIELD = new _Field("DBC", 0x200001, Type.DOUBLE, null, 8);
        $TYPE.addManagedField((ManageableType.Field)DBC$FIELD);
        XX$FIELD = new _Field("XX", 0x200001, Type.DOUBLE, null, 9);
        $TYPE.addManagedField((ManageableType.Field)XX$FIELD);
        YY$FIELD = new _Field("YY", 0x200001, Type.DOUBLE, null, 10);
        $TYPE.addManagedField((ManageableType.Field)YY$FIELD);
        ZZ$FIELD = new _Field("ZZ", 0x200001, Type.DOUBLE, null, 11);
        $TYPE.addManagedField((ManageableType.Field)ZZ$FIELD);
        Azimut$FIELD = new _Field("Azimut", 0x200001, Type.DOUBLE, null, 12);
        $TYPE.addManagedField((ManageableType.Field)Azimut$FIELD);
        Alpha$FIELD = new _Field("Alpha", 0x200001, Type.DOUBLE, null, 13);
        $TYPE.addManagedField((ManageableType.Field)Alpha$FIELD);
        AA$FIELD = new _Field("AA", 0x200001, Type.DOUBLE, null, 14);
        $TYPE.addManagedField((ManageableType.Field)AA$FIELD);
        BB$FIELD = new _Field("BB", 0x200001, Type.DOUBLE, null, 15);
        $TYPE.addManagedField((ManageableType.Field)BB$FIELD);
        CC$FIELD = new _Field("CC", 0x200001, Type.DOUBLE, null, 16);
        $TYPE.addManagedField((ManageableType.Field)CC$FIELD);
        TopDia$FIELD = new _Field("TopDia", 0x200001, Type.DOUBLE, null, 17);
        $TYPE.addManagedField((ManageableType.Field)TopDia$FIELD);
        BotDia$FIELD = new _Field("BotDia", 0x200001, Type.DOUBLE, null, 18);
        $TYPE.addManagedField((ManageableType.Field)BotDia$FIELD);
        Position$FIELD = new _Field("Position", 0x200001, Type.DOUBLE, null, 19);
        $TYPE.addManagedField((ManageableType.Field)Position$FIELD);
        Category$FIELD = new _Field("Category", 0x200001, Type.INT, null, 20);
        $TYPE.addManagedField((ManageableType.Field)Category$FIELD);
        DirectionPrimary$FIELD = new _Field("DirectionPrimary", 0x200001, Type.OBJECT, null, 21);
        $TYPE.addManagedField((ManageableType.Field)DirectionPrimary$FIELD);
        Order$FIELD = new _Field("Order", 0x200001, Type.INT, null, 22);
        $TYPE.addManagedField((ManageableType.Field)Order$FIELD);
        stdAttFlag$FIELD = new _Field("stdAttFlag", 0x200001, Type.INT, null, 23);
        $TYPE.addManagedField((ManageableType.Field)stdAttFlag$FIELD);
        Length$FIELD = new _Field("Length", 0x200001, Type.DOUBLE, null, 24);
        $TYPE.addManagedField((ManageableType.Field)Length$FIELD);
        mtgScale$FIELD = new _Field("mtgScale", 0x200001, Type.INT, null, 25);
        $TYPE.addManagedField((ManageableType.Field)mtgScale$FIELD);
        dataFlag$FIELD = new _Field("dataFlag", 0x200001, Type.INT, null, 26);
        $TYPE.addManagedField((ManageableType.Field)dataFlag$FIELD);
        $TYPE.declareFieldAttribute(mtgClass$FIELD, (Attribute)Attributes.MTG_CLASS);
        $TYPE.declareFieldAttribute(mtgClassID$FIELD, (Attribute)Attributes.MTG_CLASS_ID);
        $TYPE.declareFieldAttribute(mtgID$FIELD, (Attribute)Attributes.MTG_ID);
        $TYPE.declareFieldAttribute(L1$FIELD, (Attribute)Attributes.L1);
        $TYPE.declareFieldAttribute(L2$FIELD, (Attribute)Attributes.L2);
        $TYPE.declareFieldAttribute(L3$FIELD, (Attribute)Attributes.L3);
        $TYPE.declareFieldAttribute(DAB$FIELD, (Attribute)Attributes.DAB);
        $TYPE.declareFieldAttribute(DAC$FIELD, (Attribute)Attributes.DAC);
        $TYPE.declareFieldAttribute(DBC$FIELD, (Attribute)Attributes.DBC);
        $TYPE.declareFieldAttribute(XX$FIELD, (Attribute)Attributes.XX);
        $TYPE.declareFieldAttribute(YY$FIELD, (Attribute)Attributes.YY);
        $TYPE.declareFieldAttribute(ZZ$FIELD, (Attribute)Attributes.ZZ);
        $TYPE.declareFieldAttribute(Azimut$FIELD, (Attribute)Attributes.Azimut);
        $TYPE.declareFieldAttribute(Alpha$FIELD, (Attribute)Attributes.Alpha);
        $TYPE.declareFieldAttribute(AA$FIELD, (Attribute)Attributes.AA);
        $TYPE.declareFieldAttribute(BB$FIELD, (Attribute)Attributes.BB);
        $TYPE.declareFieldAttribute(CC$FIELD, (Attribute)Attributes.CC);
        $TYPE.declareFieldAttribute(TopDia$FIELD, (Attribute)Attributes.TopDia);
        $TYPE.declareFieldAttribute(BotDia$FIELD, (Attribute)Attributes.BotDia);
        $TYPE.declareFieldAttribute(Position$FIELD, (Attribute)Attributes.Position);
        $TYPE.declareFieldAttribute(Category$FIELD, (Attribute)Attributes.Category);
        $TYPE.declareFieldAttribute(DirectionPrimary$FIELD, (Attribute)Attributes.DirectionPrimary);
        $TYPE.declareFieldAttribute(Order$FIELD, (Attribute)Attributes.Order);
        $TYPE.declareFieldAttribute(stdAttFlag$FIELD, (Attribute)Attributes.STD_ATT_FLAG);
        $TYPE.declareFieldAttribute(Length$FIELD, (Attribute)Attributes.Length);
        $TYPE.declareFieldAttribute(mtgScale$FIELD, (Attribute)Attributes.MTG_SCALE);
        $TYPE.declareFieldAttribute(dataFlag$FIELD, (Attribute)Attributes.DATA_FLAG);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((MTGNode)object).mtgClass = (String)object2;
                    return;
                }
                case 21: {
                    ((MTGNode)object).setDirectoryPrimary((Vector3d)object2);
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((MTGNode)object).mtgClass;
                }
                case 21: {
                    return ((MTGNode)object).DirectionPrimary;
                }
            }
            return super.getObject(object);
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((MTGNode)object).mtgClassID = n;
                    return;
                }
                case 2: {
                    ((MTGNode)object).mtgID = n;
                    return;
                }
                case 20: {
                    ((MTGNode)object).Category = n;
                    return;
                }
                case 22: {
                    ((MTGNode)object).Order = n;
                    return;
                }
                case 23: {
                    ((MTGNode)object).stdAttFlag = n;
                    return;
                }
                case 25: {
                    ((MTGNode)object).mtgScale = n;
                    return;
                }
                case 26: {
                    ((MTGNode)object).dataFlag = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((MTGNode)object).mtgClassID;
                }
                case 2: {
                    return ((MTGNode)object).mtgID;
                }
                case 20: {
                    return ((MTGNode)object).Category;
                }
                case 22: {
                    return ((MTGNode)object).Order;
                }
                case 23: {
                    return ((MTGNode)object).stdAttFlag;
                }
                case 25: {
                    return ((MTGNode)object).mtgScale;
                }
                case 26: {
                    return ((MTGNode)object).dataFlag;
                }
            }
            return super.getInt(object);
        }

        public void setDouble(Object object, double d) {
            switch (this.id) {
                case 3: {
                    ((MTGNode)object).L1 = d;
                    return;
                }
                case 4: {
                    ((MTGNode)object).L2 = d;
                    return;
                }
                case 5: {
                    ((MTGNode)object).L3 = d;
                    return;
                }
                case 6: {
                    ((MTGNode)object).DAB = d;
                    return;
                }
                case 7: {
                    ((MTGNode)object).DAC = d;
                    return;
                }
                case 8: {
                    ((MTGNode)object).DBC = d;
                    return;
                }
                case 9: {
                    ((MTGNode)object).XX = d;
                    return;
                }
                case 10: {
                    ((MTGNode)object).YY = d;
                    return;
                }
                case 11: {
                    ((MTGNode)object).ZZ = d;
                    return;
                }
                case 12: {
                    ((MTGNode)object).Azimut = d;
                    return;
                }
                case 13: {
                    ((MTGNode)object).Alpha = d;
                    return;
                }
                case 14: {
                    ((MTGNode)object).AA = d;
                    return;
                }
                case 15: {
                    ((MTGNode)object).BB = d;
                    return;
                }
                case 16: {
                    ((MTGNode)object).CC = d;
                    return;
                }
                case 17: {
                    ((MTGNode)object).TopDia = d;
                    return;
                }
                case 18: {
                    ((MTGNode)object).BotDia = d;
                    return;
                }
                case 19: {
                    ((MTGNode)object).Position = d;
                    return;
                }
                case 24: {
                    ((MTGNode)object).Length = d;
                    return;
                }
            }
            super.setDouble(object, d);
        }

        public double getDouble(Object object) {
            switch (this.id) {
                case 3: {
                    return ((MTGNode)object).L1;
                }
                case 4: {
                    return ((MTGNode)object).L2;
                }
                case 5: {
                    return ((MTGNode)object).L3;
                }
                case 6: {
                    return ((MTGNode)object).DAB;
                }
                case 7: {
                    return ((MTGNode)object).DAC;
                }
                case 8: {
                    return ((MTGNode)object).DBC;
                }
                case 9: {
                    return ((MTGNode)object).XX;
                }
                case 10: {
                    return ((MTGNode)object).YY;
                }
                case 11: {
                    return ((MTGNode)object).ZZ;
                }
                case 12: {
                    return ((MTGNode)object).Azimut;
                }
                case 13: {
                    return ((MTGNode)object).Alpha;
                }
                case 14: {
                    return ((MTGNode)object).AA;
                }
                case 15: {
                    return ((MTGNode)object).BB;
                }
                case 16: {
                    return ((MTGNode)object).CC;
                }
                case 17: {
                    return ((MTGNode)object).TopDia;
                }
                case 18: {
                    return ((MTGNode)object).BotDia;
                }
                case 19: {
                    return ((MTGNode)object).Position;
                }
                case 24: {
                    return ((MTGNode)object).Length;
                }
            }
            return super.getDouble(object);
        }
    }
}

