/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.imp.View;
import de.grogra.mtg.MTGError;

public class MTGKeys {
    public static final String MTG_CODE_KEYWORD_CODE = "CODE";
    public static final String MTG_CODE_KEYWORD_FORM_A = "FORM-A";
    public static final String MTG_CODE_KEYWORD_FORM_B = "FORM-B";
    public static final String MTG_CLASSES_KEYWORD_CLASSES = "CLASSES";
    public static final String MTG_CLASSES_KEYWORD_SYMBOL = "SYMBOL";
    public static final String MTG_CLASSES_KEYWORD_SCALE = "SCALE";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION = "DECOMPOSITION";
    public static final String MTG_CLASSES_KEYWORD_INDEXATION = "INDEXATION";
    public static final String MTG_CLASSES_KEYWORD_DEFINITION = "DEFINITION";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION_CONNECTED = "CONNECTED";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR = "LINEAR";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_SUCC = "<-LINEAR";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_BRAN = "+-LINEAR";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_FREE = "FREE";
    public static final String MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_NONE = "NONE";
    public static final String MTG_CLASSES_KEYWORD_DEFINITION_IMPLICIT = "IMPLICIT";
    public static final String MTG_CLASSES_KEYWORD_DEFINITION_EXPLICIT = "EXPLICIT";
    public static final int MTG_CLASSES_KEYCODE_DECOMPOSITION_CONNECTED = 0;
    public static final int MTG_CLASSES_KEYCODE_DECOMPOSITION_LINEAR = 1;
    public static final int MTG_CLASSES_KEYCODE_DECOMPOSITION_LINEAR_SUCC = 2;
    public static final int MTG_CLASSES_KEYCODE_DECOMPOSITION_LINEAR_BRAN = 3;
    public static final int MTG_CLASSES_KEYCODE_DECOMPOSITION_LINEAR_FREE = 4;
    public static final int MTG_CLASSES_KEYCODE_DECOMPOSITION_LINEAR_NONE = 5;
    public static final int MTG_CLASSES_KEYCODE_DEFINITION_IMPLICIT = 0;
    public static final int MTG_CLASSES_KEYCODE_DEFINITION_EXPLICIT = 1;
    public static final String MTG_TOPO_KEYWORD_DESCRIPTION = "DESCRIPTION";
    public static final String MTG_TOPO_KEYWORD_LEFT = "LEFT";
    public static final String MTG_TOPO_KEYWORD_RIGHT = "RIGHT";
    public static final String MTG_TOPO_KEYWORD_RELTYPE = "RELTYPE";
    public static final String MTG_TOPO_KEYWORD_MAX = "MAX";
    public static final String MTG_TOPO_KEYWORD_RELTYPE_SUCC = "<";
    public static final String MTG_TOPO_KEYWORD_RELTYPE_BRAN = "+";
    public static final String MTG_TOPO_KEYWORD_RELTYPE_REFI = "/";
    public static final String MTG_TOPO_KEYWORD_MAX_ONE = "1";
    public static final String MTG_TOPO_KEYWORD_MAX_MANY = "?";
    public static final int MTG_TOPO_KEYCODE_RELTYPE_SUCC = 0;
    public static final int MTG_TOPO_KEYCODE_RELTYPE_BRAN = 1;
    public static final int MTG_TOPO_KEYCODE_MAX_ONE = 1;
    public static final int MTG_TOPO_KEYCODE_MAX_MANY = 0;
    public static final String MTG_ATTRIBUTE_KEYWORD_FEATURES = "FEATURES";
    public static final String MTG_ATTRIBUTE_KEYWORD_NAME = "NAME";
    public static final String MTG_ATTRIBUTE_KEYWORD_TYPE = "TYPE";
    public static final String[] MTG_ATTRIBUTE_KEYWORD_FEATURE_NAMES = new String[]{"Alias", "Date", "NbEl", "Length", "BottomDiameter", "TopDiameter", "State"};
    public static final String[] MTG_ATTRIBUTE_KEYWORD_STATE_CHARS = new String[]{"D", "A", "B", "P", "G", "V", "R", "C", "M"};
    public static final String[] MTG_ATTRIBUTE_KEYWORD_FEATURE_TYPES = new String[]{"INT", "REAL", "STRING", "DD/MM", "DD/MM/YY", "MM/YY", "DD/MM-TIME", "DD/MM/YY-TIME", "GEOMETRY", "APPEARANCE", "OBJECT", "ALPHA"};
    public static final String MTG_DATA_KEYWORD_MTG = "MTG";
    public static final String MTG_DATA_KEYWORD_ENTITY_CODE = "ENTITY-CODE";
    public static final String MTG_DATA_KEYWORD_EDGE_SUCC = "<";
    public static final String MTG_DATA_KEYWORD_EDGE_BRAN = "+";
    public static final String MTG_DATA_KEYWORD_EDGE_REFI = "/";
    public static final String MTG_DATA_KEYWORD_EDGE_SUCC_MANY = "<<";
    public static final String MTG_DATA_KEYWORD_EDGE_BRAN_MANY = "++";
    public static final String MTG_DATA_KEYWORD_EDGE_SUCC_MANY_ATT = "<.<";
    public static final String MTG_DATA_KEYWORD_EDGE_BRAN_MANY_ATT = "+.+";
    public static final int MTG_DATA_KEYCODE_EDGE_SUCC = 0;
    public static final int MTG_DATA_KEYCODE_EDGE_BRAN = 1;
    public static final int MTG_DATA_KEYCODE_EDGE_REFI = 2;
    public static final int MTG_DATA_KEYCODE_EDGE_SUCC_MANY = 3;
    public static final int MTG_DATA_KEYCODE_EDGE_BRAN_MANY = 4;
    public static final int MTG_DATA_KEYCODE_EDGE_SUCC_MANY_ATT = 5;
    public static final int MTG_DATA_KEYCODE_EDGE_BRAN_MANY_ATT = 6;
    public static final int MTG_UNKNOWN_KEYCODE = -1;
    public static final int MTG_ROOT_NODE = -2;
    public static final int MTG_ANY = -1;
    public static final String MTG_NODE_ENTITY_CLASS = "Entity Class";
    public static final String MTG_NODE_ENTITY_INDEX = "Entity Index";
    public static final String MTG_NODE_LIST_INDEX = "List Index";
    public static final String MTG_NODE_NODELIST = "Node List";
    public static final String MTG_NODE_BRANCHES = "Branches";
    public static final String MTG_NODE_PLANT_COUNT = "Plant Count";
    public static final String MTG_NODE_PLANT_ORIGIN = "Plant Origin";
    public static final String MTG_NODE_PLANT_MIN = "Plant Min";
    public static final String MTG_NODE_PLANT_MAX = "Plant Max";
    public static final String MTG_NODE_DRESSING = "Dressing";
    public static final String MTG_NODE_COORD_ORIGIN = "Coord Origin";
    public static final String MTG_NODE_COORD_SQUARES = "Coord Squares";
    public static final String MTG_RGG_MODULES = "RGGModules";
    public static final String MTG_MODULE_PREFIX = "mtg_";
    public static final String TR_X = "L1";
    public static final String TR_Y = "L2";
    public static final String TR_Z = "L3";
    public static final String TR_DAB = "DAB";
    public static final String TR_DAC = "DAC";
    public static final String TR_DBC = "DBC";
    public static final String CA_X = "XX";
    public static final String CA_Y = "YY";
    public static final String CA_Z = "ZZ";
    public static final String ATT_LENGTH = "Length";
    public static final String ATT_AZIMUT = "Azimut";
    public static final String ATT_ALPHA = "Alpha";
    public static final String ATT_TETA = "AA";
    public static final String ATT_PHI = "BB";
    public static final String ATT_PSI = "CC";
    public static final String ATT_TOPDIA = "TopDia";
    public static final String ATT_BOTTOMDIA = "BotDia";
    public static final String ATT_POSITION = "Position";
    public static final String ATT_CATEGORY = "Category";
    public static final String ATT_DIRECTION_PRI = "DirectionPrimary";
    public static final String ATT_ORDER = "Order";
    public static final int MTG_TYPE_STANDARD = 1;
    public static final int MTG_TYPE_COORD_TRI_REF = 2;
    public static final int MTG_TYPE_COORD_CARTESIAN = 3;
    public static final String MTG_SCALES_VISIBLE = View.SCALES_VISIBLE;
    public static final String MTG_SCALES_CHANGED = View.SCALES_CHANGED;
    public static final int MTG_TRUNK_ORDER = 0;

    public static int keywordToCodeEdgeType(String string) throws MTGError.MTGGraphBuildException {
        if (string.equals("<")) {
            return 0;
        }
        if (string.equals("+")) {
            return 1;
        }
        if (string.equals("/")) {
            return 2;
        }
        if (string.equals(MTG_DATA_KEYWORD_EDGE_SUCC_MANY)) {
            return 3;
        }
        if (string.equals(MTG_DATA_KEYWORD_EDGE_BRAN_MANY)) {
            return 4;
        }
        if (string.equals(MTG_DATA_KEYWORD_EDGE_SUCC_MANY_ATT)) {
            return 5;
        }
        if (string.equals(MTG_DATA_KEYWORD_EDGE_BRAN_MANY_ATT)) {
            return 6;
        }
        throw new MTGError.MTGGraphBuildException("No keycode found that represents Edge Type Keyword.");
    }

    public static int keywordToCodeStandardFeatureName(String string) {
        for (int i = 0; i < MTG_ATTRIBUTE_KEYWORD_FEATURE_NAMES.length; ++i) {
            if (!string.equals(MTG_ATTRIBUTE_KEYWORD_FEATURE_NAMES[i])) continue;
            return i;
        }
        return -1;
    }

    public static int keywordToCodeStandardFeatureTypes(String string) {
        for (int i = 0; i < MTG_ATTRIBUTE_KEYWORD_FEATURE_TYPES.length; ++i) {
            if (!string.equals(MTG_ATTRIBUTE_KEYWORD_FEATURE_TYPES[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean featureNameMatchesFeatureType(int n, int n2) {
        if (n == 0 && n2 == 2) {
            return true;
        }
        if (n == 0 && n2 == 11) {
            return true;
        }
        if (n == 1 && n2 >= 3 && n2 <= 7) {
            return true;
        }
        if (n == 2 && n2 == 0) {
            return true;
        }
        if (n == 3 && (n2 == 0 || n2 == 1)) {
            return true;
        }
        if (!(n != 4 && n != 5 || n2 != 0 && n2 != 1)) {
            return true;
        }
        return n == 6 && n2 == 2;
    }

    public static boolean stateFeatureCharactersAcceptable(String string) {
        for (int i = 0; i < string.length(); ++i) {
            boolean bl = false;
            String string2 = string.substring(i, i + 1);
            for (int j = 0; j < MTG_ATTRIBUTE_KEYWORD_STATE_CHARS.length; ++j) {
                if (!string2.equals(MTG_ATTRIBUTE_KEYWORD_STATE_CHARS[j])) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static int keywordToCodeDecomposition(String string) throws MTGError.MTGGraphBuildException {
        if (string.equals(MTG_CLASSES_KEYWORD_DECOMPOSITION_CONNECTED)) {
            return 0;
        }
        if (string.equals(MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR)) {
            return 1;
        }
        if (string.equals(MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_SUCC)) {
            return 2;
        }
        if (string.equals(MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_BRAN)) {
            return 3;
        }
        if (string.equals(MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_FREE)) {
            return 4;
        }
        if (string.equals(MTG_CLASSES_KEYWORD_DECOMPOSITION_LINEAR_NONE)) {
            return 5;
        }
        throw new MTGError.MTGGraphBuildException("No keycode found that represents Keyword in Classes Decomposition type.");
    }

    public static int keywordToCodeDefinition(String string) throws MTGError.MTGGraphBuildException {
        if (string.equals(MTG_CLASSES_KEYWORD_DEFINITION_IMPLICIT)) {
            return 0;
        }
        if (string.equals(MTG_CLASSES_KEYWORD_DEFINITION_EXPLICIT)) {
            return 1;
        }
        throw new MTGError.MTGGraphBuildException("No keycode found that represents Keyword in Classes Definition type.");
    }

    public static int keywordToCodeRelType(String string) throws MTGError.MTGGraphBuildException {
        if (string.equals("<")) {
            return 0;
        }
        if (string.equals("+")) {
            return 1;
        }
        throw new MTGError.MTGGraphBuildException("No keycode found that represents Keyword in Description RelType type.");
    }

    public static int keywordToCodeMax(String string) throws MTGError.MTGGraphBuildException {
        if (string.equals(MTG_TOPO_KEYWORD_MAX_ONE)) {
            return 1;
        }
        if (string.equals(MTG_TOPO_KEYWORD_MAX_MANY)) {
            return 0;
        }
        throw new MTGError.MTGGraphBuildException("No keycode found that represents Keyword in Description Max type.");
    }

    public static String codeToJavaTypeFeatureTypes(int n) {
        switch (n) {
            case 0: {
                return "int";
            }
            case 1: {
                return "double";
            }
            case 2: 
            case 11: {
                return "String";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return "String";
            }
        }
        return null;
    }

    public static int javaTypeToFeatureTypesCode(String string) {
        if (string.equals("int")) {
            return 0;
        }
        if (string.equals("double")) {
            return 1;
        }
        if (string.equals("String")) {
            return 2;
        }
        return -1;
    }

    public static String javaTypeToMTGType(String string) {
        int n = MTGKeys.javaTypeToFeatureTypesCode(string);
        if (n != -1) {
            return MTG_ATTRIBUTE_KEYWORD_FEATURE_TYPES[n];
        }
        return null;
    }

    public static String getGeneratedModuleName(String string) {
        if (string != null) {
            return MTG_MODULE_PREFIX + string;
        }
        return null;
    }

    public static boolean isStandardAttribute(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(TR_X) || string.equals(TR_Y) || string.equals(TR_Z) || string.equals(TR_DAB) || string.equals(TR_DAC) || string.equals(TR_DBC) || string.equals(CA_X) || string.equals(CA_Y) || string.equals(CA_Z) || string.equals(ATT_LENGTH) || string.equals(ATT_AZIMUT) || string.equals(ATT_ALPHA) || string.equals(ATT_TETA) || string.equals(ATT_PHI) || string.equals(ATT_PSI) || string.equals(ATT_TOPDIA) || string.equals(ATT_BOTTOMDIA) || string.equals(ATT_POSITION) || string.equals(ATT_CATEGORY) || string.equals(ATT_DIRECTION_PRI) || string.equals(ATT_ORDER);
    }

    public static int getStdAttFlagMask(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals(TR_X)) {
            return 1;
        }
        if (string.equals(TR_Y)) {
            return 2;
        }
        if (string.equals(TR_Z)) {
            return 4;
        }
        if (string.equals(TR_DAB)) {
            return 8;
        }
        if (string.equals(TR_DAC)) {
            return 16;
        }
        if (string.equals(TR_DBC)) {
            return 32;
        }
        if (string.equals(CA_X)) {
            return 64;
        }
        if (string.equals(CA_Y)) {
            return 128;
        }
        if (string.equals(CA_Z)) {
            return 256;
        }
        if (string.equals(ATT_LENGTH)) {
            return 512;
        }
        if (string.equals(ATT_AZIMUT)) {
            return 1024;
        }
        if (string.equals(ATT_ALPHA)) {
            return 2048;
        }
        if (string.equals(ATT_TETA)) {
            return 4096;
        }
        if (string.equals(ATT_PHI)) {
            return 8192;
        }
        if (string.equals(ATT_PSI)) {
            return 16384;
        }
        if (string.equals(ATT_TOPDIA)) {
            return (int)Math.pow(2.0, 15.0);
        }
        if (string.equals(ATT_BOTTOMDIA)) {
            return (int)Math.pow(2.0, 16.0);
        }
        if (string.equals(ATT_POSITION)) {
            return (int)Math.pow(2.0, 17.0);
        }
        if (string.equals(ATT_CATEGORY)) {
            return (int)Math.pow(2.0, 18.0);
        }
        if (string.equals(ATT_DIRECTION_PRI)) {
            return (int)Math.pow(2.0, 19.0);
        }
        if (string.equals(ATT_ORDER)) {
            return (int)Math.pow(2.0, 20.0);
        }
        return 0;
    }

    public static double integerToDouble(Object object) throws MTGError.MTGGraphBuildException {
        try {
            if (object != null) {
                return ((Integer)object).doubleValue();
            }
            throw new MTGError.MTGGraphBuildException("Cannot cast value to double.");
        }
        catch (Throwable throwable) {
            throw new MTGError.MTGGraphBuildException("Cannot cast value to double.");
        }
    }

    public static int doubleToInt(Object object) throws MTGError.MTGGraphBuildException {
        try {
            if (object != null) {
                return ((Double)object).intValue();
            }
            throw new MTGError.MTGGraphBuildException("Cannot cast value to int.");
        }
        catch (Throwable throwable) {
            throw new MTGError.MTGGraphBuildException("Cannot cast value to int.");
        }
    }

    public static String edgeBitToSymbol(int n) {
        if (n == 512) {
            return "+";
        }
        if (n == 256) {
            return "<";
        }
        if (n == 4096) {
            return "/";
        }
        return null;
    }
}

