/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGNodeDataDescription;
import de.grogra.mtg.MTGRoot;
import de.grogra.mtg.MTGTokenizer;
import java.util.ArrayList;

public class MTGGraphBuilderHeaderTopo {
    protected static final int MTG_TOPO_STAGE_DESCRIPTION = 0;
    protected static final int MTG_TOPO_STAGE_COLUMN_NAMES = 1;
    protected static final int MTG_TOPO_STAGE_INFO = 2;
    protected static final int MTG_TOPO_STAGE_END = 3;
    MTGNode rootNode;
    int stage = 0;
    int infoCount;

    public MTGGraphBuilderHeaderTopo(MTGNode mTGNode) {
        this.rootNode = mTGNode;
        this.infoCount = 0;
    }

    private void processDescription(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("DESCRIPTION") && !string.equals("DESCRIPTION:")) continue;
            this.stage = 1;
        }
    }

    private void processColumnHeaders(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("\t")) continue;
            if (!string.equals("LEFT")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'LEFT' in MTG File Header-Description section not found.");
            }
            if (stringArray.length < i + 7) {
                throw new MTGError.MTGGraphBuildException("Incorrect number of column headers in MTG File Header-Description section not found.");
            }
            if (!stringArray[i + 1].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Description section not found.");
            }
            if (!stringArray[i + 2].equals("RIGHT")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'RIGHT' in MTG File Header-Description section not found.");
            }
            if (!stringArray[i + 3].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Description section not found.");
            }
            if (!stringArray[i + 4].equals("RELTYPE")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'RELTYPE' in MTG File Header-Description section not found.");
            }
            if (!stringArray[i + 5].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Description section not found.");
            }
            if (!stringArray[i + 6].equals("MAX")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'MAX' in MTG File Header-Description section not found.");
            }
            this.stage = 2;
            return;
        }
    }

    private void processInfo(String[] stringArray) throws MTGError.MTGGraphBuildException {
        int n;
        if (stringArray.length >= 1 && (stringArray[0].equals("FEATURES") || stringArray[0].equals("FEATURES:"))) {
            this.stage = 3;
            return;
        }
        if (stringArray.length < 7) {
            throw new MTGError.MTGGraphBuildException("Unexpected number of tokens in MTG File Header-Description information Section.");
        }
        if (stringArray.length > 7) {
            for (n = 7; n < stringArray.length; ++n) {
                if (stringArray[n].equals("\t")) continue;
                throw new MTGError.MTGGraphBuildException("Unexpected number of tokens in MTG File Header-Description information Section.");
            }
        }
        if ((n = ((MTGRoot)this.rootNode).classSymbolToClassIndex(stringArray[0])) == -1) {
            throw new MTGError.MTGGraphBuildException("Reference Class in description/topo constraints not found.");
        }
        if (!stringArray[1].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Description section not found.");
        }
        String[] stringArray2 = MTGTokenizer.tokenizeTopoRightClasses(stringArray[2]);
        if (stringArray2 == null) {
            throw new MTGError.MTGGraphBuildException("Expected 'right' class symbols in MTG File Header-Description section not found.");
        }
        int[] nArray = ((MTGRoot)this.rootNode).classSymbolsToClassIndices(stringArray2);
        if (nArray == null) {
            throw new MTGError.MTGGraphBuildException("Reference Class in description/topo constraints not found.");
        }
        if (!stringArray[3].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Description section not found.");
        }
        if (!stringArray[4].equals("<") && !stringArray[4].equals("+")) {
            throw new MTGError.MTGGraphBuildException("Unexpected relationship type in MTG File Header-Description section.");
        }
        if (!stringArray[5].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Description section not found.");
        }
        int n2 = -1;
        if (!stringArray[6].equals("1") && !stringArray[6].equals("?")) {
            try {
                n2 = Integer.parseInt(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MTGError.MTGGraphBuildException("Unexpected 'MAX' column value in MTG File Header-Description section.");
            }
        } else {
            n2 = MTGKeys.keywordToCodeMax(stringArray[6]);
        }
        Object object = ((MTGRoot)this.rootNode).getObject("DESCRIPTION");
        if (object == null) {
            ((MTGRoot)this.rootNode).setObject("DESCRIPTION", new ArrayList());
        }
        if ((object = ((MTGRoot)this.rootNode).getObject("DESCRIPTION")) instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)((MTGRoot)this.rootNode).getObject("DESCRIPTION");
            MTGNodeDataDescription mTGNodeDataDescription = new MTGNodeDataDescription(n, nArray, MTGKeys.keywordToCodeRelType(stringArray[4]), n2);
            arrayList.add(mTGNodeDataDescription);
            ++this.infoCount;
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected data type in rootNode in MTG File Header-Classes section.");
        }
    }

    public int processTokensHeaderTopo(String[] stringArray) throws MTGError.MTGGraphBuildException {
        if (this.stage == 0) {
            this.processDescription(stringArray);
        } else if (this.stage == 1) {
            this.processColumnHeaders(stringArray);
        } else if (this.stage == 2) {
            this.processInfo(stringArray);
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected end stage parsing in MTG-Header Topo constraint section.");
        }
        return this.stage;
    }
}

