/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grogra;

import de.grogra.grammar.SingleLineCommentStart;
import de.grogra.grammar.StartEndCommentStart;
import de.grogra.grammar.StringStart;
import de.grogra.grammar.Token;
import de.grogra.grammar.Tokenizer;
import de.grogra.grogra.LSYTokenTypes;

public final class LSYTokenizer
extends Tokenizer
implements LSYTokenTypes {
    protected boolean isIdentifierPart(char c) {
        return super.isIdentifierPart(c) || c == '\'';
    }

    private void addToken(String string) {
        this.addToken(11, string, false);
        this.addToken(11, string + "+", false);
        this.addToken(11, string + "*", false);
        this.addToken(11, string + "l", false);
        this.addToken(11, string + "l+", false);
        this.addToken(11, string + "l*", false);
    }

    public LSYTokenizer() {
        super(10);
        this.addToken((Token)new StartEndCommentStart("/*", "*/"));
        this.addToken((Token)new SingleLineCommentStart());
        this.addToken((Token)new StringStart());
        for (int i = 0; i < 10; ++i) {
            String string = "J" + i;
            this.addToken(224, string + '=', false);
            this.addToken(224, string + "*=", false);
            this.addToken(224, string + "+=", false);
        }
        this.addToken(11, "F", false);
        this.addToken(11, "F+", false);
        this.addToken(11, "F*", false);
        this.addToken(11, "f", false);
        this.addToken(11, "f+", false);
        this.addToken(11, "f*", false);
        this.addToken(11, "@", false);
        this.addToken(11, "RH", false);
        this.addToken(11, "RL", false);
        this.addToken(11, "RU", false);
        this.addToken(11, "RV", false);
        this.addToken(11, "RV+", false);
        this.addToken(11, "RV*", false);
        this.addToken(11, "P", false);
        this.addToken(11, "Pl", false);
        this.addToken(11, "Light", false);
        this.addToken("L");
        this.addToken("D");
        this.addToken("V");
        this.addToken("N");
        this.addToken(255, "function", false);
        this.addToken(118, "=");
        this.addToken(61, "<");
        this.addToken(62, ">");
        this.addToken(85, "-");
        this.addToken(91, "*");
        this.addToken(92, "+");
        this.addToken(105, "!");
        this.addToken(108, "/");
        this.addToken(109, "%");
        this.addToken(110, "^");
        this.addToken(114, "<=");
        this.addToken(115, ">=");
        this.addToken(117, "!=");
        this.addToken(118, "==");
        this.addToken(122, "||");
        this.addToken(123, "&&");
        this.addToken(218, "(");
        this.addToken(219, ")");
        this.addToken(220, "[");
        this.addToken(221, "]");
        this.addToken(222, ":");
        this.addToken(223, ",");
        this.addToken(225, "\\set");
        this.addToken(226, "\\length");
        this.addToken(227, "\\laenge");
        this.addToken(228, "\\angle");
        this.addToken(229, "\\winkel");
        this.addToken(230, "\\const");
        this.addToken(231, "\\register");
        this.addToken(232, "\\var");
        this.addToken(233, "uniform");
        this.addToken(234, "normal");
        this.addToken(235, "binomial");
        this.addToken(236, "negbinomial");
        this.addToken(237, "poisson");
        this.addToken(238, "distribution");
        this.addToken(239, "table");
        this.addToken(240, "generation");
        this.addToken(241, "register");
        this.addToken(242, "local");
        this.addToken(243, "index");
        this.addToken(244, "length");
        this.addToken(245, "diameter");
        this.addToken(246, "n_value");
        this.addToken(247, "v_value");
        this.addToken(248, "color");
        this.addToken(249, "order");
        this.addToken(250, "carbon");
        this.addToken(251, "q_value");
        this.addToken(252, "xcoordinate");
        this.addToken(253, "ycoordinate");
        this.addToken(254, "zcoordinate");
        this.addToken(255, "function");
        this.addToken(256, "#");
        this.addToken(257, "##");
        this.addToken(258, "?");
        this.addToken(259, "&");
        this.addToken(260, "if");
        this.addToken(261, "sum");
        this.addToken(262, "sumd");
        this.addToken(263, "sump");
    }

    protected Token convert(Token token) {
        if (token.getType() == 11) {
            String string = token.getText();
            StringBuffer stringBuffer = null;
            for (int i = string.length() - 1; i >= 0; --i) {
                if (string.charAt(i) != '\'') continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string);
                }
                stringBuffer.replace(i, i + 1, '$' + Integer.toHexString(string.charAt(i)) + '_');
            }
            if (stringBuffer != null) {
                token.setText(stringBuffer.toString());
            }
        }
        return token;
    }
}

