/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grogra;

import de.grogra.grammar.Input;
import de.grogra.grammar.LexicalException;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.SemanticException;
import de.grogra.grammar.Token;
import de.grogra.grammar.Tokenizer;
import de.grogra.grammar.UnexpectedTokenException;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.grogra.DTDTokenizer;
import de.grogra.grogra.DTGShoot;
import de.grogra.grogra.FruitObject;
import de.grogra.grogra.LeafObject;
import de.grogra.grogra.ShootInfo;
import de.grogra.imp.IMP;
import de.grogra.imp3d.objects.Null;
import de.grogra.math.TMatrix4d;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.ServerConnection;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.SourceFile;
import de.grogra.rgg.Library;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.Runtime;
import de.grogra.util.IOWrapException;
import de.grogra.util.MimeType;
import de.grogra.vecmath.Math2;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTDFilter
extends FilterBase
implements ObjectSource {
    private static final boolean CLASSIC_VERSION = false;
    private static final char EOF = '\u001a';
    private static final char EOL = '\r';
    private static final float FACTOR = 0.001f;
    private static final float DEFAULT_SHORT_SHOOT_LENGTH = 7.07f;
    private static final int DEFAULT_DIRECTION = -5;
    private static final float DEFAULT_THICKNESS = 1.001f;
    private static int leafCounter = 0;
    private static int fruitCounter = 0;
    private float shootLength;
    private float distanceToMotherBasis;
    private float angle;
    private float azimuthAngle;
    private float diameter;
    private float nParameter;
    private float leafArea;
    private float leafLength;
    private float leafBreadth;
    private float qParameter;
    private int direction;
    private int order;
    private int noOfYear;
    private int internodiumCount;
    private int insertPosition;
    private int leafCount;
    private int fruitCount;
    private int shortShootCount;
    private int treeColor;
    private int globkug;
    private int genDistance;
    private int derivationSteps;
    private int minintn;
    private int phyllotax;
    private int jk;
    private boolean isDollar;
    private boolean isExtension;
    private boolean isBud;
    private boolean leafObjectAvailable;
    private boolean fruitObjectAvailable;
    private String nam;
    private String mnam;
    private String startaxiom;
    private String filename;
    private String currentLeafObject;
    private String currentFruitObject;

    public DTDFilter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.NODE);
    }

    public DTDFilter(FileSource fileSource) {
        super(null, (FilterSource)fileSource);
        this.setFlavor(IOFlavor.NODE);
    }

    public Object getObject() throws IOException {
        DTDTokenizer dTDTokenizer = new DTDTokenizer();
        this.initDTDParameter();
        dTDTokenizer.setSource(((ReaderSource)this.source).getReader(), this.source.getSystemId());
        String string = this.source.toString().substring(this.source.toString().indexOf("[") + 1, this.source.toString().length() - 1);
        if (string.charAt(0) == '~') {
            string = System.getProperty("user.home") + string.substring(1);
        }
        return this.getObjectImpl(dTDTokenizer, string);
    }

    public Object getObject(FileSource fileSource) throws IOException {
        DTDTokenizer dTDTokenizer = new DTDTokenizer();
        this.initDTDParameter();
        dTDTokenizer.setSource(fileSource.getReader(), fileSource.getSystemId());
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + fileSource.getSystemId().substring(4);
        File file = this.createTmpFile(string, ((ByteArrayOutputStream)fileSource.getFile()).toString());
        Object object = this.getObjectImpl(dTDTokenizer, string);
        this.deleteTmpFile(file);
        return object;
    }

    private File createTmpFile(String string, String string2) throws IOException {
        File file = new File(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append(string2);
        bufferedWriter.flush();
        bufferedWriter.close();
        return file;
    }

    private void deleteTmpFile(File file) {
        String string = file.getName();
        if (!file.exists()) {
            throw new IllegalArgumentException("Delete: no such file or directory: " + string);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Delete: write protected: " + string);
        }
        if (!file.delete()) {
            throw new IllegalArgumentException("Delete: deletion failed");
        }
    }

    public Object getObjectImpl(DTDTokenizer dTDTokenizer, String string) throws IOException {
        HashMap<String, ShootInfo> hashMap = new HashMap<String, ShootInfo>(500);
        ShootInfo shootInfo = null;
        leafCounter = 0;
        fruitCounter = 0;
        Input input = dTDTokenizer.getInput();
        try {
            Object object;
            Token token;
            this.createBackUpFile(string);
            this.preparationOfTheDTDFile(string);
            int n = 1;
            int n2 = 1;
            while (!input.isClosed()) {
                token = dTDTokenizer.getToken();
                if (token.getType() == 17) {
                    this.getLeafParameter(dTDTokenizer, token);
                    continue;
                }
                if (n == 1) {
                    this.initDTDShootParameter();
                    shootInfo = new ShootInfo();
                    if (token.getType() == 14) {
                        boolean bl;
                        if (token.getText().compareTo("{") == 0) {
                            bl = false;
                            while (!bl) {
                                token = dTDTokenizer.getToken();
                                if (token.getText().compareTo("}") != 0) continue;
                                bl = true;
                            }
                        } else if (token.getText().compareTo("<") == 0) {
                            bl = false;
                            while (!bl) {
                                token = dTDTokenizer.getToken();
                                if (token.getText().compareTo(">") != 0) continue;
                                bl = true;
                            }
                        }
                        token = dTDTokenizer.getToken();
                    }
                    boolean bl = this.getShootHead(input, token, dTDTokenizer);
                    n = this.isStartNewLine(input);
                    if (!bl || n != -1 && n != 1) continue;
                    this.analyseShoot(hashMap);
                    ++n2;
                    continue;
                }
                if (n != 0) continue;
                this.getShootPart(token, dTDTokenizer, shootInfo);
                n = this.isStartNewLine(input);
                if (n != 1 && n != -1) continue;
                this.analyseShoot(hashMap);
                ++n2;
            }
            token = null;
            Matrix3f matrix3f = new Matrix3f();
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            Iterator iterator = hashMap.entrySet().iterator();
            Null nullVal = new Null();
            while (iterator.hasNext()) {
                object = (ShootInfo)((Object)iterator.next().getValue());
                ShootInfo shootInfo2 = hashMap.get(object.mName);
                if (shootInfo2 == null) {
                    token = object;
                    matrix3f.setIdentity();
                } else {
                    matrix3f.transpose(shootInfo2.xf);
                    object.sub((Tuple3f)shootInfo2.tip);
                }
                matrix3f.transform((Tuple3f)object);
                matrix3f.mul(matrix3f, object.xf);
                matrix4d.setRotation(matrix3f);
                matrix4d.m03 = object.x;
                matrix4d.m13 = object.y;
                matrix4d.m23 = object.z;
                object.shoot.setTransform(new TMatrix4d(matrix4d));
                object.shoot.internodeCount = object.izahl;
                DTGShoot dTGShoot = object.shoot;
                object.shoot.parameter = object.nad;
                object.shoot.order = object.or;
                object.shoot.generativeDistance = object.gen;
                object.shoot.internodeCount = object.izahl;
                object.shoot.relPosition = object.q;
                if (shootInfo2 != null) {
                    shootInfo2.shoot.addEdgeBitsTo((Node)dTGShoot, object.or == shootInfo2.or ? 256 : 512, null);
                }
                if (object != token) continue;
                nullVal.addEdgeBitsTo((Node)token.shoot, 256, null);
            }
            if (token == null) {
                throw new SemanticException("No root").set((Tokenizer)dTDTokenizer);
            }
            object = nullVal;
            return object;
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
        finally {
            this.restoreBackUpFile(string);
        }
    }

    private String getString(Tokenizer tokenizer) throws IOException, LexicalException {
        Input input = tokenizer.getInput();
        String string = "";
        char c = ' ';
        try {
            while (c == ' ') {
                c = (char)input.getChar();
            }
            if (c == '\r' || c == '\u001a') {
                input.ungetChar();
                return null;
            }
            string = string + c;
            c = (char)input.getChar();
            while (c != ' ' && c != '\u001a' && c != '\r' && c != '\t' && c != '\n') {
                string = string + c;
                c = (char)input.getChar();
            }
            input.ungetChar();
            return string;
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
    }

    private boolean isWhiteSpace(Tokenizer tokenizer) throws IOException, LexicalException {
        Input input = tokenizer.getInput();
        try {
            char c = (char)input.getChar();
            if (c == ' ' || c == '\t') {
                return true;
            }
            input.ungetChar();
            return false;
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
    }

    private int isStartNewLine(Input input) throws IOException, LexicalException {
        if (input.isClosed()) {
            return -1;
        }
        int n = 32;
        try {
            while (n == 32) {
                n = (char)input.getChar();
            }
            if (n == 13 || n == 10) {
                return 1;
            }
            if (n == 26) {
                return -1;
            }
            input.ungetChar();
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
        return 0;
    }

    private void getLeafParameter(Tokenizer tokenizer, Token token) throws IOException, LexicalException {
        try {
            String string;
            boolean bl = true;
            if (token.getText().compareTo("\\leafarea") == 0) {
                this.leafArea = tokenizer.getFloat();
            } else if (token.getText().compareTo("\\leaflength") == 0) {
                this.leafLength = tokenizer.getFloat();
            } else if (token.getText().compareTo("\\leafbreadth") == 0) {
                this.leafBreadth = tokenizer.getFloat();
            } else if (token.getText().compareTo("\\leafobject") == 0) {
                string = null;
                this.leafObjectAvailable = true;
                this.filename = this.getString(tokenizer);
                this.startaxiom = this.getString(tokenizer);
                this.derivationSteps = tokenizer.getInt();
                string = this.getString(tokenizer);
                this.loadRGGFileToProject();
                LeafObject leafObject = new LeafObject(this.filename, this.startaxiom, string, this.derivationSteps);
                this.currentLeafObject = this.supplyToObjectExplorer(string, leafObject);
                bl = false;
            } else if (token.getText().compareTo("\\fruitobject") == 0) {
                string = null;
                this.fruitObjectAvailable = true;
                this.filename = this.getString(tokenizer);
                this.startaxiom = this.getString(tokenizer);
                this.derivationSteps = tokenizer.getInt();
                string = this.getString(tokenizer);
                this.loadRGGFileToProject();
                FruitObject fruitObject = new FruitObject(this.filename, this.startaxiom, string, this.derivationSteps);
                this.currentFruitObject = this.supplyToObjectExplorer(string, fruitObject);
                bl = false;
            } else if (token.getText().compareTo("\\phyllotaxy") == 0) {
                string = this.getString(tokenizer);
                if (string.compareTo("alternate,") == 0) {
                    this.phyllotax = 0;
                } else if (string.compareTo("spiral,") == 0) {
                    this.phyllotax = 1;
                } else if (string.compareTo("opposite,") == 0) {
                    this.phyllotax = 2;
                }
                bl = false;
            } else if (token.getText().compareTo("\\min_intn") == 0) {
                this.minintn = tokenizer.getInt();
            }
            if (bl && (string = tokenizer.getToken().getText()).compareTo(",") != 0) {
                throw new UnexpectedTokenException(string, ",").set(tokenizer);
            }
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
    }

    private String supplyToObjectExplorer(String string, Node node) {
        String string2 = null;
        try {
            Class clazz = Workbench.current().getRegistry().classForName(this.filename.substring(0, this.filename.length() - 4) + "$" + this.startaxiom);
            Object t = clazz.newInstance();
            ((Node)t).addEdgeBitsTo(node, 256, null);
            GraphManager graphManager = new GraphManager((PersistenceConnection)new ServerConnection(null), null, false, false);
            graphManager.setRoot("MainGraph", node);
            RGGGraph rGGGraph = Runtime.INSTANCE.currentGraph();
            Runtime.INSTANCE.setCurrentGraph(graphManager);
            for (int i = 0; i < this.derivationSteps; ++i) {
                Method method = t.getClass().getMethod(string, new Class[0]);
                method.invoke(t, new Object[0]);
                Library.derive();
            }
            Runtime.INSTANCE.setCurrentGraph(rGGGraph);
            string2 = this.filename + "_" + this.startaxiom + "_" + this.derivationSteps + "_" + string;
            ObjectItem objectItem = ObjectItem.createReference((RegistryContext)Workbench.current(), (Object)node, (String)string2);
            Workbench.current().getRegistry().getDirectory("/project/objects/objects", null).addUserItem((Item)objectItem);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return string2;
    }

    private void loadRGGFileToProject() {
        SourceFile sourceFile;
        Object object;
        boolean bl = false;
        Item item = Workbench.current().getRegistry().getDirectory("/project/objects/files", null);
        for (object = item.getBranch(); object != null; object = object.getSuccessor()) {
            if (!(object instanceof SourceFile) || !(sourceFile = (SourceFile)object).getName().equals(this.filename)) continue;
            bl = true;
        }
        if (!bl) {
            object = new File(this.filename);
            sourceFile = FileTypeItem.get((RegistryContext)Workbench.current(), (String)((File)object).getName());
            if (sourceFile == null) {
                throw new UnsupportedOperationException("unsupported format of " + object);
            }
            IMP.addSourceFile((File)object, (MimeType)sourceFile.getMimeType(), (Context)Workbench.current());
        }
    }

    private void initDTDParameter() {
        this.leafArea = 0.0f;
        this.leafLength = 5.0f;
        this.leafBreadth = 1.0f;
        this.fruitObjectAvailable = false;
        this.leafObjectAvailable = false;
        this.phyllotax = 0;
        this.minintn = 0;
        this.derivationSteps = 0;
    }

    private void initDTDShootParameter() {
        this.diameter = 1.001f;
        this.direction = -5;
        this.angle = 0.0f;
        this.azimuthAngle = -360.0f;
        this.nParameter = 0.0f;
        this.internodiumCount = 0;
        this.insertPosition = 0;
        this.leafCount = 0;
        this.fruitCount = 0;
        this.shortShootCount = 0;
        this.treeColor = 10;
        this.isDollar = false;
        this.globkug = 0;
        this.distanceToMotherBasis = -1.0f;
        this.order = -1;
        this.genDistance = -1;
        this.noOfYear = -1;
        this.isExtension = false;
        this.isBud = false;
    }

    private boolean getShootHead(Input input, Token token, Tokenizer tokenizer) throws IOException, LexicalException {
        try {
            Token token2;
            if (input.isClosed()) {
                return false;
            }
            boolean bl = this.isWhiteSpace(tokenizer);
            if (!bl) {
                this.nam = this.getString(tokenizer);
                if (token.getText() != null) {
                    this.nam = token.getText() + this.nam;
                }
            } else {
                this.nam = token.getText();
            }
            if (this.nam.charAt(0) == '#') {
                this.nam = this.nam.substring(1);
            }
            if ((token2 = tokenizer.getToken()).getType() == 15) {
                if (token2.getText().compareTo("Q") == 0 || token2.getText().compareTo("q") == 0) {
                    this.shortShootCount = tokenizer.getInt();
                    this.shootLength = 7.07f;
                } else if (token2.getText().compareTo("L") == 0 || token2.getText().compareTo("l") == 0) {
                    boolean bl2 = this.isWhiteSpace(tokenizer);
                    this.shootLength = !bl2 ? tokenizer.getFloat() : 0.0f;
                } else {
                    throw new UnexpectedTokenException(token2.getText(), "Q,L").set(tokenizer);
                }
            }
            if ((token2 = tokenizer.getToken()).getText().compareTo("#") != 0) {
                throw new UnexpectedTokenException(token2.getText(), "#").set(tokenizer);
            }
            this.mnam = this.getString(tokenizer);
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
        return true;
    }

    private void getShootPart(Token token, Tokenizer tokenizer, ShootInfo shootInfo) throws IOException, LexicalException {
        if (shootInfo == null || tokenizer == null) {
            return;
        }
        try {
            if (token.getText().compareTo("A") == 0 || token.getText().compareTo("a") == 0) {
                boolean bl = this.isWhiteSpace(tokenizer);
                if (!bl) {
                    this.distanceToMotherBasis = tokenizer.getFloat();
                }
            } else if (token.getText().compareTo("W") == 0 || token.getText().compareTo("w") == 0) {
                this.angle = tokenizer.getFloat();
            } else if (token.getText().compareTo("O") == 0 || token.getText().compareTo("o") == 0) {
                this.order = tokenizer.getInt();
            } else if (token.getText().compareTo("G") == 0 || token.getText().compareTo("g") == 0) {
                this.genDistance = tokenizer.getInt();
            } else if (token.getText().compareTo("J") == 0 || token.getText().compareTo("j") == 0) {
                this.noOfYear = tokenizer.getInt();
            } else if (token.getText().compareTo("R") == 0 || token.getText().compareTo("r") == 0) {
                this.direction = tokenizer.getInt();
            } else if (token.getText().compareTo("S") == 0 || token.getText().compareTo("s") == 0) {
                this.azimuthAngle = tokenizer.getFloat();
            } else if (token.getText().compareTo("E") == 0 || token.getText().compareTo("e") == 0) {
                this.internodiumCount = tokenizer.getInt();
            } else if (token.getText().compareTo("I") == 0 || token.getText().compareTo("i") == 0) {
                this.insertPosition = tokenizer.getInt();
            } else if (token.getText().compareTo("N") == 0 || token.getText().compareTo("n") == 0) {
                this.nParameter = tokenizer.getFloat();
            } else if (token.getText().compareTo("D") == 0 || token.getText().compareTo("d") == 0) {
                boolean bl = this.isWhiteSpace(tokenizer);
                if (!bl) {
                    this.diameter = tokenizer.getFloat();
                }
            } else if (token.getText().compareTo("C") == 0 || token.getText().compareTo("c") == 0) {
                this.treeColor = tokenizer.getInt();
            } else if (token.getText().compareTo("B") == 0 || token.getText().compareTo("b") == 0) {
                this.leafCount = tokenizer.getInt();
            } else if (token.getText().compareTo("F") == 0 || token.getText().compareTo("f") == 0) {
                this.fruitCount = tokenizer.getInt();
            } else if (token.getText().compareTo("T") == 0 || token.getText().compareTo("t") == 0) {
                tokenizer.getFloat();
                this.noOfYear = 0;
            } else if (token.getText().compareTo("M") == 0 || token.getText().compareTo("m") == 0) {
                tokenizer.getFloat();
            } else if (token.getText().compareTo("P") == 0 || token.getText().compareTo("p") == 0) {
                tokenizer.getFloat();
            } else if (token.getText().compareTo("X") == 0 || token.getText().compareTo("x") == 0) {
                tokenizer.getFloat();
            } else if (token.getText().compareTo("V") == 0 || token.getText().compareTo("v") == 0) {
                this.isExtension = true;
            } else if (token.getText().compareTo("K") == 0 || token.getText().compareTo("k") == 0) {
                this.isBud = true;
            } else if (token.getText().compareTo("-") == 0) {
                this.direction = 7;
            } else if (token.getText().compareTo("+") == 0) {
                this.direction = 3;
            } else if (token.getText().compareTo("$") == 0) {
                this.isDollar = true;
            } else if (token.getText().compareTo(".") == 0) {
                this.globkug = 1;
            } else if (token.getText().compareTo("(") == 0) {
                String string = tokenizer.getToken().getText();
                if (string.compareTo("D") == 0 || string.compareTo("d") == 0) {
                    this.diameter = tokenizer.getFloat();
                }
                boolean bl = false;
                while (!bl) {
                    Token token2 = tokenizer.getToken();
                    if (token2.getText().compareTo(")") != 0) continue;
                    bl = true;
                }
            } else if (token.getText().compareTo("{") == 0) {
                boolean bl = false;
                while (!bl) {
                    Token token3 = tokenizer.getToken();
                    if (token3.getText().compareTo("}") != 0) continue;
                    bl = true;
                }
            } else if (token.getText().compareTo("<") == 0) {
                boolean bl = false;
                while (!bl) {
                    Token token4 = tokenizer.getToken();
                    if (token4.getText().compareTo(">") != 0) continue;
                    bl = true;
                }
            }
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
    }

    private void analyseShoot(HashMap<String, ShootInfo> hashMap) {
        ShootInfo shootInfo = this.searchMotherShoot(hashMap, this.mnam);
        if (this.distanceToMotherBasis >= 0.0f) {
            float f = shootInfo != null ? shootInfo.laenge : 0.0f;
            this.qParameter = f > 0.0f ? 1.0f - this.distanceToMotherBasis / f : 0.0f;
            if (this.qParameter < 0.0f) {
                this.qParameter = 0.0f;
            }
            if (this.qParameter > 1.0f) {
                this.qParameter = 1.0f;
            }
        } else {
            int n = 0;
            if (shootInfo != null) {
                n = shootInfo.izahl;
            }
            this.qParameter = this.insertPosition > 0 && n > 0 ? (float)this.insertPosition / (float)n : 0.0f;
        }
        if (this.order == -1) {
            this.order = shootInfo != null ? (this.isExtension ? shootInfo.or : shootInfo.or + 1) : 0;
        }
        if (this.azimuthAngle == -360.0f) {
            this.azimuthAngle = (this.direction - 1) * 45;
        }
        if (this.genDistance == -1) {
            if (this.noOfYear == -1) {
                this.genDistance = shootInfo != null ? shootInfo.gen + 1 : 0;
            } else {
                this.genDistance = -1 - this.noOfYear;
                if (shootInfo != null) {
                    this.jk = 1;
                }
            }
        }
        if (this.internodiumCount <= 0) {
            if ((this.leafCount > 0 || this.fruitCount > 0) && this.minintn > 0) {
                this.internodiumCount = this.leafCount + 1 > this.minintn ? this.leafCount + 1 : (this.fruitCount + 1 > this.minintn ? this.fruitCount + 1 : this.minintn);
            } else if (this.leafCount > 0 || this.fruitCount > 0) {
                this.internodiumCount = 1;
            }
        }
        boolean bl = this.order <= 1;
        if (this.isDollar || this.globkug != 0) {
            bl = true;
        }
        this.processingShoot(bl, shootInfo, hashMap);
    }

    private void processingShoot(boolean bl, ShootInfo shootInfo, HashMap<String, ShootInfo> hashMap) {
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        Vector3f vector3f4;
        Vector3f vector3f5;
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        Vector3f vector3f8 = new Vector3f();
        Vector3f vector3f9 = new Vector3f();
        Vector3f vector3f10 = new Vector3f();
        Vector3f vector3f11 = new Vector3f();
        Vector3f vector3f12 = new Vector3f();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        vector3f12.y = 0.0f;
        vector3f12.x = 0.0f;
        vector3f12.z = 1.0f;
        double d = Math.PI * (double)(this.azimuthAngle / 180.0f);
        double d2 = Math.PI * (double)(this.angle / 180.0f);
        if (this.globkug == 0) {
            f = (float)Math.cos(d) * (float)Math.sin(d2);
            f2 = (float)Math.sin(d) * (float)Math.sin(d2);
            f3 = (float)Math.cos(d2);
        } else {
            f = (float)Math.cos(d2) * (float)Math.cos(d);
            f2 = (float)Math.cos(d2) * (float)Math.sin(d);
            f3 = (float)Math.sin(d2);
        }
        if (shootInfo != null) {
            vector3f5 = shootInfo.panf;
            vector3f4 = shootInfo.pend;
            vector3f3 = shootInfo.sh;
            vector3f2 = shootInfo.sl;
            vector3f = shootInfo.su;
        } else {
            vector3f5 = new Vector3f();
            vector3f4 = new Vector3f();
            vector3f3 = new Vector3f();
            vector3f = new Vector3f();
            vector3f2 = new Vector3f();
            vector3f3.z = 1.0f;
            vector3f.y = -1.0f;
            vector3f2.x = -1.0f;
        }
        vector3f6 = (Vector3f)vector3f5.clone();
        Vector3f vector3f13 = (Vector3f)vector3f4.clone();
        vector3f6.scale(this.qParameter);
        vector3f13.scale(1.0f - this.qParameter);
        vector3f6.add((Tuple3f)vector3f13);
        if (this.globkug == 0) {
            vector3f11 = (Vector3f)vector3f.clone();
            vector3f13 = (Vector3f)vector3f2.clone();
            Vector3f vector3f14 = (Vector3f)vector3f3.clone();
            vector3f11.scale(f);
            vector3f13.scale(f2);
            vector3f11.sub((Tuple3f)vector3f13);
            vector3f14.scale(f3);
            vector3f11.add((Tuple3f)vector3f14);
        } else {
            vector3f11.x = f;
            vector3f11.y = f2;
            vector3f11.z = f3;
        }
        vector3f11.scale(this.shootLength);
        vector3f7.add((Tuple3f)vector3f6, (Tuple3f)vector3f11);
        if (vector3f11.length() < 1.0E-9f) {
            vector3f8 = vector3f3;
        } else {
            vector3f8 = (Vector3f)vector3f11.clone();
            Math2.normalize((Vector3f)vector3f8);
        }
        if (bl) {
            vector3f11.cross(vector3f12, vector3f8);
            if (vector3f11.length() < 1.0E-9f) {
                vector3f9.x = -1.0f;
                vector3f9.z = 0.0f;
                vector3f9.y = 0.0f;
            } else {
                vector3f9 = (Vector3f)vector3f11.clone();
                Math2.normalize((Vector3f)vector3f9);
            }
            vector3f10.cross(vector3f8, vector3f9);
        } else {
            vector3f11.cross(vector3f2, vector3f8);
            if (vector3f11.length() < 1.0E-9f) {
                vector3f10 = vector3f;
            } else {
                vector3f10 = (Vector3f)vector3f11.clone();
                Math2.normalize((Vector3f)vector3f10);
            }
            if (vector3f10.dot(vector3f) < 0.0f) {
                vector3f10.scale(-1.0f);
            }
            vector3f9.cross(vector3f10, vector3f8);
        }
        ShootInfo shootInfo2 = this.createShoot(vector3f6, vector3f7, vector3f8, vector3f9, vector3f10);
        if (shootInfo2.akurztr > 0) {
            String string = shootInfo2.name;
            shootInfo2.name = shootInfo2.name + ".1";
            hashMap.put(this.nam + ".1", shootInfo2);
            ShootInfo shootInfo3 = shootInfo2;
            ShootInfo shootInfo4 = shootInfo2;
            Vector3f vector3f15 = (Vector3f)shootInfo2.pend.clone();
            for (int i = 2; i <= shootInfo2.akurztr; ++i) {
                Vector3f vector3f16 = new Vector3f();
                shootInfo3 = (ShootInfo)((Object)shootInfo2.clone());
                shootInfo3.name = string + "." + i;
                shootInfo3.mName = shootInfo4.name;
                shootInfo3.panf = vector3f15;
                shootInfo3.set((Tuple3f)vector3f15);
                shootInfo3.scale(0.001f);
                vector3f16.scale(shootInfo3.shoot.length, (Tuple3f)vector3f15);
                shootInfo3.pend = vector3f16;
                shootInfo3.tip.set((Tuple3f)vector3f16);
                shootInfo3.tip.scale(0.001f);
                hashMap.put(this.nam + "." + i, shootInfo3);
                shootInfo4 = shootInfo3;
                vector3f15 = (Vector3f)vector3f16.clone();
            }
        } else {
            hashMap.put(this.nam, shootInfo2);
        }
        if (this.internodiumCount > 0 && this.leafCount > 0) {
            this.analyseLeaf(bl, hashMap, shootInfo2);
        }
        if (this.internodiumCount > 0 && this.fruitCount > 0) {
            this.analyseFruit(bl, hashMap, shootInfo2);
        }
    }

    private void analyseFruit(boolean bl, HashMap<String, ShootInfo> hashMap, ShootInfo shootInfo) {
        float f = 50.0f;
        this.azimuthAngle = 90.0f;
        this.diameter = 1.001f;
        this.nParameter = 0.0f;
        this.shortShootCount = 0;
        this.treeColor = 4;
        this.shootLength = 10.0f;
        for (int i = 1; i <= this.fruitCount; ++i) {
            this.azimuthAngle += 180.0f;
            if (this.azimuthAngle > 360.0f) {
                this.azimuthAngle = 90.0f;
            }
            if (i <= this.internodiumCount) {
                this.qParameter = (float)i / (float)this.internodiumCount;
            } else {
                this.qParameter = 1.0f;
                this.azimuthAngle = f += 5.0f;
            }
            this.mnam = shootInfo.name;
            this.nam = "fruit" + ++fruitCounter;
            this.processingLeaf(bl, shootInfo, hashMap, i, true);
        }
    }

    private void analyseLeaf(boolean bl, HashMap<String, ShootInfo> hashMap, ShootInfo shootInfo) {
        float f = 70.0f;
        this.azimuthAngle = 90.0f;
        int n = 0;
        this.diameter = 1.001f;
        this.nParameter = this.leafArea;
        this.shortShootCount = 0;
        this.treeColor = 15;
        this.shootLength = 10.0f;
        this.angle = 45.0f;
        for (int i = 0; i < this.leafCount; ++i) {
            switch (this.phyllotax) {
                case 0: {
                    this.azimuthAngle += 180.0f;
                    ++this.insertPosition;
                    break;
                }
                case 1: {
                    this.azimuthAngle += 137.5f;
                    ++this.insertPosition;
                    break;
                }
                case 2: {
                    switch (n) {
                        case 0: {
                            ++this.insertPosition;
                            this.azimuthAngle = 270.0f;
                            break;
                        }
                        case 1: {
                            this.azimuthAngle = 90.0f;
                            break;
                        }
                        case 2: {
                            ++this.insertPosition;
                            this.azimuthAngle = 180.0f;
                            break;
                        }
                        case 3: {
                            this.azimuthAngle = 0.0f;
                            n = -1;
                        }
                    }
                    ++n;
                    break;
                }
                default: {
                    this.insertPosition = i - 1;
                }
            }
            if (this.insertPosition <= this.internodiumCount) {
                this.qParameter = (float)this.insertPosition / (float)this.internodiumCount;
            } else {
                this.qParameter = 1.0f;
                this.azimuthAngle = f += 5.0f;
            }
            this.mnam = shootInfo.name;
            this.nam = "leaf" + ++leafCounter;
            this.processingLeaf(bl, shootInfo, hashMap, i, false);
        }
    }

    private void processingLeaf(boolean bl, ShootInfo shootInfo, HashMap<String, ShootInfo> hashMap, int n, boolean bl2) {
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        Vector3f vector3f4;
        Vector3f vector3f5;
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        Vector3f vector3f8 = new Vector3f();
        Vector3f vector3f9 = new Vector3f();
        Vector3f vector3f10 = new Vector3f();
        Vector3f vector3f11 = new Vector3f();
        Vector3f vector3f12 = new Vector3f();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        vector3f12.y = 0.0f;
        vector3f12.x = 0.0f;
        vector3f12.z = 1.0f;
        double d = Math.PI * (double)(this.azimuthAngle / 180.0f);
        double d2 = Math.PI * (double)(this.angle / 180.0f);
        if (this.globkug == 0) {
            f = (float)Math.cos(d) * (float)Math.sin(d2);
            f2 = (float)Math.sin(d) * (float)Math.sin(d2);
            f3 = (float)Math.cos(d2);
        } else {
            f = (float)Math.cos(d2) * (float)Math.cos(d);
            f2 = (float)Math.cos(d2) * (float)Math.sin(d);
            f3 = (float)Math.sin(d2);
        }
        if (shootInfo != null) {
            vector3f5 = shootInfo.panf;
            vector3f4 = shootInfo.pend;
            vector3f3 = shootInfo.sh;
            vector3f2 = shootInfo.sl;
            vector3f = shootInfo.su;
        } else {
            vector3f5 = new Vector3f();
            vector3f4 = new Vector3f();
            vector3f3 = new Vector3f();
            vector3f = new Vector3f();
            vector3f2 = new Vector3f();
            vector3f3.z = 1.0f;
            vector3f.y = -1.0f;
            vector3f2.x = -1.0f;
        }
        vector3f6 = (Vector3f)vector3f5.clone();
        Vector3f vector3f13 = (Vector3f)vector3f4.clone();
        vector3f6.scale(this.qParameter);
        vector3f13.scale(1.0f - this.qParameter);
        vector3f6.add((Tuple3f)vector3f13);
        if (this.globkug == 0) {
            vector3f11 = (Vector3f)vector3f.clone();
            vector3f13 = (Vector3f)vector3f2.clone();
            Vector3f vector3f14 = (Vector3f)vector3f3.clone();
            vector3f11.scale(f);
            vector3f13.scale(f2);
            vector3f11.sub((Tuple3f)vector3f13);
            vector3f14.scale(f3);
            vector3f11.add((Tuple3f)vector3f14);
        } else {
            vector3f11.x = f;
            vector3f11.y = f2;
            vector3f11.z = f3;
        }
        vector3f11.scale(this.shootLength);
        vector3f7.add((Tuple3f)vector3f6, (Tuple3f)vector3f11);
        if (vector3f11.length() < 1.0E-9f) {
            vector3f8 = vector3f3;
        } else {
            vector3f8 = (Vector3f)vector3f11.clone();
            Math2.normalize((Vector3f)vector3f8);
        }
        if (bl) {
            vector3f11.cross(vector3f12, vector3f8);
            if (vector3f11.length() < 1.0E-9f) {
                vector3f9.x = -1.0f;
                vector3f9.z = 0.0f;
                vector3f9.y = 0.0f;
            } else {
                vector3f9 = (Vector3f)vector3f11.clone();
                Math2.normalize((Vector3f)vector3f9);
            }
            vector3f10.cross(vector3f8, vector3f9);
        } else {
            vector3f11.cross(vector3f2, vector3f8);
            if (vector3f11.length() < 1.0E-9f) {
                vector3f10 = vector3f;
            } else {
                vector3f10 = (Vector3f)vector3f11.clone();
                Math2.normalize((Vector3f)vector3f10);
            }
            if (vector3f10.dot(vector3f) < 0.0f) {
                vector3f10.scale(-1.0f);
            }
            vector3f9.cross(vector3f10, vector3f8);
        }
        ShootInfo shootInfo2 = this.createShoot(vector3f6, vector3f7, vector3f8, vector3f9, vector3f10);
        shootInfo2.izahl = bl2 ? -2 : -1;
        shootInfo2.or = shootInfo.or + 1;
        if (!bl2 && this.nParameter > 0.0f) {
            shootInfo2.nad = this.nParameter / (float)n;
        }
        hashMap.put(this.nam, shootInfo2);
    }

    private ShootInfo createShoot(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        DTGShoot dTGShoot;
        ShootInfo shootInfo = new ShootInfo();
        shootInfo.akurztr = this.shortShootCount;
        shootInfo.name = this.nam;
        shootInfo.mName = this.mnam;
        shootInfo.laenge = Math2.abstpp((Vector3d)new Vector3d(vector3f), (Vector3d)new Vector3d(vector3f2));
        shootInfo.edur = this.diameter;
        shootInfo.nad = this.nParameter;
        shootInfo.izahl = this.internodiumCount;
        shootInfo.farbe = this.treeColor;
        shootInfo.or = this.order;
        shootInfo.gen = this.genDistance;
        shootInfo.q = this.qParameter;
        shootInfo.panf = vector3f;
        shootInfo.pend = vector3f2;
        shootInfo.sh = vector3f3;
        shootInfo.sl = vector3f4;
        shootInfo.su = vector3f5;
        shootInfo.shoot = dTGShoot = new DTGShoot();
        dTGShoot.diameter = this.diameter * 0.001f;
        dTGShoot.color = this.treeColor;
        shootInfo.set((Tuple3f)vector3f);
        shootInfo.scale(0.001f);
        shootInfo.tip.set((Tuple3f)vector3f2);
        shootInfo.tip.scale(0.001f);
        dTGShoot.length = shootInfo.laenge * 0.001f;
        shootInfo.xf.setColumn(2, vector3f3);
        shootInfo.xf.setColumn(0, vector3f4);
        shootInfo.xf.setColumn(1, vector3f5);
        return shootInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBackUpFile(String string) {
        File file = new File(string + ".tmp");
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            file.createNewFile();
            bufferedReader = new BufferedReader(new FileReader(string));
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void restoreBackUpFile(String string) {
        File file = new File(string);
        File file2 = new File(string + ".tmp");
        if (file.exists() && file2.exists()) {
            file.delete();
            file2.renameTo(file);
        } else if (!file.exists() && file2.exists()) {
            file2.renameTo(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparationOfTheDTDFile(String string) {
        File file = new File(string);
        File file2 = new File(string + ".prep");
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() != 0) {
                    char c = string2.charAt(0);
                    if (c != '<' && c != '\\' && c != '{') {
                        bufferedWriter.write("#" + string2);
                    } else {
                        bufferedWriter.write(string2);
                    }
                }
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
            bufferedReader = new BufferedReader(new FileReader(file2));
            bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (file2.exists()) {
                    file2.delete();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private ShootInfo searchMotherShoot(HashMap<String, ShootInfo> hashMap, String string) {
        return hashMap.get(string);
    }
}

