/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.chem;

import de.grogra.chem.ChemicalExpression;
import de.grogra.chem.ChemicalTerm;
import de.grogra.chem.ISlope;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChemicalReaction
implements ISlope {
    ChemicalExpression left;
    ChemicalExpression right;
    double kf;
    double kr;

    public double getForwardRateConstant() {
        return this.kf;
    }

    public void setForwardRateConstant(double d) {
        this.kf = d;
    }

    public double getBackwardRateConstant() {
        return this.kr;
    }

    public void setBackwardRateConstant(double d) {
        this.kr = d;
    }

    public String toString() {
        return this.left.toString() + " <=> " + this.right.toString();
    }

    @Override
    public int assignIndices(int n, HashMap<Object, Integer> hashMap) {
        Integer n2;
        for (ChemicalTerm chemicalTerm : this.left.terms) {
            n2 = hashMap.get(chemicalTerm.m);
            if (n2 == null) {
                chemicalTerm.index = n;
                n2 = n++;
                hashMap.put(chemicalTerm.m, n2);
                continue;
            }
            chemicalTerm.index = n2;
        }
        for (ChemicalTerm chemicalTerm : this.right.terms) {
            n2 = hashMap.get(chemicalTerm.m);
            if (n2 == null) {
                chemicalTerm.index = n;
                n2 = n++;
                hashMap.put(chemicalTerm.m, n2);
                continue;
            }
            chemicalTerm.index = n2;
        }
        return n;
    }

    @Override
    public void eval(double[] dArray, double d, double[] dArray2) {
        double d2 = this.getForwardRateConstant();
        for (ChemicalTerm chemicalTerm : this.left.terms) {
            d2 *= Math.pow(dArray2[chemicalTerm.index], chemicalTerm.factor);
        }
        for (ChemicalTerm chemicalTerm : this.left.terms) {
            int n = chemicalTerm.index;
            dArray[n] = dArray[n] - d2 * chemicalTerm.factor;
        }
        for (ChemicalTerm chemicalTerm : this.right.terms) {
            int n = chemicalTerm.index;
            dArray[n] = dArray[n] + d2 * chemicalTerm.factor;
        }
        d2 = this.getBackwardRateConstant();
        for (ChemicalTerm chemicalTerm : this.right.terms) {
            d2 *= Math.pow(dArray2[chemicalTerm.index], chemicalTerm.factor);
        }
        for (ChemicalTerm chemicalTerm : this.left.terms) {
            int n = chemicalTerm.index;
            dArray[n] = dArray[n] + d2 * chemicalTerm.factor;
        }
        for (ChemicalTerm chemicalTerm : this.right.terms) {
            int n = chemicalTerm.index;
            dArray[n] = dArray[n] - d2 * chemicalTerm.factor;
        }
    }
}

