/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import de.grogra.grammar.NumberLiteral;

public final class FloatLiteral
extends NumberLiteral {
    private float value;

    public FloatLiteral(String string) {
        super(7, string);
        this.value = Float.NEGATIVE_INFINITY;
    }

    public FloatLiteral(float f) {
        super(7, null);
        this.value = f;
    }

    public float floatValue() {
        if (this.value == Float.NEGATIVE_INFINITY) {
            this.value = new Float(super.getText()).floatValue();
            return this.value;
        }
        return this.value;
    }

    public int intValue() {
        return (int)this.floatValue();
    }

    public long longValue() {
        return (long)this.floatValue();
    }

    public double doubleValue() {
        return this.floatValue();
    }

    public String getText() {
        String string = super.getText();
        if (string == null) {
            string = Float.toString(this.value);
            this.setText(string);
        }
        return string;
    }
}

