/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.util.Vector;
import org.gjt.sp.util.Log;

public class ReadWriteLock {
    private int activeReaders;
    private int activeWriters;
    private int waitingReaders;
    private int waitingWriters;
    private Vector readers = new Vector();
    private Thread writerThread;
    private int lockCount;

    public synchronized void readLock() {
        if (this.activeReaders != 0 || this.allowRead()) {
            ++this.activeReaders;
            return;
        }
        ++this.waitingReaders;
        while (!this.allowRead()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                --this.waitingReaders;
                Log.log(9, this, interruptedException);
                return;
            }
        }
        --this.waitingReaders;
        ++this.activeReaders;
        this.readers.addElement(Thread.currentThread());
    }

    public synchronized void readUnlock() {
        if (this.activeReaders == 0) {
            throw new InternalError("Unbalanced readLock()/readUnlock() calls");
        }
        --this.activeReaders;
        this.notifyAll();
    }

    public synchronized void writeLock() {
        if (this.writerThread != null && Thread.currentThread() == this.writerThread) {
            ++this.lockCount;
            return;
        }
        if (this.allowWrite()) {
            this.claimWriteLock();
            return;
        }
        ++this.waitingWriters;
        while (!this.allowWrite()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                --this.waitingWriters;
                Log.log(9, this, interruptedException);
                return;
            }
        }
        --this.waitingWriters;
        this.claimWriteLock();
    }

    public synchronized void writeUnlock() {
        if (this.activeWriters != 1 || this.lockCount <= 0) {
            throw new InternalError("Unbalanced writeLock()/writeUnlock() calls");
        }
        if (Thread.currentThread() != this.writerThread) {
            throw new InternalError("writeUnlock() from wrong thread");
        }
        if (--this.lockCount == 0) {
            --this.activeWriters;
            this.writerThread = null;
            this.notifyAll();
        }
    }

    public synchronized boolean isWriteLocked() {
        return this.activeWriters == 1;
    }

    private final boolean allowRead() {
        return Thread.currentThread() == this.writerThread || this.waitingWriters == 0 && this.activeWriters == 0;
    }

    private final boolean allowWrite() {
        return this.activeReaders == 0 && this.activeWriters == 0;
    }

    private void claimWriteLock() {
        ++this.activeWriters;
        this.writerThread = Thread.currentThread();
        this.lockCount = 1;
    }
}

