/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int BACKGROUND_LAYER = -60;
    public static final int LINE_BACKGROUND_LAYER = -50;
    public static final int BELOW_SELECTION_LAYER = -40;
    public static final int SELECTION_LAYER = -30;
    public static final int WRAP_GUIDE_LAYER = -20;
    public static final int BELOW_MOST_EXTENSIONS_LAYER = -10;
    public static final int DEFAULT_LAYER = 0;
    public static final int BLOCK_CARET_LAYER = 50;
    public static final int BRACKET_HIGHLIGHT_LAYER = 100;
    public static final int TEXT_LAYER = 200;
    public static final int CARET_LAYER = 300;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    JEditTextArea textArea;
    SyntaxStyle[] styles;
    Color caretColor;
    Color selectionColor;
    Color multipleSelectionColor;
    Color lineHighlightColor;
    Color structureHighlightColor;
    Color eolMarkerColor;
    Color wrapGuideColor;
    SyntaxStyle[] foldLineStyle;
    boolean blockCaret;
    boolean lineHighlight;
    boolean structureHighlight;
    boolean eolMarkers;
    boolean wrapGuide;
    boolean antiAlias;
    boolean fracFontMetrics;
    FontMetrics fm;
    private ExtensionManager extensionMgr;
    private PaintCaret caretExtension;
    private RenderingHints renderingHints;
    private FontRenderContext fontRenderContext;
    private HashMap fonts;

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n == this.getX() && n2 == this.getY() && n3 == this.getWidth() && n4 == this.getHeight()) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.textArea.recalculateVisibleLines();
        if (this.textArea.getBuffer().isLoaded()) {
            this.textArea.recalculateLastPhysicalLine();
        }
        this.textArea.propertiesChanged();
        this.textArea.updateMaxHorizontalScrollWidth();
        this.textArea.scrollBarsInitialized = true;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] syntaxStyleArray) {
        this.fonts.clear();
        this.styles = syntaxStyleArray;
        syntaxStyleArray[0] = new SyntaxStyle(this.getForeground(), null, this.getFont());
        for (int i = 0; i < syntaxStyleArray.length; ++i) {
            syntaxStyleArray[i].setCharWidth(this.getCharWidth(syntaxStyleArray[i].getFont()));
        }
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color color) {
        this.caretColor = color;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color color) {
        this.selectionColor = color;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateSelectedLines();
        }
    }

    public final Color getMultipleSelectionColor() {
        return this.multipleSelectionColor;
    }

    public final void setMultipleSelectionColor(Color color) {
        this.multipleSelectionColor = color;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateSelectedLines();
        }
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean bl) {
        this.lineHighlight = bl;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateSelectedLines();
        }
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color color) {
        this.structureHighlightColor = color;
        StructureMatcher.Match match = this.textArea.getStructureMatch();
        if (match != null) {
            this.textArea.invalidateLineRange(match.startLine, match.endLine);
        }
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean bl) {
        this.structureHighlight = bl;
        StructureMatcher.Match match = this.textArea.getStructureMatch();
        if (match != null) {
            this.textArea.invalidateLineRange(match.startLine, match.endLine);
        }
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean bl) {
        this.blockCaret = bl;
        this.extensionMgr.removeExtension(this.caretExtension);
        if (bl) {
            this.addExtension(50, this.caretExtension);
        } else {
            this.addExtension(300, this.caretExtension);
        }
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color color) {
        this.eolMarkerColor = color;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean bl) {
        this.eolMarkers = bl;
        this.repaint();
    }

    public final Color getWrapGuideColor() {
        return this.wrapGuideColor;
    }

    public final void setWrapGuideColor(Color color) {
        this.wrapGuideColor = color;
        this.repaint();
    }

    public final boolean isWrapGuidePainted() {
        return this.wrapGuide;
    }

    public final void setWrapGuidePainted(boolean bl) {
        this.wrapGuide = bl;
        this.repaint();
    }

    public final SyntaxStyle[] getFoldLineStyle() {
        return this.foldLineStyle;
    }

    public final void setFoldLineStyle(SyntaxStyle[] syntaxStyleArray) {
        this.foldLineStyle = syntaxStyleArray;
        this.repaint();
    }

    public void setAntiAliasEnabled(boolean bl) {
        this.antiAlias = bl;
        this.updateRenderingHints();
    }

    public boolean isAntiAliasEnabled() {
        return this.antiAlias;
    }

    public void setFractionalFontMetricsEnabled(boolean bl) {
        this.fracFontMetrics = bl;
        this.updateRenderingHints();
    }

    public boolean isFractionalFontMetricsEnabled() {
        return this.fracFontMetrics;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public void addExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(0, textAreaExtension);
        this.repaint();
    }

    public void addExtension(int n, TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(n, textAreaExtension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.removeExtension(textAreaExtension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.textArea.getBuffer().isLoaded()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(mouseEvent.getX(), mouseEvent.getY());
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
        if (this.textArea.getBuffer() != null && this.textArea.getBuffer().isLoaded()) {
            this.textArea.recalculateLastPhysicalLine();
        }
        this.textArea.propertiesChanged();
    }

    public float getStringWidth(String string) {
        if (this.textArea.charWidth != 0) {
            return this.textArea.charWidth * string.length();
        }
        return (float)this.getFont().getStringBounds(string, this.getFontRenderContext()).getWidth();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this.renderingHints);
        this.fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Buffer buffer = this.textArea.getBuffer();
        if (!buffer.isLoaded()) {
            return;
        }
        int n = this.fm.getHeight();
        if (n == 0) {
            return;
        }
        int n2 = rectangle.y / n;
        int n3 = (rectangle.y + rectangle.height - 1) / n;
        if (Debug.PAINT_TIMER && n3 - n2 >= 1) {
            Log.log(1, this, "repainting " + (n3 - n2) + " lines");
        }
        int n4 = rectangle.y - rectangle.y % n;
        this.extensionMgr.paintScreenLineRange(this.textArea, graphics2D, n2, n3, n4, n);
        this.textArea.updateMaxHorizontalScrollWidth();
        this.textArea.displayManager._notifyScreenLineChanges();
    }

    public float nextTabStop(float f, int n) {
        int n2 = (int)(f / this.textArea.tabSize);
        return (float)(n2 + 1) * this.textArea.tabSize;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        char[] cArray = new char[80];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        dimension.width = (int)this.getStringWidth(new String(cArray));
        dimension.height = this.fm.getHeight() * 25;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    TextAreaPainter(JEditTextArea jEditTextArea) {
        this.enableEvents(28L);
        this.textArea = jEditTextArea;
        this.fonts = new HashMap();
        this.extensionMgr = new ExtensionManager();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.fontRenderContext = new FontRenderContext(null, false, false);
        this.addExtension(-50, new PaintLineBackground());
        this.addExtension(-30, new PaintSelection());
        this.addExtension(-20, new PaintWrapGuide());
        this.addExtension(100, new StructureMatcher.Highlight(jEditTextArea));
        this.addExtension(200, new PaintText());
        this.caretExtension = new PaintCaret();
    }

    private void updateRenderingHints() {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        if (this.antiAlias) {
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.renderingHints = new RenderingHints(hashMap);
        this.fontRenderContext = new FontRenderContext(null, this.antiAlias, this.fracFontMetrics);
    }

    private int getCharWidth(Font font) {
        Integer n = (Integer)this.fonts.get(font);
        if (n == null) {
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int[] nArray = fontMetrics.getWidths();
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                if (n4 == 0 || !font.canDisplay((char)i)) continue;
                n2 = Math.min(n4, n2);
                n3 = Math.max(n4, n3);
            }
            String string = "iwiwiwiau1234";
            double d = font.createGlyphVector(this.textArea.getPainter().getFontRenderContext(), string).getLogicalBounds().getWidth();
            double d2 = string.length() * n3;
            if (n2 == n3 && (int)d == (int)d2) {
                Log.log(1, this, "Using monospaced font optimization: " + font);
                n = new Integer(n3);
            } else {
                Log.log(1, this, "Not using monospaced font optimization: " + font);
                Log.log(1, this, "Minimum width = " + n2 + ", maximum width = " + n3 + ", width 1 = " + d + ", width 2 = " + d2);
                n = new Integer(0);
            }
            this.fonts.put(font, n);
        }
        return n;
    }

    class PaintCaret
    extends TextAreaExtension {
        PaintCaret() {
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            if (!TextAreaPainter.this.textArea.isCaretVisible()) {
                return;
            }
            int n6 = TextAreaPainter.this.textArea.getCaretPosition();
            if (n6 < n3 || n6 >= n4) {
                return;
            }
            int n7 = n6 - TextAreaPainter.this.textArea.getLineStartOffset(n2);
            TextAreaPainter.this.textArea.offsetToXY(n2, n7, TextAreaPainter.this.textArea.returnValue);
            int n8 = TextAreaPainter.this.textArea.returnValue.x;
            int n9 = TextAreaPainter.this.fm.getHeight();
            graphics2D.setColor(TextAreaPainter.this.caretColor);
            if (TextAreaPainter.this.textArea.isOverwriteEnabled()) {
                graphics2D.drawLine(n8, n5 + n9 - 1, n8 + TextAreaPainter.this.textArea.charWidth, n5 + n9 - 1);
            } else if (TextAreaPainter.this.blockCaret) {
                graphics2D.drawRect(n8, n5, TextAreaPainter.this.textArea.charWidth - 1, n9 - 1);
            } else {
                graphics2D.drawLine(n8, n5, n8, n5 + n9 - 1);
            }
        }
    }

    class PaintText
    extends TextAreaExtension {
        PaintText() {
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            int n6;
            ChunkCache.LineInfo lineInfo = TextAreaPainter.this.textArea.chunkCache.getLineInfo(n);
            Font font = TextAreaPainter.this.getFont();
            Color color = TextAreaPainter.this.getForeground();
            graphics2D.setFont(font);
            graphics2D.setColor(color);
            int n7 = n6 = TextAreaPainter.this.textArea.getHorizontalOffset();
            float f = n5 + TextAreaPainter.this.fm.getHeight() - TextAreaPainter.this.fm.getLeading() - TextAreaPainter.this.fm.getDescent();
            if (lineInfo.chunks != null) {
                n6 = (int)((float)n6 + Chunk.paintChunkList(lineInfo.chunks, graphics2D, TextAreaPainter.this.textArea.getHorizontalOffset(), f, !Debug.DISABLE_GLYPH_VECTOR));
            }
            Buffer buffer = TextAreaPainter.this.textArea.getBuffer();
            if (!lineInfo.lastSubregion) {
                graphics2D.setFont(font);
                graphics2D.setColor(TextAreaPainter.this.eolMarkerColor);
                graphics2D.drawString(":", (float)Math.max(n6, TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.getDisplayManager().wrapMargin + TextAreaPainter.this.textArea.charWidth), f);
                n6 += TextAreaPainter.this.textArea.charWidth;
            } else if (n2 < buffer.getLineCount() - 1 && buffer.isFoldStart(n2) && !TextAreaPainter.this.textArea.displayManager.isLineVisible(n2 + 1)) {
                int n8 = buffer.getFoldLevel(n2 + 1);
                if (buffer.getFoldHandler() instanceof IndentFoldHandler) {
                    n8 = Math.max(1, n8 / buffer.getIndentSize());
                }
                if (n8 > 3) {
                    n8 = 0;
                }
                SyntaxStyle syntaxStyle = TextAreaPainter.this.foldLineStyle[n8];
                Font font2 = syntaxStyle.getFont();
                graphics2D.setFont(font2);
                graphics2D.setColor(syntaxStyle.getForegroundColor());
                int n9 = n + 1;
                int n10 = n9 < TextAreaPainter.this.textArea.getVisibleLines() ? TextAreaPainter.this.textArea.chunkCache.getLineInfo((int)n9).physicalLine : TextAreaPainter.this.textArea.displayManager.getNextVisibleLine(n2);
                if (n10 == -1) {
                    n10 = TextAreaPainter.this.textArea.getLineCount();
                }
                int n11 = n10 - n2 - 1;
                String string = " [" + n11 + " lines]";
                float f2 = TextAreaPainter.this.getStringWidth(string);
                graphics2D.drawString(string, (float)n6, f);
                n6 = (int)((float)n6 + f2);
            } else if (TextAreaPainter.this.eolMarkers) {
                graphics2D.setFont(font);
                graphics2D.setColor(TextAreaPainter.this.eolMarkerColor);
                graphics2D.drawString(".", (float)n6, f);
                n6 += TextAreaPainter.this.textArea.charWidth;
            }
            lineInfo.width = n6 - n7;
        }
    }

    class PaintWrapGuide
    extends TextAreaExtension {
        PaintWrapGuide() {
        }

        public void paintScreenLineRange(Graphics2D graphics2D, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4) {
            if (TextAreaPainter.this.textArea.getDisplayManager().wrapMargin != 0 && TextAreaPainter.this.isWrapGuidePainted()) {
                graphics2D.setColor(TextAreaPainter.this.getWrapGuideColor());
                int n5 = TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.getDisplayManager().wrapMargin;
                graphics2D.drawLine(n5, n3, n5, n3 + (n2 - n + 1) * n4);
            }
        }

        public String getToolTipText(int n, int n2) {
            int n3;
            if (TextAreaPainter.this.textArea.getDisplayManager().wrapMargin != 0 && TextAreaPainter.this.isWrapGuidePainted() && Math.abs(n - (n3 = TextAreaPainter.this.textArea.getDisplayManager().wrapMargin + TextAreaPainter.this.textArea.getHorizontalOffset())) < 5) {
                return String.valueOf(TextAreaPainter.this.textArea.getBuffer().getProperty("maxLineLen"));
            }
            return null;
        }
    }

    class PaintSelection
    extends TextAreaExtension {
        PaintSelection() {
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            if (TextAreaPainter.this.textArea.selection.size() == 0) {
                return;
            }
            graphics2D.setColor(TextAreaPainter.this.textArea.isMultipleSelectionEnabled() ? TextAreaPainter.this.getMultipleSelectionColor() : TextAreaPainter.this.getSelectionColor());
            for (int i = TextAreaPainter.this.textArea.selection.size() - 1; i >= 0; --i) {
                this.paintSelection(graphics2D, n, n2, n5, (Selection)TextAreaPainter.this.textArea.selection.get(i));
            }
        }

        private void paintSelection(Graphics2D graphics2D, int n, int n2, int n3, Selection selection) {
            int[] nArray = TextAreaPainter.this.textArea.getSelectionStartAndEnd(n, n2, selection);
            if (nArray == null) {
                return;
            }
            int n4 = nArray[0];
            int n5 = nArray[1];
            graphics2D.fillRect(n4, n3, n5 - n4, TextAreaPainter.this.fm.getHeight());
        }
    }

    class PaintLineBackground
    extends TextAreaExtension {
        PaintLineBackground() {
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            Color color;
            boolean bl;
            int n6;
            JEditTextArea jEditTextArea = TextAreaPainter.this.textArea;
            Buffer buffer = jEditTextArea.getBuffer();
            boolean bl2 = n2 < buffer.getLineCount() - 1 && buffer.isFoldStart(n2) && !jEditTextArea.displayManager.isLineVisible(n2 + 1);
            SyntaxStyle syntaxStyle = null;
            if (bl2) {
                n6 = buffer.getFoldLevel(n2 + 1);
                if (buffer.getFoldHandler() instanceof IndentFoldHandler) {
                    n6 = Math.max(1, n6 / buffer.getIndentSize());
                }
                if (n6 > 3) {
                    n6 = 0;
                }
                syntaxStyle = TextAreaPainter.this.foldLineStyle[n6];
            }
            n6 = jEditTextArea.getCaretPosition();
            boolean bl3 = bl = TextAreaPainter.this.isLineHighlightEnabled() && n6 >= n3 && n6 < n4 && jEditTextArea.selection.size() == 0;
            if (bl) {
                color = TextAreaPainter.this.lineHighlightColor;
            } else if (bl2) {
                color = syntaxStyle.getBackgroundColor();
                if (color == null) {
                    color = TextAreaPainter.this.getBackground();
                }
            } else {
                color = TextAreaPainter.this.getBackground();
            }
            if (bl || bl2) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, n5, TextAreaPainter.this.getWidth(), TextAreaPainter.this.fm.getHeight());
            }
            ChunkCache.LineInfo lineInfo = jEditTextArea.chunkCache.getLineInfo(n);
            if (lineInfo.chunks != null) {
                float f = n5 + TextAreaPainter.this.fm.getHeight() - TextAreaPainter.this.fm.getLeading() - TextAreaPainter.this.fm.getDescent();
                Chunk.paintChunkBackgrounds(lineInfo.chunks, graphics2D, jEditTextArea.getHorizontalOffset(), f);
            }
        }
    }
}

