/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;

public abstract class Selection
implements Cloneable {
    int start;
    int end;
    int startLine;
    int endLine;

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public abstract int getStart(Buffer var1, int var2);

    public abstract int getEnd(Buffer var1, int var2);

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean overlaps(Selection selection) {
        return this.start >= selection.start && this.start <= selection.end || this.end >= selection.start && this.end <= selection.end;
    }

    public String toString() {
        return this.getClass().getName() + "[start=" + this.start + ",end=" + this.end + ",startLine=" + this.startLine + ",endLine=" + this.endLine + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("I just drank a whole bottle of cough syrup and I feel funny!");
        }
    }

    Selection() {
    }

    Selection(Selection selection) {
        this.start = selection.start;
        this.end = selection.end;
    }

    Selection(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    abstract void getText(Buffer var1, StringBuffer var2);

    abstract int setText(Buffer var1, String var2);

    abstract boolean contentInserted(Buffer var1, int var2, int var3, int var4, int var5);

    abstract boolean contentRemoved(Buffer var1, int var2, int var3, int var4, int var5);

    public static class Rect
    extends Selection {
        int extraStartVirt;
        int extraEndVirt;

        public Rect() {
        }

        public Rect(Selection selection) {
            super(selection);
        }

        public Rect(int n, int n2) {
            super(n, n2);
        }

        public Rect(int n, int n2, int n3, int n4) {
            this.startLine = n;
            this.start = n2;
            this.endLine = n3;
            this.end = n4;
        }

        public Rect(Buffer buffer, int n, int n2, int n3, int n4) {
            this.startLine = n;
            this.endLine = n3;
            int[] nArray = new int[1];
            int n5 = buffer.getOffsetOfVirtualColumn(n, n2, nArray);
            if (n5 == -1) {
                this.extraStartVirt = n2 - nArray[0];
                n5 = buffer.getLineEndOffset(n) - 1;
            } else {
                n5 += buffer.getLineStartOffset(n);
            }
            int n6 = buffer.getOffsetOfVirtualColumn(n3, n4, nArray);
            if (n6 == -1) {
                this.extraEndVirt = n4 - nArray[0];
                n6 = buffer.getLineEndOffset(n3) - 1;
            } else {
                n6 += buffer.getLineStartOffset(n3);
            }
        }

        public int getStartColumn(Buffer buffer) {
            int n = buffer.getVirtualWidth(this.startLine, this.start - buffer.getLineStartOffset(this.startLine)) + this.extraStartVirt;
            int n2 = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine)) + this.extraEndVirt;
            return Math.min(n, n2);
        }

        public int getEndColumn(Buffer buffer) {
            int n = buffer.getVirtualWidth(this.startLine, this.start - buffer.getLineStartOffset(this.startLine)) + this.extraStartVirt;
            int n2 = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine)) + this.extraEndVirt;
            return Math.max(n, n2);
        }

        public int getStart(Buffer buffer, int n) {
            return this.getColumnOnOtherLine(buffer, n, this.getStartColumn(buffer));
        }

        public int getEnd(Buffer buffer, int n) {
            return this.getColumnOnOtherLine(buffer, n, this.getEndColumn(buffer));
        }

        void getText(Buffer buffer, StringBuffer stringBuffer) {
            int n = this.getStartColumn(buffer);
            int n2 = this.getEndColumn(buffer);
            for (int i = this.startLine; i <= this.endLine; ++i) {
                int n3;
                int n4 = buffer.getLineStartOffset(i);
                int n5 = buffer.getLineLength(i);
                int n6 = buffer.getOffsetOfVirtualColumn(i, n, null);
                if (n6 == -1) {
                    n6 = n5;
                }
                if ((n3 = buffer.getOffsetOfVirtualColumn(i, n2, null)) == -1) {
                    n3 = n5;
                }
                if (n3 < n6) {
                    System.err.println(i + ":::" + n + ":" + n2 + " ==> " + n6 + ":" + n3);
                }
                stringBuffer.append(buffer.getText(n4 + n6, n3 - n6));
                if (i == this.endLine) continue;
                stringBuffer.append('\n');
            }
        }

        int setText(Buffer buffer, String string) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.getStartColumn(buffer);
            int n6 = this.getEndColumn(buffer);
            int[] nArray = new int[1];
            int n7 = buffer.getTabSize();
            int n8 = 0;
            int n9 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (string != null) {
                n4 = 0;
                n3 = n5;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 10) {
                        ++n9;
                        arrayList.add(string.substring(n4, n2));
                        n4 = n2 + 1;
                        n8 = Math.max(n8, n3);
                        arrayList.add(new Integer(n3));
                        n3 = n5;
                        continue;
                    }
                    if (n == 9) {
                        n3 += n7 - n3 % n7;
                        continue;
                    }
                    ++n3;
                }
                if (n4 != string.length()) {
                    ++n9;
                    arrayList.add(string.substring(n4));
                    arrayList.add(new Integer(n3));
                    n8 = Math.max(n8, n3);
                }
            }
            n4 = 0;
            n3 = Math.max(this.startLine + n9 - 1, this.endLine);
            for (n2 = this.startLine; n2 <= n3; ++n2) {
                int n10;
                int n11;
                if (n2 == buffer.getLineCount()) {
                    buffer.insert(buffer.getLength(), "\n");
                }
                n = buffer.getLineStartOffset(n2);
                int n12 = buffer.getLineLength(n2);
                int n13 = buffer.getOffsetOfVirtualColumn(n2, n5, nArray);
                if (n13 == -1) {
                    n11 = n5 - nArray[0];
                    n13 = n12;
                } else {
                    n11 = 0;
                }
                int n14 = buffer.getOffsetOfVirtualColumn(n2, n6, null);
                if (n14 == -1) {
                    n14 = n12;
                }
                buffer.remove(n13 + n, n14 - n13);
                if (n11 != 0) {
                    buffer.insert(n13 + n, MiscUtilities.createWhiteSpace(n11, 0));
                }
                if (n9 == 0) {
                    n10 = n14 == n12 ? 0 : n8 - n5;
                } else {
                    int n15 = 2 * ((n2 - this.startLine) % n9);
                    String string2 = (String)arrayList.get(n15);
                    buffer.insert(n13 + n + n11, string2);
                    n10 = n14 == n12 ? 0 : n8 - (Integer)arrayList.get(n15 + 1);
                    n11 += string2.length();
                }
                if (n10 != 0) {
                    buffer.insert(n13 + n + n11, MiscUtilities.createWhiteSpace(n10, 0));
                }
                n4 = n13 + n + n11 + n10;
            }
            if (string == null || string.length() == 0) {
                return this.end;
            }
            return n4;
        }

        boolean contentInserted(Buffer buffer, int n, int n2, int n3, int n4) {
            int n5;
            if (this.end < n2) {
                return false;
            }
            this.end += n4;
            if (this.startLine > n) {
                this.start += n4;
                if (n3 != 0) {
                    this.startLine = buffer.getLineOfOffset(this.start);
                    this.endLine = buffer.getLineOfOffset(this.end);
                }
                return true;
            }
            int n6 = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine));
            if (this.start == n2) {
                int[] nArray;
                n5 = buffer.getVirtualWidth(this.startLine, n2 - buffer.getLineStartOffset(this.startLine));
                this.start += n4;
                int n7 = buffer.getVirtualWidth(n, n2 - buffer.getLineStartOffset(this.startLine));
                int n8 = buffer.getOffsetOfVirtualColumn(this.endLine, n6 + n7 - n5, nArray = new int[1]);
                if (n8 != -1) {
                    this.end = buffer.getLineStartOffset(this.endLine) + n8;
                } else {
                    this.end = buffer.getLineEndOffset(this.endLine) - 1;
                    this.extraEndVirt = nArray[0] - n6;
                }
            } else if (this.start > n2) {
                this.start += n4;
                if (n3 != 0) {
                    this.startLine = buffer.getLineOfOffset(this.start);
                }
            }
            if (n3 != 0) {
                this.endLine = buffer.getLineOfOffset(this.end);
            }
            n5 = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine));
            if (n == this.endLine && this.extraEndVirt != 0) {
                this.extraEndVirt += n6 - n5;
            } else if (n == this.startLine && this.extraStartVirt != 0) {
                this.extraStartVirt += n6 - n5;
            }
            return true;
        }

        boolean contentRemoved(Buffer buffer, int n, int n2, int n3, int n4) {
            int n5 = n2 + n4;
            boolean bl = false;
            if (this.start > n2 && this.start <= n5) {
                this.start = n2;
                bl = true;
            } else if (this.start > n5) {
                this.start -= n4;
                bl = true;
            }
            if (this.end > n2 && this.end <= n5) {
                this.end = n2;
                bl = true;
            } else if (this.end > n5) {
                this.end -= n4;
                bl = true;
            }
            if (bl && n3 != 0) {
                this.startLine = buffer.getLineOfOffset(this.start);
                this.endLine = buffer.getLineOfOffset(this.end);
            }
            return bl;
        }

        private int getColumnOnOtherLine(Buffer buffer, int n, int n2) {
            int n3 = buffer.getOffsetOfVirtualColumn(n, n2, null);
            if (n3 == -1) {
                return buffer.getLineEndOffset(n) - 1;
            }
            return buffer.getLineStartOffset(n) + n3;
        }
    }

    public static class Range
    extends Selection {
        public Range() {
        }

        public Range(Selection selection) {
            super(selection);
        }

        public Range(int n, int n2) {
            super(n, n2);
        }

        public int getStart(Buffer buffer, int n) {
            if (n == this.startLine) {
                return this.start;
            }
            return buffer.getLineStartOffset(n);
        }

        public int getEnd(Buffer buffer, int n) {
            if (n == this.endLine) {
                return this.end;
            }
            return buffer.getLineEndOffset(n) - 1;
        }

        void getText(Buffer buffer, StringBuffer stringBuffer) {
            stringBuffer.append(buffer.getText(this.start, this.end - this.start));
        }

        int setText(Buffer buffer, String string) {
            buffer.remove(this.start, this.end - this.start);
            if (string != null && string.length() != 0) {
                buffer.insert(this.start, string);
                return this.start + string.length();
            }
            return this.start;
        }

        boolean contentInserted(Buffer buffer, int n, int n2, int n3, int n4) {
            boolean bl = false;
            if (this.start >= n2) {
                this.start += n4;
                if (n3 != 0) {
                    this.startLine = buffer.getLineOfOffset(this.start);
                }
                bl = true;
            }
            if (this.end >= n2) {
                this.end += n4;
                if (n3 != 0) {
                    this.endLine = buffer.getLineOfOffset(this.end);
                }
                bl = true;
            }
            return bl;
        }

        boolean contentRemoved(Buffer buffer, int n, int n2, int n3, int n4) {
            int n5 = n2 + n4;
            boolean bl = false;
            if (this.start > n2 && this.start <= n5) {
                this.start = n2;
                bl = true;
            } else if (this.start > n5) {
                this.start -= n4;
                bl = true;
            }
            if (this.end > n2 && this.end <= n5) {
                this.end = n2;
                bl = true;
            } else if (this.end > n5) {
                this.end -= n4;
                bl = true;
            }
            if (bl && n3 != 0) {
                this.startLine = buffer.getLineOfOffset(this.start);
                this.endLine = buffer.getLineOfOffset(this.end);
            }
            return bl;
        }
    }
}

