/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.MouseActions;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class Gutter
extends JComponent
implements SwingConstants {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    private static final int FOLD_MARKER_SIZE = 12;
    private View view;
    private JEditTextArea textArea;
    private ExtensionManager extensionMgr;
    private int baseline;
    private Dimension gutterSize = new Dimension(0, 0);
    private Dimension collapsedSize = new Dimension(0, 0);
    private Color intervalHighlight;
    private Color currentLineHighlight;
    private Color foldColor;
    private FontMetrics fm;
    private int alignment;
    private int interval;
    private boolean currentLineHighlightEnabled;
    private boolean expanded;
    private boolean structureHighlight;
    private Color structureHighlightColor;
    private boolean markerHighlight;
    private Color markerHighlightColor;
    private int borderWidth;
    private Border focusBorder;
    private Border noFocusBorder;

    public Gutter(View view, JEditTextArea jEditTextArea) {
        this.view = view;
        this.textArea = jEditTextArea;
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.extensionMgr = new ExtensionManager();
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addExtension(new MarkerHighlight());
        this.updateBorder();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!this.textArea.getBuffer().isLoaded()) {
            return;
        }
        int n = this.textArea.getPainter().getFontMetrics().getHeight();
        if (n == 0) {
            return;
        }
        int n2 = (rectangle.y + rectangle.height - 1) / n;
        int n3 = rectangle.y / n;
        if (n2 - n3 > this.textArea.getVisibleLines()) {
            Log.log(9, this, "BUG: firstLine=" + n3);
            Log.log(9, this, "     lastLine=" + n2);
            Log.log(9, this, "     visibleLines=" + this.textArea.getVisibleLines());
            Log.log(9, this, "     height=" + this.getHeight());
            Log.log(9, this, "     painter.height=" + this.textArea.getPainter().getHeight());
            Log.log(9, this, "     clip.y=" + rectangle.y);
            Log.log(9, this, "     clip.height=" + rectangle.height);
            Log.log(9, this, "     lineHeight=" + n);
        }
        int n4 = rectangle.y - rectangle.y % n;
        this.extensionMgr.paintScreenLineRange(this.textArea, graphics2D, n3, n2, n4, n);
        int n5 = n3;
        while (n5 <= n2) {
            this.paintLine(graphics2D, n5, n4);
            ++n5;
            n4 += n;
        }
    }

    public void addExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(0, textAreaExtension);
        this.repaint();
    }

    public void addExtension(int n, TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(n, textAreaExtension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.removeExtension(textAreaExtension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.textArea.getBuffer().isLoaded()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(mouseEvent.getX(), mouseEvent.getY());
    }

    public void setBorder(int n, Color color, Color color2, Color color3) {
        this.borderWidth = n;
        this.focusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, n, color3), new MatteBorder(0, 0, 0, n, color));
        this.noFocusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, n, color3), new MatteBorder(0, 0, 0, n, color2));
        this.updateBorder();
    }

    public void updateBorder() {
        if (this.view.getEditPane() == null) {
            this.setBorder(this.noFocusBorder);
        } else if (this.view.getEditPane().getTextArea() == this.textArea) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        if (border == null) {
            this.collapsedSize.width = 0;
            this.collapsedSize.height = 0;
        } else {
            Insets insets = border.getBorderInsets(this);
            this.collapsedSize.width = 12 + insets.right;
            this.collapsedSize.height = this.gutterSize.height = insets.top + insets.bottom;
            this.gutterSize.width = 12 + insets.right + this.fm.stringWidth("12345");
        }
        this.revalidate();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.baseline = this.fm.getAscent();
        Border border = this.getBorder();
        if (border != null) {
            this.gutterSize.width = 12 + border.getBorderInsets((Component)this).right + this.fm.stringWidth("12345");
            this.revalidate();
        }
    }

    public Color getHighlightedForeground() {
        return this.intervalHighlight;
    }

    public void setHighlightedForeground(Color color) {
        this.intervalHighlight = color;
    }

    public Color getCurrentLineForeground() {
        return this.currentLineHighlight;
    }

    public void setCurrentLineForeground(Color color) {
        this.currentLineHighlight = color;
    }

    public Color getFoldColor() {
        return this.foldColor;
    }

    public void setFoldColor(Color color) {
        this.foldColor = color;
    }

    public Dimension getPreferredSize() {
        if (this.expanded) {
            return this.gutterSize;
        }
        return this.collapsedSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getLineNumberAlignment() {
        return this.alignment;
    }

    public void setLineNumberAlignment(int n) {
        if (this.alignment == n) {
            return;
        }
        this.alignment = n;
        this.repaint();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (this.expanded == bl) {
            return;
        }
        this.expanded = bl;
        this.textArea.revalidate();
    }

    public void toggleExpanded() {
        this.setExpanded(!this.expanded);
    }

    public int getHighlightInterval() {
        return this.interval;
    }

    public void setHighlightInterval(int n) {
        if (n <= 1) {
            n = 0;
        }
        this.interval = n;
        this.repaint();
    }

    public boolean isCurrentLineHighlightEnabled() {
        return this.currentLineHighlightEnabled;
    }

    public void setCurrentLineHighlightEnabled(boolean bl) {
        if (this.currentLineHighlightEnabled == bl) {
            return;
        }
        this.currentLineHighlightEnabled = bl;
        this.repaint();
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color color) {
        this.structureHighlightColor = color;
        this.repaint();
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean bl) {
        this.structureHighlight = bl;
        this.repaint();
    }

    public Color getMarkerHighlightColor() {
        return this.markerHighlightColor;
    }

    public void setMarkerHighlightColor(Color color) {
        this.markerHighlightColor = color;
    }

    public boolean isMarkerHighlightEnabled() {
        return this.markerHighlight;
    }

    public void setMarkerHighlightEnabled(boolean bl) {
        this.markerHighlight = bl;
    }

    private void paintLine(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4;
        Buffer buffer = this.textArea.getBuffer();
        if (!buffer.isLoaded()) {
            return;
        }
        int n5 = this.textArea.getPainter().getFontMetrics().getHeight();
        ChunkCache.LineInfo lineInfo = this.textArea.chunkCache.getLineInfo(n);
        int n6 = lineInfo.physicalLine;
        if (n6 == -1) {
            return;
        }
        if (lineInfo.firstSubregion && buffer.isFoldStart(n6)) {
            int n7 = n2 + n5 / 2;
            graphics2D.setColor(this.foldColor);
            if (this.textArea.displayManager.isLineVisible(n6 + 1)) {
                graphics2D.drawLine(1, n7 - 3, 10, n7 - 3);
                graphics2D.drawLine(2, n7 - 2, 9, n7 - 2);
                graphics2D.drawLine(3, n7 - 1, 8, n7 - 1);
                graphics2D.drawLine(4, n7, 7, n7);
                graphics2D.drawLine(5, n7 + 1, 6, n7 + 1);
            } else {
                graphics2D.drawLine(4, n7 - 5, 4, n7 + 4);
                graphics2D.drawLine(5, n7 - 4, 5, n7 + 3);
                graphics2D.drawLine(6, n7 - 3, 6, n7 + 2);
                graphics2D.drawLine(7, n7 - 2, 7, n7 + 1);
                graphics2D.drawLine(8, n7 - 1, 8, n7);
            }
        } else if (lineInfo.lastSubregion && buffer.isFoldEnd(n6)) {
            graphics2D.setColor(this.foldColor);
            int n8 = n2 + n5 / 2;
            graphics2D.drawLine(4, n8, 4, n8 + 3);
            graphics2D.drawLine(4, n8 + 3, 7, n8 + 3);
        } else if (this.structureHighlight) {
            StructureMatcher.Match match = this.textArea.getStructureMatch();
            n4 = this.textArea.getCaretLine();
            if (this.textArea.isStructureHighlightVisible() && n6 >= Math.min(n4, match.startLine) && n6 <= Math.max(n4, match.startLine)) {
                int n9;
                n3 = n4 > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(this.textArea.getCaretLine()) ? this.textArea.getScreenLineOfOffset(this.textArea.getCaretPosition()) : -1);
                if (n3 > (n9 = match.startLine > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(match.startLine) ? this.textArea.getScreenLineOfOffset(match.start) : -1))) {
                    int n10 = n3;
                    n3 = n9;
                    n9 = n10;
                }
                graphics2D.setColor(this.structureHighlightColor);
                if (n9 != n3) {
                    if (n == n3) {
                        graphics2D.fillRect(5, n2 + n5 / 2, 5, 2);
                        graphics2D.fillRect(5, n2 + n5 / 2, 2, n5 - n5 / 2);
                    } else if (n == n9) {
                        graphics2D.fillRect(5, n2, 2, n5 / 2);
                        graphics2D.fillRect(5, n2 + n5 / 2, 5, 2);
                    } else if (n > n3 && n < n9) {
                        graphics2D.fillRect(5, n2, 2, n5);
                    }
                }
            }
        }
        if (lineInfo.firstSubregion && this.expanded) {
            String string = Integer.toString(n6 + 1);
            switch (this.alignment) {
                case 4: {
                    n4 = this.gutterSize.width - this.collapsedSize.width - (this.fm.stringWidth(string) + 1);
                    break;
                }
                case 0: {
                    n4 = (this.gutterSize.width - this.collapsedSize.width - this.fm.stringWidth(string)) / 2;
                    break;
                }
                default: {
                    n4 = 0;
                }
            }
            int n11 = n3 = this.currentLineHighlightEnabled && this.textArea.selection.size() == 0 ? 1 : 0;
            if (n6 == this.textArea.getCaretLine() && n3 != 0) {
                graphics2D.setColor(this.currentLineHighlight);
            } else if (this.interval > 1 && (n + this.textArea.getFirstLine() + 1) % this.interval == 0) {
                graphics2D.setColor(this.intervalHighlight);
            } else {
                graphics2D.setColor(this.getForeground());
            }
            graphics2D.drawString(string, 12 + n4, this.baseline + n2);
        }
    }

    class MarkerHighlight
    extends TextAreaExtension {
        MarkerHighlight() {
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            Buffer buffer;
            if (Gutter.this.isMarkerHighlightEnabled() && (buffer = Gutter.this.textArea.getBuffer()).getMarkerInRange(n3, n4) != null) {
                graphics2D.setColor(Gutter.this.getMarkerHighlightColor());
                FontMetrics fontMetrics = Gutter.this.textArea.getPainter().getFontMetrics();
                graphics2D.fillRect(0, n5, Gutter.this.textArea.getGutter().getWidth(), fontMetrics.getHeight());
            }
        }

        public String getToolTipText(int n, int n2) {
            if (Gutter.this.isMarkerHighlightEnabled()) {
                int n3 = Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                if (n3 == 0) {
                    return null;
                }
                int n4 = n2 / n3;
                int n5 = Gutter.this.textArea.getScreenLineStartOffset(n4);
                int n6 = Gutter.this.textArea.getScreenLineEndOffset(n4);
                if (n5 == -1 || n6 == -1) {
                    return null;
                }
                Marker marker = Gutter.this.textArea.getBuffer().getMarkerInRange(n5, n6);
                if (marker != null) {
                    char c = marker.getShortcut();
                    if (c == '\u0000') {
                        return jEdit.getProperty("view.gutter.marker.no-name");
                    }
                    Object[] objectArray = new String[]{String.valueOf(c)};
                    return jEdit.getProperty("view.gutter.marker", objectArray);
                }
            }
            return null;
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseActions mouseActions = new MouseActions("gutter");
        boolean drag;
        int toolTipInitialDelay;
        int toolTipReshowDelay;

        MouseHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            this.toolTipInitialDelay = toolTipManager.getInitialDelay();
            this.toolTipReshowDelay = toolTipManager.getReshowDelay();
            toolTipManager.setInitialDelay(0);
            toolTipManager.setReshowDelay(0);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.setInitialDelay(this.toolTipInitialDelay);
            toolTipManager.setReshowDelay(this.toolTipReshowDelay);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Gutter.this.textArea.requestFocus();
            if (GUIUtilities.isPopupTrigger(mouseEvent) || mouseEvent.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2) {
                mouseEvent.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mousePressed(mouseEvent);
                this.drag = true;
            } else {
                String string;
                String string2;
                Buffer buffer = Gutter.this.textArea.getBuffer();
                int n = mouseEvent.getY() / Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                int n2 = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)n).physicalLine;
                if (n2 == -1) {
                    return;
                }
                if (buffer.isFoldStart(n2)) {
                    string2 = "toggle-fold";
                    string = "fold";
                } else if (Gutter.this.structureHighlight && Gutter.this.textArea.isStructureHighlightVisible() && Gutter.this.textArea.lineInStructureScope(n2)) {
                    string2 = "match-struct";
                    string = "struct";
                } else {
                    return;
                }
                String string3 = this.mouseActions.getActionForEvent(mouseEvent, string);
                if (string3 == null) {
                    string3 = string2;
                }
                StructureMatcher.Match match = Gutter.this.textArea.getStructureMatch();
                if (string3.equals("select-fold")) {
                    ((Gutter)Gutter.this).textArea.displayManager.expandFold(n2, true);
                    Gutter.this.textArea.selectFold(n2);
                } else if (string3.equals("narrow-fold")) {
                    int[] nArray = buffer.getFoldAtLine(n2);
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(nArray[0], nArray[1]);
                } else if (string3.startsWith("toggle-fold")) {
                    if (((Gutter)Gutter.this).textArea.displayManager.isLineVisible(n2 + 1)) {
                        ((Gutter)Gutter.this).textArea.displayManager.collapseFold(n2);
                    } else if (string3.endsWith("-fully")) {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(n2, true);
                    } else {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(n2, false);
                    }
                } else if (string3.equals("match-struct")) {
                    if (match != null) {
                        Gutter.this.textArea.setCaretPosition(match.end);
                    }
                } else if (string3.equals("select-struct")) {
                    if (match != null) {
                        match.matcher.selectMatch(Gutter.this.textArea);
                    }
                } else if (string3.equals("narrow-struct") && match != null) {
                    int n3 = Math.min(match.startLine, Gutter.this.textArea.getCaretLine());
                    int n4 = Math.max(match.endLine, Gutter.this.textArea.getCaretLine());
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(n3, n4);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.drag) {
                mouseEvent.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseDragged(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.drag && mouseEvent.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2) {
                mouseEvent.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseReleased(mouseEvent);
            }
            this.drag = false;
        }
    }
}

