/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.Vector;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;

public class KeywordMap {
    private int mapLength;
    private Keyword[] map;
    private boolean ignoreCase;
    private StringBuffer noWordSep;

    public KeywordMap(boolean bl) {
        this(bl, 52);
        this.ignoreCase = bl;
        this.noWordSep = new StringBuffer();
    }

    public KeywordMap(boolean bl, int n) {
        this.mapLength = n;
        this.ignoreCase = bl;
        this.map = new Keyword[n];
    }

    public byte lookup(Segment segment, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        Keyword keyword = this.map[this.getSegmentMapKey(segment, n, n2)];
        while (keyword != null) {
            if (n2 != keyword.keyword.length) {
                keyword = keyword.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, segment, n, keyword.keyword)) {
                return keyword.id;
            }
            keyword = keyword.next;
        }
        return 0;
    }

    public void add(String string, byte by) {
        this.add(string.toCharArray(), by);
    }

    public void add(char[] cArray, byte by) {
        int n = this.getStringMapKey(cArray);
        block0: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isLetterOrDigit(c)) continue;
            for (int j = 0; j < this.noWordSep.length(); ++j) {
                if (this.noWordSep.charAt(j) == c) continue block0;
            }
            this.noWordSep.append(c);
        }
        this.map[n] = new Keyword(cArray, by, this.map[n]);
    }

    public String getNonAlphaNumericChars() {
        return this.noWordSep.toString();
    }

    public String[] getKeywords() {
        Vector<String> vector = new Vector<String>(100);
        for (int i = 0; i < this.map.length; ++i) {
            Keyword keyword = this.map[i];
            while (keyword != null) {
                vector.addElement(new String(keyword.keyword));
                keyword = keyword.next;
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void add(KeywordMap keywordMap) {
        for (int i = 0; i < keywordMap.map.length; ++i) {
            Keyword keyword = keywordMap.map[i];
            while (keyword != null) {
                this.add(keyword.keyword, keyword.id);
                keyword = keyword.next;
            }
        }
    }

    private int getStringMapKey(char[] cArray) {
        return (Character.toUpperCase(cArray[0]) + Character.toUpperCase(cArray[cArray.length - 1])) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment segment, int n, int n2) {
        return (Character.toUpperCase(segment.array[n]) + Character.toUpperCase(segment.array[n + n2 - 1])) % this.mapLength;
    }

    class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        public Keyword(char[] cArray, byte by, Keyword keyword) {
            this.keyword = cArray;
            this.id = by;
            this.next = keyword;
        }
    }
}

