/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarEditDialog;

public class ToolBarOptionPane
extends AbstractOptionPane {
    private JCheckBox showToolbar;
    private DefaultListModel listModel;
    private JList list;
    private RolloverButton add;
    private RolloverButton remove;
    private RolloverButton moveUp;
    private RolloverButton moveDown;
    private RolloverButton edit;
    private DefaultComboBoxModel iconList;

    public ToolBarOptionPane() {
        super("toolbar");
    }

    protected void _init() {
        String string;
        Object object;
        Object object2;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.showToolbar = new JCheckBox(jEdit.getProperty("options.toolbar.showToolbar"));
        this.showToolbar.setSelected(jEdit.getBooleanProperty("view.showToolbar"));
        jPanel.add(this.showToolbar);
        jPanel.add(new JLabel(jEdit.getProperty("options.toolbar.caption")));
        this.add("North", jPanel);
        String string2 = jEdit.getProperty("view.toolbar");
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        this.listModel = new DefaultListModel();
        while (stringTokenizer.hasMoreTokens()) {
            Icon icon;
            String string3;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).equals("-")) {
                this.listModel.addElement(new Button("-", null, null, "-"));
                continue;
            }
            object = jEdit.getAction((String)object2);
            if (object == null || (string = ((EditAction)object).getLabel()) == null) continue;
            if (((String)object2).equals("-")) {
                string3 = null;
                icon = null;
            } else {
                string3 = jEdit.getProperty((String)object2 + ".icon");
                if (string3 == null) {
                    icon = GUIUtilities.loadIcon("BrokenImage.png");
                } else {
                    icon = GUIUtilities.loadIcon(string3);
                    if (icon == null) {
                        icon = GUIUtilities.loadIcon("BrokenImage.png");
                    }
                }
            }
            this.listModel.addElement(new Button((String)object2, string3, icon, string));
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        this.list.setCellRenderer(new ButtonCellRenderer());
        this.add("Center", new JScrollPane(this.list));
        object2 = new JPanel();
        ((JComponent)object2).setBorder(new EmptyBorder(3, 0, 0, 0));
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        object = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("options.toolbar.add"));
        this.add.addActionListener((ActionListener)object);
        ((Container)object2).add(this.add);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("options.toolbar.remove"));
        this.remove.addActionListener((ActionListener)object);
        ((Container)object2).add(this.remove);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("options.toolbar.moveUp"));
        this.moveUp.addActionListener((ActionListener)object);
        ((Container)object2).add(this.moveUp);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("options.toolbar.moveDown"));
        this.moveDown.addActionListener((ActionListener)object);
        ((Container)object2).add(this.moveDown);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.edit = new RolloverButton(GUIUtilities.loadIcon("ButtonProperties.png"));
        this.edit.setToolTipText(jEdit.getProperty("options.toolbar.edit"));
        this.edit.addActionListener((ActionListener)object);
        ((Container)object2).add(this.edit);
        ((Container)object2).add(Box.createGlue());
        this.updateButtons();
        this.add("South", (Component)object2);
        this.iconList = new DefaultComboBoxModel();
        stringTokenizer = new StringTokenizer(jEdit.getProperty("icons"));
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            this.iconList.addElement(new IconListEntry(GUIUtilities.loadIcon(string), string));
        }
    }

    protected void _save() {
        jEdit.setBooleanProperty("view.showToolbar", this.showToolbar.isSelected());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            Button button = (Button)this.listModel.elementAt(i);
            stringBuffer.append(button.actionName);
            jEdit.setProperty(button.actionName + ".icon", button.iconName);
        }
        jEdit.setProperty("view.toolbar", stringBuffer.toString());
    }

    private void updateButtons() {
        int n = this.list.getSelectedIndex();
        this.remove.setEnabled(n != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(n > 0);
        this.moveDown.setEnabled(n != -1 && n != this.listModel.getSize() - 1);
        this.edit.setEnabled(n != -1);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ToolBarOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ToolBarOptionPane.this.add) {
                ToolBarEditDialog toolBarEditDialog = new ToolBarEditDialog(ToolBarOptionPane.this, ToolBarOptionPane.this.iconList, null);
                Button button = toolBarEditDialog.getSelection();
                if (button == null) {
                    return;
                }
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                n = n == -1 ? ToolBarOptionPane.this.listModel.getSize() : ++n;
                ToolBarOptionPane.this.listModel.insertElementAt(button, n);
                ToolBarOptionPane.this.list.setSelectedIndex(n);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n);
            } else if (object == ToolBarOptionPane.this.remove) {
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                ToolBarOptionPane.this.listModel.removeElementAt(n);
                if (ToolBarOptionPane.this.listModel.getSize() != 0) {
                    if (ToolBarOptionPane.this.listModel.getSize() == n) {
                        ToolBarOptionPane.this.list.setSelectedIndex(n - 1);
                    } else {
                        ToolBarOptionPane.this.list.setSelectedIndex(n);
                    }
                }
                ToolBarOptionPane.this.updateButtons();
            } else if (object == ToolBarOptionPane.this.moveUp) {
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                Object e = ToolBarOptionPane.this.list.getSelectedValue();
                ToolBarOptionPane.this.listModel.removeElementAt(n);
                ToolBarOptionPane.this.listModel.insertElementAt(e, n - 1);
                ToolBarOptionPane.this.list.setSelectedIndex(n - 1);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n - 1);
            } else if (object == ToolBarOptionPane.this.moveDown) {
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                Object e = ToolBarOptionPane.this.list.getSelectedValue();
                ToolBarOptionPane.this.listModel.removeElementAt(n);
                ToolBarOptionPane.this.listModel.insertElementAt(e, n + 1);
                ToolBarOptionPane.this.list.setSelectedIndex(n + 1);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n + 1);
            } else if (object == ToolBarOptionPane.this.edit) {
                ToolBarEditDialog toolBarEditDialog = new ToolBarEditDialog(ToolBarOptionPane.this, ToolBarOptionPane.this.iconList, (Button)ToolBarOptionPane.this.list.getSelectedValue());
                Button button = toolBarEditDialog.getSelection();
                if (button == null) {
                    return;
                }
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                ToolBarOptionPane.this.listModel.setElementAt(button, n);
                ToolBarOptionPane.this.list.setSelectedIndex(n);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n);
            }
        }
    }

    static class IconCellRenderer
    extends DefaultListCellRenderer {
        IconCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            IconListEntry iconListEntry = (IconListEntry)object;
            this.setIcon(iconListEntry.icon);
            return this;
        }
    }

    static class ButtonCellRenderer
    extends DefaultListCellRenderer {
        ButtonCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Button button = (Button)object;
            this.setIcon(button.icon);
            return this;
        }
    }

    static class IconListEntry {
        Icon icon;
        String name;

        IconListEntry(Icon icon, String string) {
            this.icon = icon;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Button {
        String actionName;
        String iconName;
        Icon icon;
        String label;

        Button(String string, String string2, Icon icon, String string3) {
            this.actionName = string;
            this.iconName = string2;
            this.icon = icon;
            this.label = GUIUtilities.prettifyMenuLabel(string3);
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object object) {
            if (object instanceof Button) {
                return ((Button)object).actionName.equals(this.actionName);
            }
            return false;
        }
    }

    static class ButtonCompare
    implements MiscUtilities.Compare {
        ButtonCompare() {
        }

        public int compare(Object object, Object object2) {
            return MiscUtilities.compareStrings(((Button)object).label, ((Button)object2).label, true);
        }
    }
}

