/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.SyntaxHiliteOptionPane;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

class StyleTableModel
extends AbstractTableModel {
    private Vector styleChoices = new Vector(23);

    StyleTableModel() {
        for (int i = 1; i < 19; ++i) {
            String string = Token.tokenToString((byte)i);
            this.addStyleChoice(string, "view.style." + string.toLowerCase());
        }
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.1"), "view.style.foldLine.1");
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.2"), "view.style.foldLine.2");
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.3"), "view.style.foldLine.3");
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.0"), "view.style.foldLine.0");
        MiscUtilities.quicksort(this.styleChoices, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.styleChoices.size();
    }

    public Object getValueAt(int n, int n2) {
        StyleChoice styleChoice = (StyleChoice)this.styleChoices.elementAt(n);
        switch (n2) {
            case 0: {
                return styleChoice.label;
            }
            case 1: {
                return styleChoice.style;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        StyleChoice styleChoice = (StyleChoice)this.styleChoices.elementAt(n);
        if (n2 == 1) {
            styleChoice.style = (SyntaxStyle)object;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("options.syntax.object");
            }
            case 1: {
                return jEdit.getProperty("options.syntax.style");
            }
        }
        return null;
    }

    public void save() {
        for (int i = 0; i < this.styleChoices.size(); ++i) {
            StyleChoice styleChoice = (StyleChoice)this.styleChoices.elementAt(i);
            jEdit.setProperty(styleChoice.property, GUIUtilities.getStyleString(styleChoice.style));
        }
    }

    private void addStyleChoice(String string, String string2) {
        this.styleChoices.addElement(new StyleChoice(string, string2, GUIUtilities.parseStyle(jEdit.getProperty(string2), "Dialog", 12)));
    }

    static class StyleRenderer
    extends JLabel
    implements TableCellRenderer {
        public StyleRenderer() {
            this.setOpaque(true);
            this.setBorder(SyntaxHiliteOptionPane.noFocusBorder);
            this.setText("Hello World");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                SyntaxStyle syntaxStyle = (SyntaxStyle)object;
                this.setForeground(syntaxStyle.getForegroundColor());
                if (syntaxStyle.getBackgroundColor() != null) {
                    this.setBackground(syntaxStyle.getBackgroundColor());
                } else {
                    this.setBackground(jEdit.getColorProperty("view.bgColor"));
                }
                this.setFont(syntaxStyle.getFont());
            }
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : SyntaxHiliteOptionPane.noFocusBorder);
            return this;
        }
    }

    static class StyleChoice {
        String label;
        String property;
        SyntaxStyle style;

        StyleChoice(String string, String string2, SyntaxStyle syntaxStyle) {
            this.label = string;
            this.property = string2;
            this.style = syntaxStyle;
        }

        public String toString() {
            return this.label;
        }
    }
}

