/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.gui.EditAbbrevDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.AbbrevsModel;

public class AbbrevsOptionPane
extends AbstractOptionPane {
    private JComboBox setsComboBox;
    private JCheckBox expandOnInput;
    private JTable abbrevsTable;
    private AbbrevsModel globalAbbrevs;
    private Hashtable modeAbbrevs;
    private JButton add;
    private JButton edit;
    private JButton remove;

    public AbbrevsOptionPane() {
        super("abbrevs");
    }

    protected void _init() {
        Object object;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this.expandOnInput = new JCheckBox(jEdit.getProperty("options.abbrevs.expandOnInput"), Abbrevs.getExpandOnInput());
        jPanel.add((Component)this.expandOnInput, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add(Box.createGlue());
        JLabel jLabel = new JLabel(jEdit.getProperty("options.abbrevs.set"));
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jPanel2.add(jLabel);
        Hashtable hashtable = Abbrevs.getModeAbbrevs();
        this.modeAbbrevs = new Hashtable();
        Mode[] modeArray = jEdit.getModes();
        Arrays.sort(modeArray, new MiscUtilities.StringICaseCompare());
        String[] stringArray = new String[modeArray.length + 1];
        stringArray[0] = "global";
        for (int i = 0; i < modeArray.length; ++i) {
            object = modeArray[i].getName();
            stringArray[i + 1] = object;
            this.modeAbbrevs.put(object, new AbbrevsModel((Hashtable)hashtable.get(object)));
        }
        this.setsComboBox = new JComboBox<String>(stringArray);
        ActionHandler actionHandler = new ActionHandler();
        this.setsComboBox.addActionListener(actionHandler);
        jPanel2.add(this.setsComboBox);
        jPanel2.add(Box.createGlue());
        jPanel.add((Component)jPanel2, "South");
        this.add("North", jPanel);
        this.globalAbbrevs = new AbbrevsModel(Abbrevs.getGlobalAbbrevs());
        this.abbrevsTable = new JTable(this.globalAbbrevs);
        this.abbrevsTable.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        this.abbrevsTable.setAutoResizeMode(4);
        this.abbrevsTable.getTableHeader().setReorderingAllowed(false);
        this.abbrevsTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.abbrevsTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.abbrevsTable.getSelectionModel().setSelectionMode(0);
        this.abbrevsTable.addMouseListener(new TableMouseHandler());
        object = this.abbrevsTable.getPreferredSize();
        ((Dimension)object).height = Math.min(((Dimension)object).height, 200);
        JScrollPane jScrollPane = new JScrollPane(this.abbrevsTable);
        jScrollPane.setPreferredSize((Dimension)object);
        this.add("Center", jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("options.abbrevs.add"));
        this.add.addActionListener(actionHandler);
        jPanel3.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("options.abbrevs.remove"));
        this.remove.addActionListener(actionHandler);
        jPanel3.add(this.remove);
        this.edit = new RolloverButton(GUIUtilities.loadIcon("ButtonProperties.png"));
        this.edit.setToolTipText(jEdit.getProperty("options.abbrevs.edit"));
        this.edit.addActionListener(actionHandler);
        jPanel3.add(this.edit);
        jPanel3.add(Box.createGlue());
        this.add("South", jPanel3);
        this.updateEnabled();
    }

    protected void _save() {
        if (this.abbrevsTable.getCellEditor() != null) {
            this.abbrevsTable.getCellEditor().stopCellEditing();
        }
        Abbrevs.setExpandOnInput(this.expandOnInput.isSelected());
        Abbrevs.setGlobalAbbrevs(this.globalAbbrevs.toHashtable());
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.modeAbbrevs.keys();
        Enumeration enumeration2 = this.modeAbbrevs.elements();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), ((AbbrevsModel)enumeration2.nextElement()).toHashtable());
        }
        Abbrevs.setModeAbbrevs(hashtable);
    }

    private void updateEnabled() {
        int n = this.abbrevsTable.getSelectedRow();
        this.edit.setEnabled(n != -1);
        this.remove.setEnabled(n != -1);
    }

    private void edit() {
        AbbrevsModel abbrevsModel = (AbbrevsModel)this.abbrevsTable.getModel();
        int n = this.abbrevsTable.getSelectedRow();
        String string = (String)abbrevsModel.getValueAt(n, 0);
        String string2 = (String)abbrevsModel.getValueAt(n, 1);
        String string3 = string;
        EditAbbrevDialog editAbbrevDialog = new EditAbbrevDialog((Dialog)GUIUtilities.getParentDialog(this), string, string2, (Map)abbrevsModel.toHashtable());
        string = editAbbrevDialog.getAbbrev();
        string2 = editAbbrevDialog.getExpansion();
        if (string != null && string2 != null) {
            for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
                if (!abbrevsModel.getValueAt(i, 0).equals(string3)) continue;
                abbrevsModel.remove(i);
                break;
            }
            this.add(abbrevsModel, string, string2);
        }
    }

    private void add(AbbrevsModel abbrevsModel, String string, String string2) {
        for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
            if (!abbrevsModel.getValueAt(i, 0).equals(string)) continue;
            abbrevsModel.remove(i);
            break;
        }
        abbrevsModel.add(string, string2);
        this.updateEnabled();
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        Renderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object.toString();
            if (string.toLowerCase().startsWith("<html>")) {
                string = " " + string;
            }
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbbrevsModel abbrevsModel = (AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel();
            Object object = actionEvent.getSource();
            if (object == AbbrevsOptionPane.this.setsComboBox) {
                String string = (String)AbbrevsOptionPane.this.setsComboBox.getSelectedItem();
                if (string.equals("global")) {
                    AbbrevsOptionPane.this.abbrevsTable.setModel(AbbrevsOptionPane.this.globalAbbrevs);
                } else {
                    AbbrevsOptionPane.this.abbrevsTable.setModel((AbbrevsModel)AbbrevsOptionPane.this.modeAbbrevs.get(string));
                }
                AbbrevsOptionPane.this.updateEnabled();
            } else if (object == AbbrevsOptionPane.this.add) {
                EditAbbrevDialog editAbbrevDialog = new EditAbbrevDialog((Dialog)GUIUtilities.getParentDialog(AbbrevsOptionPane.this), null, null, (Map)abbrevsModel.toHashtable());
                String string = editAbbrevDialog.getAbbrev();
                String string2 = editAbbrevDialog.getExpansion();
                if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                    AbbrevsOptionPane.this.add(abbrevsModel, string, string2);
                }
            } else if (object == AbbrevsOptionPane.this.edit) {
                AbbrevsOptionPane.this.edit();
            } else if (object == AbbrevsOptionPane.this.remove) {
                int n = AbbrevsOptionPane.this.abbrevsTable.getSelectedRow();
                abbrevsModel.remove(n);
                AbbrevsOptionPane.this.updateEnabled();
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbbrevsOptionPane.this.updateEnabled();
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                AbbrevsOptionPane.this.edit();
            }
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (AbbrevsOptionPane.this.abbrevsTable.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 0: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(0);
                    break;
                }
                case 1: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(1);
                }
            }
        }
    }
}

