/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.util.Log;

public class EnhancedCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private ActionContext context;
    private String shortcut;
    private String action;

    public EnhancedCheckBoxMenuItem(String string, String string2, ActionContext actionContext) {
        this.context = actionContext;
        this.action = string2;
        this.shortcut = this.getShortcut();
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            this.setText(string + " (" + this.shortcut + ")");
            this.shortcut = null;
        } else {
            this.setText(string);
        }
        if (string2 != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(actionContext, string2));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
        this.setModel(new Model());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.shortcut != null) {
            dimension.width += this.getFontMetrics(EnhancedMenuItem.acceleratorFont).stringWidth(this.shortcut) + 15;
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.shortcut != null) {
            graphics.setFont(EnhancedMenuItem.acceleratorFont);
            graphics.setColor(this.getModel().isArmed() ? EnhancedMenuItem.acceleratorSelectionForeground : EnhancedMenuItem.acceleratorForeground);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Insets insets = this.getInsets();
            graphics.drawString(this.shortcut, this.getWidth() - (fontMetrics.stringWidth(this.shortcut) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (OperatingSystem.isMacOSLF() ? 0 : 1)));
        }
    }

    private String getShortcut() {
        if (this.action == null) {
            return null;
        }
        String string = jEdit.getProperty(this.action + ".shortcut");
        String string2 = jEdit.getProperty(this.action + ".shortcut2");
        if (string == null || string.length() == 0) {
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + " or " + string2;
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;

        MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            String string = jEdit.getProperty(EnhancedCheckBoxMenuItem.this.action + ".mouse-over");
            if (string != null) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(string);
                this.msgSet = true;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }
    }

    class Model
    extends DefaultButtonModel {
        Model() {
        }

        public boolean isSelected() {
            if (!EnhancedCheckBoxMenuItem.this.isShowing()) {
                return false;
            }
            EditAction editAction = EnhancedCheckBoxMenuItem.this.context.getAction(EnhancedCheckBoxMenuItem.this.action);
            if (editAction == null) {
                Log.log(7, this, "Unknown action: " + EnhancedCheckBoxMenuItem.this.action);
                return false;
            }
            try {
                return editAction.isSelected(EnhancedCheckBoxMenuItem.this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
                return false;
            }
        }

        public void setSelected(boolean bl) {
        }
    }
}

