/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class FileVFS
extends VFS {
    public static final String PERMISSIONS_PROPERTY = "FileVFS__perms";

    public FileVFS() {
        super("file", 0x7B | (OperatingSystem.isMacOS() || OperatingSystem.isDOSDerived() ? 128 : 0), new String[]{"type", "size", "status", "modified"});
    }

    public String getParentOfPath(String string) {
        if (OperatingSystem.isDOSDerived()) {
            if (string.length() == 2 && string.charAt(1) == ':') {
                return "roots:";
            }
            if (string.length() == 3 && string.endsWith(":\\")) {
                return "roots:";
            }
            if (string.startsWith("\\\\") && string.indexOf(92, 2) == -1) {
                return string;
            }
        }
        return super.getParentOfPath(string);
    }

    public String constructPath(String string, String string2) {
        if (string.endsWith(File.separator) || string.endsWith("/")) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public char getFileSeparator() {
        return File.separatorChar;
    }

    public boolean save(View view, Buffer buffer, String string) {
        if (OperatingSystem.isUnix()) {
            int n = FileVFS.getPermissions(buffer.getPath());
            Log.log(1, this, buffer.getPath() + " has permissions 0" + Integer.toString(n, 8));
            buffer.setIntegerProperty(PERMISSIONS_PROPERTY, n);
        }
        return super.save(view, buffer, string);
    }

    public boolean insert(View view, Buffer buffer, String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            VFSManager.error((Component)((Object)view), file.getPath(), "ioerror.open-directory", null);
            return false;
        }
        if (!file.canRead()) {
            VFSManager.error((Component)((Object)view), file.getPath(), "ioerror.no-read", null);
            return false;
        }
        return super.insert(view, buffer, string);
    }

    public String _canonPath(Object object, String string, Component component) throws IOException {
        return MiscUtilities.canonPath(string);
    }

    public VFS.DirectoryEntry[] _listDirectory(Object object, String string, Component component) {
        File file;
        File[] fileArray;
        if (OperatingSystem.isWindows() && string.length() == 2 && string.charAt(1) == ':') {
            string = string.concat(File.separator);
        }
        if ((fileArray = (file = new File(string)).listFiles()) == null) {
            VFSManager.error(component, string, "ioerror.directory-error-nomsg", null);
            return null;
        }
        VFS.DirectoryEntry[] directoryEntryArray = new VFS.DirectoryEntry[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            directoryEntryArray[i] = new LocalDirectoryEntry(fileArray[i]);
        }
        return directoryEntryArray;
    }

    public VFS.DirectoryEntry _getDirectoryEntry(Object object, String string, Component component) {
        if (string.equals("/") && OperatingSystem.isUnix()) {
            return new VFS.DirectoryEntry(string, string, string, 1, 0L, false);
        }
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        return new LocalDirectoryEntry(file);
    }

    public boolean _delete(Object object, String string, Component component) {
        String string2;
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        boolean bl = file.delete();
        if (bl) {
            VFSManager.sendVFSUpdate(this, string2, true);
        }
        return bl;
    }

    public boolean _rename(Object object, String string, String string2, Component component) {
        String string3;
        String string4;
        File file = new File(string2);
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string4 = string2;
        }
        File file2 = new File(file.getParent());
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                return false;
            }
        } else {
            file2.mkdirs();
            if (!file2.exists()) {
                return false;
            }
        }
        File file3 = new File(string);
        try {
            string3 = file3.getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = string;
        }
        if (!string3.equalsIgnoreCase(string4)) {
            file.delete();
        }
        boolean bl = file3.renameTo(file);
        VFSManager.sendVFSUpdate(this, string3, true);
        VFSManager.sendVFSUpdate(this, string4, true);
        return bl;
    }

    public boolean _mkdir(Object object, String string, Component component) {
        String string2;
        String string3 = this.getParentOfPath(string);
        if (!new File(string3).exists() && !this._mkdir(object, string3, component)) {
            return false;
        }
        File file = new File(string);
        boolean bl = file.mkdir();
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        VFSManager.sendVFSUpdate(this, string2, true);
        return bl;
    }

    public void _backup(Object object, String string, Component component) throws IOException {
        int n = jEdit.getIntegerProperty("backups", 1);
        if (n == 0) {
            return;
        }
        String string2 = jEdit.getProperty("backup.prefix");
        String string3 = jEdit.getProperty("backup.suffix");
        String string4 = jEdit.getProperty("backup.directory");
        int n2 = jEdit.getIntegerProperty("backup.minTime", 0);
        File file = new File(string);
        if (string4 == null || string4.length() == 0) {
            string4 = file.getParent();
        } else {
            string4 = MiscUtilities.constructPath(System.getProperty("user.home"), string4);
            File file2 = new File(string4 = MiscUtilities.concatPath(string4, file.getParent()));
            if (!file2.exists()) {
                file2.mkdirs();
            }
        }
        MiscUtilities.saveBackup(file, n, string2, string3, string4, n2);
    }

    public InputStream _createInputStream(Object object, String string, boolean bl, Component component) throws IOException {
        try {
            return new FileInputStream(string);
        }
        catch (IOException iOException) {
            if (bl) {
                return null;
            }
            throw iOException;
        }
    }

    public OutputStream _createOutputStream(Object object, String string, Component component) throws IOException {
        return new FileOutputStream(string);
    }

    public void _saveComplete(Object object, Buffer buffer, String string, Component component) {
        int n = buffer.getIntegerProperty(PERMISSIONS_PROPERTY, 0);
        FileVFS.setPermissions(string, n);
    }

    public static int getPermissions(String string) {
        int n = 0;
        if (jEdit.getBooleanProperty("chmodDisabled")) {
            return n;
        }
        if (OperatingSystem.isUnix()) {
            String[] stringArray = new String[]{"ls", "-ld", string};
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string2 = bufferedReader.readLine();
                if (string2 != null) {
                    String string3 = string2.substring(1, 10);
                    n = MiscUtilities.parsePermissions(string3);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return n;
    }

    public static void setPermissions(String string, int n) {
        if (jEdit.getBooleanProperty("chmodDisabled")) {
            return;
        }
        if (n != 0 && OperatingSystem.isUnix()) {
            String[] stringArray = new String[]{"chmod", Integer.toString(n, 8), string};
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class LocalDirectoryEntry
    extends VFS.DirectoryEntry {
        public static DateFormat DATE_FORMAT = DateFormat.getInstance();
        public long modified;

        public LocalDirectoryEntry(File file) {
            super(file.getName(), file.getPath(), file.getPath(), file.isDirectory() ? 1 : 0, file.length(), file.isHidden());
            this.modified = file.lastModified();
            this.canRead = file.canRead();
            this.canWrite = file.canWrite();
            this.symlinkPath = MiscUtilities.resolveSymlinks(this.path);
        }

        public String getExtendedAttribute(String string) {
            if (string.equals("modified")) {
                return DATE_FORMAT.format(new Date(this.modified));
            }
            return super.getExtendedAttribute(string);
        }
    }
}

