/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class StatusBar
extends JPanel
implements WorkThreadProgressListener {
    private View view;
    private JPanel panel;
    private Box box;
    private ToolTipLabel caretStatus;
    private Component messageComp;
    private JLabel message;
    private JLabel mode;
    private JLabel wrap;
    private JLabel multiSelect;
    private JLabel rectSelect;
    private JLabel overwrite;
    private JLabel lineSep;
    StringBuffer buf = new StringBuffer();
    private Timer tempTimer;
    private boolean currentMessageIsIO;
    private Segment seg = new Segment();
    private boolean showCaretStatus;
    private boolean showEditMode;
    private boolean showFoldMode;
    private boolean showEncoding;
    private boolean showWrap;
    private boolean showMultiSelect;
    private boolean showRectSelect;
    private boolean showOverwrite;
    private boolean showLineSeperator;
    static final String caretTestStr = "9999,999-999 99%";

    public StatusBar(View view) {
        super(new BorderLayout());
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.view = view;
        this.panel = new JPanel(new BorderLayout());
        this.box = new Box(0);
        this.panel.add("East", this.box);
        this.add("Center", this.panel);
        MouseHandler mouseHandler = new MouseHandler();
        this.caretStatus = new ToolTipLabel();
        this.caretStatus.setToolTipText(jEdit.getProperty("view.status.caret-tooltip"));
        this.caretStatus.addMouseListener(mouseHandler);
        this.message = new JLabel(" ");
        this.setMessageComponent(this.message);
        this.mode = new ToolTipLabel();
        this.mode.setToolTipText(jEdit.getProperty("view.status.mode-tooltip"));
        this.mode.addMouseListener(mouseHandler);
        this.wrap = new ToolTipLabel();
        this.wrap.setHorizontalAlignment(0);
        this.wrap.setToolTipText(jEdit.getProperty("view.status.wrap-tooltip"));
        this.wrap.addMouseListener(mouseHandler);
        this.multiSelect = new ToolTipLabel();
        this.multiSelect.setHorizontalAlignment(0);
        this.multiSelect.setToolTipText(jEdit.getProperty("view.status.multi-tooltip"));
        this.multiSelect.addMouseListener(mouseHandler);
        this.rectSelect = new ToolTipLabel();
        this.rectSelect.setHorizontalAlignment(0);
        this.rectSelect.setToolTipText(jEdit.getProperty("view.status.rect-tooltip"));
        this.rectSelect.addMouseListener(mouseHandler);
        this.overwrite = new ToolTipLabel();
        this.overwrite.setHorizontalAlignment(0);
        this.overwrite.setToolTipText(jEdit.getProperty("view.status.overwrite-tooltip"));
        this.overwrite.addMouseListener(mouseHandler);
        this.lineSep = new ToolTipLabel();
        this.lineSep.setHorizontalAlignment(0);
        this.lineSep.setToolTipText(jEdit.getProperty("view.status.linesep-tooltip"));
        this.lineSep.addMouseListener(mouseHandler);
    }

    public void propertiesChanged() {
        Color color = jEdit.getColorProperty("view.status.foreground");
        Color color2 = jEdit.getColorProperty("view.status.background");
        this.showCaretStatus = jEdit.getBooleanProperty("view.status.show-caret-status");
        this.showEditMode = jEdit.getBooleanProperty("view.status.show-edit-mode");
        this.showFoldMode = jEdit.getBooleanProperty("view.status.show-fold-mode");
        this.showEncoding = jEdit.getBooleanProperty("view.status.show-encoding");
        this.showWrap = jEdit.getBooleanProperty("view.status.show-wrap");
        this.showMultiSelect = jEdit.getBooleanProperty("view.status.show-multi-select");
        this.showRectSelect = jEdit.getBooleanProperty("view.status.show-rect-select");
        this.showOverwrite = jEdit.getBooleanProperty("view.status.show-overwrite");
        this.showLineSeperator = jEdit.getBooleanProperty("view.status.show-line-seperator");
        boolean bl = jEdit.getBooleanProperty("view.status.show-memory");
        boolean bl2 = jEdit.getBooleanProperty("view.status.show-clock");
        this.panel.setBackground(color2);
        this.panel.setForeground(color);
        this.caretStatus.setBackground(color2);
        this.caretStatus.setForeground(color);
        this.message.setBackground(color2);
        this.message.setForeground(color);
        this.mode.setBackground(color2);
        this.mode.setForeground(color);
        this.wrap.setBackground(color2);
        this.wrap.setForeground(color);
        this.multiSelect.setBackground(color2);
        this.multiSelect.setForeground(color);
        this.rectSelect.setBackground(color2);
        this.rectSelect.setForeground(color);
        this.overwrite.setBackground(color2);
        this.overwrite.setForeground(color);
        this.lineSep.setBackground(color2);
        this.lineSep.setForeground(color);
        Font font = new JLabel().getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = null;
        if (this.showCaretStatus) {
            this.panel.add("West", this.caretStatus);
            this.caretStatus.setFont(font);
            dimension = new Dimension(fontMetrics.stringWidth(caretTestStr), fontMetrics.getHeight());
            this.caretStatus.setPreferredSize(dimension);
        } else {
            this.panel.remove(this.caretStatus);
        }
        this.box.removeAll();
        if (this.showEncoding || this.showEditMode || this.showFoldMode) {
            this.box.add(this.mode);
        }
        if (this.showWrap) {
            dimension = new Dimension(Math.max(Math.max(fontMetrics.charWidth('-'), fontMetrics.charWidth('H')), fontMetrics.charWidth('S')) + 1, fontMetrics.getHeight());
            this.wrap.setPreferredSize(dimension);
            this.wrap.setMaximumSize(dimension);
            this.box.add(this.wrap);
        }
        if (this.showMultiSelect) {
            dimension = new Dimension(Math.max(fontMetrics.charWidth('-'), fontMetrics.charWidth('M')) + 1, fontMetrics.getHeight());
            this.multiSelect.setPreferredSize(dimension);
            this.multiSelect.setMaximumSize(dimension);
            this.box.add(this.multiSelect);
        }
        if (this.showRectSelect) {
            dimension = new Dimension(Math.max(fontMetrics.charWidth('-'), fontMetrics.charWidth('R')) + 1, fontMetrics.getHeight());
            this.rectSelect.setPreferredSize(dimension);
            this.rectSelect.setMaximumSize(dimension);
            this.box.add(this.rectSelect);
        }
        if (this.showOverwrite) {
            dimension = new Dimension(Math.max(fontMetrics.charWidth('-'), fontMetrics.charWidth('O')) + 1, fontMetrics.getHeight());
            this.overwrite.setPreferredSize(dimension);
            this.overwrite.setMaximumSize(dimension);
            this.box.add(this.overwrite);
        }
        if (this.showLineSeperator) {
            dimension = new Dimension(Math.max(Math.max(fontMetrics.charWidth('U'), fontMetrics.charWidth('W')), fontMetrics.charWidth('M')) + 1, fontMetrics.getHeight());
            this.lineSep.setPreferredSize(dimension);
            this.lineSep.setMaximumSize(dimension);
            this.box.add(this.lineSep);
        }
        if (bl) {
            this.box.add(new MemoryStatus());
        }
        if (bl2) {
            this.box.add(new Clock());
        }
        this.updateBufferStatus();
        this.updateMiscStatus();
    }

    public void addNotify() {
        super.addNotify();
        VFSManager.getIOThreadPool().addProgressListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        VFSManager.getIOThreadPool().removeProgressListener(this);
    }

    public void statusUpdate(final WorkThreadPool workThreadPool, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (StatusBar.this.message != null && !"".equals(StatusBar.this.message.getText().trim()) && !StatusBar.this.currentMessageIsIO) {
                    return;
                }
                int n = workThreadPool.getRequestCount();
                if (n == 0) {
                    StatusBar.this.setMessageAndClear(jEdit.getProperty("view.status.io.done"));
                    StatusBar.this.currentMessageIsIO = true;
                } else if (n == 1) {
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io-1"));
                    StatusBar.this.currentMessageIsIO = true;
                } else {
                    Object[] objectArray = new Object[]{new Integer(n)};
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io", objectArray));
                    StatusBar.this.currentMessageIsIO = true;
                }
            }
        });
    }

    public void progressUpdate(WorkThreadPool workThreadPool, int n) {
    }

    public void setMessageAndClear(String string) {
        this.setMessage(string);
        this.tempTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StatusBar.this.isShowing()) {
                    StatusBar.this.setMessage(null);
                }
            }
        });
        this.tempTimer.setInitialDelay(10000);
        this.tempTimer.setRepeats(false);
        this.tempTimer.start();
    }

    public void setMessage(String string) {
        if (this.tempTimer != null) {
            this.tempTimer.stop();
            this.tempTimer = null;
        }
        this.setMessageComponent(this.message);
        if (string == null) {
            if (this.view.getMacroRecorder() != null) {
                this.message.setText(jEdit.getProperty("view.status.recording"));
            } else {
                this.message.setText(" ");
            }
        } else {
            this.message.setText(string);
        }
    }

    public void setMessageComponent(Component component) {
        this.currentMessageIsIO = false;
        if (component == null || this.messageComp == component) {
            return;
        }
        this.messageComp = component;
        this.panel.add("Center", this.messageComp);
    }

    public void updateCaretStatus() {
        if (this.showCaretStatus) {
            Buffer buffer = this.view.getBuffer();
            if (!buffer.isLoaded() || buffer != this.view.getTextArea().getBuffer()) {
                this.caretStatus.setText(" ");
                return;
            }
            JEditTextArea jEditTextArea = this.view.getTextArea();
            int n = jEditTextArea.getCaretLine();
            if (n >= buffer.getLineCount()) {
                return;
            }
            int n2 = jEditTextArea.getLineStartOffset(n);
            int n3 = jEditTextArea.getCaretPosition() - n2;
            if (n3 < 0) {
                return;
            }
            buffer.getText(n2, n3, this.seg);
            int n4 = MiscUtilities.getVirtualWidth(this.seg, buffer.getTabSize());
            this.buf.setLength(0);
            this.buf.append(Integer.toString(n + 1));
            this.buf.append(',');
            this.buf.append(Integer.toString(n3 + 1));
            if (n4 != n3) {
                this.buf.append('-');
                this.buf.append(Integer.toString(n4 + 1));
            }
            this.buf.append(' ');
            int n5 = jEditTextArea.getFirstLine();
            int n6 = jEditTextArea.getVisibleLines();
            int n7 = jEditTextArea.getDisplayManager().getScrollLineCount();
            if (n6 >= n7) {
                this.buf.append("All");
            } else if (n5 == 0) {
                this.buf.append("Top");
            } else if (n5 + n6 >= n7) {
                this.buf.append("Bot");
            } else {
                float f = (float)n5 / (float)n7 * 100.0f;
                this.buf.append(Integer.toString((int)f));
                this.buf.append('%');
            }
            this.caretStatus.setText(this.buf.toString());
        }
    }

    public void updateBufferStatus() {
        String string;
        Buffer buffer = this.view.getBuffer();
        if (this.showWrap) {
            string = buffer.getStringProperty("wrap");
            if (string.equals("none")) {
                this.wrap.setText("-");
            } else if (string.equals("hard")) {
                this.wrap.setText("H");
            } else if (string.equals("soft")) {
                this.wrap.setText("S");
            }
        }
        if (this.showLineSeperator) {
            string = buffer.getStringProperty("lineSeparator");
            if ("\n".equals(string)) {
                this.lineSep.setText("U");
            } else if ("\r\n".equals(string)) {
                this.lineSep.setText("W");
            } else if ("\r".equals(string)) {
                this.lineSep.setText("M");
            }
        }
        if (this.showEditMode || this.showFoldMode || this.showEncoding) {
            this.buf.setLength(0);
            if (buffer.isLoaded()) {
                if (this.showEditMode) {
                    this.buf.append(buffer.getMode().getName());
                }
                if (this.showFoldMode) {
                    if (this.showEditMode) {
                        this.buf.append(",");
                    }
                    this.buf.append((String)this.view.getBuffer().getProperty("folding"));
                }
                if (this.showEncoding) {
                    if (this.showEditMode || this.showFoldMode) {
                        this.buf.append(",");
                    }
                    this.buf.append(buffer.getStringProperty("encoding"));
                }
            }
            this.mode.setText("(" + this.buf.toString() + ")");
        }
    }

    public void updateMiscStatus() {
        JEditTextArea jEditTextArea = this.view.getTextArea();
        if (this.showMultiSelect) {
            this.multiSelect.setText(jEditTextArea.isMultipleSelectionEnabled() ? "M" : "-");
        }
        if (this.showRectSelect) {
            this.rectSelect.setText(jEditTextArea.isRectangularSelectionEnabled() ? "R" : "-");
        }
        if (this.showOverwrite) {
            this.overwrite.setText(jEditTextArea.isOverwriteEnabled() ? "O" : "-");
        }
    }

    class Clock
    extends JLabel
    implements ActionListener {
        private Timer timer;

        public Clock() {
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
        }

        public void addNotify() {
            super.addNotify();
            this.update();
            int n = 60000;
            this.timer = new Timer(n, this);
            this.timer.setInitialDelay((int)((long)n - System.currentTimeMillis() % (long)n) + 500);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public String getToolTipText() {
            return new Date().toString();
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private String getTime() {
            return DateFormat.getTimeInstance(3).format(new Date());
        }

        private void update() {
            this.setText(this.getTime());
        }
    }

    class MemoryStatus
    extends JComponent
    implements ActionListener {
        private static final String memoryTestStr = "9999/9999Mb";
        private LineMetrics lm;
        private Color progressForeground;
        private Color progressBackground;
        private Timer timer;

        public MemoryStatus() {
            Font font = new JLabel().getFont();
            this.setFont(font);
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            Rectangle2D rectangle2D = font.getStringBounds(memoryTestStr, fontRenderContext);
            Dimension dimension = new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.lm = font.getLineMetrics(memoryTestStr, fontRenderContext);
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.progressForeground = jEdit.getColorProperty("view.status.memory.foreground");
            this.progressBackground = jEdit.getColorProperty("view.status.memory.background");
            this.addMouseListener(new MouseHandler());
        }

        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public String getToolTipText() {
            Runtime runtime = Runtime.getRuntime();
            int n = (int)(runtime.freeMemory() / 1024L);
            int n2 = (int)(runtime.totalMemory() / 1024L);
            int n3 = n2 - n;
            Object[] objectArray = new Integer[]{new Integer(n3), new Integer(n2)};
            return jEdit.getProperty("view.status.memory-tooltip", objectArray);
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Insets insets = new Insets(0, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int n = (int)(runtime.freeMemory() / 1024L);
            int n2 = (int)(runtime.totalMemory() / 1024L);
            int n3 = n2 - n;
            int n4 = this.getWidth() - insets.left - insets.right;
            int n5 = this.getHeight() - insets.top - insets.bottom - 1;
            float f = (float)n3 / (float)n2;
            graphics.setColor(this.progressBackground);
            graphics.fillRect(insets.left, insets.top, (int)((float)n4 * f), n5);
            String string = n3 / 1024 + "/" + n2 / 1024 + "Mb";
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string, fontRenderContext);
            Graphics graphics2 = graphics.create();
            graphics2.setClip(insets.left, insets.top, (int)((float)n4 * f), n5);
            graphics2.setColor(this.progressForeground);
            graphics2.drawString(string, insets.left + (int)((double)n4 - rectangle2D.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(insets.left + (int)((float)n4 * f), insets.top, this.getWidth() - insets.left - (int)((float)n4 * f), n5);
            graphics2.setColor(this.getForeground());
            graphics2.drawString(string, insets.left + (int)((double)n4 - rectangle2D.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            graphics2.dispose();
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    jEdit.showMemoryDialog(StatusBar.this.view);
                    MemoryStatus.this.repaint();
                }
            }
        }
    }

    class ToolTipLabel
    extends JLabel {
        ToolTipLabel() {
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Buffer buffer = StatusBar.this.view.getBuffer();
            Object object = mouseEvent.getSource();
            if (object == StatusBar.this.caretStatus) {
                if (mouseEvent.getClickCount() == 2) {
                    StatusBar.this.view.getTextArea().showGoToLineDialog();
                }
            } else if (object == StatusBar.this.mode) {
                if (mouseEvent.getClickCount() == 2) {
                    new BufferOptions(StatusBar.this.view, StatusBar.this.view.getBuffer());
                }
            } else if (object == StatusBar.this.wrap) {
                buffer.toggleWordWrap(StatusBar.this.view);
            } else if (object == StatusBar.this.multiSelect) {
                StatusBar.this.view.getTextArea().toggleMultipleSelectionEnabled();
            } else if (object == StatusBar.this.rectSelect) {
                StatusBar.this.view.getTextArea().toggleRectangularSelectionEnabled();
            } else if (object == StatusBar.this.overwrite) {
                StatusBar.this.view.getTextArea().toggleOverwriteEnabled();
            } else if (object == StatusBar.this.lineSep) {
                buffer.toggleLineSeparator(StatusBar.this.view);
            }
        }
    }
}

