/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class LogViewer
extends JPanel
implements DefaultFocusComponent,
EBComponent {
    private JList list;
    private JButton copy;
    private JCheckBox tail;
    private boolean tailIsOn;

    public LogViewer() {
        super(new BorderLayout());
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            object = new String[]{MiscUtilities.constructPath(string, "activity.log")};
            jComponent = new JLabel(jEdit.getProperty("log-viewer.caption", (Object[])object));
            jPanel.add(jComponent);
        }
        jPanel.add(Box.createHorizontalGlue());
        this.tailIsOn = jEdit.getBooleanProperty("log-viewer.tail", false);
        this.tail = new JCheckBox(jEdit.getProperty("log-viewer.tail.label"), this.tailIsOn);
        this.tail.addActionListener(new ActionHandler());
        jPanel.add(this.tail);
        jPanel.add(Box.createHorizontalStrut(12));
        this.copy = new JButton(jEdit.getProperty("log-viewer.copy"));
        this.copy.addActionListener(new ActionHandler());
        jPanel.add(this.copy);
        object = Log.getLogListModel();
        object.addListDataListener(new ListHandler());
        this.list = new LogList((ListModel)object);
        this.add("North", jPanel);
        jComponent = new JScrollPane(this.list);
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = Math.min(600, dimension.width);
        jComponent.setPreferredSize(dimension);
        this.add("Center", jComponent);
        this.propertiesChanged();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.tailIsOn) {
            int n = this.list.getModel().getSize() - 1;
            this.list.ensureIndexIsVisible(n);
        }
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    public void focusOnDefaultComponent() {
        this.list.requestFocus();
    }

    private void propertiesChanged() {
        this.list.setFont(jEdit.getFontProperty("view.font"));
        this.list.setFixedCellHeight(this.list.getFontMetrics(this.list.getFont()).getHeight());
    }

    class LogList
    extends JList {
        private int startIndex;

        LogList(ListModel listModel) {
            super(listModel);
            this.setVisibleRowCount(24);
            this.getSelectionModel().setSelectionMode(1);
            this.setAutoscrolls(true);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.startIndex = LogViewer.this.list.locationToIndex(mouseEvent.getPoint());
            }
            super.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                int n = LogViewer.this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    if (this.startIndex == -1) {
                        LogViewer.this.list.setSelectionInterval(n, n);
                        this.startIndex = n;
                    } else {
                        LogViewer.this.list.setSelectionInterval(this.startIndex, n);
                    }
                    LogViewer.this.list.ensureIndexIsVisible(n);
                    mouseEvent.consume();
                }
            } else {
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }

    class ListHandler
    implements ListDataListener {
        ListHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (LogViewer.this.tailIsOn) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = LogViewer.this.list.getModel().getSize() - 1;
                        LogViewer.this.list.ensureIndexIsVisible(n);
                    }
                });
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LogViewer.this.tail) {
                int n;
                LogViewer.this.tailIsOn = !LogViewer.this.tailIsOn;
                jEdit.setBooleanProperty("log-viewer.tail", LogViewer.this.tailIsOn);
                if (LogViewer.this.tailIsOn && (n = LogViewer.this.list.getModel().getSize()) != 0) {
                    LogViewer.this.list.ensureIndexIsVisible(n - 1);
                }
            } else if (object == LogViewer.this.copy) {
                StringBuffer stringBuffer = new StringBuffer();
                Object[] objectArray = LogViewer.this.list.getSelectedValues();
                if (objectArray != null && objectArray.length != 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(objectArray[i]);
                        stringBuffer.append('\n');
                    }
                } else {
                    ListModel listModel = LogViewer.this.list.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        stringBuffer.append(listModel.getElementAt(i));
                        stringBuffer.append('\n');
                    }
                }
                Registers.setRegister('$', stringBuffer.toString());
            }
        }
    }
}

