/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;

public class VFSDirectoryEntryTable
extends JTable {
    private BrowserView browserView;
    private FileCellRenderer renderer;
    private StringBuffer typeSelectBuffer = new StringBuffer();
    private Timer timer = new Timer(0, new ClearTypeSelect());

    public VFSDirectoryEntryTable(BrowserView browserView) {
        super(new VFSDirectoryEntryTableModel());
        this.browserView = browserView;
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.renderer = new FileCellRenderer();
        this.setDefaultRenderer(VFSDirectoryEntryTableModel.Entry.class, this.renderer);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(0);
    }

    public boolean selectFile(String string) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)this.getValueAt(i, 1);
            if (!entry.dirEntry.path.equals(string)) continue;
            this.setSelectedRow(i);
            return true;
        }
        return false;
    }

    public void doTypeSelect(String string, boolean bl) {
        if (string.length() == 0) {
            this.clearSelection();
        } else if (this.getSelectedRow() == -1) {
            this.doTypeSelect(string, 0, this.getRowCount(), bl);
        } else {
            int n = this.getSelectionModel().getMaxSelectionIndex();
            boolean bl2 = this.doTypeSelect(string, n, this.getRowCount(), bl);
            if (!bl2) {
                this.doTypeSelect(string, 0, n, bl);
            }
        }
    }

    public VFS.DirectoryEntry[] getSelectedFiles() {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        LinkedList<VFS.DirectoryEntry> linkedList = new LinkedList<VFS.DirectoryEntry>();
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            linkedList.add(vFSDirectoryEntryTableModel.files[nArray[i]].dirEntry);
        }
        return linkedList.toArray(new VFS.DirectoryEntry[linkedList.size()]);
    }

    public void getExpandedDirectories(Set set) {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        if (vFSDirectoryEntryTableModel.files != null) {
            for (int i = 0; i < vFSDirectoryEntryTableModel.files.length; ++i) {
                if (!vFSDirectoryEntryTableModel.files[i].expanded) continue;
                set.add(vFSDirectoryEntryTableModel.files[i].dirEntry.path);
            }
        }
    }

    public void toggleExpanded(final int n) {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[n];
        if (entry.dirEntry.type == 0) {
            return;
        }
        if (entry.expanded) {
            vFSDirectoryEntryTableModel.collapse(VFSManager.getVFSForPath(entry.dirEntry.path), n);
            this.resizeColumnsAppropriately();
        } else {
            this.browserView.clearExpansionState();
            this.browserView.loadDirectory(entry, entry.dirEntry.path);
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSDirectoryEntryTable.this.setSelectedRow(n);
            }
        });
    }

    public void setDirectory(VFS vFS, Object object, ArrayList arrayList, Set set) {
        int n;
        this.timer.stop();
        this.typeSelectBuffer.setLength(0);
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        if (object == null) {
            n = 0;
            vFSDirectoryEntryTableModel.setRoot(vFS, arrayList);
        } else {
            n = vFSDirectoryEntryTableModel.expand(vFS, (VFSDirectoryEntryTableModel.Entry)object, arrayList);
            ++n;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[n + i];
            String string = entry.dirEntry.path;
            if (!set.contains(string)) continue;
            this.browserView.loadDirectory(entry, string);
            set.remove(string);
        }
        this.resizeColumnsAppropriately();
    }

    public void maybeReloadDirectory(String string) {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        for (int i = 0; i < vFSDirectoryEntryTableModel.files.length; ++i) {
            VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[i];
            if (!entry.expanded || entry.dirEntry.type == 0) continue;
            VFS.DirectoryEntry directoryEntry = entry.dirEntry;
            String string2 = directoryEntry.symlinkPath == null ? directoryEntry.path : directoryEntry.symlinkPath;
            if (!VFSBrowser.pathsEqual(string, string2)) continue;
            this.browserView.saveExpansionState();
            this.browserView.loadDirectory(entry, string);
            return;
        }
    }

    public void propertiesChanged() {
        this.renderer.propertiesChanged();
        VFS.DirectoryEntry directoryEntry = new VFS.DirectoryEntry("foo", "foo", "foo", 0, 0L, false);
        this.setRowHeight(this.renderer.getTableCellRendererComponent((JTable)this, (Object)new VFSDirectoryEntryTableModel.Entry((VFS.DirectoryEntry)directoryEntry, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
        Dimension dimension = this.getPreferredSize();
        this.setPreferredScrollableViewportSize(new Dimension(dimension.width, this.getRowHeight() * 12));
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        rectangle.width = 0;
        super.scrollRectToVisible(rectangle);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
            int n = this.getSelectedRow();
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    keyEvent.consume();
                    if (n != -1) {
                        if (vFSDirectoryEntryTableModel.files[n].expanded) {
                            vFSDirectoryEntryTableModel.collapse(VFSManager.getVFSForPath(vFSDirectoryEntryTableModel.files[n].dirEntry.path), n);
                            break;
                        }
                        for (int i = n - 1; i >= 0; --i) {
                            if (!vFSDirectoryEntryTableModel.files[i].expanded) continue;
                            this.setSelectedRow(i);
                            break;
                        }
                    }
                    String string = this.browserView.getBrowser().getDirectory();
                    string = MiscUtilities.getParentOfPath(string);
                    this.browserView.getBrowser().setDirectory(string);
                    break;
                }
                case 39: {
                    if (n != -1 && !vFSDirectoryEntryTableModel.files[n].expanded) {
                        this.toggleExpanded(n);
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (n != -1 || this.getModel().getRowCount() == 0) break;
                    this.setSelectedRow(0);
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    this.browserView.getBrowser().filesActivated(keyEvent.isShiftDown() ? 1 : 0, false);
                    keyEvent.consume();
                }
            }
        } else if (keyEvent.getID() == 400) {
            if (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown()) {
                return;
            }
            if (keyEvent.isShiftDown() && keyEvent.getKeyChar() == '\n') {
                return;
            }
            VFSBrowser vFSBrowser = this.browserView.getBrowser();
            switch (keyEvent.getKeyChar()) {
                case '~': {
                    if (vFSBrowser.getMode() != 2) break;
                    vFSBrowser.setDirectory(System.getProperty("user.home"));
                    break;
                }
                case '/': {
                    if (vFSBrowser.getMode() != 2) break;
                    vFSBrowser.rootDirectory();
                    break;
                }
                case '-': {
                    if (vFSBrowser.getMode() != 2) break;
                    vFSBrowser.setDirectory(vFSBrowser.getView().getBuffer().getDirectory());
                    break;
                }
                default: {
                    this.typeSelectBuffer.append(keyEvent.getKeyChar());
                    this.doTypeSelect(this.typeSelectBuffer.toString(), vFSBrowser.getMode() == 3);
                    this.timer.stop();
                    this.timer.setInitialDelay(750);
                    this.timer.setRepeats(false);
                    this.timer.start();
                    return;
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setSelectedRow(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    private boolean doTypeSelect(String string, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            String string2;
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)this.getValueAt(i, 1);
            if (bl && entry.dirEntry.type == 0) continue;
            String string3 = string2 = MiscUtilities.isAbsolutePath(string) ? entry.dirEntry.path : entry.dirEntry.name;
            if (!string2.regionMatches(true, 0, string, 0, string.length())) continue;
            this.setSelectedRow(i);
            return true;
        }
        return false;
    }

    private void resizeColumnsAppropriately() {
        Object object;
        int n;
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        int[] nArray = new int[vFSDirectoryEntryTableModel.getColumnCount()];
        for (n = 0; n < nArray.length; ++n) {
            object = vFSDirectoryEntryTableModel.getColumnName(n);
            if (object == null) continue;
            nArray[n] = (int)this.renderer.plainFont.getStringBounds((String)object, fontRenderContext).getWidth();
        }
        for (n = 0; n < vFSDirectoryEntryTableModel.files.length; ++n) {
            object = vFSDirectoryEntryTableModel.files[n];
            Font font = ((VFSDirectoryEntryTableModel.Entry)object).dirEntry.type == 0 ? this.renderer.plainFont : this.renderer.boldFont;
            nArray[0] = Math.max(nArray[0], this.renderer.getEntryWidth((VFSDirectoryEntryTableModel.Entry)object, font, fontRenderContext));
            for (int i = 1; i < nArray.length; ++i) {
                String string = vFSDirectoryEntryTableModel.getExtendedAttribute(i - 1);
                String string2 = ((VFSDirectoryEntryTableModel.Entry)object).dirEntry.getExtendedAttribute(string);
                if (string2 == null) continue;
                nArray[i] = Math.max(nArray[i], (int)font.getStringBounds(string2, fontRenderContext).getWidth());
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            n2 = n != nArray.length - 1 && n2 != 0 ? (n2 += 10) : (n2 += 2);
            this.getColumnModel().getColumn(n).setPreferredWidth(n2);
            this.getColumnModel().getColumn(n).setMinWidth(n2);
            this.getColumnModel().getColumn(n).setMaxWidth(n2);
            this.getColumnModel().getColumn(n).setWidth(n2);
        }
        this.doLayout();
    }

    class ClearTypeSelect
    implements ActionListener {
        ClearTypeSelect() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VFSDirectoryEntryTable.this.typeSelectBuffer.setLength(0);
        }
    }
}

