/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import bsh.NameSpace;
import bsh.UtilEvalError;
import gnu.regexp.RE;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserIORequest;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.util.Log;

public class VFSBrowser
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final String NAME = "vfs.browser";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int BROWSER_DIALOG = 4;
    public static final int CHOOSE_DIRECTORY_DIALOG = 3;
    public static final int BROWSER = 2;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;
    public static final int M_INSERT = 4;
    String currentEncoding;
    boolean autoDetectEncoding;
    private static ActionContext actionContext = new BrowserActionContext();
    private EventListenerList listenerList = new EventListenerList();
    private View view;
    private boolean horizontalLayout;
    private String path;
    private HistoryTextField pathField;
    private JCheckBox filterCheckbox;
    private HistoryTextField filterField;
    private Box toolbarBox;
    private FavoritesMenuButton favorites;
    private PluginsMenuButton plugins;
    private BrowserView browserView;
    private RE filenameFilter;
    private int mode;
    private boolean multipleSelection;
    private boolean showHiddenFiles;
    private boolean sortMixFilesAndDirs;
    private boolean sortIgnoreCase;
    private boolean doubleClickClose;
    private boolean requestRunning;
    private boolean maybeReloadRequestRunning;

    public static void browseDirectoryInNewWindow(View view, String string) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        if (string != null) {
            jEdit.setTemporaryProperty("vfs.browser.path.tmp", string);
        }
        dockableWindowManager.floatDockableWindow(NAME);
        jEdit.unsetProperty("vfs.browser.path.tmp");
    }

    public static void browseDirectory(View view, String string) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        VFSBrowser vFSBrowser = (VFSBrowser)dockableWindowManager.getDockable(NAME);
        if (vFSBrowser != null) {
            dockableWindowManager.showDockableWindow(NAME);
            vFSBrowser.setDirectory(string);
        } else {
            if (string != null) {
                jEdit.setTemporaryProperty("vfs.browser.path.tmp", string);
            }
            dockableWindowManager.addDockableWindow(NAME);
            jEdit.unsetProperty("vfs.browser.path.tmp");
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public VFSBrowser(View view, String string) {
        this(view, null, 2, true, string);
    }

    public VFSBrowser(View view, String string, int n, boolean bl, String string2) {
        super(new BorderLayout());
        String string3;
        String string4;
        this.mode = n;
        this.multipleSelection = bl;
        this.view = view;
        this.currentEncoding = jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding"));
        this.autoDetectEncoding = jEdit.getBooleanProperty("buffer.encodingAutodetect");
        ActionHandler actionHandler = new ActionHandler();
        Box box = new Box(1);
        this.horizontalLayout = n != 2 || "top".equals(string2) || "bottom".equals(string2);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        box.add(this.toolbarBox);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(jEdit.getProperty("vfs.browser.path"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.pathField = new HistoryTextField("vfs.browser.path");
        this.pathField.setInstantPopups(true);
        this.pathField.setEnterAddsToHistory(false);
        this.pathField.setSelectAllOnFocus(true);
        Dimension dimension = this.pathField.getPreferredSize();
        dimension.width = 0;
        this.pathField.setPreferredSize(dimension);
        this.pathField.addActionListener(actionHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.pathField, gridBagConstraints);
        jPanel.add(this.pathField);
        this.filterCheckbox = new JCheckBox(jEdit.getProperty("vfs.browser.filter"));
        this.filterCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.filterCheckbox.setRequestFocusEnabled(false);
        this.filterCheckbox.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.filterCheckbox.setSelected(jEdit.getBooleanProperty("vfs.browser.filter-enabled"));
        this.filterCheckbox.addActionListener(actionHandler);
        if (n != 3) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.filterCheckbox, gridBagConstraints);
            jPanel.add(this.filterCheckbox);
        }
        this.filterField = new HistoryTextField("vfs.browser.filter");
        this.filterField.setInstantPopups(true);
        this.filterField.setSelectAllOnFocus(true);
        this.filterField.addActionListener(actionHandler);
        if (n != 3) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.filterField, gridBagConstraints);
            jPanel.add(this.filterField);
        }
        box.add(jPanel);
        this.add("North", box);
        this.browserView = new BrowserView(this);
        this.add("Center", this.browserView);
        this.propertiesChanged();
        if (n == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            string4 = jEdit.getProperty("vfs.browser.last-filter");
            if (string4 == null) {
                string4 = jEdit.getProperty("vfs.browser.default-filter");
            }
        } else {
            string3 = MiscUtilities.getFileExtension(view.getBuffer().getName());
            string4 = string3.length() == 0 ? jEdit.getProperty("vfs.browser.default-filter") : "*" + string3;
        }
        this.filterField.setText(string4);
        this.filterField.addCurrentToHistory();
        this.updateFilterEnabled();
        if (string == null) {
            string = jEdit.getProperty("vfs.browser.path.tmp");
        }
        if (string == null || string.length() == 0) {
            string3 = System.getProperty("user.home");
            String string5 = jEdit.getProperty("vfs.browser.defaultPath");
            if (string5.equals("home")) {
                string = string3;
            } else if (string5.equals("working")) {
                string = System.getProperty("user.dir");
            } else if (string5.equals("buffer")) {
                if (view != null) {
                    Buffer buffer = view.getBuffer();
                    string = buffer.getDirectory();
                } else {
                    string = string3;
                }
            } else {
                HistoryModel historyModel;
                string = string5.equals("last") ? ((historyModel = HistoryModel.getModel("vfs.browser.path")).getSize() == 0 ? "~" : historyModel.getItem(0)) : (string5.equals("favorites") ? "favorites:" : string3);
            }
        }
        string3 = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VFSBrowser.this.setDirectory(string3);
            }
        });
    }

    public void focusOnDefaultComponent() {
        this.browserView.focusOnFileView();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        super.removeNotify();
        jEdit.setBooleanProperty("vfs.browser.filter-enabled", this.filterCheckbox.isSelected());
        if (this.mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            jEdit.setProperty("vfs.browser.last-filter", this.filterField.getText());
        }
        EditBus.removeFromBus(this);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            if (bufferUpdate.getWhat() == BufferUpdate.CREATED || bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
                this.browserView.updateFileView();
            }
        } else if (eBMessage instanceof PluginUpdate) {
            PluginUpdate pluginUpdate = (PluginUpdate)eBMessage;
            if (pluginUpdate.getWhat() == PluginUpdate.LOADED || pluginUpdate.getWhat() == PluginUpdate.UNLOADED) {
                this.plugins.updatePopupMenu();
            }
        } else if (eBMessage instanceof VFSUpdate) {
            this.maybeReloadDirectory(((VFSUpdate)eBMessage).getPath());
        }
    }

    public View getView() {
        return this.view;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelection;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean bl) {
        this.showHiddenFiles = bl;
    }

    public String getFilenameFilter() {
        if (this.filterCheckbox.isSelected()) {
            String string = this.filterField.getText();
            if (string.length() == 0) {
                return "*";
            }
            return string;
        }
        return "*";
    }

    public void setFilenameFilter(String string) {
        if (string == null || string.length() == 0 || string.equals("*")) {
            this.filterCheckbox.setSelected(false);
        } else {
            this.filterCheckbox.setSelected(true);
            this.filterField.setText(string);
        }
    }

    public HistoryTextField getDirectoryField() {
        return this.pathField;
    }

    public String getDirectory() {
        return this.path;
    }

    public void setDirectory(String string) {
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        this.pathField.setText(string);
        if (!this.startRequest()) {
            return;
        }
        this.updateFilenameFilter();
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, string);
        this.path = string;
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void rootDirectory() {
        if (OperatingSystem.isMacOS() || OperatingSystem.isDOSDerived()) {
            this.setDirectory("roots:");
        } else {
            this.setDirectory("/");
        }
    }

    public void reloadDirectory() {
        VFSManager.getVFSForPath(this.path).reloadDirectory(this.path);
        this.updateFilenameFilter();
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, this.path);
    }

    public void delete(VFS.DirectoryEntry[] directoryEntryArray) {
        String string = MiscUtilities.isURL(directoryEntryArray[0].deletePath) && "favorites".equals(MiscUtilities.getProtocolOfURL(directoryEntryArray[0].deletePath)) ? "vfs.browser.delete-favorites" : "vfs.browser.delete-confirm";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < directoryEntryArray.length; ++i) {
            stringBuffer.append(directoryEntryArray[i].path);
            stringBuffer.append('\n');
        }
        Object[] objectArray = new Object[]{stringBuffer.toString()};
        int n = GUIUtilities.confirm(this, string, objectArray, 0, 2);
        if (n != 0) {
            return;
        }
        VFS vFS = VFSManager.getVFSForPath(directoryEntryArray[0].deletePath);
        if (!this.startRequest()) {
            return;
        }
        for (int i = 0; i < directoryEntryArray.length; ++i) {
            Object object = vFS.createVFSSession(directoryEntryArray[i].deletePath, this);
            if (object == null) continue;
            VFSManager.runInWorkThread(new BrowserIORequest(1, this, object, vFS, directoryEntryArray[i].deletePath, null, null));
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void rename(String string) {
        VFS vFS = VFSManager.getVFSForPath(string);
        String string2 = vFS.getFileName(string);
        Object[] objectArray = new String[]{string2};
        String string3 = GUIUtilities.input(this, "vfs.browser.rename", objectArray, string2);
        if (string3 == null) {
            return;
        }
        string3 = MiscUtilities.constructPath(vFS.getParentOfPath(string), string3);
        Object object = vFS.createVFSSession(string, this);
        if (object == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(2, this, object, vFS, string, string3, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void mkdir() {
        String string;
        String string2 = GUIUtilities.input(this, "vfs.browser.mkdir", null);
        if (string2 == null) {
            return;
        }
        VFS.DirectoryEntry[] directoryEntryArray = this.getSelectedFiles();
        if (directoryEntryArray.length == 0) {
            string = this.path;
        } else if (directoryEntryArray[0].type == 0) {
            string = directoryEntryArray[0].path;
            string = VFSManager.getVFSForPath(string).getParentOfPath(string);
        } else {
            string = directoryEntryArray[0].path;
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        string2 = MiscUtilities.constructPath(string, string2);
        Object object = vFS.createVFSSession(string2, this);
        if (object == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(3, this, object, vFS, string2, null, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void newFile() {
        VFS.DirectoryEntry[] directoryEntryArray = this.getSelectedFiles();
        if (directoryEntryArray.length >= 1) {
            VFS.DirectoryEntry directoryEntry = directoryEntryArray[0];
            if (directoryEntry.type == 1) {
                jEdit.newFile(this.view, directoryEntry.path);
            } else {
                VFS vFS = VFSManager.getVFSForPath(directoryEntry.path);
                jEdit.newFile(this.view, vFS.getParentOfPath(directoryEntry.path));
            }
        } else {
            jEdit.newFile(this.view, this.path);
        }
    }

    public void searchInDirectory() {
        VFS.DirectoryEntry[] directoryEntryArray = this.getSelectedFiles();
        if (directoryEntryArray.length >= 1) {
            VFS.DirectoryEntry directoryEntry = directoryEntryArray[0];
            this.searchInDirectory(directoryEntry.path, directoryEntry.type != 0);
        } else {
            this.searchInDirectory(this.path, true);
        }
    }

    public void searchInDirectory(String string, boolean bl) {
        String string2;
        if (bl) {
            string2 = this.getFilenameFilter();
        } else {
            String string3 = MiscUtilities.getFileName(string);
            String string4 = MiscUtilities.getFileExtension(string3);
            string2 = string4 == null || string4.length() == 0 ? this.getFilenameFilter() : "*" + string4;
            string = MiscUtilities.getParentOfPath(string);
        }
        SearchAndReplace.setSearchFileSet(new DirectoryListSet(string, string2, true));
        SearchDialog.showSearchDialog(this.view, null, 2);
    }

    public BrowserView getBrowserView() {
        return this.browserView;
    }

    public VFS.DirectoryEntry[] getSelectedFiles() {
        return this.browserView.getSelectedFiles();
    }

    public void locateFile(final String string) {
        if (!this.filenameFilter.isMatch(MiscUtilities.getFileName(string))) {
            this.setFilenameFilter(null);
        }
        this.setDirectory(MiscUtilities.getParentOfPath(string));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.browserView.getTable().selectFile(string);
            }
        });
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.listenerList.add(BrowserListener.class, browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.listenerList.remove(BrowserListener.class, browserListener);
    }

    public void filesActivated(int n, boolean bl) {
        Object object;
        VFS.DirectoryEntry[] directoryEntryArray = this.browserView.getSelectedFiles();
        Object object2 = null;
        for (int i = 0; i < directoryEntryArray.length; ++i) {
            EditPane[] editPaneArray;
            VFS.DirectoryEntry directoryEntry = directoryEntryArray[i];
            if (directoryEntry.type == 1 || directoryEntry.type == 2) {
                if (n == 1 && this.mode == 2) {
                    VFSBrowser.browseDirectoryInNewWindow(this.view, directoryEntry.path);
                    continue;
                }
                this.setDirectory(directoryEntry.path);
                continue;
            }
            if (this.mode != 2 && this.mode != 4) continue;
            if (n == 4) {
                this.view.getBuffer().insertFile(this.view, directoryEntry.path);
                continue;
            }
            object = jEdit.getBuffer(directoryEntry.path);
            if (object == null) {
                editPaneArray = new Hashtable();
                editPaneArray.put("encoding", this.currentEncoding);
                editPaneArray.put("encodingAutodetect", new Boolean(this.autoDetectEncoding));
                object = jEdit.openFile(null, null, directoryEntry.path, false, (Hashtable)editPaneArray);
            } else if (this.doubleClickClose && bl && this.mode != 4 && directoryEntryArray.length == 1) {
                editPaneArray = this.view.getEditPanes();
                for (int j = 0; j < editPaneArray.length; ++j) {
                    if (editPaneArray[j].getBuffer() != object) continue;
                    jEdit.closeBuffer(this.view, (Buffer)object);
                    return;
                }
            }
            if (object == null) continue;
            object2 = object;
        }
        if (object2 != null) {
            switch (n) {
                case 0: {
                    this.view.setBuffer((Buffer)object2);
                    break;
                }
                case 1: {
                    jEdit.newView(this.view, object2, false);
                    break;
                }
                case 2: {
                    jEdit.newView(this.view, object2, true);
                    break;
                }
                case 3: {
                    this.view.splitHorizontally().setBuffer((Buffer)object2);
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BrowserListener.class) continue;
            object = (BrowserListener)objectArray[i + 1];
            object.filesActivated(this, directoryEntryArray);
        }
    }

    static boolean pathsEqual(String string, String string2) {
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("/") || string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string.equals(string2);
    }

    void updateFilenameFilter() {
        try {
            String string = this.filterField.getText();
            if (string.length() == 0) {
                string = "*";
            }
            this.filenameFilter = new RE(MiscUtilities.globToRE(string), 2);
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
            Object[] objectArray = new String[]{this.filterField.getText(), exception.getMessage()};
            GUIUtilities.error(this, "vfs.browser.bad-filter", objectArray);
        }
    }

    void directoryLoaded(Object object, Object[] objectArray) {
        VFSManager.runInAWTThread(new DirectoryLoadedAWTRequest(object, objectArray));
    }

    void filesSelected() {
        Object object;
        VFS.DirectoryEntry[] directoryEntryArray = this.browserView.getSelectedFiles();
        if (this.mode == 2) {
            for (int i = 0; i < directoryEntryArray.length; ++i) {
                VFS.DirectoryEntry directoryEntry = directoryEntryArray[i];
                object = jEdit.getBuffer(directoryEntry.path);
                if (object == null || this.view == null) continue;
                this.view.setBuffer((Buffer)object);
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BrowserListener.class) continue;
            object = (BrowserListener)objectArray[i + 1];
            object.filesSelected(this, directoryEntryArray);
        }
    }

    void endRequest() {
        this.requestRunning = false;
    }

    private JPanel createMenuBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(0, 1, 0, 3));
        jPanel.add(new CommandsMenuButton());
        jPanel.add(Box.createHorizontalStrut(3));
        this.plugins = new PluginsMenuButton();
        jPanel.add(this.plugins);
        jPanel.add(Box.createHorizontalStrut(3));
        this.favorites = new FavoritesMenuButton();
        jPanel.add(this.favorites);
        return jPanel;
    }

    private Box createToolBar() {
        if (this.mode == 2) {
            return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-browser");
        }
        return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-dialog");
    }

    private void propertiesChanged() {
        JComponent jComponent;
        this.showHiddenFiles = jEdit.getBooleanProperty("vfs.browser.showHiddenFiles");
        this.sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
        this.doubleClickClose = jEdit.getBooleanProperty("vfs.browser.doubleClickClose");
        this.browserView.propertiesChanged();
        this.toolbarBox.removeAll();
        if (jEdit.getBooleanProperty("vfs.browser.showToolbar")) {
            jComponent = this.createToolBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add(jComponent);
            } else {
                jComponent.add(Box.createGlue());
                this.toolbarBox.add(jComponent);
            }
        }
        if (jEdit.getBooleanProperty("vfs.browser.showMenubar")) {
            jComponent = this.createMenuBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add(Box.createHorizontalStrut(6));
                this.toolbarBox.add((Component)jComponent, 0);
            } else {
                jComponent.add(Box.createGlue());
                this.toolbarBox.add(jComponent);
            }
        } else {
            this.favorites = null;
        }
        this.toolbarBox.add(Box.createGlue());
        this.revalidate();
        if (this.path != null) {
            this.reloadDirectory();
        }
    }

    private boolean startRequest() {
        if (this.requestRunning) {
            Log.log(1, this, new Throwable("For debugging purposes"));
            GUIUtilities.error(this, "browser-multiple-io", null);
            return false;
        }
        this.requestRunning = true;
        return true;
    }

    private void updateFilterEnabled() {
        this.filterField.setEnabled(this.filterCheckbox.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadDirectory(String string) {
        if (MiscUtilities.isURL(string) && MiscUtilities.getProtocolOfURL(string).equals("favorites") && this.favorites != null) {
            this.favorites.popup = null;
        }
        if (this.maybeReloadRequestRunning) {
            return;
        }
        if (this.path != null) {
            try {
                this.maybeReloadRequestRunning = true;
                this.browserView.maybeReloadDirectory(string);
            }
            catch (Throwable throwable) {
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        VFSBrowser.this.maybeReloadRequestRunning = false;
                    }
                });
                throw throwable;
            }
            VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
        }
    }

    static {
        ActionSet actionSet = new ActionSet(null, null, null, jEdit.class.getResource("browser.actions.xml"));
        actionSet.setLabel(jEdit.getProperty("action-set.browser"));
        actionSet.load();
        actionContext.addActionSet(actionSet);
    }

    static class BrowserActionContext
    extends ActionContext {
        BrowserActionContext() {
        }

        private VFS.DirectoryEntry[] getSelectedFiles(EventObject eventObject, VFSBrowser vFSBrowser) {
            Component component = (Component)eventObject.getSource();
            if (GUIUtilities.getComponentParent(component, JList.class) != null) {
                Object[] objectArray = vFSBrowser.getBrowserView().getParentDirectoryList().getSelectedValues();
                VFS.DirectoryEntry[] directoryEntryArray = new VFS.DirectoryEntry[objectArray.length];
                System.arraycopy(objectArray, 0, directoryEntryArray, 0, objectArray.length);
                return directoryEntryArray;
            }
            return vFSBrowser.getSelectedFiles();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeAction(EventObject eventObject, EditAction editAction) {
            VFSBrowser vFSBrowser = (VFSBrowser)GUIUtilities.getComponentParent((Component)eventObject.getSource(), VFSBrowser.class);
            VFS.DirectoryEntry[] directoryEntryArray = this.getSelectedFiles(eventObject, vFSBrowser);
            NameSpace nameSpace = BeanShell.getNameSpace();
            try {
                nameSpace.setVariable("browser", vFSBrowser);
                nameSpace.setVariable("files", directoryEntryArray);
                View view = vFSBrowser.getView();
                if (view == null) {
                    view = jEdit.getActiveView();
                }
                editAction.invoke(view);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, this, utilEvalError);
            }
            finally {
                try {
                    nameSpace.setVariable("browser", null);
                    nameSpace.setVariable("files", null);
                }
                catch (UtilEvalError utilEvalError) {
                    Log.log(9, this, utilEvalError);
                }
            }
        }
    }

    class DirectoryLoadedAWTRequest
    implements Runnable {
        Object node;
        Object[] loadInfo;

        DirectoryLoadedAWTRequest(Object object, Object[] objectArray) {
            this.node = object;
            this.loadInfo = objectArray;
        }

        public void run() {
            String string = (String)this.loadInfo[0];
            if (string == null) {
                return;
            }
            VFS.DirectoryEntry[] directoryEntryArray = (VFS.DirectoryEntry[])this.loadInfo[1];
            if (this.node == null) {
                VFSBrowser.this.path = string;
                if (!VFSBrowser.this.pathField.getText().equals(string)) {
                    VFSBrowser.this.pathField.setText(string);
                }
                if (string.endsWith("/") || string.endsWith(File.separator)) {
                    string = string.substring(0, string.length() - 1);
                }
                HistoryModel.getModel("vfs.browser.path").addItem(string);
            }
            boolean bl = VFSBrowser.this.filterCheckbox.isSelected();
            ArrayList<VFS.DirectoryEntry> arrayList = new ArrayList<VFS.DirectoryEntry>();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (directoryEntryArray != null) {
                for (int i = 0; i < directoryEntryArray.length; ++i) {
                    VFS.DirectoryEntry directoryEntry = directoryEntryArray[i];
                    if (directoryEntry.hidden && !VFSBrowser.this.showHiddenFiles) {
                        ++n3;
                        continue;
                    }
                    if (directoryEntry.type == 0 && bl && VFSBrowser.this.filenameFilter != null && !VFSBrowser.this.filenameFilter.isMatch(directoryEntry.name)) {
                        ++n3;
                        continue;
                    }
                    if (directoryEntry.type == 0) {
                        ++n2;
                    } else {
                        ++n;
                    }
                    arrayList.add(directoryEntry);
                }
                MiscUtilities.quicksort(arrayList, (Comparator)new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
            }
            VFSBrowser.this.browserView.directoryLoaded(this.node, string, arrayList);
            if (VFSBrowser.this.mode == 3) {
                VFSBrowser.this.filesSelected();
            }
        }

        public String toString() {
            return (String)this.loadInfo[0];
        }
    }

    class FavoritesMenuButton
    extends JButton {
        JPopupMenu popup;

        FavoritesMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.favorites.label"));
            this.setIcon(GUIUtilities.loadIcon("ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        void createPopupMenu() {
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.add-to-favorites.label"));
            jMenuItem.setActionCommand("add-to-favorites");
            jMenuItem.addActionListener(actionHandler);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.edit-favorites.label"));
            jMenuItem.setActionCommand("dir@favorites:");
            jMenuItem.addActionListener(actionHandler);
            this.popup.add(jMenuItem);
            this.popup.addSeparator();
            Object[] objectArray = FavoritesVFS.getFavorites();
            if (objectArray.length == 0) {
                jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
                jMenuItem.setEnabled(false);
                this.popup.add(jMenuItem);
            } else {
                MiscUtilities.quicksort(objectArray, (MiscUtilities.Compare)new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    jMenuItem = new JMenuItem(((VFS.DirectoryEntry)object).path);
                    jMenuItem.setIcon(FileCellRenderer.getIconForFile((VFS.DirectoryEntry)object, false));
                    String string = (((VFS.DirectoryEntry)object).type == 0 ? "file@" : "dir@") + ((VFS.DirectoryEntry)object).path;
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionHandler);
                    this.popup.add(jMenuItem);
                }
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (FavoritesMenuButton.this.popup != null && FavoritesMenuButton.this.popup.isVisible()) {
                    FavoritesMenuButton.this.popup.setVisible(false);
                    return;
                }
                if (FavoritesMenuButton.this.popup == null) {
                    FavoritesMenuButton.this.createPopupMenu();
                }
                GUIUtilities.showPopupMenu(FavoritesMenuButton.this.popup, FavoritesMenuButton.this, 0, FavoritesMenuButton.this.getHeight(), false);
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("add-to-favorites")) {
                    VFS.DirectoryEntry[] directoryEntryArray = VFSBrowser.this.getSelectedFiles();
                    if (directoryEntryArray == null || directoryEntryArray.length == 0) {
                        if (VFSBrowser.this.path.equals("favorites:")) {
                            GUIUtilities.error(VFSBrowser.this, "vfs.browser.recurse-favorites", null);
                        } else {
                            FavoritesVFS.addToFavorites(VFSBrowser.this.path, 1);
                        }
                    } else {
                        for (int i = 0; i < directoryEntryArray.length; ++i) {
                            VFS.DirectoryEntry directoryEntry = directoryEntryArray[i];
                            FavoritesVFS.addToFavorites(directoryEntry.path, directoryEntry.type);
                        }
                    }
                } else if (string.startsWith("dir@")) {
                    VFSBrowser.this.setDirectory(string.substring(4));
                } else if (string.startsWith("file@")) {
                    switch (VFSBrowser.this.getMode()) {
                        case 2: {
                            jEdit.openFile(VFSBrowser.this.view, string.substring(5));
                            break;
                        }
                        default: {
                            VFSBrowser.this.locateFile(string.substring(5));
                        }
                    }
                }
            }
        }
    }

    class PluginsMenuButton
    extends JButton {
        JPopupMenu popup;

        PluginsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.plugins.label"));
            this.setIcon(GUIUtilities.loadIcon("ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        void updatePopupMenu() {
            this.popup = null;
        }

        private void createPopupMenu() {
            int n;
            Object object;
            if (this.popup != null) {
                return;
            }
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            if (VFSBrowser.this.getMode() == 2) {
                this.popup.add(GUIUtilities.loadMenuItem("plugin-manager", false));
                this.popup.add(GUIUtilities.loadMenuItem("plugin-options", false));
                this.popup.addSeparator();
            }
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
            Enumeration enumeration = VFSManager.getFilesystems();
            while (enumeration.hasMoreElements()) {
                object = (VFS)enumeration.nextElement();
                if ((((VFS)object).getCapabilities() & 4) == 0) continue;
                JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs." + ((VFS)object).getName() + ".label"));
                jMenuItem.setActionCommand(((VFS)object).getName());
                jMenuItem.addActionListener(actionHandler);
                arrayList.add(jMenuItem);
            }
            object = jEdit.getPlugins();
            for (n = 0; n < ((Object)object).length; ++n) {
                JMenuItem jMenuItem = ((EditPlugin)object[n]).createBrowserMenuItems();
                if (jMenuItem == null) continue;
                arrayList.add(jMenuItem);
            }
            if (arrayList.size() != 0) {
                MiscUtilities.quicksort(arrayList, (Comparator)new MiscUtilities.MenuItemCompare());
                for (n = 0; n < arrayList.size(); ++n) {
                    this.popup.add((JMenuItem)arrayList.get(n));
                }
            } else {
                JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.plugins.no-plugins.label"));
                jMenuItem.setEnabled(false);
                this.popup.add(jMenuItem);
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PluginsMenuButton.this.createPopupMenu();
                if (!PluginsMenuButton.this.popup.isVisible()) {
                    GUIUtilities.showPopupMenu(PluginsMenuButton.this.popup, PluginsMenuButton.this, 0, PluginsMenuButton.this.getHeight(), false);
                } else {
                    PluginsMenuButton.this.popup.setVisible(false);
                }
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                VFS vFS = VFSManager.getVFSByName(actionEvent.getActionCommand());
                String string = vFS.showBrowseDialog(null, VFSBrowser.this);
                if (string != null) {
                    VFSBrowser.this.setDirectory(string);
                }
            }
        }
    }

    class CommandsMenuButton
    extends JButton {
        BrowserCommandsMenu popup;

        CommandsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.commands.label"));
            this.setIcon(GUIUtilities.loadIcon("ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.popup = new BrowserCommandsMenu(VFSBrowser.this, null);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!CommandsMenuButton.this.popup.isVisible()) {
                    CommandsMenuButton.this.popup.update();
                    GUIUtilities.showPopupMenu(CommandsMenuButton.this.popup, CommandsMenuButton.this, 0, CommandsMenuButton.this.getHeight(), false);
                } else {
                    CommandsMenuButton.this.popup.setVisible(false);
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == VFSBrowser.this.pathField || object == VFSBrowser.this.filterField || object == VFSBrowser.this.filterCheckbox) {
                VFSBrowser.this.updateFilterEnabled();
                String string = VFSBrowser.this.pathField.getText();
                if (string != null) {
                    VFSBrowser.this.setDirectory(string);
                }
                VFSBrowser.this.browserView.focusOnFileView();
            }
        }
    }
}

