/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import de.grogra.ext.jedit.ViewBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.gui.ToolBarManager;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchBar;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.util.Log;

public class View
extends ViewBase
implements EBComponent {
    public static final int TOP_GROUP = 0;
    public static final int BOTTOM_GROUP = 1;
    public static final int DEFAULT_GROUP = 0;
    public static final int TOP_LAYER = Integer.MAX_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int BOTTOM_LAYER = Integer.MIN_VALUE;
    public static final int ABOVE_SYSTEM_BAR_LAYER = 150;
    public static final int SYSTEM_BAR_LAYER = 100;
    public static final int BELOW_SYSTEM_BAR_LAYER = 75;
    public static final int SEARCH_BAR_LAYER = 75;
    public static final int BELOW_SEARCH_BAR_LAYER = 50;
    public static final int ABOVE_ACTION_BAR_LAYER = -50;
    public static final int ACTION_BAR_LAYER = -75;
    public static final int STATUS_BAR_LAYER = -100;
    public static final int BELOW_STATUS_BAR_LAYER = -150;
    public static final int VIEW = 0;
    public static final int TEXT_AREA = 1;
    public static final int ACTION_BAR = 2;
    View prev;
    View next;
    private boolean closed;
    private DockableWindowManager dockableWindowManager;
    private JPanel topToolBars;
    private JPanel bottomToolBars;
    private ToolBarManager toolBarManager;
    private Box toolBar;
    private SearchBar searchBar;
    private ActionBar actionBar;
    private EditPane editPane;
    private JSplitPane splitPane;
    private StatusBar status;
    private KeyListener keyEventInterceptor;
    private InputHandler inputHandler;
    private Macros.Recorder recorder;
    private Component prefixFocusOwner;
    private int waitCount;
    private boolean showFullPath;
    private boolean plainView;
    private Socket waitSocket;

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public Box getToolBar() {
        return this.toolBar;
    }

    public void addToolBar(Component component) {
        this.addToolBar(0, 0, component);
    }

    public void addToolBar(int n, Component component) {
        this.addToolBar(n, 0, component);
    }

    public void addToolBar(int n, int n2, Component component) {
        this.toolBarManager.addToolBar(n, n2, component);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component component) {
        this.toolBarManager.removeToolBar(component);
        this.getRootPane().revalidate();
    }

    public synchronized void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            EditPane[] editPaneArray = this.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                EditPane editPane = editPaneArray[i];
                editPane.getTextArea().getPainter().setCursor(cursor);
            }
        }
    }

    public synchronized void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            cursor = Cursor.getPredefinedCursor(2);
            EditPane[] editPaneArray = this.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                EditPane editPane = editPaneArray[i];
                editPane.getTextArea().getPainter().setCursor(cursor);
            }
        }
    }

    public final SearchBar getSearchBar() {
        return this.searchBar;
    }

    public final ActionBar getActionBar() {
        return this.actionBar;
    }

    public StatusBar getStatus() {
        return this.status;
    }

    public void quickIncrementalSearch(boolean bl) {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(false);
        JEditTextArea jEditTextArea = this.getTextArea();
        if (bl) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                jEditTextArea.selectWord();
                string = jEditTextArea.getSelectedText();
            } else if (string.indexOf(10) != -1) {
                string = null;
            }
            this.searchBar.getField().setText(string);
        }
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void quickHyperSearch(boolean bl) {
        JEditTextArea jEditTextArea = this.getTextArea();
        if (bl) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                jEditTextArea.selectWord();
                string = jEditTextArea.getSelectedText();
            }
            if (string != null && string.indexOf(10) == -1) {
                HistoryModel.getModel("find").addItem(string);
                SearchAndReplace.setSearchString(string);
                SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
                SearchAndReplace.hyperSearch(this);
                return;
            }
        }
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(true);
        this.searchBar.getField().setText(null);
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void actionBar() {
        if (this.actionBar == null) {
            this.actionBar = new ActionBar(this, true);
        }
        if (this.actionBar.getParent() == null) {
            this.addToolBar(1, -75, this.actionBar);
        }
        this.actionBar.goToActionBar();
    }

    public KeyListener getKeyEventInterceptor() {
        return this.keyEventInterceptor;
    }

    public void setKeyEventInterceptor(KeyListener keyListener) {
        this.keyEventInterceptor = keyListener;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public Macros.Recorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(Macros.Recorder recorder) {
        this.recorder = recorder;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent, 0);
    }

    public void processKeyEvent(KeyEvent keyEvent, boolean bl) {
        this.processKeyEvent(keyEvent, bl ? 1 : 0);
    }

    public void processKeyEvent(KeyEvent keyEvent, int n) {
        if (Debug.DUMP_KEY_EVENTS && n != 0) {
            Log.log(1, this, "Key event: " + GrabKeyDialog.toString(keyEvent));
        }
        if (this.getTextArea().hasFocus() && n == 0) {
            return;
        }
        if ((keyEvent = this._preprocessKeyEvent(keyEvent)) == null) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS && n != 0) {
            Log.log(1, this, "Key event after workaround: " + GrabKeyDialog.toString(keyEvent));
        }
        switch (keyEvent.getID()) {
            case 400: {
                KeyEventTranslator.Key key;
                boolean bl = false;
                if (this.prefixFocusOwner != null && this.prefixFocusOwner.isShowing()) {
                    this.prefixFocusOwner.requestFocus();
                    bl = true;
                }
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(keyEvent);
                } else if ((n == 2 || this.inputHandler.isPrefixActive() || this.getTextArea().hasFocus()) && (key = KeyEventTranslator.translateKeyEvent(keyEvent)) != null) {
                    if (Debug.DUMP_KEY_EVENTS && n != 0) {
                        Log.log(1, this, "Translated: " + key);
                    }
                    if (this.inputHandler.handleKey(key)) {
                        keyEvent.consume();
                    }
                }
                if (this.isClosed()) {
                    return;
                }
                if (this.inputHandler.isPrefixActive()) {
                    if (this.getFocusOwner() instanceof JTextComponent) {
                        this.prefixFocusOwner = this.getFocusOwner();
                        this.getTextArea().requestFocus();
                        break;
                    }
                    if (bl) {
                        this.getTextArea().requestFocus();
                        break;
                    }
                    this.prefixFocusOwner = null;
                    break;
                }
                this.prefixFocusOwner = null;
                break;
            }
            case 401: {
                KeyEventTranslator.Key key;
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(keyEvent);
                    break;
                }
                boolean bl = false;
                if (this.prefixFocusOwner != null) {
                    if (this.prefixFocusOwner.isShowing()) {
                        this.prefixFocusOwner.requestFocus();
                        bl = true;
                    }
                    this.prefixFocusOwner = null;
                }
                if ((key = KeyEventTranslator.translateKeyEvent(keyEvent)) != null) {
                    if (Debug.DUMP_KEY_EVENTS && n != 0) {
                        Log.log(1, this, "Translated: " + key);
                    }
                    if (this.inputHandler.handleKey(key)) {
                        keyEvent.consume();
                    }
                }
                if (this.isClosed()) {
                    return;
                }
                if (this.inputHandler.isPrefixActive()) {
                    if (this.getFocusOwner() instanceof JTextComponent) {
                        this.prefixFocusOwner = this.getFocusOwner();
                        this.getTextArea().requestFocus();
                        break;
                    }
                    if (bl) {
                        this.getTextArea().requestFocus();
                        break;
                    }
                    this.prefixFocusOwner = null;
                    break;
                }
                this.prefixFocusOwner = null;
                break;
            }
            case 402: {
                if (this.keyEventInterceptor == null) break;
                this.keyEventInterceptor.keyReleased(keyEvent);
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int n) {
        PerspectiveManager.setPerspectiveDirty(true);
        this.editPane.saveCaretInfo();
        EditPane editPane = this.editPane;
        this.setEditPane(this.createEditPane(editPane.getBuffer()));
        this.editPane.loadCaretInfo();
        JComponent jComponent = (JComponent)editPane.getParent();
        final JSplitPane jSplitPane = new JSplitPane(n);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setBorder(null);
        jSplitPane.setMinimumSize(new Dimension(0, 0));
        int n2 = n == 0 ? editPane.getHeight() : editPane.getWidth();
        final int n3 = (int)((double)(n2 - jSplitPane.getDividerSize()) * 0.5);
        jSplitPane.setDividerLocation(n3);
        if (jComponent instanceof JSplitPane) {
            JSplitPane jSplitPane2 = (JSplitPane)jComponent;
            int n4 = jSplitPane2.getDividerLocation();
            Component component = jSplitPane2.getLeftComponent();
            if (component == editPane) {
                jSplitPane2.setLeftComponent(jSplitPane);
            } else {
                jSplitPane2.setRightComponent(jSplitPane);
            }
            jSplitPane.setLeftComponent(editPane);
            jSplitPane.setRightComponent(this.editPane);
            jSplitPane2.setDividerLocation(n4);
        } else {
            this.splitPane = jSplitPane;
            jSplitPane.setLeftComponent(editPane);
            jSplitPane.setRightComponent(this.editPane);
            jComponent.add((Component)jSplitPane, 0);
            jComponent.revalidate();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jSplitPane.setDividerLocation(n3);
            }
        });
        this.editPane.focusOnTextArea();
        return this.editPane;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            PerspectiveManager.setPerspectiveDirty(true);
            EditPane[] editPaneArray = this.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                EditPane editPane = editPaneArray[i];
                if (this.editPane == editPane) continue;
                editPane.close();
            }
            JComponent jComponent = (JComponent)this.splitPane.getParent();
            jComponent.remove(this.splitPane);
            jComponent.add((Component)this.editPane, 0);
            jComponent.revalidate();
            this.splitPane = null;
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            JComponent jComponent;
            PerspectiveManager.setPerspectiveDirty(true);
            Container container = this.editPane;
            while (!(container instanceof JSplitPane)) {
                container = container.getParent();
            }
            EditPane[] editPaneArray = this.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                jComponent = editPaneArray[i];
                if (!GUIUtilities.isAncestorOf(container, jComponent) || jComponent == this.editPane) continue;
                ((EditPane)jComponent).close();
            }
            JComponent jComponent2 = (JComponent)container.getParent();
            if (jComponent2 instanceof JSplitPane) {
                jComponent = (JSplitPane)jComponent2;
                int n = ((JSplitPane)jComponent).getDividerLocation();
                if (((JSplitPane)jComponent).getLeftComponent() == container) {
                    ((JSplitPane)jComponent).setLeftComponent(this.editPane);
                } else {
                    ((JSplitPane)jComponent).setRightComponent(this.editPane);
                }
                ((JSplitPane)jComponent).setDividerLocation(n);
            } else {
                jComponent2.remove(container);
                jComponent2.add((Component)this.editPane, 0);
                this.splitPane = null;
            }
            jComponent2.revalidate();
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void nextTextArea() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            if (this.editPane != editPaneArray[i]) continue;
            if (i == editPaneArray.length - 1) {
                editPaneArray[0].focusOnTextArea();
                break;
            }
            editPaneArray[i + 1].focusOnTextArea();
            break;
        }
    }

    public void prevTextArea() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            if (this.editPane != editPaneArray[i]) continue;
            if (i == 0) {
                editPaneArray[editPaneArray.length - 1].focusOnTextArea();
                break;
            }
            editPaneArray[i - 1].focusOnTextArea();
            break;
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public Buffer getBuffer() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getBuffer();
    }

    public void setBuffer(Buffer buffer) {
        this.editPane.setBuffer(buffer);
    }

    public EditPane goToBuffer(Buffer buffer) {
        if (this.editPane.getBuffer() == buffer) {
            this.editPane.focusOnTextArea();
            return this.editPane;
        }
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            EditPane editPane = editPaneArray[i];
            if (editPane.getBuffer() != buffer || editPane.getTextArea().getVisibleLines() <= 1) continue;
            this.setEditPane(editPane);
            editPane.focusOnTextArea();
            return editPane;
        }
        this.setBuffer(buffer);
        return this.editPane;
    }

    public JEditTextArea getTextArea() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getTextArea();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        if (this.splitPane == null) {
            EditPane[] editPaneArray = new EditPane[]{this.editPane};
            return editPaneArray;
        }
        Vector vector = new Vector();
        this.getEditPanes(vector, this.splitPane);
        Object[] objectArray = new EditPane[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ViewConfig getViewConfig() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.splitPane != null) {
            this.getSplitConfig(this.splitPane, stringBuffer);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(MiscUtilities.charsToEscapes(this.getBuffer().getPath()));
            stringBuffer.append("\" buffer");
        }
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.plainView = this.isPlainView();
        viewConfig.splitConfig = stringBuffer.toString();
        viewConfig.x = this.getX();
        viewConfig.y = this.getY();
        viewConfig.width = this.getWidth();
        viewConfig.height = this.getHeight();
        viewConfig.extState = 0;
        viewConfig.top = this.dockableWindowManager.getTopDockingArea().getCurrent();
        viewConfig.left = this.dockableWindowManager.getLeftDockingArea().getCurrent();
        viewConfig.bottom = this.dockableWindowManager.getBottomDockingArea().getCurrent();
        viewConfig.right = this.dockableWindowManager.getRightDockingArea().getCurrent();
        viewConfig.topPos = this.dockableWindowManager.getTopDockingArea().getDimension();
        viewConfig.leftPos = this.dockableWindowManager.getLeftDockingArea().getDimension();
        viewConfig.bottomPos = this.dockableWindowManager.getBottomDockingArea().getDimension();
        viewConfig.rightPos = this.dockableWindowManager.getRightDockingArea().getDimension();
        return viewConfig;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public View getNext() {
        return this.next;
    }

    public View getPrev() {
        return this.prev;
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (eBMessage instanceof SearchSettingsChanged) {
            if (this.searchBar != null) {
                this.searchBar.update();
            }
        } else if (eBMessage instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)eBMessage);
        } else if (eBMessage instanceof EditPaneUpdate) {
            this.handleEditPaneUpdate((EditPaneUpdate)eBMessage);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setWaitSocket(Socket socket) {
        this.waitSocket = socket;
    }

    public String toString() {
        return this.getClass().getName() + "[" + (jEdit.getActiveView() == this ? "active" : "inactive") + "]";
    }

    View(Buffer buffer, ViewConfig viewConfig) {
        this.plainView = viewConfig.plainView;
        this.enableEvents(8L);
        this.setIconImage(GUIUtilities.getEditorIcon());
        this.dockableWindowManager = new DockableWindowManager(this, viewConfig);
        this.topToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.bottomToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.toolBarManager = new ToolBarManager(this.topToolBars, this.bottomToolBars);
        this.status = new StatusBar(this);
        this.inputHandler = new DefaultInputHandler(this, (DefaultInputHandler)jEdit.getInputHandler());
        try {
            Component component = this.restoreSplitConfig(buffer, viewConfig.splitConfig);
            this.dockableWindowManager.add(component, 0);
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
        this.getContentPane().add("Center", this.dockableWindowManager);
        this.dockableWindowManager.init();
        this.propertiesChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        EditBus.addToBus(this);
        SearchDialog.preloadSearchDialog(this);
    }

    void close() {
        this.closed = true;
        this.dockableWindowManager.close();
        EditBus.removeFromBus(this);
        SearchDialog searchDialog = SearchDialog.getSearchDialog(this);
        if (searchDialog != null) {
            searchDialog.dispose();
        }
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            editPaneArray[i].close();
        }
        this.toolBarManager = null;
        this.toolBar = null;
        this.searchBar = null;
        this.splitPane = null;
        this.inputHandler = null;
        this.recorder = null;
        this.getContentPane().removeAll();
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void updateTitle() {
        Vector<Buffer> vector = new Vector<Buffer>();
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            Buffer buffer = editPaneArray[i].getBuffer();
            if (vector.indexOf(buffer) != -1) continue;
            vector.addElement(buffer);
        }
        StringBuffer stringBuffer = new StringBuffer(jEdit.getProperty("view.title"));
        for (int i = 0; i < vector.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            Buffer buffer = (Buffer)vector.elementAt(i);
            stringBuffer.append(this.showFullPath && !buffer.isNewFile() ? buffer.getPath() : buffer.getName());
            if (!buffer.isDirty()) continue;
            stringBuffer.append(jEdit.getProperty("view.title.dirty"));
        }
        this.setTitle(stringBuffer.toString());
    }

    private void getEditPanes(Vector vector, Component component) {
        if (component instanceof EditPane) {
            vector.addElement(component);
        } else if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            this.getEditPanes(vector, jSplitPane.getLeftComponent());
            this.getEditPanes(vector, jSplitPane.getRightComponent());
        }
    }

    private void getSplitConfig(JSplitPane jSplitPane, StringBuffer stringBuffer) {
        Component component = jSplitPane.getRightComponent();
        if (component instanceof JSplitPane) {
            this.getSplitConfig((JSplitPane)component, stringBuffer);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(MiscUtilities.charsToEscapes(((EditPane)component).getBuffer().getPath()));
            stringBuffer.append("\" buffer");
        }
        stringBuffer.append(' ');
        Component component2 = jSplitPane.getLeftComponent();
        if (component2 instanceof JSplitPane) {
            this.getSplitConfig((JSplitPane)component2, stringBuffer);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(MiscUtilities.charsToEscapes(((EditPane)component2).getBuffer().getPath()));
            stringBuffer.append("\" buffer");
        }
        stringBuffer.append(' ');
        stringBuffer.append(jSplitPane.getDividerLocation());
        stringBuffer.append(' ');
        stringBuffer.append(jSplitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Component restoreSplitConfig(Buffer buffer, String string) throws IOException {
        if (buffer != null) {
            this.editPane = this.createEditPane(buffer);
            return this.editPane;
        }
        if (string == null) {
            this.editPane = this.createEditPane(jEdit.getFirstBuffer());
            return this.editPane;
        }
        Buffer[] bufferArray = jEdit.getBuffers();
        Stack<Object> stack = new Stack<Object>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(35, 126);
        streamTokenizer.commentChar(33);
        streamTokenizer.quoteChar(34);
        streamTokenizer.eolIsSignificant(false);
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -1: {
                    break block6;
                }
                case -3: {
                    int n;
                    if (streamTokenizer.sval.equals("vertical") || streamTokenizer.sval.equals("horizontal")) {
                        int n2 = streamTokenizer.sval.equals("vertical") ? 0 : 1;
                        n = (Integer)stack.pop();
                        this.splitPane = new JSplitPane(n2, (Component)stack.pop(), (Component)stack.pop());
                        stack.push(this.splitPane);
                        this.splitPane.setOneTouchExpandable(true);
                        this.splitPane.setBorder(null);
                        this.splitPane.setMinimumSize(new Dimension(0, 0));
                        this.splitPane.setDividerLocation(n);
                        break;
                    }
                    if (!streamTokenizer.sval.equals("buffer")) break;
                    Object e = stack.pop();
                    if (e instanceof Integer) {
                        n = (Integer)e;
                        if (n >= 0 && n < bufferArray.length) {
                            buffer = bufferArray[n];
                        }
                    } else if (e instanceof String) {
                        String string2 = (String)e;
                        buffer = jEdit.getBuffer(string2);
                    }
                    if (buffer == null) {
                        buffer = jEdit.getFirstBuffer();
                    }
                    this.editPane = this.createEditPane(buffer);
                    stack.push(this.editPane);
                    break;
                }
                case -2: {
                    stack.push(new Integer((int)streamTokenizer.nval));
                    break;
                }
                case 34: {
                    stack.push(streamTokenizer.sval);
                }
            }
        }
        this.updateGutterBorders();
        return (Component)stack.peek();
    }

    private void propertiesChanged() {
        this.setJMenuBar(GUIUtilities.loadMenuBar("view.mbar"));
        this.loadToolBars();
        this.showFullPath = jEdit.getBooleanProperty("view.showFullPath");
        this.updateTitle();
        this.status.propertiesChanged();
        this.removeToolBar(this.status);
        this.getContentPane().remove(this.status);
        if (jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
            this.getContentPane().add("North", this.topToolBars);
            this.getContentPane().add("South", this.bottomToolBars);
            if (!this.plainView && jEdit.getBooleanProperty("view.status.visible")) {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            this.dockableWindowManager.add(this.topToolBars, "top-toolbars", 0);
            this.dockableWindowManager.add(this.bottomToolBars, "bottom-toolbars", 0);
            if (!this.plainView && jEdit.getBooleanProperty("view.status.visible")) {
                this.getContentPane().add("South", this.status);
            }
        }
        this.getRootPane().revalidate();
    }

    private void loadToolBars() {
        if (jEdit.getBooleanProperty("view.showToolbar") && !this.plainView) {
            if (this.toolBar != null) {
                this.toolBarManager.removeToolBar(this.toolBar);
            }
            this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
            this.addToolBar(0, 100, this.toolBar);
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.searchBar != null) {
            this.removeToolBar(this.searchBar);
        }
        if (jEdit.getBooleanProperty("view.showSearchbar") && !this.plainView) {
            if (this.searchBar == null) {
                this.searchBar = new SearchBar(this, false);
            }
            this.searchBar.propertiesChanged();
            this.addToolBar(0, 75, this.searchBar);
        }
    }

    private EditPane createEditPane(Buffer buffer) {
        EditPane editPane = new EditPane(this, buffer);
        JEditTextArea jEditTextArea = editPane.getTextArea();
        jEditTextArea.addFocusListener(new FocusHandler());
        jEditTextArea.addCaretListener(new CaretHandler());
        jEditTextArea.addScrollListener(new ScrollHandler());
        EditBus.send(new EditPaneUpdate(editPane, EditPaneUpdate.CREATED));
        return editPane;
    }

    private void setEditPane(EditPane editPane) {
        this.editPane = editPane;
        this.status.updateCaretStatus();
        this.status.updateBufferStatus();
        this.status.updateMiscStatus();
        this.updateGutterBorders();
        EditBus.send(new ViewUpdate(this, ViewUpdate.EDIT_PANE_CHANGED));
    }

    private void handleBufferUpdate(BufferUpdate bufferUpdate) {
        Buffer buffer = bufferUpdate.getBuffer();
        if (bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED || bufferUpdate.getWhat() == BufferUpdate.LOADED) {
            EditPane[] editPaneArray = this.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                if (editPaneArray[i].getBuffer() != buffer) continue;
                this.updateTitle();
                break;
            }
        }
    }

    private void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPane.getView() == this && editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane.getBuffer().isLoaded()) {
            this.status.updateCaretStatus();
            this.status.updateBufferStatus();
            this.status.updateMiscStatus();
        }
    }

    private void updateGutterBorders() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            editPaneArray[i].getTextArea().getGutter().updateBorder();
        }
    }

    private KeyEvent _preprocessKeyEvent(KeyEvent keyEvent) {
        if (this.isClosed()) {
            return null;
        }
        if (this.getFocusOwner() instanceof JComponent) {
            Object object;
            JComponent jComponent = (JComponent)this.getFocusOwner();
            InputMap inputMap = jComponent.getInputMap();
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null && jComponent.isEnabled() && (object = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent))) != null && actionMap.get(object) != null) {
                return null;
            }
        }
        if (this.getFocusOwner() instanceof JTextComponent && keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 8: 
                case 9: 
                case 10: 
                case 32: {
                    return null;
                }
            }
        }
        if (keyEvent.isConsumed()) {
            return null;
        }
        return KeyEventWorkaround.processKeyEvent(keyEvent);
    }

    public static class ViewConfig {
        public boolean plainView;
        public String splitConfig;
        public int x;
        public int y;
        public int width;
        public int height;
        public int extState;
        public String top;
        public String left;
        public String bottom;
        public String right;
        public int topPos;
        public int leftPos;
        public int bottomPos;
        public int rightPos;

        public ViewConfig() {
        }

        public ViewConfig(boolean bl) {
            this.plainView = bl;
            String string = bl ? "plain-view" : "view";
            this.x = jEdit.getIntegerProperty(string + ".x", 0);
            this.y = jEdit.getIntegerProperty(string + ".y", 0);
            this.width = jEdit.getIntegerProperty(string + ".width", 0);
            this.height = jEdit.getIntegerProperty(string + ".height", 0);
        }

        public ViewConfig(boolean bl, String string, int n, int n2, int n3, int n4, int n5) {
            this.plainView = bl;
            this.splitConfig = string;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.extState = n5;
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            jEdit.setActiveView(View.this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jEdit.checkBufferStatus(View.this);
                }
            });
        }

        public void windowClosing(WindowEvent windowEvent) {
            jEdit.closeView(View.this);
        }
    }

    class ScrollHandler
    implements ScrollListener {
        ScrollHandler() {
        }

        public void scrolledVertically(JEditTextArea jEditTextArea) {
            if (View.this.getTextArea() == jEditTextArea) {
                View.this.status.updateCaretStatus();
            }
        }

        public void scrolledHorizontally(JEditTextArea jEditTextArea) {
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            while (!(component instanceof EditPane)) {
                if (component == null) {
                    return;
                }
                component = component.getParent();
            }
            if (component != View.this.editPane) {
                View.this.setEditPane((EditPane)component);
            } else {
                View.this.updateGutterBorders();
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (caretEvent.getSource() == View.this.getTextArea()) {
                View.this.status.updateCaretStatus();
            }
        }
    }
}

