/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;
import javax.swing.UIManager;
import org.gjt.sp.util.Log;

public class OperatingSystem {
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int VMS = 912082;
    private static final int UNKNOWN = 2989;
    private static int os;
    private static boolean java14;
    private static boolean java15;
    private static int hasScreenMenuBar;

    public static final Rectangle getScreenBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n6 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (OperatingSystem.isMacOS()) {
            n4 = 0;
            n3 = 22;
            n2 = n5;
            n = n6 - n3 - 4;
        } else if (OperatingSystem.isWindows()) {
            n4 = -4;
            n3 = -4;
            n2 = n5 - 2 * n4;
            n = n6 - 2 * n3;
        } else {
            n4 = 0;
            n3 = 0;
            n2 = n5;
            n = n6;
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public static final Rectangle getScreenBounds(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        Object object3;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            object3 = graphicsDeviceArray[i].getDefaultConfiguration();
            if (!rectangle.intersects(((GraphicsConfiguration)object3).getBounds())) continue;
            object2 = vector.elements();
            while (object2.hasMoreElements() && !((GraphicsConfiguration)(object = (GraphicsConfiguration)object2.nextElement())).getBounds().equals(((GraphicsConfiguration)object3).getBounds())) {
            }
            vector.add(object3);
        }
        Object object4 = null;
        if (vector.size() > 0) {
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (GraphicsConfiguration)object3.nextElement();
                if (object4 == null) {
                    object4 = object2;
                    continue;
                }
                object = ((GraphicsConfiguration)object4).getBounds().intersection(rectangle);
                Rectangle rectangle2 = ((GraphicsConfiguration)object2).getBounds().intersection(rectangle);
                n4 = rectangle2.width * rectangle2.height;
                n3 = ((Rectangle)object).width * ((Rectangle)object).height;
                if (n4 <= n3) continue;
                object4 = object2;
            }
        } else {
            object4 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int n5 = ((GraphicsConfiguration)object4).getBounds().x;
        int n6 = ((GraphicsConfiguration)object4).getBounds().y;
        int n7 = ((GraphicsConfiguration)object4).getBounds().width;
        int n8 = ((GraphicsConfiguration)object4).getBounds().height;
        if (OperatingSystem.isMacOS()) {
            n3 = n5;
            n4 = n6 + 22;
            n2 = n7;
            n = n8 - n4 - 4;
        } else if (OperatingSystem.isWindows()) {
            n3 = n5 - 4;
            n4 = n6 - 4;
            n2 = n7 - 2 * n3;
            n = n8 - 2 * n4;
        } else {
            n3 = n5;
            n4 = n6;
            n2 = n7;
            n = n8;
        }
        return new Rectangle(n3, n4, n2, n);
    }

    public static final boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static final boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static final boolean isWindows9x() {
        return os == 1600;
    }

    public static final boolean isWindowsNT() {
        return os == 1638;
    }

    public static final boolean isOS2() {
        return os == 57005;
    }

    public static final boolean isUnix() {
        return os == 201527 || os == 2748;
    }

    public static final boolean isMacOS() {
        return os == 2748;
    }

    public static boolean isX11() {
        return os == 201527;
    }

    public static final boolean isVMS() {
        return os == 912082;
    }

    public static final boolean isMacOSLF() {
        return OperatingSystem.isMacOS() && UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static final boolean hasScreenMenuBar() {
        if (!OperatingSystem.isMacOS()) {
            return false;
        }
        if (hasScreenMenuBar == -1) {
            String string = System.getProperty("apple.laf.useScreenMenuBar");
            if (string == null) {
                string = System.getProperty("com.apple.macos.useScreenMenuBar");
            }
            hasScreenMenuBar = "true".equals(string) ? 1 : 0;
        }
        return hasScreenMenuBar == 1;
    }

    public static final boolean hasJava14() {
        return java14;
    }

    public static final boolean hasJava15() {
        return java15;
    }

    static {
        String string;
        hasScreenMenuBar = -1;
        if (System.getProperty("mrj.version") != null) {
            os = 2748;
        } else {
            string = System.getProperty("os.name");
            if (string.indexOf("Windows 9") != -1 || string.indexOf("Windows M") != -1) {
                os = 1600;
            } else if (string.indexOf("Windows") != -1) {
                os = 1638;
            } else if (string.indexOf("OS/2") != -1) {
                os = 57005;
            } else if (string.indexOf("VMS") != -1) {
                os = 912082;
            } else if (File.separatorChar == '/') {
                os = 201527;
            } else {
                os = 2989;
                Log.log(7, OperatingSystem.class, "Unknown operating system: " + string);
            }
        }
        string = System.getProperty("jedit.force.java.version");
        if (string == null || string.equals("")) {
            string = System.getProperty("java.version");
        }
        java14 = string.compareTo("1.4") >= 0;
        java15 = string.compareTo("1.5") >= 0;
    }
}

