/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class Java14 {
    public static void init() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new MyFocusManager());
        EditBus.addToBus(new EBComponent(){

            public void handleMessage(EBMessage eBMessage) {
                EditPaneUpdate editPaneUpdate;
                if (eBMessage instanceof ViewUpdate) {
                    ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
                    if (viewUpdate.getWhat() == ViewUpdate.CREATED) {
                        viewUpdate.getView().setFocusTraversalPolicy(new MyFocusTraversalPolicy());
                    }
                } else if (eBMessage instanceof EditPaneUpdate && (editPaneUpdate = (EditPaneUpdate)eBMessage).getWhat() == EditPaneUpdate.CREATED) {
                    Java14.initTextArea(editPaneUpdate.getEditPane().getTextArea());
                }
            }
        });
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (clipboard != null) {
            Log.log(1, Java14.class, "Setting % register to system selection");
            Registers.setRegister('%', new Registers.ClipboardRegister(clipboard));
        }
    }

    public static void dragAndDropCallback(JEditTextArea jEditTextArea, InputEvent inputEvent, boolean bl) {
        Log.log(1, Java14.class, "Drag and drop callback");
        TransferHandler transferHandler = jEditTextArea.getTransferHandler();
        transferHandler.exportAsDrag(jEditTextArea, inputEvent, bl ? 1 : 2);
    }

    static void initTextArea(JEditTextArea jEditTextArea) {
        jEditTextArea.addMouseWheelListener(new MouseWheelHandler());
        jEditTextArea.setTransferHandler(new TextAreaTransferHandler());
        try {
            jEditTextArea.getDropTarget().addDropTargetListener(new DropHandler(jEditTextArea));
            jEditTextArea.setDragAndDropCallback(Java14.class.getMethod("dragAndDropCallback", JEditTextArea.class, InputEvent.class, Boolean.TYPE));
        }
        catch (Exception exception) {
            Log.log(9, Java14.class, exception);
        }
    }

    public static void initBufferSwitcher(final EditPane editPane, BufferSwitcher bufferSwitcher) {
        bufferSwitcher.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                editPane.getTextArea().requestFocus();
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                editPane.getTextArea().requestFocus();
            }
        });
    }

    static class TextAreaSelection
    extends StringSelection {
        JEditTextArea textArea;

        TextAreaSelection(JEditTextArea jEditTextArea) {
            super(jEditTextArea.getSelectedText());
            this.textArea = jEditTextArea;
        }
    }

    static class DropHandler
    extends DropTargetAdapter {
        JEditTextArea textArea;
        Buffer savedBuffer;
        int savedCaret;

        DropHandler(JEditTextArea jEditTextArea) {
            this.textArea = jEditTextArea;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            Log.log(1, this, "Drag enter");
            this.savedBuffer = this.textArea.getBuffer();
            this.textArea.setDragInProgress(true);
            this.savedCaret = this.textArea.getCaretPosition();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            point = SwingUtilities.convertPoint(this.textArea, point, this.textArea.getPainter());
            int n = this.textArea.xyToOffset(point.x, point.y, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
            if (n != -1) {
                this.textArea.moveCaretPosition(n, JEditTextArea.ELECTRIC_SCROLL);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            Log.log(1, this, "Drag exit");
            this.textArea.setDragInProgress(false);
            if (this.textArea.getBuffer() == this.savedBuffer) {
                this.textArea.moveCaretPosition(this.savedCaret, JEditTextArea.ELECTRIC_SCROLL);
            }
            this.savedBuffer = null;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Log.log(1, this, "Drop");
            this.textArea.setDragInProgress(false);
        }
    }

    static class TextAreaTransferHandler
    extends TransferHandler {
        private static JEditTextArea dragSource;
        private static boolean compoundEdit;

        TextAreaTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            Log.log(1, this, "createTransferable()");
            JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
            if (jEditTextArea.getSelectionCount() == 0) {
                return null;
            }
            dragSource = jEditTextArea;
            return new TextAreaSelection(jEditTextArea);
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            boolean bl;
            Log.log(1, this, "Import data");
            if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return false;
            }
            try {
                bl = transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? this.importFile(jComponent, transferable) : this.importText(jComponent, transferable);
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                bl = false;
            }
            GUIUtilities.getView(jComponent).toFront();
            GUIUtilities.getView(jComponent).requestFocus();
            jComponent.requestFocus();
            return bl;
        }

        private boolean importFile(JComponent jComponent, Transferable transferable) throws Exception {
            Log.log(1, this, "=> File list");
            EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
            Buffer buffer = null;
            Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : (List)object) {
                Buffer buffer2 = jEdit.openFile(null, file.getPath());
                if (buffer2 == null) continue;
                buffer = buffer2;
            }
            if (buffer != null) {
                editPane.setBuffer(buffer);
            }
            editPane.getView().toFront();
            editPane.getView().requestFocus();
            editPane.requestFocus();
            return true;
        }

        private boolean importText(JComponent jComponent, Transferable transferable) throws Exception {
            int n;
            Selection selection;
            Log.log(1, this, "=> String");
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
            if (dragSource != null && jEditTextArea.getBuffer() == dragSource.getBuffer()) {
                compoundEdit = true;
                jEditTextArea.getBuffer().beginCompoundEdit();
            }
            if ((selection = jEditTextArea.getSelectionAtOffset(n = jEditTextArea.getCaretPosition())) != null) {
                if (jEditTextArea == dragSource) {
                    return false;
                }
                jEditTextArea.setSelectedText(selection, string);
            } else {
                jEditTextArea.getBuffer().insert(n, string);
            }
            jEditTextArea.scrollToCaret(true);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            Log.log(1, this, "Export done");
            JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
            try {
                if (transferable == null) {
                    Log.log(1, this, "=> Null transferrable");
                    jEditTextArea.selectNone();
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Log.log(1, this, "=> String");
                    if (n == 2) {
                        jEditTextArea.setSelectedText(null, false);
                    } else {
                        jEditTextArea.selectNone();
                    }
                }
            }
            finally {
                if (compoundEdit) {
                    compoundEdit = false;
                    jEditTextArea.getBuffer().endCompoundEdit();
                }
            }
            dragSource = null;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
            boolean bl = false;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) {
                    bl = true;
                    continue;
                }
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor) || !jEditTextArea.isEditable()) continue;
                bl = true;
            }
            Log.log(1, this, "canImport() returning " + bl);
            return bl;
        }
    }

    static class MouseWheelHandler
    implements MouseWheelListener {
        MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JEditTextArea jEditTextArea = (JEditTextArea)mouseWheelEvent.getSource();
            if (mouseWheelEvent.isAltDown()) {
                this.moveCaret(jEditTextArea, mouseWheelEvent.getWheelRotation(), mouseWheelEvent.isShiftDown() || mouseWheelEvent.isControlDown());
            } else if (mouseWheelEvent.isShiftDown()) {
                this.scrollPage(jEditTextArea, mouseWheelEvent.getWheelRotation());
            } else if (mouseWheelEvent.isControlDown()) {
                this.scrollLine(jEditTextArea, mouseWheelEvent.getWheelRotation());
            } else if (mouseWheelEvent.getScrollType() == 0) {
                this.scrollLine(jEditTextArea, mouseWheelEvent.getUnitsToScroll());
            } else {
                this.scrollLine(jEditTextArea, 3 * mouseWheelEvent.getWheelRotation());
            }
        }

        private void scrollLine(JEditTextArea jEditTextArea, int n) {
            jEditTextArea.setFirstLine(jEditTextArea.getFirstLine() + n);
        }

        private void scrollPage(JEditTextArea jEditTextArea, int n) {
            if (n > 0) {
                jEditTextArea.scrollDownPage();
            } else {
                jEditTextArea.scrollUpPage();
            }
        }

        private void moveCaret(JEditTextArea jEditTextArea, int n, boolean bl) {
            if (n < 0) {
                jEditTextArea.goToPrevLine(bl);
            } else {
                jEditTextArea.goToNextLine(bl);
            }
        }
    }

    static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        MyFocusTraversalPolicy() {
        }

        public Component getDefaultComponent(Container container) {
            return GUIUtilities.getView(container).getTextArea();
        }
    }

    static class MyFocusManager
    extends DefaultKeyboardFocusManager {
        MyFocusManager() {
            this.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                Component component = (Component)keyEvent.getSource();
                if (!component.isShowing()) {
                    return true;
                }
                while (true) {
                    if (component instanceof View) {
                        ((View)((Object)component)).processKeyEvent(keyEvent, 0);
                        return true;
                    }
                    if (component == null || component instanceof Window || component instanceof JEditTextArea) break;
                    component = component.getParent();
                }
            }
            return super.postProcessKeyEvent(keyEvent);
        }
    }
}

