/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.jedit;

import de.grogra.pf.registry.Registry;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;

public class VFSAdapter
extends VFS {
    private static VFSAdapter allProjects;
    private final FileSystem fs;

    public static synchronized VFSAdapter forAllProjects() {
        if (allProjects == null) {
            allProjects = new VFSAdapter("project", (FileSystem)Registry.ALL_FILE_SYSTEMS, true);
        }
        return allProjects;
    }

    public VFSAdapter(String string, FileSystem fileSystem, boolean bl) {
        super(string, 0x2B | (bl ? 64 : 0), new String[]{"type", "size", "status", "modified"});
        this.fs = fileSystem;
    }

    private Object getFileOrNull(String string) {
        String string2 = this.getName();
        if (string.length() > string2.length() && string.startsWith(string2) && string.charAt(string2.length()) == ':') {
            string = string.substring(string2.length() + 1);
        }
        return string.length() == 0 ? this.fs.getRoot() : this.fs.getFile(string);
    }

    private Object getFile(String string) throws FileNotFoundException {
        Object object = this.getFileOrNull(string);
        if (object == null) {
            throw new FileNotFoundException(string);
        }
        return object;
    }

    private String getPath(Object object) {
        return this.getName() + ':' + this.fs.getPathWithLeadingSlash(object);
    }

    public String getParentOfPath(String string) {
        int n;
        String string2 = this.getName();
        if (string.length() >= 2 && (n = string.lastIndexOf(47, string.length() - 2)) > 0) {
            return string.substring(0, n + 1);
        }
        return string2 + ":/";
    }

    public String constructPath(String string, String string2) {
        return string.endsWith("/") ? string + string2 : string + '/' + string2;
    }

    public char getFileSeparator() {
        return '/';
    }

    public VFS.DirectoryEntry[] _listDirectory(Object object, String string, Component component) {
        Object object2 = this.getFileOrNull(string);
        if (object2 == null) {
            return null;
        }
        Object[] objectArray = this.fs.listFiles(object2);
        VFS.DirectoryEntry[] directoryEntryArray = new Entry[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            directoryEntryArray[i] = new Entry(this.getName(), this.fs, objectArray[i]);
        }
        return directoryEntryArray;
    }

    public VFS.DirectoryEntry _getDirectoryEntry(Object object, String string, Component component) {
        Object object2 = this.getFileOrNull(string);
        return object2 != null ? new Entry(this.getName(), this.fs, object2) : null;
    }

    public boolean _delete(Object object, String string, Component component) {
        try {
            this.fs.delete(this.getFile(string));
        }
        catch (IOException iOException) {
            return false;
        }
        VFSManager.sendVFSUpdate(this, string, true);
        return true;
    }

    public boolean _mkdir(Object object, String string, Component component) {
        String string2 = this.getParentOfPath(string);
        Object object2 = this.getFileOrNull(string2);
        if (object2 == null) {
            if (!this._mkdir(object, string2, component)) {
                return false;
            }
            object2 = this.getFileOrNull(string2);
            if (object2 == null) {
                return false;
            }
        }
        int n = string.lastIndexOf(47, string.length() - 2);
        try {
            this.fs.create(object2, string.substring(n + 1), true);
        }
        catch (IOException iOException) {
            return false;
        }
        VFSManager.sendVFSUpdate(this, string, true);
        return true;
    }

    public InputStream _createInputStream(Object object, String string, boolean bl, Component component) throws IOException {
        try {
            return this.fs.getInputStream(this.getFile(string));
        }
        catch (IOException iOException) {
            if (bl) {
                return null;
            }
            throw iOException;
        }
    }

    public OutputStream _createOutputStream(Object object, String string, Component component) throws IOException {
        Object object2 = this.getFileOrNull(string);
        if (object2 == null) {
            object2 = this.fs.create(this.getFile(this.getParentOfPath(string)), string.substring(string.lastIndexOf(47) + 1), false);
        }
        return this.fs.getOutputStream(object2, false);
    }

    public String getDefaultEncoding(String string) {
        Object object = this.getFileOrNull(string);
        return object != null ? this.fs.getCharset(object).name() : super.getDefaultEncoding(string);
    }

    public void setEncoding(String string, String string2) {
        Object object = this.getFileOrNull(string);
        if (object == null) {
            return;
        }
        MimeType mimeType = this.fs.getMimeType(object);
        if (mimeType != null && "text".equals(mimeType.getPrimaryType())) {
            StringMap stringMap = mimeType.getParameters();
            stringMap.put("charset", (Object)string2);
            mimeType = new MimeType(mimeType.getMediaType(), stringMap, mimeType.getRepresentationClass());
            this.fs.setMimeType(object, mimeType);
        }
    }

    public static class Entry
    extends VFS.DirectoryEntry {
        public static DateFormat DATE_FORMAT = DateFormat.getInstance();
        private final long modified;

        public Entry(String string, FileSystem fileSystem, Object object) {
            super(fileSystem.getName(object), null, null, fileSystem.isLeaf(object) ? 0 : 1, fileSystem.getSize(object), false);
            this.canRead = true;
            this.canWrite = !fileSystem.isReadOnly(object);
            this.modified = fileSystem.getTime(object);
            this.symlinkPath = this.deletePath = string + ':' + fileSystem.getPathWithLeadingSlash(object);
            this.path = this.deletePath;
        }

        public String getExtendedAttribute(String string) {
            return string.equals("modified") ? DATE_FORMAT.format(new Date(this.modified)) : super.getExtendedAttribute(string);
        }
    }
}

