/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.LinkedList;

public class TreeLayout
extends Layout {
    private float minDistanceX = 0.3f;
    private float minDistanceY = 0.3f;
    private boolean topDown = false;
    public static final Type $TYPE = new Type(TreeLayout.class);
    public static final SCOType.Field minDistanceX$FIELD = Type._addManagedField($TYPE, "minDistanceX", 0x200002, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field minDistanceY$FIELD = Type._addManagedField($TYPE, "minDistanceY", 0x200002, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field topDown$FIELD = Type._addManagedField($TYPE, "topDown", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 4);

    public TreeLayout() {
        minDistanceX$FIELD.setFloat((Object)this, -0.4f);
        minDistanceY$FIELD.setFloat((Object)this, 1.0f);
        topDown$FIELD.setBoolean((Object)this, true);
    }

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                GraphUtilities graphUtilities = new GraphUtilities();
                LinkedList linkedList = graphUtilities.getRoots(node);
                double d = TreeLayout.this.minDistanceX;
                double d2 = TreeLayout.this.minDistanceY;
                graphUtilities.setAllEdgesAccessed(node, true);
                Node node2 = node;
                while (node2 != null) {
                    node2.layoutVarX = 0.0f;
                    node2.layoutVarY = 0.0f;
                    node2 = node2.next;
                }
                for (int i = 0; i < linkedList.size(); ++i) {
                    this.calcXCoord((Node)((Object)linkedList.get(i)), d);
                    graphUtilities.setAllEdgesAccessed(node, true);
                    double d3 = this.calcYCoord((Node)((Object)linkedList.get(i)), d2);
                    if (d3 >= 0.0) {
                        d2 = d3;
                    }
                    graphUtilities.setAllEdgesAccessed(node, true);
                }
                if (TreeLayout.this.topDown) {
                    Node node3 = node;
                    while (node3 != null) {
                        float f = node3.x;
                        node3.x = -node3.y;
                        node3.y = -f;
                        node3 = node3.next;
                    }
                }
            }

            private void calcXCoord(Node node, double d) {
                if (node.isAccessed) {
                    return;
                }
                node.isAccessed = true;
                node.x = (float)d;
                node.y = node.layoutVarY;
                d += (double)(node.width + TreeLayout.this.minDistanceX);
                node.layoutVarX = node.x;
                node.layoutVarY = node.y;
                node.isAccessed = false;
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    if (!edge.isAccessed) continue;
                    edge.isAccessed = false;
                    if (edge.target != node) {
                        this.calcXCoord(edge.target, d);
                        continue;
                    }
                    this.calcXCoord(edge.source, d);
                }
            }

            private double calcYCoord(Node node, double d) {
                double d2 = d;
                if (node.isAccessed) {
                    return -1.0;
                }
                node.isAccessed = true;
                if (node.layoutVarY > 0.0f) {
                    node.isAccessed = false;
                    return -1.0;
                }
                Node node2 = null;
                Node node3 = null;
                if (node.getFirstEdge() != null) {
                    for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                        double d3;
                        if (!edge.isAccessed) continue;
                        edge.isAccessed = false;
                        Node node4 = null;
                        if (edge.target != node) {
                            d3 = this.calcYCoord(edge.target, d2);
                            node4 = edge.target;
                        } else {
                            d3 = this.calcYCoord(edge.source, d2);
                            node4 = edge.source;
                        }
                        if (!(d3 >= 0.0)) continue;
                        d2 = d3;
                        if (node2 == null) {
                            node2 = node4;
                            continue;
                        }
                        node3 = node4;
                    }
                }
                if (node2 == null) {
                    node.y = (float)d2;
                    node.layoutVarX = node.x;
                    node.layoutVarY = (float)d2;
                    d2 += (double)(node.height + TreeLayout.this.minDistanceY);
                } else if (node3 == null) {
                    double d4 = 0.0;
                    node.y = node2.y;
                    d4 = (double)node.y + (double)node.height + (double)TreeLayout.this.minDistanceY;
                    node.layoutVarX = node.x;
                    node.layoutVarY = node.y;
                    if (d4 > d2) {
                        d2 = d4;
                    }
                } else {
                    double d5 = 0.0;
                    node.y = (node2.y + node3.y) / 2.0f;
                    d5 = (float)((int)(node2.y + node3.y) / 2) + node.height + TreeLayout.this.minDistanceY;
                    node.layoutVarX = node.x;
                    node.layoutVarY = node.y;
                    if (d5 > d2) {
                        d2 = d5;
                    }
                }
                node.isAccessed = false;
                return d2;
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(TreeLayout treeLayout, SCOType sCOType) {
            super(treeLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 4: {
                    ((TreeLayout)((Object)object)).topDown = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 4: {
                    return ((TreeLayout)((Object)object)).topDown;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((TreeLayout)((Object)object)).minDistanceX = f;
                    return;
                }
                case 3: {
                    ((TreeLayout)((Object)object)).minDistanceY = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((TreeLayout)((Object)object)).minDistanceX;
                }
                case 3: {
                    return ((TreeLayout)((Object)object)).minDistanceY;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new TreeLayout();
        }
    }
}

