/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.Node;
import java.util.LinkedList;

public class GraphUtilities {
    public LinkedList getNodesList(Node node) {
        LinkedList linkedList = this.getRoots(node);
        LinkedList linkedList2 = new LinkedList();
        linkedList2.add(linkedList.get(0));
        Node node2 = node;
        while (node2 != null) {
            if (!node2.equals(linkedList.get(0))) {
                linkedList2.add(node2);
            }
            node2 = node2.next;
        }
        return linkedList2;
    }

    public LinkedList getNodesListDFS(Node node) {
        this.setAllNodesEdgesAccessed(node, false);
        LinkedList linkedList = this.getRoots(node);
        LinkedList linkedList2 = new LinkedList();
        for (int i = 0; i < linkedList.size(); ++i) {
            this.addToNodesListDFS((Node)((Object)linkedList.get(i)), linkedList2);
        }
        return linkedList2;
    }

    private void addToNodesListDFS(Node node, LinkedList linkedList) {
        if (node.isAccessed) {
            return;
        }
        node.isAccessed = true;
        linkedList.add(node);
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            if (edge.target == node) continue;
            this.addToNodesListDFS(edge.target, linkedList);
        }
    }

    public void setAllNodesEdgesAccessed(Node node, boolean bl) {
        Node node2 = node;
        while (node2 != null) {
            node2.isAccessed = bl;
            for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                edge.isAccessed = bl;
            }
            node2 = node2.next;
        }
    }

    public void setAllEdgesAccessed(Node node, boolean bl) {
        Node node2 = node;
        while (node2 != null) {
            for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                edge.isAccessed = bl;
            }
            node2 = node2.next;
        }
    }

    public int getNodeCount(Node node) {
        int n = 0;
        int n2 = 0;
        this.setAllEdgesAccessed(node, false);
        Node node2 = node;
        while (node2 != null) {
            for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                if (edge.isAccessed) continue;
                edge.isAccessed = true;
                ++n2;
            }
            ++n;
            node2 = node2.next;
        }
        System.out.println("nodeCount: " + n);
        return n;
    }

    public void setNodeAccessed(Node node, boolean bl) {
        node.isAccessed = bl;
    }

    public void setEdgeAccessed(Edge edge, boolean bl) {
        edge.isAccessed = bl;
    }

    public boolean isNodeAccessed(Node node) {
        return node.isAccessed;
    }

    public boolean isEdgeAccessed(Edge edge) {
        return edge.isAccessed;
    }

    public LinkedList getRoots(Node node) {
        Node node2;
        Object object;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        boolean bl = false;
        this.setAllNodesEdgesAccessed(node, true);
        Node node3 = node;
        while (node3 != null) {
            if (node3.getFirstEdge() != null) {
                if (this.isNodeAccessed(node3)) {
                    bl = true;
                    for (object = node3.getFirstEdge(); object != null; object = ((Edge)object).getNext(node3)) {
                        if (this.isEdgeAccessed((Edge)object)) continue;
                        bl = false;
                    }
                    this.setNodeAccessed(node3, false);
                }
                object = node3;
                this.setNodeAccessed((Node)((Object)object), false);
                for (Node node4 = node2 = ((Node)((Object)object)).getFirstEdge(); node4 != null; node4 = ((Edge)((Object)node4)).getNext((Node)((Object)object))) {
                    this.setEdgeAccessed((Edge)((Object)node4), false);
                    this.setNodeAccessed(((Edge)((Object)node4)).source, false);
                    this.setNodeAccessed(((Edge)((Object)node4)).target, false);
                }
            }
            node3 = node3.next;
        }
        this.setAllNodesEdgesAccessed(node, true);
        node3 = node;
        while (node3 != null) {
            for (object = node3.getFirstEdge(); object != null; object = ((Edge)object).getNext(node3)) {
                node2 = ((Edge)object).target;
                node2.isAccessed = false;
                ((Edge)object).isAccessed = false;
            }
            node3 = node3.next;
        }
        node3 = node;
        while (node3 != null) {
            if (node3.isAccessed) {
                linkedList.add(node3);
            }
            node3 = node3.next;
        }
        this.setAllNodesEdgesAccessed(node, false);
        return linkedList;
    }

    public LinkedList getConnectedNodes(Node node) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Node node2 = node;
        while (node2 != null) {
            if (node2.getFirstEdge() != null) {
                linkedList.add(node2);
            }
            node2 = node2.next;
        }
        return linkedList;
    }

    protected int getConnectedNodesSize(Node node) {
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            if (node2.getFirstEdge() != null) {
                ++n;
            }
            node2 = node2.next;
        }
        return n;
    }

    public LinkedList getUnconnectedNodes(Node node) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Node node2 = node;
        while (node2 != null) {
            if (node2.getFirstEdge() != null) {
                linkedList.add(node2);
            }
            node2 = node2.next;
        }
        return linkedList;
    }
}

