/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.ForceBasedLayout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.Random;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public class EadesLayout
extends ForceBasedLayout {
    private float minDistanceX = 0.4f;
    private float minDistanceY = 0.4f;
    private float repellingConst = 1.0f;
    private float springConst = 4.0f;
    private double springLength = Math.sqrt(this.minDistanceX * this.minDistanceX + this.minDistanceY * this.minDistanceY);
    public static final Type $TYPE = new Type(EadesLayout.class);
    public static final SCOType.Field minDistanceX$FIELD = Type._addManagedField($TYPE, "minDistanceX", 0x200002, de.grogra.reflect.Type.FLOAT, null, 7);
    public static final SCOType.Field minDistanceY$FIELD = Type._addManagedField($TYPE, "minDistanceY", 0x200002, de.grogra.reflect.Type.FLOAT, null, 8);
    public static final SCOType.Field repellingConst$FIELD = Type._addManagedField($TYPE, "repellingConst", 0x200002, de.grogra.reflect.Type.FLOAT, null, 9);
    public static final SCOType.Field springConst$FIELD = Type._addManagedField($TYPE, "springConst", 0x200002, de.grogra.reflect.Type.FLOAT, null, 10);

    protected void setRandomPosition(Node node, Random random) {
        node.x = random.nextFloat();
        node.y = random.nextFloat();
    }

    protected void computeForce(Node node, Node node2, Vector2f vector2f) {
        double d = Math.abs(node2.distance(node));
        if (d == 0.0) {
            d = 0.001;
        }
        float f = (float)((double)this.repellingConst / d);
        vector2f.sub((Tuple2f)node2, (Tuple2f)node);
        vector2f.scale((float)(1.0 / d));
        vector2f.scale(f);
    }

    protected void computeForce(Edge edge, Vector2f vector2f) {
        double d = Math.abs(edge.source.distance(edge.target));
        if (d == 0.0) {
            d = 0.001;
        }
        float f = (float)(Math.log(d / this.springLength) * (double)this.springConst);
        vector2f.sub((Tuple2f)edge.source, (Tuple2f)edge.target);
        vector2f.scale((float)(1.0 / d));
        vector2f.scale(f);
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends ForceBasedLayout.Type {
        private static final int SUPER_FIELD_COUNT = 7;
        protected static final int FIELD_COUNT = 11;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(EadesLayout eadesLayout, SCOType sCOType) {
            super(eadesLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)ForceBasedLayout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 7: {
                    ((EadesLayout)((Object)object)).minDistanceX = f;
                    return;
                }
                case 8: {
                    ((EadesLayout)((Object)object)).minDistanceY = f;
                    return;
                }
                case 9: {
                    ((EadesLayout)((Object)object)).repellingConst = f;
                    return;
                }
                case 10: {
                    ((EadesLayout)((Object)object)).springConst = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((EadesLayout)((Object)object)).minDistanceX;
                }
                case 8: {
                    return ((EadesLayout)((Object)object)).minDistanceY;
                }
                case 9: {
                    return ((EadesLayout)((Object)object)).repellingConst;
                }
                case 10: {
                    return ((EadesLayout)((Object)object)).springConst;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new EadesLayout();
        }
    }
}

